// packer.cpp ... version 2
// May 30th, 1999 ... griesse@bigfoot.com

#include <stdio.h>

#define XB1 2
#define XL1 4
#define XB2 4
#define XL2 16

FILE *fi, // hugi.raw
     *fo, // entry.com
     *fd; // depack.com

int pos = 0, byte = 0;

long cb = 0;

void putc_fo(void)
{
    fputc(byte,fo);
    cb++;
    pos = 0; byte = 0;
}

void putbit(int len, unsigned char wert)
{
  if (len > (8 - pos)) {
    len = (len - (8 - pos));
    byte = byte | (wert >> len);
    putc_fo();
  }

  byte = byte | (wert << (8 - (pos + len)));
  pos = pos + len;
  if (pos >= 8) putc_fo();
}

void main(void)
{
  unsigned char old, buffer[768];
  int ch, i;

  if (!(fi = fopen("hugi.raw","rb"))) return;
  if (!(fd = fopen("depack.com","rb"))) return;

  fo = fopen("entry.com","wb");

  i = fread(buffer, 1, 512, fd); // copy depack.com -> entry.com
  fwrite(buffer, i, 1, fo);

  fread(buffer, sizeof(buffer), 1, fi);
  fwrite(buffer, sizeof(buffer), 1, fo);

  i = 1;
  old = ch = fgetc(fi);

  while ((ch = fgetc(fi)) != EOF) {
    if (ch == old && ((old == 0 && i < 256) || (old != 0 && i < XL2)))
      i++;
    else {
      if (old == 0) { // Flag = 00 ... 8 Bit Length (Color = Black)
         putbit(2, 0);
         putbit(8, i-1);
      }
      else if (i == 1) { // Flag = 01 ... 8 Bit Color
        putbit(2, 1);
        putbit(8, old);
      }
      else if (i <= XL1) { // Flag = 10 ... XB1 Bit Length + 8 Bit Color
        putbit(2, 2);
        putbit(XB1, i-1);
        putbit(8, old);
      }
      else { // Flag = 11 ... XB2 Bit Length + 8 Bit Color
        putbit(2, 3);
        putbit(XB2, i-1);
        putbit(8, old);
      }

      i = 1;
      old = ch;
    }
  }

  if (byte != 0) {
    fputc(byte,fo);
    cb++;
  }

  printf("Bytes of compressed Picture = %d ", cb + 768);
  printf("[%d,%d]\n",XB1,XB2);

  fclose(fo);
  fclose(fi);
}
