/*
 * Image preprocessor for Hugi compo #7
 * by INT-E
 */

#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>

#define PREFIX          "hugi."
#define RAW             "raw"
#define PRE             "pre"
#define INC             "prepro.inc"

#define Uchar           unsigned char

#ifndef O_BINARY
#define O_BINARY 0
#endif


Uchar a[64000];
Uchar p[768];
int numcol;
int numshades;

void preprocess() {
  Uchar trans[256];
  Uchar rtran[256];
  int count[256];
  int i,j,l=0,g=0,t;
  for (i=0;i<256;i++) trans[i]=i;
  for (i=0;i<256;i++) count[i]=0;
  for (i=0;i<64000;i++) count[a[i]]++;
#define SWAP(a,b)       (t=a,a=b,b=t)
  for (i=0;i<256;i++) if (count[i]) {
    if ((p[3*i]==p[3*i+1])&&(p[3*i]==p[3*i+2])) {
      SWAP(trans[i],trans[g]);
      for (j=0;j<3;j++) SWAP(p[3*i+j],p[3*g+j]);
      g++;
    }
    SWAP(trans[i],trans[l]);
    for (j=0;j<3;j++) SWAP(p[3*i+j],p[3*l+j]);
    l++;
  }
  for (i=0;i<256;i++) rtran[trans[i]]=i;
  numcol=l;
  numshades=g;
  for (;l<256;l++) p[3*l]=p[3*l+1]=p[3*l+2]=0;
#undef SWAP
  for (i=0;i<64000;i++) a[i]=rtran[a[i]];
}

int main() {
  int f;
  FILE *i;
  f=open(PREFIX RAW,O_RDONLY|O_BINARY);
  read(f,p,768);
  read(f,a,64000);
  close(f);
  preprocess();
  f=open(PREFIX PRE,O_WRONLY|O_BINARY|O_CREAT|O_TRUNC,S_IWUSR|S_IRUSR);
  write(f,p,768);
  write(f,a,64000);
  close(f);
  i=fopen(INC,"w");
  fprintf(i,"; This file was generated automatically. Do not edit.\n"
            "\tNUMCOL\tequ\t%d\n"
            "\tNUMSHD\tequ\t%d\n",numcol,numshades);
  fclose(i);
}
