;
; raw2com v1.15 depacker (NASM style) -- Hugi Compo #7 entry by Jibz '99
;
; The file layout is:
;
;   +-------------+ --+
;   |  depacker   |   |
;   +-------------+   |
;   |  tag data   |   |
;   +-------------+   +- inside entry.com
;   |   palette   |   |
;   +-------------+   |
;   |  raw data   |   |
;   +-------------+ --+
;   : pp raw data :   |
;   +- - - - - - -+   +- depacked from tag data and raw data
;   : pp bit data :   |
;   +- - - - - - -+ --+
;
; The depacker sets mode13h, then depacks 'raw data' and 'tag data' into mem
; immediately after 'raw data'.  It depacks the palette and sets it. Then it
; reverses the preprocessing on 'pp raw data' and 'pp bit data', and outputs
; the result to video memory. Finally it waits for a keypress, sets mode03h,
; and exits.
;

       org     100h

       ; Set mode13h
       mov     al, 13h
       int     10h

       mov     si, raw_data       ; set in packer
       mov     di, 2400h          ; set in packer

       mov     bp, bit_data

literal:
       movsb
next_tag:
       call    getbit
       jnc     literal

       call    getgamma
       xchg    ax, cx
       dec     ax
       dec     ax

       mov     cx, 6
getmore_ax:
       call    getbit
       adc     ax, ax
       loop    getmore_ax

       neg     ax
       jz      done
       xchg    ax, bx

       call    getgamma

copy_byte:
       mov     al, [bx + di]
       stosb
       loop    copy_byte
       jmp     short next_tag

done:
       mov     dx, 03c8h
       out     dx, al             ; al = 0 from depacker
       inc     dx

       mov     ah, 0a0h           ; al = 0 from depacker
       mov     es, ax

       xor     bx, bx             ; we use al, bl, bh for color components
       mov     di, 256*3          ; set in packer

next_color:
       mov     ah, 0              ; get 2 bits
       call    getbit
       adc     ah, ah
       call    getbit
       adc     ah, ah
       jz      sign_ok

       jpo     got_distance       ; 1 and 2 have odd parity, 3 has even

       call    getgamma
       inc     cx                 ; 3 or more
       mov     ah, cl

got_distance:
       call    getbit             ; get sign-bit
       jnc     sign_ok
       neg     ah
sign_ok:
       add     al, ah
       out     dx, al

       xchg    al, bl             ; rotate color components
       xchg    al, bh             ;
       dec     di
       jnz     next_color

       mov     bp, bit_data       ; set in packer

next_byte:
       call    getbit
       jnc     write_byte

       lodsb

write_byte:
       stosb
       cmp     di, 64000
       jb      next_byte

       ; Wait for keypress
       xor     ax, ax
       int     16h

       ; Back to text-mode
       mov     ax, 03h
       int     10h

getbit:
       shr     BYTE [bp], 1       ; thx to Chut for this beauty
       jnz     still_bits_left    ;
       inc     bp                 ;
       rcr     BYTE [bp], 1       ;
still_bits_left:
       ret

getgamma:
       mov     cx, 1
getmore_cx:
       call    getbit
       adc     cx, cx
       call    getbit
       jc      getmore_cx
       ret

bit_data:
raw_data:
