; METALBRAIN's entry for Hugi Size Compo #7
;
;depacker code

;THIS VERSION:
;11th ENTRY > 30-05-99:
; 12th try: Take Huffman coding of distance's lenght in consideration
;               to find the best match > 7593 (7330+263) bytes

;HISTORY:
;  (0th try: aPPACK from Jibz's aPLib 0.20 > 8421 (8251+170) bytes > ILLEGAL)
;  1st try: RLE for zeros only > 23926 (23851+75) bytes
;  2nd try: RLE + Greedy LZ > 8940 (8818+122) bytes
;  3rd try: RLE + A bit LaZy > 8643 (8529+114) bytes
;1st ENTRY > 26-04-99:
;  4th try: Bits instead of bytes + minor changes > 8305 (8152+153) bytes
;2nd ENTRY > 28-04-99:
;  5th try: Encoded 2 literals in 6 bits > 8280 (8112+168) bytes
;           Removed 2 bytes from depacker > 8278 (8112+166) bytes
;3rd ENTRY >  2-05-99:
;  6th try: Changed LZ scheme > 8048 (7887+161) bytes
;4th ENTRY >  3-05-99:
;           Removed a short jump in depacker > 8046 (7887+159) bytes
;           Removed 2 do-nothing instructions > 8043 (7887+156) bytes
;5th ENTRY >  8-05-99:
;  7th try: Changed again LZ scheme > 7885 (7722+163) bytes
;6th ENTRY > 11-05-99:
;           Optimized LZ encoder (about 12-13 times faster) > still 7885 bytes
;7th ENTRY > 16-05-99:
;  8th try: Uses static Huffman for distance's lenght > 7801 (7575+226) bytes
;  9th try: Compress image backwards > 7780 (7558+222)
;8th ENTRY > 23-05-99:
; 10th try: Huffman for MatchLenght's lenght too > 7641 (7393+248) bytes
;9th ENTRY > 25-05-99:
; 11th try: Literals with 4 bits in the low part > 7614 (7345+269) bytes
;10th ENTRY > 26-05-99:
;           Changed minimum number of zeros to be RLEd > 7607 (7338+269) bytes
;           Removed 6 bytes from depacker > 7601 (7338+263) bytes


                org     256
                mov     bp,getbit       ;This routine is called many times
                mov     al,19
                int     10h             ;Set our favourite mode. It also clear
                                        ; the screen with zeros, and first
                                        ; color (0) is 0 0 0
                mov     si,PALETTE
                mov     dx,03c8h
                mov     al,1            ;Start setting color 1
                out     dx,al
                inc     dx
                mov     di,630          ;Number of used colors * 3
palloop         mov     cl,6
                call    getbits
                out     dx,al
                dec     di
                jnz     palloop         ;Set palette
                mov     di,DATARLE
lzloop          xor     ax,ax
                call    bp              ;LZ bits decoder starts here
                jc      lznormalcode    ;1xxx > LZcode
patchhere       jmp     short lzliteral
                call    bp
                jnc     lzliteral       ;00xx > Literal between 0-63
                call    bp              ;01xx > Literal between 64-191
                adc     al,1            ;Adjust first 2 bits
lzliteral       mov     cl,3
                call    getbits         ;complete the literal byte
storeit         add     al,2            ;Fix small chars
                stosb                   ;and store it
                cmp     al,214          ;Is it the big jump?
                jnz     cmpfinal        ;YES: Go to check end
                mov     [lzliteral+1],byte 6    ;NO: Put normal conditions
                mov     [patchhere+1],ah
                mov     [storeit+1],ah
cmpfinal        cmp     al,213          ;Is it the end code?
tolzloop        jnz     lzloop          ;NO: Next code
                push    word 0a000h     ;YES: Let's go with RLE part
                pop     es              ;Set screen segment
                mov     di,63144        ;StartPoint+BigJumpLenght
bigjump         sub     di,2674         ;Only one big jump: encoded manually
next            lodsb                   ;AL=CODE
                sub     al,2            ;Restore true value
                jc      rlezero         ;254 or 255 > RLE
                cmp     al,211
                jc      literal         ;Under 211 > Literal
                jnz     bigjump         ;212 > Big jump
                int     16h             ;211 > This is the end: Wait key
                mov     ax,3
                int     10h             ;Restore mode 3
                ret                     ;Exit to DOS
lznormalcode    call    bp              ;2nd Huffman decoder
                jnc     hf2_last
                call    bp
                jnc     hf2_3
                call    bp
                jnc     hf2_4
                call    bp
                jnc     hf2_done
                mov     cl,5
                call    bp
                jnc     hf2_done
hf2_last        call    bp
                jnc     hf2_1
                jmp     short hf2_2
specialcase     pop     ax              ;Literal between 192-214
                add     al,189          ;Adjust literal (Min LZ lenght was 3)
                jmp     short storeit
hf2_4           inc     cx
hf2_3           inc     cx
hf2_2           inc     cx
hf2_1           inc     cx
hf2_done        inc     ax              ;Leading bit
                call    getbits         ;Take rest of MatchLenght
                inc     ax
                inc     ax              ;Complete
                push    ax              ;And store it
                call    bp              ;Huffman decoder start here
                jc      hf1             ;It sets distance's lenght in CX
hf0             call    bp
                mov     cl,7
                jnc     donehuff
hf01            inc     cx              ;Codes 10 and 11 are together
hflast          call    bp
                jc      hc3
                jnc     hc2
donehuff        mov     al,1            ;Leading bit
                call    getbits         ;Distance in AX
                pop     cx              ;Lenght in CX
                push    si
                mov     si,di
                sub     si,ax           ;Set match position
                rep     movsb           ;Decode LZ
                pop     si
                jmp     short tolzloop  ;Next code...
hf1             call    bp
                jc      hf11
hf10            call    bp
                jc      hf101
hf100           mov     cl,6            ;Codes 8 and 9 are together
                jmp     short hflast
rlezero         inc     ax              ;Set AH
                lodsb                   ;Get number of zeros+1
                dec     ax              ;Zeros
                dec     ax              ;Zeros -1
                xchg    ax,cx           ;Set number of zeros-1 in CX
literal         inc     cx              ;Zeros or 1
                std                     ;Go backwards
                rep     stosb           ;Set CX zeros or 1 literal 
                cld                     ;Forwards again
                jmp     short next      ;Next...
                                        ;Here continues huffman decoder...
hf101           mov     cl,3            ;Codes 5 and 6 are together
                jmp     short hflast
hf11            call    bp
                jc      hf111
hf110           mov     cl,10           ;Codes 12 and 13 are together
                jmp     short hflast
hf111           call    bp
                jnc     donehuff
hf1111          call    bp
                jnc     hf01
hf11111         call    bp
                jnc     specialcase
                call    bp
                jnc     hc2
                mov     cl,11
hc3             inc     cx
hc2             inc     cx
                inc     cx
                jmp     short donehuff

getbit          add     bl,bl
                jnz     stillbitsleft
                mov     bl,[si]
                inc     si
                stc
                adc     bl,bl
stillbitsleft   ret

getbits         jcxz    nobits
                call    bp
                rcl     ax,1
                loop    getbits
nobits          ret

PALETTE         INCBIN "PALETTE2"
                INCBIN "HUGI.ST3"
DATARLE
