; METALBRAIN's entry for Hugi Size Compo #7
;
;2nd step code: The RLE encoder for zeros
;
;Compile with NASM:
;nasm step2.nas -o step2.com

                org     256

                mov     ax,ds
                add     ax,4096
                push    ax
                pop     es              ;ES: Output segment
                mov     dx,infile
                mov     ax,3d00h
                int     33              ;Open HUGI.ST1
                jc      doserror
                xchg    ax,bx
                mov     cx,57017
                mov     dx,datahere
                mov     si,dx
                xor     di,di
                mov     ah,3fh
                int     33              ;Read file
                jc      doserror
                mov     dx,cx
                xor     ax,ax
clearcx         xor     cx,cx
zeros           lodsb                   ;Next byte
                inc     cx
                cmp     al,0
                jz      zeros
                loop    zerofound
putliteral      add     al,2
                stosb                   ;Put non zero code
                cmp     si,datahere+57017
                jc      clearcx
                mov     ax,3cd5h
                stosb                   ;Put EOF code+2 (213)
                mov     dx,outfile
                int     33              ;Create HUGI.ST2
                jc      doserror
                push    es
                pop     ds
                xchg    ax,bx
                mov     ah,40h
                mov     dx,cx           ;CX=0
                mov     cx,di
                int     33              ;Write file
                jc      doserror
                int     32              ;Exit to DOS
doserror        mov     ah,9
                push    cs
                pop     ds
                mov     dx,ERRMSG
                int     33
                mov     ax,4c01h
                int     33              ;Exit with error flag
zerofound       cmp     cx,38          ;Minimum number of zeros to be LREd
                jnc     putcode
                push    ax              ;Save literal
                mov     al,2
                rep     stosb           ;Put small number of zeros
                pop     ax              ;Recover literal
                jmp     short putliteral
putcode         cmp     cx,2000         ;There is only one higher
                jnc     putlong
                xchg    ax,cx           ;Literal in CX
                inc     ax
                xchg    al,ah
                stosw
                xchg    ax,cx           ;Recover literal
                jmp     short putliteral
putlong         mov     [es:di],byte 212;Lenght is encoded in the depacker
                inc     di
                jmp     short putliteral
infile          db "HUGI.ST1",0
outfile         db "HUGI.ST2",0
ERRMSG          db "Error in step 2",13,10,"$"
datahere
