; METALBRAIN's entry for Hugi Size Compo #7
;
;3rd step code: The LZ encoder, a bit lazy, with a bit static Huffman.
;
;Compile with NASM and ALINK (TLINK would work too):
;nasm step3.nas -f obj
;alink step3.obj
;
;Optional > Compress with aPACK:
;apack -m step3.exe step3.exe

LASTPAL EQU 13

SEGMENT CODE PUBLIC ALIGN=16 CLASS=CODE USE16
                ..start

                mov     ax,DATA1
                mov     ds,ax           ;DS: segment for input and output
                mov     es,ax           ;ES: segment for input and output
                mov     dx,infile
                mov     ax,3d00h
                int     33              ;Open HUGI.ST2
                jnc     nodoserror
doserror        mov     dx,ERRMSG
doserror4       mov     ah,9            ;Error code
                int     33
                mov     ax,4c01h
                int     33              ;Exit with error flag
nodoserror      xchg    ax,bx
                mov     cx,65535
                mov     dx,datahere
                mov     si,dx           ;si > pointer to current position
                dec     si
                mov     ah,3fh
                int     33              ;Read data
                jc      doserror
                mov     [lenght],ax
loopforl0       mov     cx,[incr]
loopforl2       inc     si
                mov     al,[si]         ;Current char
                mov     ah,0
                add     ax,ax
                mov     bx,p
                add     bx,ax
                mov     ax,[bx]         ;# of previous hits of this byte
                inc     word [bx]       ;increase
                loop    loopforl2
                mov     [maxmatch],byte 0
                xchg    ax,cx           ;search ax previous hits
                jcxz    noforl1
                mov     di,si           ;DI will scan the matches
loopforl1       push    cx
                cmp     [maxmatch],byte 253  ;Has max already been reached?
                jz      noswap          ; YES: Pass it
                dec     di              ;start 1 byte back
                mov     cx,65535        ;Scan using rep without problems
                mov     al,[si]         ;Current char
                std
                repnz   scasb           ;Search next equal backwards
                mov     bx,1            ;BX=current match
                inc     di              ;adjust pointer
                cld
                push    di
                push    si
                repz    cmpsb           ;scan matching forwards
                dec     si              ;adjust pointer
                mov     ax,si
                pop     si
                pop     di
                sub     ax,si           ;calculate match for this hit
                mov     dx,si
                sub     dx,di           ;calculate herematch
                sub     ax,2            ;does it accomplish the minimum match?
                jna     noswap          ;NO: Continue
                cmp     ax,254          ;is it more than 254?
                jc      nolimitax
                mov     ax,253
nolimitax       cmp     [maxmatch],al   ;is it the best maxmatch till now?
                jz      maybe
                jnc     noswap          ;NO: Continue
swap            mov     [maxmatch],al   ;YES: set maxmatch
                mov     [herematch],dx  ;     and herematch
noswap          pop     cx
                loop    loopforl1       ;Repeat for all scans
noforl1         mov     ax,[maxmatch]   ;AX=maxmatch
                and     ax,ax
                jz      literal
                call    testlazy
                jnc     lzcode
literal         mov     al,[si]         ;Get literal code
                mov     [incr],word 1   ;Increase just a byte
patchere        jmp     short smalliteral
                cmp     al,192
                jnc     gotospc1
                cmp     al,64
                jc      nospecialcase2
                add     al,64
                call    put0            ;Put a 0
nospecialcase2  mov     cx,8            ;Put 8 bits
continuesmall   call    putbits
testit          cmp     si,[lenght]
                jnc     endofitall
                jmp     loopforl0       ;Repeat for all bytes
maybe           pusha
                mov     bx,[herematch]
                bsr     bx,bx
                bsr     dx,dx
                cmp     bl,4
                jnz     test6
                cmp     dl,5
                jnz     test7
maybeyes        popa
                jmp     swap
test6           cmp     bl,6
                jz      test7
maybeno         popa
                jmp     noswap
test7           cmp     dl,7
                jz      maybeyes
                jmp     short maybeno
smalliteral     cmp     al,192
                jc      putsmall
                mov     [cs:patchere+1],byte 0     ;Disable smalliteral
gotospc1        jmp     short specialcase1      ;And put the big code
putsmall        mov     cx,4            ;Put 4 bits for the low part
                sub     al,2            ;Save 2-17 to 0-15
                jmp     short continuesmall
endofitall      cmp     [currbits],byte 1
                jz      lastdone
                call    putbit
                jmp     short endofitall
lzcode          inc     ax
                inc     ax
                mov     [incr],ax
                dec     ax
                dec     ax
                mov     bx,[herematch]
                call    put1
                push    ax
                bsr     ax,ax           ;AX is under 256 > now it's under 8
                call    puthuff2
                pop     ax
continuespecial call    putbitsnolead   ;Put lzlenght
                bsr     ax,bx
                call    puthuffman
                xchg    ax,bx
                call    putbitsnolead   ;Put herematch
                jmp     testit

lastdone        mov     ax,3c00h
                mov     dx,outfile
                int     33              ;Create HUGI.ST3
                jc      doserror2
                xchg    ax,bx
                mov     ah,40h
                mov     dx,output
                mov     cx,di
                sub     cx,dx
                int     33              ;Write file
                jc      doserror2
                mov     ax,4c00h
                int     33              ;Exit to DOS
doserror2       jmp     doserror
putbitsnolead   bsr     cx,ax
                jcxz    nobits
putbits         ror     ax,cl
putanotherbit   shl     ax,1
                call    putbit
                loop    putanotherbit
nobits          ret

specialcase1    call    put1
                sub     al,191
                push    ax
                bsr     ax,ax
                call    puthuff2
                pop     ax
                call    putbitsnolead   ;Put code over 191
                call    puthf15         ;Special literal code
                jmp     testit          ;Next one...

testlazy        pusha
                inc     si
                mov     al,[si]         ;Current char
                mov     ah,0
                add     ax,ax
                mov     bx,p
                add     bx,ax
                mov     ax,[bx]         ;# of previous hits of this byte
                xchg    ax,cx           ;search ax previous hits
                jcxz    nolazyatall
                mov     di,si           ;DI will scan the matches
loopforlazy     push    cx
                dec     di              ;start 1 byte back
                mov     cx,65535        ;Scan using rep without problems
                mov     al,[si]         ;Current char
                std
                repnz   scasb           ;Search next equal backwards
                mov     bx,1            ;BX=current match
                inc     di              ;adjust pointer
                cld
                push    di
                push    si
                repz    cmpsb           ;scan matching forwards
                dec     si              ;adjust pointer
                mov     ax,si
                pop     si
                pop     di
                sub     ax,si           ;calculate match for this hit
                sub     ax,2            ;does it accomplish the minimum match?
                jna     noswaplazy      ;NO: Continue
                cmp     ax,254          ;is it more than 254?
                jc      nolimitlazy
                mov     ax,253
nolimitlazy     cmp     [maxmatch],al   ;is it the best maxmatch till now?
                jc      yeslazy
noswaplazy      pop     cx
                loop    loopforlazy     ;Repeat for all scans
nolazyatall     popa
                clc
                ret
yeslazy         pop     cx
                popa
                stc
                ret

put0            clc
                jmp     short putbit
put1            stc
putbit          push    si
                push    dx
                mov     dl,[currbits]
                mov     di,[currbyte]
                adc     dl,dl
                jnc     nonextbyte
                mov     [di],dl
                inc     word [currbyte]
                mov     dl,1
nonextbyte      mov     [currbits],dl
                pop     dx
                pop     si
                ret
puthf15         call    put1
                call    put1
                call    put1
                call    put1
                call    put1
                call    put0
                ret

puthuffman      and     ax,ax
                jnz     noputhf0
puthf0          call    put1
                call    put1
                call    put1
                call    put0
                ret
noputhf0        dec     ax
                dec     ax
                jnz     noputhf2
puthf2          call    put1
                call    put1
                call    put1
                call    put1
                call    put1
                call    put1
                call    put0
                ret
noputhf2        dec     ax
                jnz     noputhf3
puthf3          call    put1
                call    put1
                call    put1
                call    put1
                call    put0
                call    put0
                ret
noputhf3        dec     ax
                jnz     noputhf4
puthf4          call    put1
                call    put1
                call    put1
                call    put1
                call    put0
                call    put1
                ret
noputhf4        dec     ax
                jnz     noputhf5
puthf5          call    put1
                call    put0
                call    put1
                call    put0
                ret
noputhf5        dec     ax
                jnz     noputhf6
puthf6          call    put1
                call    put0
                call    put1
                call    put1
                ret
noputhf6        dec     ax
                jnz     noputhf7
puthf7          call    put0
                call    put0
                ret
noputhf7        dec     ax
                jnz     noputhf8
puthf8          call    put1
                call    put0
                call    put0
                call    put0
                ret
noputhf8        dec     ax
                jnz     noputhf9
puthf9          call    put1
                call    put0
                call    put0
                call    put1
                ret
noputhf9        dec     ax
                jnz     noputhf10
puthf10         call    put0
                call    put1
                call    put0
                ret
noputhf10       dec     ax
                jnz     noputhf11
puthf11         call    put0
                call    put1
                call    put1
                ret
noputhf11       dec     ax
                jnz     noputhf12
puthf12         call    put1
                call    put1
                call    put0
                call    put0
                ret
noputhf12       dec     ax
                jnz     puthf14
puthf13         call    put1
                call    put1
                call    put0
                call    put1
                ret
puthf14         call    put1
                call    put1
                call    put1
                call    put1
                call    put1
                call    put1
                call    put1
                ret
;      Huffman code     Total number of bits
;0 - 4:1110.            4
;2 - 7:1111110.         9
;3 - 6:111100.          9
;4 - 6:111101.         10--->That's why distances of lenght 5 or 7 are better
;5 - 4:1010.            9  /  than distances of 4 or 6
;6 - 4:1011.           10 /
;7 - 2:00.              9/
;8 - 4:1000.           12
;9 - 4:1001.           13
;A - 3:010.            13
;B - 3:011.            14
;C - 4:1100.           16
;D - 4:1101.           17
;E - 7:1111111.        21
;F - 6:111110.         21


puthuff2        and     ax,ax
                jnz     no0hf2
                call    put1
                call    put1
                call    put1
                call    put0
                ret
no0hf2          dec     ax
                jnz     no1hf2
                call    put0
                call    put0
                ret
no1hf2          dec     ax
                jnz     no2hf2
                call    put0
                call    put1
                ret
no2hf2          dec     ax
                jnz     no3hf2
                call    put1
                call    put0
                ret
no3hf2          dec     ax
                jnz     no4hf2
                call    put1
                call    put1
                call    put0
                ret
no4hf2          dec     ax
                jnz     no5hf2
                call    put1
                call    put1
                call    put1
                call    put1
                call    put0
                ret
no5hf2          dec     ax
                jnz     no6hf2
                call    put1
                call    put1
                call    put1
                call    put1
                call    put1
                call    put0
                ret
no6hf2          call    put1
                call    put1
                call    put1
                call    put1
                call    put1
                call    put1
                ret
;0 - 4:1110.
;1 - 2:00.
;2 - 2:01.
;3 - 2:10.
;4 - 3:110.
;5 - 5:11110.
;6 - 6:111110.
;7 - 6:111111.

SEGMENT DATA1 PUBLIC ALIGN=16 CLASS=DATA
datahere        times 32768 db 0                ;Source data
output          times 8000 db 0                 ;LZ compressed output
infile          db "HUGI.ST2",0
outfile         db "HUGI.ST3",0
p               times 512 db 0                  ;# of hits table
incr            dw 1
lenght          dw 0
lastbyte        db 0
maxmatch        dw 0
herematch       dw 0
currbyte        dw output
currbits        db 16+LASTPAL
ERRMSG          db "Error in step 3",13,10,"$"

SEGMENT STACKSEG STACK ALIGN=16 CLASS=STACK 
                RESW 256
