
;   PACKER 

bkp     macro
        int     3
        endm

mof     macro   r,t
        mov     r,offset t
        endm

inc2    macro   arg
        inc     arg
        inc     arg
        endm

dec2    macro   arg
        dec     arg
        dec     arg
        endm

ds_cs   macro
        push    cs
        pop     ds
        endm

es_cs   macro
        push    cs
        pop     es
        endm

clr     macro   reg
        xor     reg,reg
        endm

ww      macro
        clr     ah
        int     16h
        endm

ex      macro
        jmp     extdos
        endm


        assume  ds:_TEXT,cs:_TEXT
_TEXT   segment


                        org     100h

        start:          jmp     begin

                externdef entry_start:near
                externdef entry_end:near
                externdef cycles:byte


; PARAMETERS and VARIABLES 

                palet   db      768 dup(?)
                palet1  db      768 dup(?)
                root    dw      ?
                efil    dw      ?
                pcnt    dw      ?
                mcnt    dw      ?
                reptc   db      ?
                savvec  dw      ?
                oldvec  db      ?
                oldbord dw      ?
                bordc   dw      ?
                bordxyp dw      ?
                clen1   dw      ?
                clen2   dw      ?
                clen3   dw      ?
                clenp   dw      ?
                palval  label   byte                 ;
                halval  label   byte                 ;
                intar   dw      8000 dup (?)        ;

                hist    dw      256 dup(?)
                hval    dw      256 dup(?)
                htree   db      511 dup(?)
                htabl   db      256 dup(?)
                bcode   db      255 dup(?)

                haloxy =  0                     ;array 8192 words
                measur =  haloxy+2*8192         ;array 8192 words
                anchor =  measur+2*8192         ;array 8192 words
                distan =  anchor+2*8192

                hfil    db      'hugi.raw',0
                enam    db      'entry.com',0

                bondry  label   byte                 ;boundary vectors
                counts  db      3000 dup (?)
                values  db      3000 dup (?)
                vvectx  db      4000 dup (?)
                vvecty  db      4000 dup (?)
                bordxy  dw      3000 dup (?)
                sqzdat  db      4000 dup (?)
                vectors db      5000 dup (?)

                pntr    dw      ?
                vvc     dw      0
                vvp     dw      0
                vectp   dw      0
                bordend dw      ?         ;word

                opt_len dw      ?
                opt_wid db      ?
                itm_wid db      ?
                bias    db      ?
                mean    db      ?
                sqzcnt  db      ?
                c320    dw      320

                mir     dw      ?
                cor     dw      ?
                aux     dw      ?
                picseg  dw      ?
                gramem  dw      0a000h

; CODE start point 

                begin:  call    general_init
                        call    load_file       ;read the .raw file
                        mof     di,sqzdat       ;- squeezed data buffer
                        call    pack_palette    ;pack the palette
                        call    ext_cycles      ;pack the cycles

; Write the initial code of entry.com
                        mov     bx,efil
                        mof     cx,entry_end
                        mof     dx,entry_start
                        sub     cx,dx
                        mov     ah,40h
                        int     21h

; Write the squeezed data up to now
                        mov     cx,di
                        sub     cx,offset sqzdat
                        call    appsqz          ;
                        call    pack_core       ;pack the letters core
                        call    pack_tran       ;pack the transient area


; Generate the halo 

                        mov     vvc,0           ;count of vertical vectors
                        mov     vvp,0           ;pointer to vertical vecs

                        mof     bp,cycles
                        mof     di,sqzdat
                        mof     vectp,vectors

; Skip to transit cycle
                        call    getbound0       ; H cycle
                        call    getbound0       ; u cycle
                        call    getbound0       ; g cycle
                        call    getbound0       ; i cycle

; Leave only transit and halo cycles
                        mov     vvc,0           ;count of vertical vectors
                        mov     vvp,0           ;pointer to vertical vecs
                        call    getbound0       ; transit cycle

; The border must be the transit border

                        call    getbound        ; halo cycle
                        call    gram_mir

                        call    gethalo         ;get the halo xy array
                        push    cx

                        mof     di,halval
                        mov     si,haloxy

                @@:     mov     es,aux
                        mov     bx,es:[si]
                        mov     es,mir
                        mov     al,es:[bx]
                        inc2    si
                        es_cs
                        stosb
                        loop    @b

                        pop     cx
                        mof     si,halval
                        mof     di,sqzdat ;- where halo data starts
                        call    pack_rpt
                        mof     cx,sqzdat
                        sub     cx,di
                        neg     cx
                        call    appsqz
                        ex


; Extract and sort the halo points 
;

        gethalo:
                clr     bx              ;start from 1st point in mir
                clr     di              ;index in haloxy, anchors, distans

        nxtpnt: inc     bx              ;point x,y
                jnz     @f              ;nz - more points to check
                shr     di,1
                mov     cx,di
                ret

        @@:     call    ckin            ;point in our area?
                jz      nxtpnt          ;z - no
                mov     ax,bx
                call    qqq


; Process a halo point 
; Found a neighbour - get its distance to core and its anchor.
; Range it accordingly.
;


; Get distance and anchor 
; Find a point from the border which is closest to a selected one and is
; closest to the beginning of border (its index is called an anchor)
; On entry:bx = selected point;
; On exit: dx = distance of [bx] to anchor point;
;          bp - 2 = anchor.
;

                push    di
                mof     si,bordxy       ;
                push    si
                mov     dx,-1           ;distance estimate = max

        lc0:    lodsw                   ;ax = next point from border
                call    getsqd          ;get the square of the distance

; Compare and replace distance if smaller

                cmp     di,dx           ;that point closer to selected?
                ja      lc2             ;a - no
                je      @f              ;e - need anchor check
                mov     dx,di           ;replace best distance
                jmp     lc1             ;replace the anchor also

; Compare and replace anchor if smaller

        @@:     cmp     si,bp           ;new point is closer to border start
                jae     lc2             ;ae - no, do not replace anchor
        lc1:    mov     bp,si           ;replace anchor
        lc2:    cmp     si,ds:[bordend] ;reached the border end?
                jnz     lc0             ;ne - not yet


; Compute euristic measure 

                pop     si              ;si - bordxy
                push    bp

                dec2    bp

                sub     bp,si
                mov     cx,ds:[clen1]
                cmp     bp,cx
                jb      @f
                sub     bp,cx
                add     si,cx
                mov     cx,ds:[clen2]
                cmp     bp,cx
                jb      @f
                sub     bp,cx
                add     si,cx
                mov     cx,ds:[clen3]

        @@:     dec2    bp
                jns     @f
                add     bp,cx
        @@:     call    getsqd0

                add     bp,4
                cmp     bp,cx
                jb      @f
                sub     bp,cx
        @@:     call    getsqd0

                pop     bp
                pop     di

                mov     ds,ds:[aux]

                mov     [di],bx         ;enrol it
                mov     measur[di],dx   ;along with the measure
                mov     anchor[di],bp   ;and the anchor


; Find the exact location of the current point in haloxy 

                mov     si,di
                inc2    di

; Move left the [bx] point: measure decreasing, anchors decreasing
; Use bubble method

                or      si,si
                jz      lc3             ;z - only the bubble in array

; At that place [si] - bubble position in haloxy
; bx = bubble x,y, dx = bubble measure, bp = bubble anchor

        @@:     cmp     measur-2[si],dx ;reached points that are bigger than bubble?
                jb      lc3             ;b - yes, stop bubbling
                ja      swap            ;a - no, move bubble left
                cmp     anchor-2[si],bp ;left point has a smaller anchor?
                jbe     lc3             ;b - yes, points to the left are bigger than bubble
        swap:   mov     ax,bx
                xchg    ax,[si-2]       ;move the bubble
                mov     [si],ax         ;left
                mov     ax,dx
                xchg    ax,measur-2[si] ;swap the
                mov     measur[si],ax   ;distance
                mov     ax,bp
                xchg    ax,anchor-2[si] ;swap the
                mov     anchor[si],ax   ;anchor
                dec2    si              ;points to bubble
                jnz     @b              ;check the left point if any
        lc3:    ds_cs

        lc4:    jmp     nxtpnt

; Compute the square of euclidian distance
; di = sqr(|ax-bx|)
;

        getsqd0:
                mov     ax,ds:[si+bp]
                call    getsqd
                shr     di,1
                add     dx,di
                ret

        getsqd: push    ax
                sub     al,bl           ;x difference
                imul    al              ;sqr(x difference)
                mov     di,ax           ;remember
                pop     ax
                mov     al,ah
                sub     al,bh           ;y difference
                imul    al              ;sqr(y difference)
                add     di,ax           ;di = sqr(distance)
                ret


;Exit to DOS
        extdos:         mov     bx,efil
                        mov     ah,3eh
                        int     21h             ;close the entry.com file
                        mov     ax,2            ;change to text mode
                        int     10h
                        ret

; General init 

; Used segments above the task's segment
        general_init:   mov     ax,cs
                        add     ax,1000h
                        mov     mir,ax     ;
                        add     ax,1000h
                        mov     cor,ax
                        add     ax,1000h
                        mov     aux,ax
                        add     ax,1000h
                        mov     picseg,ax

; Set graphic mode to show pictures
                        mov     ax,13h
                        int     10h
                        mov     ax,3
                        int     10h
                        mov     ax,13h
                        int     10h

; Create and write the beginning of the entry.com
                        mof     dx,enam
                        clr     cx              ;read/write attribute
                        mov     ah,3ch
                        int     21h             ;get a file handle
                        mov     efil,ax
                        ret                     ;to mainstream

; Pack the palette 

; Move the last 7 colors 25 position backwards (249 -> 224)

        pack_palette:   push    di
                        mof     di,palet1+3*224
                        mof     si,palet1+3*249
                        mov     cx,3*7
                        rep     movsb

; The shortened table is 224+7 = 231.

                        mof     si,palet1
                        mof     di,palval
                        clr     ah
        nxt_plt:        mov     cx,231
                        push    si
        @@:             lodsb           ;get p[i]
                        sub     al,ah   ;al = p[i]-p[i-1]
                        stosb           ;store it
                        add     ah,al   ;ah = p[i]
                        inc2    si
                        loop    @b
                        pop     si
                        inc     si
                        cmp     si,offset palet1+3
                        jb      nxt_plt

                        mov     cx,3*231
                        mof     dx,palval
                        call    output
                        mof     si,palval
                        pop     di
                        call    pack_huf0       ;store length before block
                        ret


; Extract the cycles 

        ext_cycles:     push    di              ;- squeezed data
                        call    select
                        call    cor_mir
                        mof     vectp,vectors   ;- vectors array
                        mof     bp,cycles       ;- cycles array

                        mov     dl,27           ;the H cycle
                        mov     dh,14
                        call    getcyc
                        call    putzero

                        mov     dl,102          ;the u cycle
                        mov     dh,46
                        call    getcyc
                        call    putzero

                        mov     dl,189          ;the g external cycle
                        mov     dh,39
                        call    getcyc
                        mov     dl,157          ;the g hole cycle
                        mov     dh,81
                        call    getcyc
                        call    putzero

                        mov     dl,216          ;i point
                        mov     dh,8
                        call    getcyc
                        mov     dl,209          ;i stick
                        mov     dh,39
                        call    getcyc
                        call    putzero

                        call    selhalo         ;mir = core + halo, cor = core
                        call    gramem_cor      ;show the core

                        mov     dl,27
                        mov     dh,13           ;The whole
                        call    getcyc

                        mov     dl,160
                        mov     dh,80           ;g hole
                        call    getcyc

                        mov     dl,213
                        mov     dh,7            ;i point
                        call    getcyc
                        call    putzero

                        mov     dl,25
                        mov     dh,7            ;The whole
                        call    getcyc0

                        mov     dl,160
                        mov     dh,74           ;g hole
                        call    getcyc0

                        mov     dl,211
                        mov     dh,1            ;i point
                        call    getcyc0
                        call    putzero

                        mof     si,vectors
                        mov     cx,vectp
                        sub     cx,si
                        mof     dx,vectors
                        call    output

                        pop     di
                        call    pack_rpt        ;pack the vectors
                        ret

; Pack the core of letters 

        pack_core:      call    select
                        mov     vvc,0           ;count of vertical vectors
                        mov     vvp,0           ;pointer to vertical vecs
                        mof     bp,cycles
                        mof     si,vectors
                        mof     di,sqzdat
                        mof     vectp,vectors

                        call    extarea         ;pack H
                        call    extarea         ;pack u
                        call    extarea         ;pack g
                        call    extarea         ;pack i
                        mov     cx,di
                        sub     cx,offset sqzdat
                        call    appsqz          ;append the squeezed core
                        ret


; Generate the transit 
; extarea resets the clen pointer and sets clen1 clen2 ... etc
; infact this is a function of extvec (it checks for closeness)
;
        pack_tran:      call    selhalo         ;mir = body + halo, cor = body
                        call    gramem_cor
                        mov     vvc,0           ;count of vertical vectors
                        mov     vvp,0           ;pointer to vertical vecs

                        mof     bp,cycles
                        mof     si,vectors
                        mof     di,sqzdat
                        mof     vectp,vectors

                        call    getbound0       ; H cycle
                        call    getbound0       ; u cycle
                        call    getbound0       ; g cycle
                        call    getbound0       ; i cycle
                        call    getbound0       ; transit cycle

                        call    genars          ;get the transit area
                        mof     di,sqzdat
                        mof     si,intar
                        call    pack_huf0
                        mov     cx,di
                        sub     cx,offset sqzdat
                        call    appsqz          ;

                        mov     ax,bordxyp
                        mov     bordend,ax
                        ret


; Extract the boundry and border 
; Extract the boundary to bondry array and squeeze it in bondsqz
; Extract the border to border array
; Get the vertical vectors
; Extract the area in an array moving snakelike
;
        extarea:        push    di
                        mov     vvc,0           ;count of vertical vectors
                        mov     vvp,0           ;pointer to vertical vecs
                        call    getbound0
                        call    genars          ;generate interior with snakelike movement
                        mof     si,intar
                        pop     di
                        call    pack_rpt
                        mof     cx,sqzdat
                        sub     cx,di
                        neg     cx
                        ret

        getbound0:      mof     bordxyp,bordxy
                        mof     clenp,clen1
        getbound:       call    clr_cor
                        es_cs

                @@:     call    extvec          ;restore vertical vectors
                        cmp     byte ptr[bp],0  ;last cycle?
                        jnz     @b              ;nz - no, process the next
                        inc     bp              ;- after 0
                        ret

;ggg
; Unpack and get vector arrays 
; On entry: si - start of packed 2-vecs;
;           di - index into vvectx and vvecty arrays;
; On exit:  vvectx and vvecty are filled;
;           di - after the last data item in vvectx and vvecty;
;           si - after the last byte of 2-vectors;
;           cx = length of border;
;           vvc is increased by count of vertical vectors;
;
; bl = -1, 0, 1
; bh = -1, 0, 1
; Possible values of bx: (1,0),(-1,0),(0,-1),(0,1)
; the coding values are
;        00 - repeat the last vector twice
;        10 - repeat the last vector
;        01 - rotate and change dir
;        11 - rotate and keep dir
; The first vector is never encoded. It is defaulted to bx = 1.
;
                extvec: mov     cx,bordxyp ;get to compute increase
                        mov     si,vectp
                        mov     di,vvp  ;where to write vertical vectors
                        mov     ax,[bp] ;get this cycle root
                        inc2    bp      ;- next cycle
                        mov     dx,ax   ;set root
                        push    di      ;save pointer
                        mov     bx,1    ;default start vector

                extnxt: push    ax      ;save root
                        lodsb           ;get next vector
                        ror     al,1    ;that vector is rotated?
                        jnc     @f      ;nc - no
                        xchg    bh,bl   ;rotate vector
                        shr     al,1    ;precise the direction
                        jnc     @f      ;z, keep the same direction
                        neg     bl      ;reverse the
                        neg     bh      ;direction
                @@:
                        call    storv
                        pop     ax      ;get root
                        cmp     dx,ax   ;closed?
                        jne     extnxt  ;

                        pop     ax      ;- start of vertical vectors for that cycle
                        sub     ax,di   ;cx = - count
                        sub     vvc,ax  ;increase vvc by vector count
                        mov     vvp,di  ;update the pointer also
                        sub     cx,bordxyp
                        add     bordxyp,cx;update bordxy pointer
                                        ;cx = length of border * 2
                        mov     vectp,si
                        mov     bx,clenp
                        mov     [bx],cx
                        add     clenp,2
                        ret

; bx  0, 1        0, 0
; bx  0,-1       -1,-1
; bx  1, 0        0,-1
; bx -1, 0       -1, 0

        storv:          mov     ax,dx   ;dx is the start of the current vector
                        or      bl,bl
                        jg      @skp
                        js      @f
                        or      bh,bh
                        jg      @dal
                        inc     al
                @@:     dec     ah
                @dal:   dec     al
                @skp:
                        call    qqq
                        push    bx
                        mov     bx,cx
                        cmp     ax,[bx-2]       ;already enrolled?
                        je      @f              ;e, yes
                        mov     [bx],ax         ;enrol square
                        inc2    cx              ;maintain length of border
                @@:     pop     bx

                        add     dh,bh
                        add     dl,bl
                        mov     ax,dx

; Check and store vertical vectors
                        or      bh,bh   ;vertical vector?
                        jz      @sv     ;z - yes
                        mov     vvectx[di],al   ;remember x of vertical vector
                                        ;ah = start vertex
                        js      @f      ;s - up vector
                        dec     ah      ;ah = end vertex of down vector
                @@:     mov     vvecty[di],ah ;
                        inc     di      ;
                @sv:    ret




; Array copy routines 

                gram_cor:
                        push    si
                        push    di
                        mov     es,gramem
                        mov     ds,cor
                        mov     di,320*9+43
                        clr     si
                        mov     bp,143
                @@:     mov     cx,256
                        rep     movsb
                        add     di,320-256
                        dec     bp
                        jnz     @b
                        ds_cs
                        es_cs
                        pop     di
                        pop     si
                        ret

                gram_mir:
                        push    si
                        push    cx
                        mov     es,gramem
                        mov     ds,mir
                        mov     di,320*9+43
                        clr     si
                        mov     bp,143
                @@:     mov     cx,256
                        rep     movsb
                        add     di,320-256
                        dec     bp
                        jnz     @b
                        ds_cs
                        es_cs
                        pop     cx
                        pop     si
                        ret

;
;

                clr_cor:
                        mov     es,cor
                        jmp     @f

                clr_mir:
                        mov     es,mir
                        jmp     @f

                clr_gram:
                        mov     es,gramem

                @@:     push    ax
                        push    cx
                        push    di
                        mov     cx,-1
                        clr     al
                        clr     di
                        rep     stosb
                        pop     di
                        pop     cx
                        pop     ax
                        ret

                cor_mir:push    si
                        push    di
                        call    clr_cor
                        mov     es,cor
                        mov     ds,mir
                        mov     cx,-1
                        clr     si
                        clr     di
                        rep     movsb
                        pop     di
                        pop     si
                        ds_cs
                        es_cs
                        ret

                mir_gram:call    clr_mir
                        mov     ds,gramem
                        mov     si,320*9+43
                        clr     di
                        mov     bp,143
                @@:     mov     cx,256
                        rep     movsb
                        add     si,320-256
                        dec     bp
                        jnz     @b
                        ds_cs
                        es_cs
                        ret

                gramem_cor:
                        push    si
                        push    di
                        mov     es,gramem
                        mov     ds,cor
                        mov     di,320*9+43
                        clr     si
                        mov     bx,143
                @@:     mov     cx,256
                        rep     movsb
                        add     di,320-256
                        dec     bx
                        jnz     @b
                        ds_cs
                        es_cs
                        pop     di
                        pop     si
                        ret




; Get a cycle 
; On exit:  di - after last in vectors array;
; The boundary is saved as a sequence 2 bit relative vectors
;   10 keep the same vector
;   01 rotate and keep direction
;   11 rotate and change direction
;
; BX is the square x,y, DX is the vector end vertex x,y
;


        getcyc0:        mov     es,mir
                        jmp     @f
        getcyc:         mov     es,cor
        @@:             mov     root,dx
                        mov     di,vectp
                        clr     cx      ;will count vectors in the cycle
                        mov     ds:[bp],dx ;remember cycle root
                        inc2    bp      ;- next in cycles array
                        mov     bx,dx
                        dec     bl
                        jmp     rig0
;  
; 
;             00
; 
                rig:    inc     dl
                        call    ckclos
                rig0:   cmp     byte ptr es:[bx+1],0
                        jne     @f
                        mov     al,01b
                        jmp     dwn ;rotate + keep dir
                @@:     inc     bl
                        cmp     byte ptr es:[bx-256],0
                        jne     @f
                        mov     al,10b
                        jmp     rig
                @@:     mov     al,11b          ;rotate + change dir
                        dec     bh
; 
;            10
; 
                up:     dec     dh
                        call    ckclos
                        cmp     byte ptr es:[bx-256],0
                        jne     @f
                        mov     al,11b
                        jmp     rig ;rotate + change dir
                @@:     dec     bh
                        cmp     byte ptr es:[bx-1],0
                        jne     @f
                        mov     al,10b
                        jmp     up  ;keep all
                @@:     mov     al,01b          ;rotate + keep dir
                        dec     bl
; 
;             01
; 
;  
                lft:    dec     dl
                        call    ckclos
                        cmp     byte ptr es:[bx-1],0
                        jne     @f
                        mov     al,01b
                        jmp     up  ;rotate + keep dir
                @@:     dec     bl
                        cmp     byte ptr es:[bx+256],0
                        jne     @f
                        mov     al,10b
                        jmp     lft ;keep all
                @@:     mov     al,11b          ;rotate + change dir
                        inc     bh
; 
;            11
; 
                dwn:    inc     dh
                        call    ckclos
                        cmp     byte ptr es:[bx+256],0
                        jne     @f
                        mov     al,11b
                        jmp     lft ;rotate + change dir
                @@:     inc     bh
                        cmp     byte ptr es:[bx+1],0
                        jne     @f
                        mov     al,10b
                        jmp     dwn ;keep all
                @@:     inc     bl
                        mov     al,01b
                        jmp     rig ;rotate + keep dir


; Store the new value (x,y), inc count, check for closeness

                ckclos: mov     [di],al
                        inc     di      ;- next in vectors array
                        cmp     root,dx
                        jne     @f
                        mov     vectp,di
                        pop     ax      ;remove return address
                        es_cs
                @@:     ret

; Append a 0 byte to the cycles array - terminates area cycle sets
; bp - cycles array

        putzero:        mov     byte ptr ds:[bp],0
                        inc     bp
                        ret

; Squeeze the bound to four 2 vectors in a byte and succesive pairs 
; On entry: bondry + 1 contains the vectors to squeeze;
;           di - where to store squeezed vectors;
;           cx = their count;
;           root = the x,y of the path root;
; On exit:  di - just after the last byte of squeezed data
; The structure of a path record is as follows:
;   0 - n = count of 2-vectors in the path;
;   2 - x,y of the root
;   4 - n 2-vectors
; If n = 0 then the path is assumed to be the last in a series of consecutive
; paths.
;
                bondsqz:
                        push    di      ;save for final processing
                        inc2    di      ;space for the 2-vector count
                        mov     ax,root ;fix the root
                        stosw           ;now
                        mof     si,bondry
                        mov     bh,1    ;0th vector is assumed right
                        mov     dh,-1   ;not a valid vector
                        xor     bp,bp   ;counts 2-vectors

                @@:     call    getvec  ;get a 2-vector
                        jc      @f      ;c - no more
                        inc     bp      ;one more 2-vector
                        call    putvec  ;put it
                        jmp     @b      ;and go for the next one

                @@:     cmp     bh,1    ;a byte entamed?
                        je      @bsret  ;e - no
                @@:     shr     byte ptr[di],1 ;right adjust the data in the last byte
                        rol     bh,1    ;adjusted?
                        jnc     @b      ;nc - not yet
                        inc     di      ;- just after the squeezed data
                @bsret: pop     bx
                        mov     [bx],bp ;store count of squeezed vectors
                        mov     cx,di
                        sub     cx,bx
                        ret

                getvec: jcxz    gvr
                        dec     cx
                        lodsb
                        cmp     al,dh   ;new is the same?
                        jne     @f      ;ne no
                        jcxz    @f      ;no more vectors left to pair
                        cmp     al,[si] ;next = current?
                        jne     @f      ;ne - no, can't iterate
                        inc     si      ;else one more
                        dec     cx      ;iteration
                        xor     al,al   ;0 = iteration code
                        ret             ;ret C clr
                @@:     mov     dh,al   ;set new value
                        clc
                        ret
                gvr:    stc
                        ret


                putvec: ror     al,1    ;copy bit
                        rcr     byte ptr[di],1 ;to destination
                        ror     al,1    ;copy bit
                        rcr     byte ptr[di],1 ;to destination
                        .386
                        rol     bh,2    ;byte filled?
                        .8086
                        jnc     @f      ;nz no
                        inc     di
                @@:     ret




; Generate the area 
; By a snakelike move
; locate a point within area.
; remember its value
; On entry: vvectx and vvecty are set;
;           vvc = count of vertical vectors
; On exit:  intar array is filled
;           cx = size of the array
;
                genars: push    bp
                        mov     dh,1
                        clr     bx
                        mov     bp,143
                        mof     di,intar
                g1:     call    ckin
                        jz      @f
                        mov     es,mir
                        mov     al,0e0h
                        xchg    al,es:[bx]
                        es_cs
                        stosb
                @@:     add     bl,dh
                        jnz     g1
                        inc     bh
                        neg     dh
                        jns     @f
                        dec     bl
                @@:     dec     bp
                        jnz     g1
                        sub     di,offset intar
                        mov     cx,di
                        pop     bp
                        ret

                ckin:   push    di
                        mof     di,vvecty
                        es_cs
                        mov     cx,vvc
                        mov     al,bh
                        xor     dl,dl
                cin0:   repne   scasb   ;locate vectors crossing that line
                        jne     cin1    ;ne - no such vectors
                        cmp     vvectx-vvecty-1[di],bl
                        ja      @f
                        not     dl      ;keep in/out counter
                @@:     or      cx,cx
                        jnz     cin0
                cin1:   or      dl,dl
                        pop     di
                        ret


; Generate the area 
; By a snakelike move
; locate a point within area.
; remember its value
; On entry: vvectx and vvecty are set;
;           vvc = count of vertical vectors
; On exit:  intar array is filled
;           cx = size of the array
;

                filars: push    si
                        mov     dh,1
                        clr     bx
                        mov     bp,143
                        mof     si,intar
                f1:     call    ckin
                        jz      @f
                        mov     es,cor
                        cmp     byte ptr es:[bx],0
                        jne     @f
                        lodsb
                        mov     es:[bx],al
                @@:     add     bl,dh
                        jnz     f1
                        inc     bh
                        neg     dh
                        jns     @f
                        dec     bl
                @@:     dec     bp
                        jnz     f1
                        pop     si
                        ret


; lll

        load_file:
;Load the picture
                        mof     dx,hfil
                        mov     ax,3d00h        ;get a file handle code al = read/write attrib
                        int     21h             ;open the file
                        mov     bx,ax

                        mof     dx,palet1
                        mov     cx,3*256
                        mov     ah,3fh
                        int     21h             ;read data from file
                        mov     ds,picseg
                        clr     dx
                        mov     cx,64000
                        mov     ah,3fh
                        int     21h             ;read data from file
                        ds_cs
                        mov     ah,3eh
                        int     21h             ;close the file

                        push    es
                        mov     es,picseg
                        clr     di
                        mov     cx,64000
                @18:    mov     al,es:[di]
                        cmp     al,223
                        jbe     @19
                @@:     mov     byte ptr es:[di],0
                @19:    inc     di
                        loop    @18
                        pop     es

                        push    es
                        push    ds
                        mov     es,gramem
                        mov     ds,picseg
                        clr     si
                        clr     di
                        mov     cx,32000
                        rep     movsw
                        pop     ds
                        pop     es
                        ret

;uuu
; Unpack an array of frequently repeated data 
; On entry: si - array of squeezed data;
;           di - where to store the unpacked data;
; On exit:  cx = size of the unpacked data array;
;           si - just after squeezed data;
;
; The format of the input array is as follows:
;  0     count of data items
;  2     Huffman block of squeezed counts
;  2+n   Huffman block of squeezed values
;
        unpack_rpt:     push    di      ;save raw data start

; Unsqueeze the counts
                        mof     di,counts
                        call    unpack_huf0 ;get the data count from stream

; Unsqueeze the values. They are differentially encoded if ch > 6

                        mof     di,values
                        call    unpack_huf ;
                        cmp     ch,6    ;doing the halo?
                        jbe     @f      ;be - no
                        call    diff_to_val

; Unfold data
         @@:            pop     di      ;- raw data start
                        push    si      ;- next squeezed data
                        push    di      ;save start of raw data
                        mof     si,values
                        mov     dx,cx   ;count of data groups
                        xor     cx,cx   ;clear ch

        @@:             mov     cl,counts-values[si] ;get next
                        lodsb           ;get next value
                        rep     stosb   ;unfold the data
                        dec     dx      ;more data to unfold?
                        jnz     @b      ;nz - yes
                        pop     cx      ;= start of raw data
                        sub     cx,di
                        neg     cx      ;= count of raw data
                        pop     si      ;- next squeezed data
                        ret


; Unpack a differentially coded array 
; On entry: si - array of squeezed differences;
;           di - where to store the raw data;
;           cx = data count;
; On exit:  cx = raw data count;
;           si - after the sqeezed data;
;           di - after the raw data.
;
        unpack_dif:     push    di              ;save destination start
                        call    unpack_huf0     ;get the data count from stream
                        pop     di              ;- destination

; Recover data from differences
; On entry: di - the array of differences
;           cx = data count
; 0th data item is assumed 0 - thus the 1st diff is actually the 1st value.

        diff_to_val:    clr     al              ;0th data item
                        push    cx              ;save data count
        @@:             add     al,[di]
                        stosb
                        loop    @b
                        pop     cx              ;= data count
                        ret


; Decode a Huffman block 
; ddd
; On entry: si - a Huffman block;
;           di - where to store decoded data;
; On exit:  di - after the decoded data;
;           cx = count of data bytes.
;
        unpack_huf0:    lodsw           ;get data count from stream
                        mov     cx,ax   ;better use

; cx = count of squeezed data bytes;
        unpack_huf:     push    cx      ;save data count
                        push    cx      ;twice
                        lodsb           ;get
                        clr     ah      ;Huffman table length in ax
                        mov     cx,ax   ;= table length
                        mof     bp,htree;once forever

; Extract the Huffman tree (convert bits to bytes)

                        push    di      ;save data destination
                        push    cx      ;save table length
                        shl     cx,1    ;
                        dec     cx      ;cx = 2*length-1
                        mov     di,bp   ;- htree start
                        mov     dl,80h  ;initialize a bit counter

        ext:            clr     al      ;assume next bit is 0
                        call    getbit  ;is it 0?
                        jnc     @f      ;nc - yes
                        not     al      ;0ff for 1 bit
        @@:             stosb           ;store as a byte
                        loop    ext     ;until done
                        or      dl,dl   ;just increased?
                        js      @f      ;s - yes
                        inc     si      ;- the table start

        @@:             pop     cx      ;= table length
                        pop     di      ;- data destination
                        pop     ax      ;= data count
                        push    si      ;- table start
                        add     si,cx   ;skip the table
                        mov     cx,ax   ;cx = data count
                        mov     dl,80h  ;initialize a bit counter

; Decode the data. Find a code word, get and store the corresponding value.


        hdebyt:         mov     bx,bp   ;bx - tree start
                        pop     ax      ;- table start
                        push    ax      ;save back

        gb:             call    getbit  ;get next bit from stream
                        jnc     ckl     ;0 - move along left branch

; Skip left subtree
                        clr     dh      ;when = 0 again left subtree is skipped
        @@:             inc     dh      ;move along left branch
        sl:             inc     bx      ;- next node
                        sar     byte ptr[bx],1
                        jnc     @b      ;nc - nonleaf
                        inc     ax      ;- next in table
                        dec     dh      ;move along right branch
                        jnz     sl      ;nz - more nodes to skip

        ckl:            inc     bx      ;- next node
                        sar     byte ptr [bx],1 ;on leaf (end of decoding)?
                        jnc     gb      ;nc - no

                        xchg    si,ax
                        movsb           ;store next data byte value
                        mov     si,ax   ;restore pointer to Huffman block
                        loop    hdebyt  ;loop for the next byte

                        pop     ax      ;clean up the stack
                        or      dl,dl   ;just increased?
                        js      @f      ;s - yes
                        inc     si      ;- after the block
        @@:             pop     cx      ;= data count
                        ret


; Extract next bit into C flag

        getbit:         shr     byte ptr [si],1  ;
                        pushf           ;save C
                        ror     dl,1    ;need to move to the next byte?
                        jnc     @f      ;ne no
                        inc     si      ;pass on the next byte
        @@:             popf            ;get data bit in C flag
                        ret

;ppp

; Pack an array of frequently repeated data 
; On entry: si - array of bytes;
;           cx = count of bytes;
;           di - where to store the squeezed data;
; On exit:  cx = size of the squeezed data array;
;           di - after the squeezed data;
;
; The format of the output array is as follows
;  0     count of data items
;  2     Huffman block of squeezed counts
;  2+n   Huffman block of squeezed data values
;

        pack_rpt:       push    di              ;- start of squeezed data
                        push    di

; Fold the data - generate the (count,value) pairs

                        clr     di              ;reset index
                        dec     cx              ;data count - 1
                        mov     al,[si]         ;1st data
                        mov     bx,1            ;preset index
                @pd:    cmp     al,[si+bx]      ;current equal to the next?
                        je      @f              ;e - yes
                        add     si,bx           ;si - start of new sequence
                        mov     counts[di],bl   ;remember old sequence length
                        mov     values[di],al   ;remember old sequence value
                        inc     di
                        mov     al,[si]
                        clr     bx
                @@:     inc     bx
                        loop    @pd

                        mov     counts[di],bl   ;last
                        mov     values[di],al   ;pair
                        inc     di

                        mov     cx,di           ;cx = count of pairs
                        cmp     ch,6            ;doing the halo?
                        jbe     @f              ;be - no
                        call    val_to_dif      ;convert values to differences
                @@:     pop     di              ;- start of squeezed data

; Squeeze the counts
                        mof     si,counts
                        call    pack_huf0       ;on return di - the 1st free in sqzdat
; Squeeze the values
                        mof     si,values
                        call    pack_huf        ;on return di - the 1st free in sqzdat

                        pop     cx              ;- start of squeezed data
                        sub     cx,di
                        neg     cx              ;count of squeezed data bytes
                        ret

; Convert values to differences

        val_to_dif:     push    si
                        push    cx
                        mof     si,values
                        clr     ah      ;always assume 0th element = 0

        @@:             lodsb           ;get p[i]
                        sub     al,ah   ;al = p[i]-p[i-1]
                        mov     [si-1],al;store it
                        add     ah,al   ;ah = p[i]
                        loop    @b
                        pop     cx
                        pop     si
                        ret


; Encode a data array to a Huffman block 
; On entry: si - start of data;
;           cx = data count;
;           di - start of Huffman block;
; On exit:  cx = total length of the block.
; Must preserve bp !
;
        pack_huf0:      mov     ax,cx   ;get data count
                        stosw
        pack_huf:       push    bp      ;save it
                        push    cx      ;save data count
                        push    cx      ;twice
                        push    si      ;save data start
                        call    crehtt  ;create Huffman tree and table
                        mov     al,cl   ;get code table length
                        stosb           ;store it
                        mov     bp,cx   ;remember it

; Bit pack the tree

                        push    cx      ;save table length
                        sal     cx,1    ;htree contains
                        dec     cx      ;2*n-1 nodes
                        mov     dl,1    ;bit counter
                        mof     si,htree
        @@:             sar     byte ptr [si],1 ;get next node value in C
                        inc     si
                        call    putbit  ;store as a single bit
                        loop    @b      ;until all stored
                        call    radjust
                        pop     cx      ;= table length

; Copy the table
                        mof     si,htabl
                        rep     movsb   ;copy the table

; Encode the data

                        pop     si      ;- data start
                        pop     cx      ;= data count

        @@:             lodsb           ;get data byte
                        push    cx      ;save remaining data count
                        push    di      ;save pointer to coded data

; Locate the byte in the code table

                        mof     di,htabl
                        push    di      ;save to reuse
                        mov     cx,bp
                        repne   scasb   ;locate in the table
                        pop     cx
                        sub     cx,di
                        neg     cx      ;relative position
                        pop     di      ;- coded data free space

; Encode the byte, number is in cx

                        call    henbyt  ;encode that byte
                        pop     cx      ;= remaining data count
                        loop    @b
                        call    radjust ;right adjust the last byte
                        pop     cx      ;data count
                        pop     bp
                        ret


; Encode a byte 
; On entry: cx = code
;           di - free sapce in Huffman block;
; On exit   di - updated.
;

        henbyt:         push    si      ;save
                        push    di      ;save pointer to Huffman block

; Generate the code bits in array of bytes

                        mof     si,htree
                        mof     di,bcode

        henc:           lodsb           ;get node in al
                        sar     al,1    ;node is a leaf?
                        jnc     hen     ;nc - no
                        dec     cx      ;over?
                        jz      bpack   ;z - yes
        @@:             dec     di      ;overwrite previous
                        cmp     [di],al ;there is a 1?
                        je      @b      ;
        hen:            stosb           ;
                        jmp     henc

; Bit packing
        bpack:          mov     cx,di
                        mof     si,bcode
                        sub     cx,si   ;count of bits to shift out
                        pop     di      ;- data again

        @@:             sar     byte ptr[si],1  ;get the bit
                        inc     si
                        call    putbit  ;shift it out
                        loop    @b

                        pop     si
                        ret


; On entry: C flag = the bit

        putbit:         rcr     byte ptr[di],1
                        rol     dl,1
                        jnc     @f
                        inc     di
        @@:             ret

; Right adjust the bits in the last byte

        radjust:        cmp     dl,1    ;any bits in the last byte?
                        je      @b      ;e - no
                        call    putbit  ;else move
                        jmp     radjust ;them right


; Generate the Huffman tree and the table 
; On entry: si - a data array
;           cx = its length
;-

        crehtt:         push    di
                        call    ghist   ;create the initial histogram
                        call    huffcod ;create the tree and the value table

; Copy hval words to htabl bytes

                        mof     di,htabl;
                        mof     si,hval ;
                        push    cx      ;
                @@:     movsb           ;
                        inc     si      ;keep wordaligned
                        loop    @b
                        pop     cx
                        pop     di      ;
                        ret

; Recursive procedure to create the Huffman tree and code table

        huffcod:        call    sorthist;sort the histogram
                        cmp     cx,2    ;only two non zero?
                        ja      @f      ;a - more than 2
                        mov     htree,0
                        mov     htree+1,-1
                        mov     htree+2,-1
                        ret

        @@:             mov     bx,cx   ;bx = count of table items
                        shl     bx,1    ;word pointer after last
                        push    hval-2[bx]      ;save last
                        push    hval-4[bx]      ;save pre-last
                        clr     ax              ;
                        xchg    ax,hist-2[bx]   ;last qty = 0
                        add     hist-4[bx],ax   ;add last qty to pre-last
                        call    huffcod ;get in cx = table length
        @@:             pop     ax      ;get pre-last

; Locate pre-last in the table

                        mof     di,hval ;
                        push    cx      ;save table length
                        repne   scasw   ;di - after pre-last in table
                        mof     ax,hval ;
                        sub     ax,di
                        neg     ax      ;
                        shr     ax,1    ;ax = relative position
                        mov     bx,ax   ;remember it
                        pop     cx      ;cx = length of the table
                        cmp     ax,cx   ;any values to the right
                        je      @f      ;e, no

; Shift the values to the right one position right

                        push    di      ;save position after the 'pre-last'
                        push    cx      ;save table length
                        sub     cx,ax   ;how much to move to make place
                        add     di,cx   ;di is a
                        add     di,cx   ;word pointer
                        mov     si,di   ;- after the table
                        dec2    si      ;- last in the table
                        std
                        rep     movsw   ;move the tail one position right
                        cld
                        pop     cx      ;= table length
                        pop     di      ;- after the 'pre-last'

; ax = number of the 'last' node. The first node is number 1.

; Insert the 'last' value in the table

        @@:             pop     [di]    ;

; Locate the n'th leaf (nonzero value) of the htree, ax = n

                        push    cx      ;save table length
                        mov     cx,ax   ;
                        mof     si,htree
        @@:             sar     byte ptr[si],1  ;a leaf?
                        inc     si
                        jnc     @b      ;nc - no
                        loop    @b      ;look for the next leaf
                        pop     cx      ;= table length

; si - after the nth leaf

                        push    si      ;save position after the nth leaf
                        sub     si,offset htree
                        mov     ax,cx   ;
                        sal     ax,1    ;
                        dec     ax      ;2*count-1
                        cmp     si,ax   ;any nodes to the right?
                        je      @f      ;e, no

; Shift the nodes to the right 2 positions right

                        push    cx      ;save table length
                        mof     di,htree;
                        add     di,ax   ;- after last node
                        sub     ax,si   ;ax = tail length
                        mov     cx,ax   ;set a counter
                        mov     si,di
                        dec     si      ;si - last node
                        inc     di      ;di - where it should go (two places to the right)
                        std
                        rep     movsb   ;move the tail two positions right
                        cld
                        pop     cx      ;= table length

; Make the nth leaf a nonleaf and connect to it two leaves

        @@:             pop     di      ;di - after the nth leaf
                        dec     di      ;di - the nth leaf
                        clr     ax      ;
                        stosb           ;make it a nonleaf
                        not     ax      ;
                        stosw           ;and insert the two leaves
                        inc     cx      ;one more value in the code table
                        ret


; Generate a histogram 
; On entry: si - start of data;
;           cx = data length
;

        ghist:

; Clear the histogram array
                        push    cx
                        push    di
                        clr     ax
                        mof     di,hist
                        mov     cx,256
                        rep     stosw
                        pop     di
                        pop     cx

; Increment for each occurence of a value

                        push    si
                        push    cx
        @@:             lodsb
                        clr     ah
                        mov     bx,ax
                        shl     bx,1
                        inc     hist[bx]
                        mov     hval[bx],ax
                        loop    @b
                        pop     cx
                        pop     si
                        ret

;Bubble sort of the histogram (the bigger to the left)
;On exit: cx = count of nonzero elements
; Changes bx !

        sorthist:       push    si
                        mov     bx,255

        hs1:            mof     si,hist
                        mov     cx,bx
        hs2:            lodsw           ;get next element
                        cmp     ax,[si] ;is it > the next on the right
                        jae     @f      ;ae, yes
                        xchg    ax,[si] ;
                        mov     [si-2],ax
                        mov     ax,hval-hist-2[si]
                        xchg    ax,hval-hist[si]
                        mov     hval-hist-2[si],ax
        @@:             loop    hs2
                        dec     bx
                        jnz     hs1


; Count the non0 elements of the histogram i.e. find the 1st 0 element

                        mof     si,hist
                        mov     cx,256
        @@:             lodsw
                        or      ax,ax
                        loopne  @b

        @@:             sub     si,offset hist+2 ;si - after the 0
                        mov     cx,si
                        shr     cx,1
                        pop     si
                        ret


; Select the core and halo 
;

                selhalo:
                        push    di
                        push    es
                        push    ds

; Clr cor and mir
                        call    clr_cor
                        call    clr_mir

                        mov     ds,picseg
                        mov     si,320*9+43
                        clr     di
                        mov     bx,145
                ss2:    mov     cx,256
                ss1:    lodsb
                        cmp     al,16
                        jbe     @f
                        mov     es,cs:cor
                        stosb
                        dec     di
                @@:     cmp     al,16           ;replace color 16 by 14
                        jne     @f
                        mov     al,14
                @@:     mov     es,cs:mir
                        stosb
                        or      al,al
                        jz      @f
                @@:     loop    ss1
                        add     si,320-256
                        dec     bx
                        jnz     ss2

                        pop     ds
                        pop     es
                        pop     di
                        ret

                select:
                        push    es
                        mov     es,gramem
                        clr     di
                        mov     cx,64000
                @2:     mov     al,es:[di]
                        cmp     al,112
                        jb      @f
                        cmp     al,223
                        jbe     @1
                @@:     mov     byte ptr es:[di],0
                @1:     inc     di
                        loop    @2
                        pop     es

; Copy graphic memory to mirror

                        call    selint  ;get int(x) in mir
; Exchange mir and gramem

                        mov     es,mir
                        mov     ds,gramem
                        clr     di
                        clr     si
                        mov     cx,64000
                @@:     lodsb
                        xchg    es:[di],al
                        mov     [si-1],al
                        inc     di
                        loop    @b
                        es_cs
                        ds_cs
                        call    expand
                        call    expand
                        call    expand
                        call    expand
                        call    mir_gram
                        ret


                selint:
                        call    clr_mir
                        mov     es,gramem
                        mov     ds,mir
                        clr     di
                        mov     cx,64000

                @3:
                        cmp     byte ptr es:[di],0
                        je      @f     ;skip external
                        cmp     byte ptr es:[di-1],0
                        je      @f   ;skip closing
                        cmp     byte ptr es:[di+1],0
                        je      @f   ;skip closing
                        cmp     byte ptr es:[di-320],0
                        je      @f ;skip closing
                        cmp     byte ptr es:[di+320],0
                        je      @f ;skip closing
                        mov     al,es:[di]
                        mov     [di],al
                @@:     inc     di
                        loop    @3
                        ds_cs
                        es_cs
                        ret

                expand: mov     es,cor
                        clr     al
                        mov     cx,64000
                        clr     di
                        rep     stosb
                        mov     es,mir
                        push    ds
                        mov     ds,gramem
                        clr     di
                        mov     cx,64000

                @5:     mov     al,es:[di]
; Skip external
                        cmp     al,0
                        je      pok
; Skip internal
                @4:     cmp     byte ptr [di],0
                        jne     pok
; Skip nonclosing
minv = 0
                @@:     cmp     byte ptr [di-1],0
                        je      @f
                        mov     bl,es:[di-1]
                        sub     bl,al
                        cmp     bl,minv
                        jbe     pok
                @@:     cmp     byte ptr [di+1],0
                        je      @f
                        mov     bl,es:[di+1]
                        sub     bl,al
                        cmp     bl,minv
                        jbe     pok
                @@:     cmp     byte ptr [di-320],0
                        je      @f
                        mov     bl,es:[di-320]
                        sub     bl,al
                        cmp     bl,minv
                        jbe     pok
                @@:     cmp     byte ptr [di+320],0
                        je      clrp
                        mov     bl,es:[di+320]
                        sub     bl,al
                        cmp     bl,minv
                        jbe     pok
                clrp:   clr     al
                pok:    push    es
                        mov     es,cs:cor
                        stosb
                        pop     es
                        loop    @5

                        pop     ds
                        mov     es,gramem
                        mov     ds,cor
                        mov     cx,64000
                        clr     di
                        clr     si
                        rep     movsb
                        ds_cs
                        es_cs
                        ret

                outsqz:
                        mof     ax,sqzdat

; cx = length to write

                appsqz: push    si
                        push    di
                        push    cx
                        mov     bx,efil
                        mof     dx,sqzdat
                        mov     ah,40h
                        int     21h             ;write via DOS
                        pop     cx
                        pop     di
                        pop     si
                        ret

                xnam    db      'data.huf',0

                output: push    si
                        push    di
                        push    cx
                        push    dx
                        mof     dx,xnam
                        clr     cx              ;read/write attribute
                        mov     ah,3ch
                        int     21h             ;get a file handle
                        mov     bx,ax
                        pop     dx
                        pop     cx
                        mov     ah,40h
                        int     21h             ;write via DOS
                        mov     ah,3eh
                        int     21h             ;close the entry.com file
                        pop     di
                        pop     si
                        ret

;ax = coordiantes
        qqq:            push    es
                        push    dx
                        push    ax
                        push    bx
                        mov     bx,ax
                        mov     al,bh
                        add     al,9
                        clr     ah,ah
                        mul     c320
                        xchg    ax,bx
                        clr     ah
                        add     ax,43
                        add     bx,ax
                        mov     es,gramem
                        mov     byte ptr es:[bx],6
                        pop     bx
                        pop     ax
                        pop     dx
                        pop     es
                        ret

_TEXT ends
                        end     start
