
 ; Size ......... : 182
 ; Title ........ : Morse Coder/Decoder
 ; Author ....... : Chut
 ; Country ...... : Hungary
 ; Competition .. : Hugi Size Coding Competition #8

 ;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
 ; Thanks to Lawrence E. Boothby for the 'sentinel bit' idea. ;
 ;____________________________________________________________;

.286

b               Equ     byte ptr
o               Equ     offset
s               Equ     short

Morse           Segment
                Assume  cs:Morse,ds:Morse
                Org     0100h

Start:          mov     di,o LoadChar   ;00:3
                mov     cl,15h          ;03:2
                cwd                     ;05:1
                call    di              ;06:2
                je      s Decoder       ;08:2

Encoder:        DB      00101110b       ;0A:1 LF (cs:)

                mov     dl,'_'          ;0B:2

                DB      00101110b       ;0D:1 CR (cs:)

                xchg    ax,cx           ;0E:1 1st code <-> BOM
                call    MorseOut        ;0F:3
                xchg    ax,cx           ;12:1 "." <-> 1st code

CheckChar:      cmp     al,61h          ;13:2 abc ---> ABC
                jc      s NoChange      ;15:2
                sub     al,20h          ;17:2

NoChange:       push    o CheckChar     ;19:3
                cmp     al,' '          ;1C:2
                je      s EndOfWord     ;1E:2
                xlatb                   ;20:1
                call    MorseOut        ;21:3
                mov     dl,' '          ;24:2

                DB      82h             ;26:1 skip 3 bytes
                DB      01100001b       ;27:1 '
EndOfWord:      mov     dl,'/'          ;24:2

                jmp     s LoadChar      ;28:2

                DB      01001100b       ;2C:1 ,
                DB      01011110b       ;2D:1 -
                DB      01010101b       ;2E:1 .
                DB      00110110b       ;2F:1 /

                DB      00100000b       ;30:1 0
                DB      00100001b       ;31:1 1
                DB      00100011b       ;32:1 2
                DB      00100111b       ;33:1 3
                DB      00101111b       ;34:1 4
                DB      00111111b       ;35:1 5
                DB      00111110b       ;36:1 6
                DB      00111100b       ;37:1 7
                DB      00111000b       ;38:1 8
                DB      00110000b       ;39:1 9
                DB      01111000b       ;3A:1 :
                DB      01101010b       ;3B:1 ;

Decoder:        mov     ds:[di-38h],cl  ;3C:3

                DB      01110011b       ;3F:1 ? (jnc decoder2)
                DB      00110001b       ;40:1

                DB      00000101b       ;41:1 A
                DB      00011110b       ;42:1 B
                DB      00011010b       ;43:1 C
                DB      00001110b       ;44:1 D
                DB      00000011b       ;45:1 E
                DB      00011011b       ;46:1 F
                DB      00001100b       ;47:1 G
                DB      00011111b       ;48:1 H
                DB      00000111b       ;49:1 I
                DB      00010001b       ;4A:1 J
                DB      00001010b       ;4B:1 K
                DB      00011101b       ;4C:1 L
                DB      00000100b       ;4D:1 M
                DB      00000110b       ;4E:1 N
                DB      00001000b       ;4F:1 O
                DB      00011001b       ;50:1 P
                DB      00010100b       ;51:1 Q
                DB      00001101b       ;52:1 R
                DB      00001111b       ;53:1 S
                DB      00000010b       ;54:1 T
                DB      00001011b       ;55:1 U
                DB      00010111b       ;56:1 V
                DB      00001001b       ;57:1 W
                DB      00010110b       ;58:1 X
                DB      00010010b       ;59:1 Y
                DB      00011100b       ;5A:1 Z

EOT:            pop     di              ;5B:1 AL=2E (REQUIRED)
                xchg    ax,dx           ;5C:1
                inc     dx              ;5D:1
                DB      0B8h            ;5E:1
                DB      00110101b       ;5F:1 mov al,EOM | skip 1 byte
                DB      01101101b       ;60:1 `

MorseOut:       xchg    ax,dx           ;     DL=morse AL=separator
NextDigit:      call    SaveChar        ;
                shr     dl,1            ;
                mov     al,'_'          ;
                jnc     s NextDigit     ;
                mov     al,'.'          ;
                jnz     s NextDigit     ;     AL=2E (NECESSARY)
                mov     dl,'/'          ;
                ret                     ;

Decoder2:       call    di              ;     BOM = "_._._/"
                jp      s Decoder2      ;

NewMorseCode:   mov     dh,80h          ;     Set Second Sentinel
Decycle:        call    di              ;     " " | "." | "/" | "_"
Sentinel2:      rcr     dh,1            ;    [C]=1 [C]=1 [C]=1 [C]=0
                jp      s Decycle       ;    [P]=0 [P]=1 [P]=0 [P]=1
                jnc     s Sentinel2     ;

                xchg    ax,cx           ;     CL=current / AL=previous
                sub     al,0Fh          ;
                jp      s NoSpace       ;
                call    SaveChar        ;
NoSpace:        mov     bl,61h          ;     reversed table offset
Search:         dec     bx              ;
                cmp     dh,[bx]         ;
                jne     s Search        ;
                mov     al,bl           ;     AL=ASCII code
                push    o NewMorseCode  ;

SaveChar:       mov     bx,4001h        ;
                mov     [si],al         ;

                DB      0A9h            ;     skip 2 bytes
LoadChar:       mov     bh,3Fh          ;     BL=00 (REQUIRED)

CRtoLF:         pusha                   ;
                mov     dx,si           ;
                xchg    ah,bh           ;     AH=00 <-> BH=function
                mov     cl,01h          ;
                int     21h             ;
                dec     ax              ;     EOF -> [Z]=0
                popa                    ;
                jnz     s EOT           ;
                mov     al,0Ah          ;     put LF into the output puffer
                xchg    al,[si]         ;
                cmp     al,1Ah          ;     correction (F6+CRLF)
                je      s EOT           ;
                org     $-4             ;
                cmp     al,0Dh          ;     CR+LF pair in one code
                je      s CRtoLF        ;
                mov     bx,si           ;
                cmp     al,'_'          ;
                ret                     ;     BL=00 (NECESSARY)

Morse           Ends
                End     Start