; Morse coder/decoder
; Copyright 1999 GreenGhost
;
; 99.06.28 : 337 bytes
;          : 322 bytes - packed data
;          : 317 bytes - accent not moved
;          : 311 bytes - Joshua's readchar
;          : 294 bytes - optimizing
; 99.06.29 : 283 bytes - tree data
;          : 279 bytes - optimizing
;          : 291 bytes - reorganized
;          : 273 bytes - optimized
; 99.07.05 : 271 bytes - optimized
; 99.07.08 : submission 1

org 100h

Separator:
  db '/'			;1  executes as 'das' - harmless

; mov si,Separator		;   point to separator
  call ReadChar			;3
  cmp al,'_'			;2
  je .Morse			;2
    push ax			;1  save char
    mov ax,0000101000000101b	;3  write "_._._"
    call WriteRawMorse		;3
    pop ax			;1  get char
    jmp short .Next		;2
  .Morse:			;
    add word[.ProcessCall+1],byte ProcessMorse-ProcessText	;5  change call
    mov byte[Exit],0C3h         ;5  store "rts"
    mov cl,6			;2  skip "._._/"
    .NextSkip:			;
      call ReadChar		;3  skip char
    loop .NextSkip		;2
;   xor cx,cx			;   clear pattern
  .Next:			;
    .ProcessCall:		;
    call ProcessText		;3
    call ReadChar		;3
  jz .Next                      ;2                      43

Exit:				;
  mov dl,'/'			;2  set separator
  mov ax,0001010100000101b	;3  write "._._."
  jmp short WriteMorse          ;2                      7

ProcessText:                    ;
  cmp al,96                     ;2
  jbe .NotCapitalize            ;2
    sub al,32                   ;2
  .NotCapitalize:               ;
  sub al,32                     ;2
  jae .NotCr                    ;2
    call ReadChar               ;3  skip LF
    mov ax,0000111000000101b    ;3  write "_..._"
    jmp short .Write            ;2
  .NotCr:                       ;
  jne .NotSpace                 ;2
    mov byte[si],'/'            ;3  set separator
    ret                         ;1
  .NotSpace:                    ;
  xchg bx,ax                    ;1  code in bx
  call GetCode                  ;3  get code
  .Write:                       ;
  mov dl,[si]                   ;2  get separator
  mov byte[si],' '              ;3  set separator
; jmp short WriteMorse          ;   write code          33

WriteMorse:                     ;   dl=separator 
  call WriteChar                ;3  write separator     3

WriteRawMorse:                  ;   al=cnt, ah=code
  mov dl,'_'                    ;2  set dash
  shr ah,1                      ;2  test bit
  jnc .NotDot                   ;2  skip if 0
    mov dl,'.'                  ;2  set dot
  .NotDot:                      ;
  dec ax                        ;1  count
  jz .Last                      ;2
    push dx                     ;1  save char
    call WriteRawMorse          ;3  write the rest
    pop dx                      ;1  restore char
  .Last:                        ;                       16
; jmp short WriteChar           ;   write the char

WriteChar:                      ;   char in dl
  push ax                       ;1
  mov ah,6                      ;2  cmd=writechar
  int 21h                       ;2  call dos
  pop ax                        ;1
ret                             ;1                      7

ProcessMorse:			;
  sub al,32			;2  test char
  jb ReadChar			;2  <32 : cr
  je Space			;2  =32 : space
  cmp al,15			;2  .:cy _:nc
  je Slash			;2  =47 : /
    rcl ch,1			;2
    inc cx			;1  increase patterncounter
    ret				;1
  Slash:			;   al=15
  Space:			;   al=0
  mov bl,7			;2
  .NextCheck:			;
    push ax			;1
    call GetCode		;3  get code
    cmp ax,cx			;2  compare to pattern
    pop ax			;1
    je .Found			;2
    inc bx			;1  next code
    cmp bl,65                   ;3
  jne .NextCheck		;2  end of table : CR
    mov dl,13			;2  write CR
    call WriteChar		;3
    mov al,0			;2  clear next separator
    mov [si],al			;2  clear separator
    mov bl,-22			;2  prepare LF
  .Found:			;
  xor cx,cx			;2
  add bl,32                     ;3
  mov dl,bl			;2
  cmp byte[si],15		;3  test separator
  mov byte[si],al               ;2  set separator
  jne .NotSeparator		;2
    push dx			;1  save char
    mov dl,' '			;2  write separator
    call WriteChar		;3
    pop dx			;1  restore char
  .NotSeparator:		;
  jmp short WriteChar           ;2  write char          65
  
ReadChar:			;
  push cx			;1
  mov dx,.GetChar+1		;3  point to parameter
  xor bx,bx			;2  STDIN
  mov cx,1			;3  length=1
  mov ah,3Fh			;2  cmd=read
  int 21h			;2  call dos
;  or ax,ax                      ;2  test length
;  jz .EOF                       ;2'
  dec ax                        ;1  test length
  .GetChar:			;
    mov al,42                   ;2  get char
;    cmp al,26                   ;2
;  .EOF:                         ;
  pop cx			;1
ret                             ;1  ax=char, nz=EOF     18 (23)

GetCode:                        ;   bx=code-32
  xor ax,ax                     ;2  clear pattern
.Get:                           ;
  push bx                       ;1
  mov bl,[Tree-7+bx]            ;4  get code
  shr bl,1                      ;2  shift out bit
  jz .Last                      ;2
    pushf                       ;1  save bit
    call .Get                   ;3  get the rest
    popf                        ;1  restore bit
  .Last:                        ;
  rcl ah,1                      ;2  shift into pattern
  inc ax                        ;1  increase len
  pop bx                        ;1
ret                             ;1  ah=code, al=len     21

Tree:                           ;58
 db 17*2+1      ;7  39 '    .____.
 db 58*2+0      ;8  40               __.._
 db 10*2+1      ;9  41               ._._.
 db 50*2+0      ;10 42               ._._
 db 47*2+0      ;11 43               ____
 db 08*2+0      ;12 44 ,    __..__
 db 22*2+0      ;13 45 -    _...._
 db 09*2+0      ;14 46 .    ._._._
 db 56*2+1      ;15 47 /    _.._.
 db 11*2+0      ;16 48 0    _____
 db 42*2+0      ;17 49 1    .____
 db 28*2+0      ;18 50 2    ..___
 db 54*2+0      ;19 51 3    ...__
 db 40*2+0      ;20 52 4    ...._
 db 40*2+1      ;21 53 5    .....
 db 34*2+1      ;22 54 6    _....
 db 58*2+1      ;23 55 7    __...
 db 29*2+1      ;24 56 8    ___..
 db 11*2+1      ;25 57 9    ____.
 db 24*2+1      ;26 58 :    ___...
 db 32*2+1      ;27 59 ;    _._._.
 db 53*2+0      ;28 60               ..__
 db 47*2+1      ;29 61               ___.
 db 28*2+1      ;30 62               ..__.
 db 30*2+1      ;31 63 ?    ..__..
 db 35*2+0      ;32 64               _._._
 db 37*2+0      ;33 65 A    ._
 db 36*2+1      ;34 66 B    _...
 db 43*2+1      ;35 67 C    _._.
 db 46*2+1      ;36 68 D    _..
 db  0  +1      ;37 69 E    .
 db 53*2+1      ;38 70 F    .._.
 db 45*2+1      ;39 71 G    __.
 db 51*2+1      ;40 72 H    ....
 db 37*2+1      ;41 73 I    ..
 db 55*2+0      ;42 74 J    .___
 db 46*2+0      ;43 75 K    _._
 db 50*2+1      ;44 76 L    ._..
 db 52*2+0      ;45 77 M    __
 db 52*2+1      ;46 78 N    _.
 db 45*2+0      ;47 79 O    ___
 db 55*2+1      ;48 80 P    .__.
 db 39*2+0      ;49 81 Q    __._
 db 33*2+1      ;50 82 R    ._.
 db 41*2+1      ;51 83 S    ...
 db  0  +0      ;52 84 T    _
 db 41*2+0      ;53 85 U    .._
 db 51*2+0      ;54 86 V    ..._
 db 33*2+0      ;55 87 W    .__
 db 36*2+0      ;56 88 X    _.._
 db 43*2+0      ;57 89 Y    _.__
 db 39*2+1      ;58 90 Z    __..
 db 44*2+0      ;59 91               ._.._
 db 0           ;60 92
 db 0           ;61 93
 db 0           ;62 94
 db 0           ;63 95
 db 59*2+1      ;64 96 `    ._.._.
