comment -Ŀ
             entry for HUGI size coding competition #8          
  
  
         
            morse coder / decoder               
          
  
   will probably not work with WIN NT
  
-
.model tiny
.486
.code
.startup
INCLUDE dmc.inc
DOT     = 2             ; value of DIT
BAR     = 1             ; value of DAH
DMCOFS  = 1             ; set up parameters to use sentinel bit method
; I first tried DMCOFS=0, but it turned out to be larger than this way
;       dmc     _..._
;       db      (27h-13-1) dup (?) ; 25 bytes
start:  dmc     _..._           ; SEGCS
        dmc     <mov dx,'/'*256+>,_._._
encode: call    getchar         ; dh: next separator; dl: next code.
        jcxz    noeof
        mov     al,EOM
slash:  mov     dh,'/'          ; eof: print EOM, and a slash before
noeof:  cmp     al,'_'          ; '_' is an invalid character for text
        je      bdec            ; if '_' -> try decoding instead
        aam     61h
        aad     41h             ; upcase, ah=0
        sub     al,13
        je      do              ; 13 -> print
        je      do              ; ignore one byte without affecting register
        org     $-1             ; (neat, isn't it?)

FREE4   MACRO
nonl:   cmp     al,' '-13
        jmp     benc            ; 28..2B
        ENDM

FREE3   MACRO
bdec:   std                     ; bridge to decode
        jmp     dentry          ; 3C..3E
        ENDM

FREE1   MACRO
        EOM     equ     40h
        dmc     ._._.          ; 40 code for EOM
        ENDM

INCLUDE codes.inc
;        db      5 dup(?)
;        dmc     ._.._.
        MAXCODE = MAXCODE+6

benc:   je      slash           ; if ' ', set separator to '/'
        jl      encode          ; if control character, ignore
        jl      encode          ; ignore one byte
        org     $-1
        dmc     ._.._.          ; 60 code for `
do:
        xchg    ax,bp
        mov     al,dh           ; print last code
        call    pgenc           ; print char in al (was:dh) afterwards
        mov     dl,[si+bp]
        mov     dh,' '          ; set separator to ' '
        jcxz    encode          ; if not eof, read next char

gencode:shr     dl,1            ; print code in dl
        jz      @ret
        db      0D6h            ; setalc
        and     al,('.') xor ('_')
        xor     al,'_'          ; calculate '_' (cf=0) or '.' (cf=1)
pgenc:  pusha                   ; print code in dl and char in al
        call    gencode
        popa

putchar:pusha
p:      xchg    dx,ax
        mov     ah,6            ; function 06 works :-)
        int     21h             ; returns al=printed character (WIN, DOS)
        sub     al,3
        cmp     al,10
        je      p               ; if 0D printed, print 0A
        popa
@ret:   ret                     ; return with ah=6

calc:   rcl     dl,1            ; '.': carry set
                                ; '_': carry clear
decode: cmp     al,dh           ; dh='/' and al='/'
        je      nxt             ; ignore first character (BOM), dh=49h
dentry: cmp     al,' '
        jl      next            ; ignore control codes
                                ; ' ' '.' '/' '_'  add  BOM  ' '  '/'
                                ; 20  2E  2F  5F        4A
        sub     al,'_'-4        ; C5e D3o D4e 04o  -->  96e, 11e, 20o
        jpo     calc            ; if '.' or '_', calculate code

find:   xchg    ax,dx           ; '/' or ' ' to dl
        mov     di,offset CODES+MAXCODE
        mov     cl,MAXCODE+1
        repne   scasb           ; find code (in al) in table
        mov     al,ah           ; get previous '/'(D4h) or ' '(C5h) or 4Ah
        add     al,' '-'/'+'_'-4; calculate ' '
        jpe     nosp            ; if not ' ', don't print
        call    putchar
nosp:   xchg    ax,cx           ; get code in al
        call    putchar         ; print it
nxt:    mov     dh,dl
        mov     dl,1
next:   call    getchar
        jcxz    decode          ; (==_._.__._._)

getchar:mov     ah,3Fh
        mov     cx,1            ; read 1 byte
        int     21h
        xchg    ax,cx           ; count -> cx
        dec     cx              ; if char read, cx=0
        mov     di,dx
        mov     al,[di]
        ret

end
