; METALBRAIN's entry for Hugi Size Compo #8 : Morse encoder/decoder
;
;Changelog: 25/06/99 > 264 (finally it works!), 263
;           26/06/99 > 262, 260, 258, 257, 255, 250 (Bugfix: I was outputting
;                 13,32,10 instead of 32,13,10 when word separator (space) +
;                 Newline codes appeared), 249, 248, 247, 246 (1st entry)
;           29/06/99 > 242
;           30/06/99 > 240, 239 (AAAAAARGHHHH!!!! My first entry fails!!!!)
;            1/07/99 > 269 (Fucking winbug!!!!! I found the bug, it's a
;                       Microsoft bug. I must rewrite my entry a lot)
;            2/07/99 > 256, 255, 254, 253 (2nd entry)
;            4/07/99 > 252
;            6/07/99 > 251, 250, 248, 246 (again!, 3rd entry)
;           21/07/99 > 241, 240, 238

                org     256
                mov     dx,BOM          ;DX points to start of next output
loophere2       mov     di,stword+1     ;Set here next symbol
continue        call    getch           ;Get a char from STDIN
                jp      endmorser       ;If parity: AL=60 (point to EOM code)
                                        ;       and get out
                mov     al,[si]         ;Get read char in al
                cmp     al,32           ;If space...
                jz      loopheretoo     ;...Next symbol will start with "/"
                jnc     decode
                call    getch           ;Newline: 2 chars
                mov     al,62           ;Newline code here
decode          cmp     al,'_'
                jz      mtt             ;First time: morse to text if "_"
                jc      noupper         ;Over 95?
                sub     al,32           ; YES: Make upwards (and ` to 64)
                jmp     short noupper
table           db      97      ;39     '
loopheretoo     mov     dl,stword-256
                jmp     short loophere2
                db      76      ;44     ,
                db      94      ;45     -
                db      85      ;46     .
                db      54      ;47     /
                db      32      ;48     0
                db      33      ;49     1
                db      35      ;50     2
                db      39      ;51     3
                db      47      ;52     4
                db      63      ;53     5
                db      62      ;54     6
                db      60      ;55     7
                db      56      ;56     8
                db      48      ;57     9
                db      120     ;58     :
                db      106     ;59     ;
                db      53      ; (Used for EOM)
                db      1
                db      46      ; (Used for Newline)
                db      115     ;63     ?
                db      109     ; (Used for 96) `
                db      5       ;65     Aa
                db      30      ;66     Bb
                db      26      ;67     Cc
                db      14      ;68     Dd
                db      3       ;69     Ee
                db      27      ;70     Ff
                db      12      ;71     Gg
                db      31      ;72     Hh
                db      7       ;73     Ii
                db      17      ;74     Jj
                db      10      ;75     Kk
                db      29      ;76     Ll
                db      4       ;77     Mm
                db      6       ;78     Nn
                db      8       ;79     Oo
                db      25      ;80     Pp
                db      20      ;81     Qq
                db      13      ;82     Rr
                db      15      ;83     Ss
                db      2       ;84     Tt
                db      11      ;85     Uu
                db      23      ;86     Vv
                db      9       ;87     Ww
                db      22      ;88     Xx
                db      18      ;89     Yy
                db      28      ;90     Zz
endmorser       mov     [di-1],byte "/"
noupper         xchg    ax,bp
                mov     bl,[si+bp+table-295]
                push    bx              ;Store it
outputting      mov     al,'_'          ;"_" for 0
                shr     bx,1
                jnc     dash
                mov     al,'.'          ;"." for 1
dash            stosb                   ;Store morse symbol
                jnz     short outputting;Till the code has finished
                dec     di
                call    newfunc09       ;Output morse code
                pop     ax
                cmp     al,53           ;If last code wasn't EOF, continue
                mov     dl,stsymbol-256 ;Next symbol will have a leading " "
                mov     di,stsymbol+1   ;Set here next symbol
                jnz     continue        ;If it was, pass getch through
getch           mov     cl,1            ;one char
readchars       push    dx              ;Preserve DX
                mov     dx,si           ;Store were it will be read
                mov     ah,3fh
                int     33              ;Read char
                pop     dx              ;Restore DX
                add     al,60
endmtt          ret                     ;Back from routine or to DOS
stsymbol        db " "                  ;In mtt, char is placed at stsymbol+1
mtt             mov     cl,5            ;--Decoder
                call    readchars       ;Pass through 5 chars (BOM)
symbolsep       mov     dl,stsymbol-255 ;Place to store decoded chars
wordsep         mov     bp,32768        ;Set marker bit to align
nextmorsechar   call    getch           ;Get char
                jp      endmtt          ;No more chars > back to DOS
                mov     al,[si]         ;Get morse char
                cmp     al,47           ;Is it "/"?
                jz      separation      ;Yes: finish code, next will be
                                        ; another word
                jnc     putbit          ;Over 47 > 59 "_" > Set a zero
                add     al,224          ;Is it " "?
                jz      separation      ;Yes: finish code, next will be
                                        ; another symbol of the same word
                jnc     nextmorsechar   ;Ignore 10 and 13, if carry is on,
                                        ; it was over 32 > 46 "." > Set a one
putbit          xchg    ax,bp           ;Set code in AX
                rcr     ax,1            ;Get a new bit
separation      xchg    ax,bp           ;Set code back in BP, or in AX if
                                        ; we have jumped to separation
                jnz     nextmorsechar   ;If we have jumped to separation, Z
                                        ; flag is still active, if not, read
                                        ; next symbol
                push    bp              ;Next is a: symbol (0) or word (47)
                stc                     ;Set marker bit in morse code
fillit          rcr     ax,1            ;Align code to left
                jnc     fillit          ;Till the bit to align dissapear
                mov     di,table
notfound        scasb                   ;Scan the table
                jnz     notfound        ;Till you find the code
                xchg    ax,di           ;AX=position were the code is found
                add     al,4            ;AL=ASCII code
                mov     di,stsymbol+1
                cmp     al,62           ;Is it newline?
                jnz     nonewline2
                mov     al,0dh          ;Newline
                stosb
                mov     al,0ah
nonewline2      cmp     al,64
                jnz     notilde
                mov     al,96           ;64 must be transformed to 96 (`)
notilde         stosb
                call    newfunc09       ;Output decoded char
                pop     ax
                dec     ax
                js      symbolsep
                mov     dl,stsymbol-256 ;Next char will have leading space
                jmp     short wordsep
newfunc09       pusha
                mov     cx,di
                sub     cx,dx
                mov     si,dx
anotherone      lodsb
                xchg    ax,dx
                mov     ah,6h
                int     33
                loop    anotherone
                popa
                ret
BOM             db "_._._"
stword          db "/"
