    .MODEL TINY             ; $AO/m/l

;------------------------------------------------------------------------------
; Morse coder/decoder, Build 1, for Hugi Compo #8
; by Josha Munnik, The Netherlands
;------------------------------------------------------------------------------
;
; Legal bit:
; The software is provided "as is" and in no event shall the developer or
; distrebutor be liable for any direct or indirect damage to one atom or
; group of atoms (including, but not limited to, both non-living and living
; objects).
;
;------------------------------------------------------------------------------
; To remake:
;
; tasm /z/m entry
; tlink /t entry
;------------------------------------------------------------------------------
; Version history
;
; Build 1
; - 1st version, using code/data mix with coding with stop bit
;------------------------------------------------------------------------------

    .CODE
    ORG 100h

IDEAL
LOCALS @@
P486

;
; Enable statement below to show some debug info
; DEBUG = 1
; Enable below to use additional init code for use with turbo debug
; TURBODEBUG = 1
;

IFDEF DEBUG
INCLUDE "blockinf.mac"
ELSE
MACRO @BlockInfo
ENDM
ENDIF

@BlockInfo <Start>

;
; Constants
;
NEWLINE = 13      ; cr + lf

;
; Requires the following settings for vars:
; BX = 0000
; SI = 0100
;

PROC Start

; DB 2Fh = das
	das                           ; 00
;
; Decide which type of input we have
;
IFDEF TURBODEBUG
    call Init                       ; will jmp to GetChar
ELSE
    call GetChar                    ; 01
ENDIF
    mov dh, 01011000b               ; 04
    cmp al, "_"                     ; 06, morse file ?
    jne E_Start                     ; 08
    mov cl, 5                       ; 10
TableStart:
    mov ax, 3f00h + 10001100b       ; 12 
;
;*** Code 13, 8C = mov r/m16, seg
;
;   db 10001100b ;  13  Dh _..._   140 8Ch 10001100b

;   mov ax, ....                    ; +1 -> next ins start at 15 (relative 01)
    int 21h                         ; 01, skip rest of BOM
D_ResetDI:
    and di,bx                       ; 03
D_AddBit:
    cmc                             ; 05, CF is set when "." or reset when "_"
    rcl di,1                        ; 06
D_NextChar:
    call GetChar                    ; 08
    jnz Exit                        ; 11
    sub al, 2Fh                     ; 15, 2F = '/'
    ja D_AddBit                     ; 17, > then '_' (5F)
    je D_Print                      ; 19
    inc al                          ; 21
    jz D_AddBit                     ; 22, ZF set then 2E = '.'
    cmp al, 30h				; 24
    jp D_NextChar				; 26
;
;*** code 39, 7Ah = jp rel8
;
;   db 01111010b ;  39 27h .____.  122 7Ah 01111010b
;
    dec cx                          ; 01, 00 = relative jp. No prefix char with next code
D_Print:
    jmp D_TestSpace                 ; 02, +2
;
;*** Code 44..59, AA = stosb, E2 = loop, F4 = HLT, ...
; 
    db 11001110b ;  44 2Ch __..__  206 CEh 11001110b
    db 10000110b ;  45 2Dh _...._  134 86h 10000110b
    db 01010110b ;  46 2Eh ._._._   86 56h 01010110b
    db 10010100b ;  47 2Fh _.._.   148 94h 10010100b
    db 11111100b ;  48 30h _____   252 FCh 11111100b
    db 01111100b ;  49 31h .____   124 7Ch 01111100b
    db 00111100b ;  50 32h ..___    60 3Ch 00111100b
    db 00011100b ;  51 33h ...__    28 1Ch 00011100b
    db 00001100b ;  52 34h ...._    12 0Ch 00001100b
    db 00000100b ;  53 35h .....     4 04h 00000100b
    db 10000100b ;  54 36h _....   132 84h 10000100b
    db 11000100b ;  55 37h __...   196 C4h 11000100b
    db 11100100b ;  56 38h ___..   228 E4h 11100100b
    db 11110100b ;  57 39h ____.   244 F4h 11110100b
    db 11100010b ;  58 3Ah ___...  226 E2h 11100010b
    db 10101010b ;  59 3Bh _._._.  170 AAh 10101010b

E_Start:
    nop                         ; 00
    jmp E_UseDash               ; 01 +2
;
;*** Code 63..90
;
    db 00110010b ;  63 3Fh ..__..   50 32h 00110010b
    db 00000000b ; filler
    db 01100000b ;  65 41h ._       96 60h 01100000b
    db 10001000b ;  66 42h _...    136 88h 10001000b
    db 10101000b ;  67 43h _._.    168 A8h 10101000b
    db 10010000b ;  68 44h _..     144 90h 10010000b
    db 01000000b ;  69 45h .        64 40h 01000000b
    db 00101000b ;  70 46h .._.     40 28h 00101000b
    db 11010000b ;  71 47h __.     208 D0h 11010000b
    db 00001000b ;  72 48h ....      8 08h 00001000b
    db 00100000b ;  73 49h ..       32 20h 00100000b
    db 01111000b ;  74 4Ah .___    120 78h 01111000b
    db 10110000b ;  75 4Bh _._     176 B0h 10110000b
    db 01001000b ;  76 4Ch ._..     72 48h 01001000b
    db 11100000b ;  77 4Dh __      224 E0h 11100000b
    db 10100000b ;  78 4Eh _.      160 A0h 10100000b
    db 11110000b ;  79 4Fh ___     240 F0h 11110000b
    db 01101000b ;  80 50h .__.    104 68h 01101000b
    db 11011000b ;  81 51h __._    216 D8h 11011000b
    db 01010000b ;  82 52h ._.      80 50h 01010000b
    db 00010000b ;  83 53h ...      16 10h 00010000b
    db 11000000b ;  84 54h _       192 C0h 11000000b
    db 00110000b ;  85 55h .._      48 30h 00110000b
    db 00011000b ;  86 56h ..._     24 18h 00011000b
    db 01110000b ;  87 57h .__     112 70h 01110000b
    db 10011000b ;  88 58h _.._    152 98h 10011000b
    db 10111000b ;  89 59h _.__    184 B8h 10111000b
    db 11001000b ;  90 5Ah __..    200 C8h 11001000b
; C8 = Enter

@BlockInfo <GetChar Start>

GetChar:
    mov ah, 3fh                           ; +2
    mov dx, OFFSET CopyChar + 2           ; +3
;
;*** Code 96, 4Ah = dec dx
;
;   db 01001010b ;  96 60h ._.._.   74 4Ah 01001010b
    dec dx
TableEnd: 
    mov cx, 1    ; 16 bits move needed else OFFSET CopyChar + 2 = 68h = 'P'
    int 21h
SameChar:
    dec ax
CopyChar:
    mov ax,0620h
Exit:
    ret

@BlockInfo <GetChar>

;
; Decode morse back to text
;
;2Fh = '/'
;20h = ' '
;5Fh = '_'
;2Eh = '.'

D_TestSpace:
    dec si                          ; 1st time SI = 100, else it is 1 or 0
    mov dl, 20h
    jnz D_Scan
    int 21h
D_Scan:
    mov si, cx                      ; copy new prefix char flag

    mov dl, 61h                     ; DH = 1, so load only DL
    xchg dx, di                     ; DL = morse, DI = offset end of table + 1
    stc
D_Init:
    rcl dl,1                        ; rotate stop bit in and continue
    jnc D_Init                      ; until start bit has been rotated out
D_Loop:
    dec di                          ; goto entry
    cmp dl, [di]                    ; compare
    jne D_Loop
    mov dx, di                      ; lsb of DI is ascii

D_PrintChar:
    int 21h                         ; print char
    cmp dl, 13                      ; test for newline
    jne D_ResetDI
    mov dl, 10                      ; add linefeed
    jmp D_PrintChar

@BlockInfo <Decoder>

;
; Encode chars to morse code
;
E_TheEnd:
    inc [byte E_NextChar]	      ; call -> jmp
    mov dh, 01010100b               ; EOM
E_Print:
    int 21h                         ; 1st time: print prefix char (space or /)
    shl dh, 1                       ; get bit
    mov dl, 2Eh                     ; '.'
    jnc E_Print
E_UseDash:
    mov dl, 5Fh                     ; '_'
    jnz E_Print
E_NextChar:
    call SameChar                   ; 1st time no char is read
    mov [byte E_NextChar + 1], offset GetChar - $ ; set prev call to GetChar
    mov dx, 202Fh                   ; DH = ' ', DL = '\'
    js E_TheEnd
    cmp al, 13                      ; ignore LF
    jb E_NextChar
    xchg dl,[si]				; get previous prefix char and set to '/'
    cmp al, dh                      ; equals space ? Y: print '/' with next symbol
    je E_NextChar
    mov [si], dh                    ; else print space with next code
    cmp al,"a"                      ; >= 'a'
    jb E_Scan
    xor al, dh				; al - 32 
E_Scan:
    xchg bl, al
    mov dh,[si + bx]
    xchg bl, al
    jmp E_Print

@BlockInfo <Encoder>

IFDEF TURBODEBUG

Init:
;
; Initialize vars as stated by rules
;
    xor ax,ax
    xor bx,bx
    mov cx,00FFh
    mov dx,cx
    mov si,0100h
    mov di,0FFFEh
    mov bp,0900h
    cld
    jmp GetChar
@BlockInfo <Debugger code>
ENDIF

ENDP

LastToken		  = 79h

ProgSize = $ - Start

; Phase is used to keep track of phase without getting the MCP warning
; uses the fact that unitialised vars always are zero

IF Phase EQ 0
Phase = 1
ELSEIF Phase EQ 1
Phase = 2
ELSEIF Phase EQ 2
Phase = 3
ENDIF

END Start

