by  EQU <BYTE PTR>
wo  EQU <WORD PTR>
dwo EQU <DWORD PTR>
off EQU <OFFSET DS:>

;*** Morse code format : 1='_'   0='.'
;    the bits are shifted out right and translated, the left most 1 is only
;    used to detirmine the number of dashes and dots in the char,
;    e.g.  10100B wil be translated to .._.
;
; assumptions on entry : bp=09xx, ch=00, si=0100, di=fffe, bx=0000
;
; Compiled using: tasm /ml entry
;                 tlink /t entry

BOM                 EQU       00110101b           ;_._._
EOM                 EQU       00101010b           ;._._.
NEWLINE             EQU       00110001B           ;_..._

SALC                MACRO                         ;Most usefull instruction
                    db        0d6h
                    ENDM

                    .MODEL    TINY
                    
                    .286
                    
                    LOCALS

                    .CODE
                    ORG       100h

Start:              push      1ah                 ;In case of no bytes read
                    mov       dx,sp               ;Destination of read con
                    mov       ah,3fh
                    mov       cl,1
                    int       21h                 ;Read 1 byte from con
                    pop       ax                  ;Zero extended byte read.
                    cmp       al,0ah
                    je        Start               ;0ah may always be ignored
                    cmp       al,61h              ;Limit for CAPS
                    jb        @@IsCap
                    sub       al,20h              ;Make it CAPS
@@IsCap:            cmp       al,1ah
                    push      si                  ;Assume return 100h=Start
                    jne       Go                  ;>> Not EOF, return to 100h
                    push      bx   ;pop si        ;Return will terminate
                    dec       ax                  ;EOM can be found here
                    dec       di                  ;EOM preceeded by WORDSEP
Go:                 cmp       al,' '
wDirect:            cmp       al,'_'              ;Code becomes JMP SHORT ??

         ;*** The next instructions modify the code at wDirect
         ;    "  wDirect: --> jmp short MorseIn"

                    mov   wo [si+wDirect-Start],0ebh+(MorseIn-wDirect-2h)*100h
                    je  short _Ret                ;Yep, is MorseIn so return

         ;*** "  wDirect: --> jmp short MorseOut"
         ;       Send BOM and proces first char of text file
                    
                    
                    mov       bl,BOM              ;BOM code
                    mov       by [si+wDirect-Start+1],bl
                    xchg      ax,di               ;Needed after BOM
                    call      PutMorse            ;Output BOM code
                    xchg      ax,di               ;di=xxff, ax=ASCII char
                                                  ; forces WORDSEP after BOM
MorseOut1:          xchg      ax,bx               ;Code pointer to bp
                    mov       bl,by [bx+si+TableStart-Start-27h] ;Translate
PutSep:             xchg      ax,di               ;Get separator, store 0
                    and       al,0fh              ;Prepare for '/' or ' '
                    
         ;*** The NEWLINE in the next opcode belongs to the table
         ;    adding or removing code below will need the NEWLINE
         ;    to be repositioned in code !!!!!
         ;    The opcode below uses the fact that the parity flag
         ;    is only afected by the low byte of the result, i.e. AL

                    xor       ax,20h+100h*NEWLINE ;xor 20h for ' ' or '/'
                    jpe short _Ret                ;fffe and 1 -> no output
                                                  ;only used by MorseIn

         ;*** Putchar :  if bl==0, output char al to con
         ;                         0dh is expanded to 0dh,0ah.
         ;
         ;               if bl!=0, output char as if ch==0 but is
         ;                         followed by the morsebits stored
         ;                         in bl. Always returns al=-1
         ;
         ;    calling PutMorse only outputs morsebits stored in bl.

PutChar:            xchg      ax,dx               ;Need char in dl
                    mov       ah,6                ;Yep, no way around it.
                    int       21h                 ;Output char to con
                    cmp       al,0dh              ;Test for NEWLINE

         ;*** The EOM in the next opcode belongs to the table
         ;    adding or removing code below will need the EOM
         ;    to be repositioned in code !!!!!

                    mov       ax,0ah+EOM*100h     ;Assume NEWLINE
                    je  short PutChar             ;>> NEWLINE, output 0ah
PutMorse:           shr       bl,1                ;Shift out next morse bit
                    SALC                          ;If CY AL=-1 else AL=0
                    je  short _Ret                ;End if ch has become 0
                    or        al,8eh              ;Convert to '_' or '.'
                    xor       al,0a0h
                    jmp short PutChar             ;Must be next dash or dot

TableStart          db        01011110B           ;"`" =27h .____.
MorseOut:           jne       MorseOut1           ;>> No SPACE, proces char
                    dec       di                  ;Next prefix is WORDSEP
_Ret:               ret                           ;SPACE, gives no output
                    db        1110011B            ;"'" =2ch __..__
                    db        1100001B            ;"-" =2dh _...._
                    db        1101010B            ;"." =2eh ._._._
                    db        0101001B            ;"/" =2fh _.._.
                    db        0111111B            ;"0" =30h _____
                    db        0111110B            ;"1" =31h .____
                    db        0111100B            ;"2" =32h ..___
                    db        0111000B            ;"3" =33h ...__
                    db        0110000B            ;"4" =34h ...._
                    db        0100000B            ;"5" =35h .....
                    db        0100001B            ;"6" =36h _....
                    db        0100011B            ;"7" =37h __...
                    db        0100111B            ;"8" =38h ___..
                    db        0101111B            ;"9" =39h ____.
                    db        1000111B            ;":" =3ah ___...
                    db        1010101B            ;";" =3bh _._._.
RotBp_0:            std                           ;Set DF for use of scasb
                    jmp short RotBp1              ;Finish morse bit scan
                    db        1001100B            ;"?" =3fh ..__..
                    db        -1                  ;Not used
                    db        0000110B            ;"A" =41h ._
                    db        0010001B            ;"B" =42h _...
                    db        0010101B            ;"C" =43h _._.
                    db        0001001B            ;"D" =44h _..
                    db        0000010B            ;"E" =45h .
                    db        0010100B            ;"F" =46h .._.
                    db        0001011B            ;"G" =47h __.
                    db        0010000B            ;"H" =48h ....
                    db        0000100B            ;"I" =49h ..
                    db        0011110B            ;"J" =4ah .___
                    db        0001101B            ;"K" =4bh _._
                    db        0010010B            ;"L" =4ch ._..
                    db        0000111B            ;"M" =4dh __
                    db        0000101B            ;"N" =4eh _.
                    db        0001111B            ;"O" =4fh ___
                    db        0010110B            ;"P" =50h .__.
                    db        0011011B            ;"Q" =51h __._
                    db        0001010B            ;"R" =52h ._.
                    db        0001000B            ;"S" =53h ...
                    db        0000011B            ;"T" =54h _
                    db        0001100B            ;"U" =55h .._
                    db        0011000B            ;"V" =56h ..._
                    db        0001110B            ;"W" =57h .__
                    db        0011001B            ;"X" =58h _.._
                    db        0011101B            ;"Y" =59h _.__
                    db        0010011B            ;"Z" =5ah __..
MorseIn:            je  short RotBp_0             ;SPACE, code finished (STD)
                    jb  short _Ret                ;NEWLINE, gives no output
                    db        0e2h                ;Loop ... so cx=0 -> WORDSEP
                                                  ; nicely skips next opcode
bCmpEntry           db        1010010B            ;"'" =60h ._.._.

                    cmp       al,2fh              ;NC -> DASH, ZF -> end 

RotBp1:             SALC                          ;Zero AL for ' ' or '/'
                    cmc                           ;Toggle CY

         ;*** At entry of RotBp : ZF==1 -> Separator detected, CY always 1
         ;                                 cx==0 -> terminated by '/'
         ;                                 cx==1 -> terminated by ' '
         ;                        ZF==0 -> No separator detected, dash or dot
         ;                                 CY==1 for dash, CY==0 for dot


RotBp:              rcr       bp,1                ;Rotate morse bit in
                    jne short _Ret                ;rcr doesn't afect ZF !!
                    jnc short RotBp               ;Put morse bits into place
                    
         ;*** At this point :  ax=0
         ;                     cx==0 -> next prefix is WORDSEP
         ;                     cx==1 -> next prefix is SYMBOLSEP
         ;                     di==0 -> this prefix is WORDSEP
         ;                     di==1 || di==fffe -> this prefix is SYMBOLSEP
         ;                     LOW  bp = Morse bits from input as in table
         ;                     HIGH bp!= 0 -> BOM, initial bp != 8000h
         ;                     CY=1, DF=1

                    xchg      ax,bp
                    rcr       bp,1
                    sahf
                    js  short _Ret
                    push      cx
                    call      PutSep              ;Output separator if needed
                    xchg      ax,di               ;Morse code back into al
                                                  ;PutSep stuffed it in di
                    mov       cl,61h              ;Bottom gives ASCII 60h='`'
                    mov       di,off bCmpEntry    ;Bottom of table (DF=1)
                    repne scasb                   ;Morse --> ASCII in cl
                    pop       di                  ;Next separator <-- cx
                    xchg      ax,cx               ;ASCII in al, keeps ch=0
                    jmp short PutChar             ;Output the ASCII char

                    END       Start
