;Morse coder/decoder for Hugi Compo 8
;by st0ne (199 bytes)

.model tiny
.386
.code
.startup
Ideal

	org	0100h

;------------------------------- 44

start:	call	@head
	cmp	al,'_'
	jne	@enc	;7

@dec:	mov	cl,05h
@bom:	call	@read

	db	66h
	org	010Dh
	db	20h+10001b	;0D	xor edx,edx
	db	0D2h

	loop	@bom	;10

@ddo:	stc
@dsto:	adc	cl,cl
@dnxt:	call	@read
	js	@quit		;it's EOF
	cmp	al,0Dh
	je	@dnxt		;it's CRLF	
	add	al,0C5h		;set PF and CF
	jp	@dsto	;16

	xchg	ax,bp		;al=prev sep bp=nxt sep
	inc	ax		;set PF : po for '_' and ' '+C5
	mov	ah,06h		;         pe for '/'+C5
	
	mov	dx,' '
	org	0127h
	db	40h+011110b	;'	mov dx,5E20

	jnp	@dnop
	int	21h
	;jmp	@dnop	;11
	
;------------------------------- 47

	org	012Ch
	db	40h+110011b	;,		jnb 018F
	db	40h+100001b	;-		?
	db	40h+010101b	;.		push bp
	db	20h+10010b	;/	;4

	db	20h+11111b	;0
	db	20h+01111b	;1
	db	20h+00111b	;2
	db	20h+00011b	;3
	db	20h+00001b	;4
	db	20h+00000b	;5
	db	20h+10000b	;6
	db	20h+11000b	;7
	db	20h+11100b	;8
	db	20h+11110b	;9	;10

	db	40h+111000b	;:		js 01A6
	db	40h+101010b	;;		?

	db	0,0,0

	db	40h+001100b	;?		dec sp
	db	0			;7

	db	04h+01b		;A		add ax,1A18
	db	10h+1000b	;B
	db	10h+1010b	;C
	db	08h+100b	;D
	db	02h+0b		;E
	db	10h+0010b	;F
	db	08h+110b	;G
	db	10h+0000b	;H
	db	04h+00b		;I
	db	10h+0111b	;J
	db	08h+101b	;K
	db	10h+0100b	;L
	db	04h+11b		;M
	db	04h+10b		;N
	db	08h+111b	;O
	db	10h+0110b	;P
	db	10h+1101b	;Q
	db	08h+010b	;R
	db	08h+000b	;S
	db	02h+1b		;T
	db	08h+001b	;U
	db	10h+0001b	;V
	db	08h+011b	;W
	db	10h+1001b	;X
	db	10h+1011b	;Y		sbb bx,[si]
	db	10h+1100b	;Z	;26	sbb al,?

;------------------------------- 23

@dret:	db	33h,0C9h		;xor cx,cx
	jmp	@ddo	;4

@read:	push	cx
	
	org	0160h
last:	db	40h+010010b	;`	push dx

	mov	ah,3Fh
	mov	cl,01h
	mov	dx,si
	int	21h
	mul	[byte si]
	pop	dx
	pop	cx
	cmp	al,0Ah
	je	@read
@quit:	ret		;19

;------------------------------- 29

@enc:	push	ax
	mov	dl,'_'
	mov	al,10h+0101b	;BEGIN

	call	@disp
	pop	ax
	mov	dl,'/'	;11

@edo:	cmp	al,' '
	je	@esep

	aam	061h
	aad	041h		;ah=0
	xchg	ax,bp
	mov	al,[si+bp]
	call	@disp
	mov	dl,' '
	jmp	@eloop	;18

;------------------------------- 19

@dnop:	mov	dx,offset last+1
@dsrch:	dec	dx
	cmp	cl,[edx]
	jne	@dsrch
@dlf:	int	21h
	cmp	al,0Dh
	mov	dl,0Ah
	je	@dlf
	jmp	@dret

;------------------------------- 34

@esep:	mov	dl,'/'

@eloop:	call	@read
	jns	@edo	;7

	mov	dl,'/'
	mov	al,20h+01010b	;END

@disp:	cbw
	bsr	cx,ax		;morse code size
	shrd	bp,ax,cl	;al>>cl in bp
	inc	cx	;12	;separator

@d2:	mov	ah,06h
	int	21h
	mov	dl,'.'
	add	bp,bp
	jnc	@d3
	mov	dl,'_'
@d3:	loop	@d2
	ret		;15

;------------------------------- 3

@head:	xchg	ax,bp	;stupid last minute fix
	jmp	@read

end