;[Bonus] Morse coder/decoder for Hugi Compo 8
;by st0ne (209 bytes)

;This version behaves like the example C program when using 
;non redirected mode :
;- you can press ^Z at anytime, not only on the begining of a line
;- it doesn't mess up stdout when you type a CR/LF on stdin

.model tiny
.386
.code
.startup
Ideal

	org	0100h

;------------------------------- 34

start:	xchg	ax,bp		;counter bp=0
	call	@read
	cmp	al,'_'
	jne	@enc1	;8

	lea	si,[si+5]
	lea	bp,[bp-5]	;skip header
	xchg	di,ax	;7

@ddo:	mov	cl,00h
	stc
@dsto:	adc	cl,cl
@dnxt:	call	@read
	jz	@quit		;it's EOF
	js	@dnxt		;it's CRLF
	add	al,0CDh		;set PF and CF
	jnp	@dsto	;16

	xchg	di,ax		;al=prev sep
	mov	ah,06h	;3	;di=nxt sep
	
;------------------------------- 32
	
	db	66h
data:	db	20h+10001b	;0D		xor edx,edx
	db	0D2h

	mov	dl,' '
	cmp	al,'/'+0CDh	
	jne	@dnop	;9

	int	21h
@dnop:	mov	dx,0161h
@dsrch:	dec	dx
	cmp	cl,[edx+16h]	;(offset last-160h)
	jne	@dsrch	;12

@dcr:	int	21h
	cmp	al,0Dh
	mov	dx,0Ah	;6

	org	data-0Dh+27h
	db	40h+011110b	;'		pop si

	jne	@ddo	
	jmp	@dcr	;5

;------------------------------- 47

	org	data-0Dh+2Ch
	db	40h+110011b	;,		jnb 018F
	db	40h+100001b	;-		?
	db	40h+010101b	;.		push bp
	db	20h+10010b	;/	;4

	db	20h+11111b	;0
	db	20h+01111b	;1
	db	20h+00111b	;2
	db	20h+00011b	;3
	db	20h+00001b	;4
	db	20h+00000b	;5
	db	20h+10000b	;6
	db	20h+11000b	;7
	db	20h+11100b	;8
	db	20h+11110b	;9	;10

	db	40h+111000b	;:		js 01A6
	db	40h+101010b	;;		?

@enc1:	push	ax
	jmp	@enc2-2		;without -2 it's a morse code !

	db	40h+001100b	;?		dec sp
	
@quit:	ret				;7

	db	04h+01b		;A		add ax,1A18
	db	10h+1000b	;B
	db	10h+1010b	;C
	db	08h+100b	;D
	db	02h+0b		;E
	db	10h+0010b	;F
	db	08h+110b	;G
	db	10h+0000b	;H
	db	04h+00b		;I
	db	10h+0111b	;J
	db	08h+101b	;K
	db	10h+0100b	;L
	db	04h+11b		;M
	db	04h+10b		;N
	db	08h+111b	;O
	db	10h+0110b	;P
	db	10h+1101b	;Q
	db	08h+010b	;R
	db	08h+000b	;S
	db	02h+1b		;T
	db	08h+001b	;U
	db	10h+0001b	;V
	db	08h+011b	;W
	db	10h+1001b	;X
	db	10h+1011b	;Y		sbb bx,[si]
	db	10h+1100b	;Z	;26	sbb al,?

;------------------------------- 32

@read:	dec	bp		;buffer empty ?
	jg	@rok	;3

	mov	si,[bx]		;buffer at CD20h

	org	data-0Dh+60h
last:	db	40h+010010b	;`	;6	;push dx
	
	push	cx
	mov	ah,3Fh
	mov	dx,si
	mov	ch,01h
	int	21h
	pop	cx
	pop	dx	;14

	xchg	ax,bp
	or	bp,bp
	jz	@quit	;5

@rok:	lodsb
	cmp	al,0Dh
	jne	@rtst
	dec	bp
	inc	si
@rtst:	cmp	al,1Ah
	ret		;10

;------------------------------- 30

@enc2:	mov	dl,'_'
	mov	al,10h+0101b	;BEGIN
	call	@disp
	pop	ax
	mov	dl,'/'	;10

@edo:	cmp	al,' '
	je	@esep
	aam	061h
	aad	041h		;ah=0
	xchg	ax,di
	mov	al,[di+offset data-0Dh]
	call	@disp
	mov	dl,' '
	jmp	@eloop	;20

;------------------------------- 34

@esep:	mov	dl,'/'
	
@eloop:	call	@read
	jnz	@edo	;7

	mov	dl,'/'
	mov	al,20h+01010b	;END

@disp:	cbw
	bsr	cx,ax		;morse code size
	shrd	di,ax,cl	;al>>cl in di
	inc	cx	;12	;separator

@d2:	mov	ah,06h
	int	21h
	mov	dl,'.'
	add	di,di
	jnc	@d3
	mov	dl,'_'
@d3:	loop	@d2
	ret		;15

end