/*
 * Hugi size coding compo #08
 * Morse coder/decoder
 *
 * example program
 *
 * version 0.3
 */

/*
  changes:
    0.1: initial version (INT-E)
    0.2: support CRLF    (INT-E)
    0.3: rewrote part of the program to meet the restricted rules.
         dropped size limits. (INT-E)
*/

/*
   running a valid text file through this program twice will
   turn all lower case letters into upper case
*/

#include <stdio.h>

#define BEGIN    256
#define END      257
#define INVCODE  -1
#define MAXLEN   6
#define NUMSYM   258

#define DEBUG(s) /*fprintf(stderr,"%s",s);*/

char *codes[NUMSYM];

void initcodes()
{
    int i;
    for (i = 0; i < NUMSYM; i++) codes[i] = 0;
    codes[BEGIN] = "_._._";    codes[END] = "._._.";
    codes['\n'] = "_..._";     codes[','] = "__..__";
    codes['.'] = "._._._";     codes['?'] = "..__..";
    codes['/'] = "_.._.";      codes['-'] = "_...._";
    codes[':'] = "___...";     codes[';'] = "_._._.";
    codes['`'] = "._.._.";     codes['\''] = ".____.";
    codes['0'] = "_____";
    codes['1'] = ".____";codes['2'] = "..___";codes['3'] = "...__";
    codes['4'] = "...._";codes['5'] = ".....";codes['6'] = "_....";
    codes['7'] = "__...";codes['8'] = "___..";codes['9'] = "____.";
    codes['A'] = codes['a'] = "._";  codes['B'] = codes['b'] = "_...";
    codes['C'] = codes['c'] = "_._.";codes['D'] = codes['d'] = "_..";
    codes['E'] = codes['e'] = ".";   codes['F'] = codes['f'] = ".._.";
    codes['G'] = codes['g'] = "__."; codes['H'] = codes['h'] = "....";
    codes['I'] = codes['i'] = "..";  codes['J'] = codes['j'] = ".___";
    codes['K'] = codes['k'] = "_._"; codes['L'] = codes['l'] = "._..";
    codes['M'] = codes['m'] = "__";  codes['N'] = codes['n'] = "_.";
    codes['O'] = codes['o'] = "___"; codes['P'] = codes['p'] = ".__.";
    codes['Q'] = codes['q'] = "__._";codes['R'] = codes['r'] = "._.";
    codes['S'] = codes['s'] = "..."; codes['T'] = codes['t'] = "_";
    codes['U'] = codes['u'] = ".._"; codes['V'] = codes['v'] = "..._";
    codes['W'] = codes['w'] = ".__"; codes['X'] = codes['x'] = "_.._";
    codes['Y'] = codes['y'] = "_.__";codes['Z'] = codes['z'] = "__..";
}

int isspace(unsigned char a)
{
    return
        (a == 32) /*(a!='\n') && (a <= 32)*/;
}


int searchcode(char *c)
{
    int i;
    for (i = 0; i < NUMSYM; i++) if (codes[i]) {
        if (strcmp(c, codes[i]) == 0)
            return i;
    }
    fprintf(stderr, "error: invalid morse symbol (\"%s\").\n", c);
    return INVCODE;
}

int printcode(int c)
{
    if (! codes[c]) {
        fprintf(stderr, "error: invalid text symbol (`%c'=%d).\n", c,c);
        return -1;
    }
    printf("%s", codes[c]);
    return 0;
}

unsigned char buf[MAXLEN+1];
int  bptr;

int decode()
{
    int i;
    int c = 0, o, nl = 0;
    int state = 0; /* state: 0: before BEGIN; 1: in text; 2: after END */
    int space = -1;
    while (c != EOF) {
        c = getchar();
        if (isspace(c)||(c == '/')||(c==EOF)) {
            buf[bptr] = 0;
            if ((o = searchcode(buf)) == INVCODE)
                return -1;
            if (state == 1) {
                if (o == BEGIN) {
                    fprintf(stderr,"error: second BEGIN found.\n");
                    return -1;
                }
                if (o == END) {
                    if (space == 0) {
                        fprintf(stderr,
                                "error: END must be preceded by `/'.\n");
                        return -1;
                    }
                    state = 2;
                }
            }
            if (state == 1) {
                if (space > 0)
                    putchar(' ');
                space = 0;
                putchar(o);
            }
            if (state == 0) {
                if (o != BEGIN) {
                    fprintf(stderr,"error: BEGIN expected.\n");
                    return -1;
                }
                if (c != '/') {
                    fprintf(stderr,"error: BEGIN must be followed by `/'.\n");
                    return -1;
                }
                state = 1;
                space = -1; /* ugly hack */
            }
            bptr = 0;
            if (c == '/')
                space++;
            nl = 0;
        } else if (c != '\n') {
            if (nl) {
                fprintf(stderr,"error: NEWLINE in morse symbol.\n");
                return -1;
            }
            if (state == 2) {
                fprintf(stderr,"error: extra characters after END.\n");
                return -1;
            }
            buf[bptr++] = c;
            if (bptr > MAXLEN) {
                fprintf(stderr,"error: morse symbol too long.\n");
                return -1;
            }
        } else {
            nl=bptr;
        }
    }
    return 0;
}

int encode()
{
    int i;
    int state = 1; /* state: 0: in word; 1: in white space */
    int c = buf[0];
    printcode(BEGIN);
    do {
        if (isspace(c)) { /* treat as white space */
            if (state) { /* allow only one space in a row */
                fprintf(stderr,"error: extra space.\n");
                return -1;
            }
            state = 1;
            continue;
        }
        if (state)
            putchar('/');
        else
            putchar(' ');
        state = 0;
        if (printcode(c))
            return -1;
    } while ((c = getchar()) != EOF);
    if (state) {
        fprintf(stderr,"error: space at EOF");
        return -1;
    }
    putchar('/');
    printcode(END);
    return 0;
}

int processfile()
{
    int i;
    bptr=0;
    i=getchar();
    if (i==EOF) {
        fprintf(stderr,"error: empty input file");
    }
    buf[bptr++] = i;
    if (i == '_') {
        DEBUG("morse input\n");
        return decode();
    } else {
        DEBUG("text input\n");
        return encode();
    }
}

int main()
{
    int i;
    initcodes();
    i = processfile();
    return -i;
}