O		equ	Offset

S		equ	Short

B		equ	Byte PTR

W		equ	Word PTR

SPEW_A		equ	B [di]

SPEW_F		equ	B [di+1]

SPEW_SP		equ	W [di+2]

SPEW_PC		equ	W [di+4]

.model	tiny

.code

.286

		org	100h

Start:		jmp	Emulator

;------------------------------------------------------------------------------

Return_Gosub:	or	ah,ah

		je	S Return

		mov	cx,SPEW_PC

		sub	SPEW_SP,2

		mov	bx,SPEW_SP

		and	bx,bp

		mov	[bx],cx

		mov	SPEW_PC,si

		ret

Return:		mov	si,SPEW_SP

		and	si,bp

		sub	SPEW_PC,2

		add	SPEW_SP,2

		mov	ax,[si]

		mov	SPEW_PC,ax

		ret

;------------------------------------------------------------------------------

PushB:		dec	SPEW_SP

		mov	bx,SPEW_SP

		and	bx,bp

		mov	cl,[si]

		mov	[bx],cl

		ret

;------------------------------------------------------------------------------

PopB:		mov	bx,SPEW_SP

		and	bx,bp

		mov	ah,[bx]

		mov	[si],ah

		inc	SPEW_SP

		ret

;------------------------------------------------------------------------------

LDA:		mov	SPEW_A,cl

STA:		mov	ah,SPEW_A

		mov	[si],ah

		ret

;------------------------------------------------------------------------------

RDI:		mov	ah,[bx]

		mov	SPEW_A,ah

WRI:		mov	ah,SPEW_A

		mov	[bx],ah

		ret

;------------------------------------------------------------------------------

RDSYS:		mov	ah,es:[si]

		mov	SPEW_A,ah

		ret

;------------------------------------------------------------------------------

ADDW:		mov	al,SPEW_A

		cbw

		add	[si],ax

		ret

;------------------------------------------------------------------------------

JPcc:		or	al,01110000b

		mov	B cs:JP_OpCode,al

		call	Status2F

		jne	S JPcc_JMP

JP_OpCode	equ	$-2

		ret

JPcc_JMP:	mov	ax,si

		cbw

		add	SPEW_PC,ax

		ret

;------------------------------------------------------------------------------

OS_Call:	jne	S OS_Call_jp

		call	Status2F

		mov	al,SPEW_A

		mov	dl,al

		int	21h

		mov	SPEW_A,al

		jmp	S F2S_End

OS_Call_JP:	mov	SPEW_PC,si

		ret

;------------------------------------------------------------------------------

ADCA:		call	Status2F

		adc	SPEW_A,cl

		jmp	S F2S_End

;------------------------------------------------------------------------------

SBBA:		call	Status2F

		sbb	SPEW_A,cl

		jmp	S F2S_End

;------------------------------------------------------------------------------

ORA:		or	SPEW_A,cl

		jmp	S F2S_End

;------------------------------------------------------------------------------

ANDA:		and	SPEW_A,cl

		jmp	S F2S_End

;------------------------------------------------------------------------------

XORA:		xor	SPEW_A,cl

;------------------------------------------------------------------------------

F2S_End:

F2Status:	pushf

		pop	dx

		and	dx,0000100011010101b

		or	dl,dh

		mov	SPEW_F,dl

Status2F:	mov	dl,SPEW_F

		mov	dh,dl

		push	dx

		popf

		ret

;------------------------------------------------------------------------------

Emulator:	mov	bl,B ds:[80h]

		mov	[bx+81h],al

		mov	ah,3dh

		mov	dx,82h

		int	21h

		mov	bx,ax

		mov	dh,0bbh

		mov	ds,dx

		xor	dx,dx

		mov	ah,3fh

		mov	ch,10h

		int	21h

		mov	es,dx

		mov	bx,dx

Zero_page:	mov	[bx],bl

		inc	bl

		jne	Zero_page

		mov	di,0f00h

		mov	bp,0fffh

;------------------------------------------------------------------------------

Processor:	mov	bx,SPEW_PC

		and	bx,bp

		mov	si,[bx]

		mov	ax,si

		mov	bx,si

		shr	bx,12

		add	SPEW_PC,2

		mov	dl,cs:SPEW_SET[bx]

		mov	dh,1

		and	si,bp

		mov	bx,[si]

		and	bx,bp

		xchg	al,ah

		and	al,0fh

		mov	cl,[si]

		call	dx

		jmp	Processor

;------------------------------------------------------------------------------

SPEW_SET	db	O OS_Call	-100h

		db	O Return_Gosub	-100h

		db	O PushB		-100h

		db	O PopB		-100h

		db	O LDA		-100h

		db	O STA		-100h

		db	O RDI		-100h

		db	O WRI		-100h

		db	O RDSYS		-100h

		db	O ADDW		-100h

		db	O JPcc		-100h

		db	O ADCA		-100h

		db	O SBBA		-100h

		db	O ORA		-100h

		db	O ANDA		-100h

		db	O XORA		-100h

Emulator_End	equ	$

		end	Start

