;ķ
; Chris Dragan's entry for Hugi Size Coding Competition #9		     
; Version 10 (6.10.99), 206 bytes, intended for compiling with NASM	     
; Chris Dragan's Corner is at http://ams.ampr.org/cdragan/		     
;Ľ
; Greetings to TAD and st0ne

org 100h

%define A	si-2
%define STATUS	si-1
%define STK	si
%define PC	si+2
%define LO(a)	(a - 100h)

; Opcodes
%define _adc	12h
%define _sbb	1Ah
%define _or	0Ah
%define _and	22h
%define _xor	32h

;Load-image

		; Assumed at startup: bx=0, ch=0

		; Set DTA
			mov	ax, 1A5Ch	; DOSFn - Set DTA
			mov	dx, 1000h	; ImageBase = 1000h
			mov	di, dx
			int	21h

		; Open first parameter's FCB
			cbw
			xchg	ax, dx
			dec	ax		; DOSFn 0Fh - Open FCB
			int	21h

		; Set up FCB and load file
			mov	[bx+7Ch], bl	; CurRec = 0
			mov	[bx+6Ah], di	; RecSize = 1000h
			mov	ah, 14h 	; DOSFn - Read FCB file
			int	21h

		; Prepare first 256 bytes
			mov	bh, 01h 	; bl assumed to be 00h
_prepare_imm:		dec	bx
			mov	[bx+di], bl
			jnz	_prepare_imm

;Executeaninstruction

		; Prepare return address and registers
			pop	es		; Clear ES for RDSYS
			push	word $		; Start of every instruction
			mov	cl, 2		; cx=2 (a constant)
			mov	si, 1F02h	; Pointer to STK register
			mov	bp, 0FFFh	; Cleanup mask

		; Load instruction word
			mov	bx, [PC]
			and	bx, bp
			mov	ax, [bx+di]

		; Execute return _before_ incrementing PC
			cmp	ax, di
			je	_return

		; Increment PC
			add	[PC], cx

		; Separate opcode from data
			xor	dx, dx
			div	di

		; Update jcc instruction for jpcc
			mov	bx, InstrTable
			mov	ah, 71h
			xor	ah, dh
			mov	[byte bx+_jcc_opcode-InstrTable], ah

		; Get target address
			cmp	al, 0Bh
			xlatb
			mov	ah, 01h

		; Handle arithmetic/logic instructions
			jb	_no_arith
			mov	[byte bx+_arith_opcode-InstrTable], al
			mov	al, LO(_arith_opcode)
_no_arith:
		; Store instruction handler address (for ret)
			push	ax
			mov	bx, dx

		; Load flags and accumulator
			mov	ax, [A] 	; Next byte after A is STATUS
			mov	dx, ax
			shr	dh, 4		; Bit 3 (OF) to carry
			rcr	dh, 1		; Set OF according to carry
			sahf

		; Execute instruction
			ret

;Instructions

		; RETURN, JP
_return:		and	bp, [STK]
			add	[STK], cx
			mov	bx, [bp+di]
			db	0BDh ; opcode of "mov bp, X" - skip next instr
_jp equ ($-$$)
			mov	cl, bh
			mov	ah, bl
			jcxz	_oscall
__jp:			mov	[PC], bx
			ret

		; GOSUB, JP
_gosub equ ($-$$)
			sub	[STK], cx
			and	bp, [STK]
			mov	ax, [PC]
			mov	[bp+di], ax
			jmp	short __jp

		; PUSHB
_pushb equ ($-$$)
			dec	word [STK]
			and	bp, [STK]
			mov	al, [bx+di]
			mov	[bp+di], al
			ret

		; POPB
_popb equ ($-$$)
			and	bp, [STK]
			mov	al, [bp+di]
			mov	[bx+di], al
			inc	word [STK]
			ret

		; RDI, LDA
_rdi equ ($-$$)
			mov	bx, [bx+di]
			and	bx, bp
_lda equ ($-$$)
			add	bx, di
			db	0B2h ; opcode of "mov dl, X" - skip prefix
_rdsys equ ($-$$)
			mov	al, [es:bx]
			jmp	short _store_a

		; WRI, STA
_wri equ ($-$$)
			mov	bx, [bx+di]
			and	bx, bp
_sta equ ($-$$)
			mov	[bx+di], al
			ret

		; JPcc, ADDW
_jpcc equ ($-$$)
_jcc_opcode:		jo	_skip_jcc
			xchg	ax, bx
			mov	bx, 0F04h ; PC
_addw equ ($-$$)
			cbw
			add	[bx+di], ax
_skip_jcc:		ret

		; OSCALL
_oscall:		int	21h
			db	0BAh ; opcode of "mov dx, X" - skip next instr

		; ADCA, SBBA, ORA, ANDA, XORA
_arith_opcode:		adc	al, [bx+di]

		; Store flags and accumulator
_store_a_and_flags:	lahf
			pushf
			pop	bx
			and	bx, bp
			xor	ah, bh
_store_a:		mov	[A], ax
			ret

;Instructiontable

InstrTable	db LO(_jp),   LO(_gosub),LO(_pushb),LO(_popb)
		db LO(_lda),  LO(_sta),  LO(_rdi),  LO(_wri)
		db LO(_rdsys),LO(_addw), LO(_jpcc), _adc
		db _sbb,      _or,	 _and,	    _xor

;End-Of-File
