
 ; Size ......... : 198
 ; Title ........ : SPEW emulator
 ; Author ....... : Chut
 ; Country ...... : Hungary
 ; Competition .. : Hugi Size Coding Competition #9
 ;
 ; Compiler ..... : Turbo Assembler v3.2
 ; Linker ....... : Turbo Link v3.01
 ;
 ; Thanks to Lawrence E. Boothby.

.286
.radix 16

w		Equ	word ptr
b		Equ	byte ptr
o		Equ	offset
s		Equ	short

Spew		Segment Use16
		Assume	cs:Spew,ds:Spew
		Org	0100

Start:		or	ax,351Dh	; handler table
		and	ax,8EA3		;
		adc	ax,0A9C4	;
		xchg	ax,cx		;
		test	al,8A		;
		lodsb			;
		mov	ch,94		;

		mov	dx,1000		;
		mov	ax,1A5C		;
		int	21		; set DTA
		cbw			;
		xchg	ax,dx		; DX=005C
		xchg	ax,di		; DI=1000
		mov	ah,0F		;
		int	21		; open FCB
		mov	ah,27		;
		int	21		; read

Fill:		dec	bl		; FF..00
		mov	[di+bx],bl	;
		jnz	s Fill		;

		pop	es		; ES=0000

		push	0129		; SP=-2
		mov	si,1F04		; [SI]=PC
		mov	bp,0FFF		;
		std			;
		lodsw			; [SI]=STK
		xchg	ax,bx		; BX=PC
		and	bx,bp		;
		mov	bx,w [bx+di]	; instruction

		cmp	di,bx		;
		je	s RETURN	;
		sub	[si+2],sp	; PC + 2

		lodsb			; [SI] = STATUS
		lodsb			; [SI] = A
		or	al,02		; IF=1
		mov	ah,al		;
		and	ax,0AD5		; DF=0
		push	ax		; flags for IRET

		mov	ax,di		; AX=1000
		or	al,bh		; 00xx -> OSCALL
		mov	dl,[si]		;
		jz	s OSCALL	;

		xor	al,0D0		; JPcc condition
		mov	b [JPxx],al	;

		shr	ax,4		;
		xchg	ax,bx		;
		mov	bl,[bx]		;
		xchg	ax,bx		; AX=01nn

		sub	al,05		;
		mov	b [ASOAX],al	; arithmetic
		js	s Skip		;
		mov	al,7A		;

Skip:		push	cs		;
		push	ax		;

		and	bx,bp		; BX=0xxx
		mov	ax,[bx+di]	;
		and	ax,bp		; AX=mem[xxx]

		iret			;

OSCALL:		mov	ah,bl		; ah = xx
		mov	al,dl		;
		popf			;
		int	21		;
		mov	[si],al		;

		DB	0BDh		; skip
ASOAX:		adc	[si],al		;

		lodsb			;
		pushf			;
		pop	ax		;
		and	ax,08D5		;
		or	al,ah		;

		DB	0A		; skip
RDI:		xchg	ax,bx		;
		mov	ax,[bx+di]	;

		DB	00		; skip
RDSYS:		mov	ax,es:[bx]	;

LDA:		mov	[si],al		; A / STATUS
		ret			;

POPB:		lodsw			;
RETURN:		and	bp,[si]		;
		mov	ax,[bp+di]	;
		mov	[bx+di],al	;
		sub	bx,di		; BX=1000 / 0xxx
		sbb	[si],sp		; STK + 2 /  + 1
		inc	bx		;
		jg	s RET2		;
		ret			;

ADDW:		lodsb			;
Signed:		cbw			;
		add	[bx+di],ax	;
		ret			;

WRI:		xchg	ax,bx		;
STA:		mov	[bx+di],dl	;
		ret			;

GOSUB:		lodsw			; [SI] -> STK
		add	[si],sp		; STK - 2
		lodsw			; [SI] -> PC
		and	bp,ax		;
		lodsw			;
		mov	[bp+di],ax	;
JUMP:		xchg	ax,bx		;
RET2:		mov	ds:[1F04],ax	; PC = 0xxx
		ret			;

PUSHB:		lodsw			;
		dec	w [si]		; STK - 1
		and	bp,[si]		;
		mov	ax,[bx+di]	;
		mov	[bp+di],al	;
		ret			;

JPcc:		mov	ax,0F04		;
		xchg	ax,bx		;
JPxx:		jmp	s Signed	; PC + pp
		ret			;

Spew		Ends
		End	Start