RADIX 16
P486
greatOne SEGMENT 'CODE' USE16
	ASSUME cs:greatOne
	ASSUME ds:greatOne
	ASSUME es:greatOne

	ORG 100

start:
	mov	fs,ax

	mov	dx,1000
	mov	di,dx
	mov	ah,1a
	int	21

	mov	dx,5c

	mov	ah,0f
	int	21

	mov	word ptr[bx+6ah],di
	mov	ah,14
	int	21


	inc	cx
	push	di
fill:
	stosb
	inc	ax
	loop 	fill

	pop	di

	mov	si,1f02


decode:
	mov	dx,0fff
	push	decode-start+100


decode_one:
	mov	bp,[si+02]
	and	bp,dx

	mov	cx,[di+bp]

	mov	bx,cx
	shr	bx,0c
	mov	al,byte ptr[bx + INSTRUCTIONS]
	mov	byte ptr[JUMP_TO + 1],al

	mov	al,byte ptr[bx + ATM_data - 0bh]
	mov	byte ptr[ATM_execute],al

	mov	bp,cx
	and	bp,dx

	cmp	cx,di
	jz	RETURN

	add 	word ptr [si+02],2

	mov	ax,[si-2]
	mov	bx,ax
	mov	al,ah
	and	ax,08d5
	or	ax,3202
	push	ax

	mov	ax,[di+bp]
	and	ax,dx
	xchg	ax,bx

	mov	ah,cl
	xor	cl,cl
	jcxz	OSCALL
	sub	ch,30
	mov	byte ptr[JUMPC_jump],ch

	popf

JUMP_TO:
	jmp	BEGIN

BEGIN:
GOSUB:
	sub	word ptr [si],02
	mov	bx,[si]
	and	bx,dx
	push	word ptr[si+2]
	pop	word ptr[di+bx]
JUMPU:
	mov	[si+2],bp
	ret

RDI:
	mov	al,[di+bx]
	jmp	SAVE_ACCUM

WRI:
	mov	[di+bx],al
	ret

RDSYS:
	mov	al,fs:[bp]
	jmp	SAVE_ACCUM

ADDW:
	cbw
	add	[di+bp],ax
	ret

PUSHB:
	dec	word ptr [si]
	mov	al,[di+bp]
	mov	bp,[si]
	and	bp,dx
STA:
	mov	[di+bp],al
	ret

POPB:
	mov	bx,[si]
	and	bx,dx
	mov 	ah,[di+bx]
	mov	[di+bp],ah
	inc	word ptr [si]
	ret


JUMPC:
JUMPC_jump:
	jz	JUMPC_true
	ret
JUMPC_true:
	xchg	ax,bp
	cbw
	add	[si+2],ax
	ret

ATM:
ATM_execute:
	db	00,0c3
FLAGS_TO_STATUS:
	xchg	ax,bx
	pushf
	pop	ax
	and	ax,08d5
	or	al,ah
	mov	[si-1],al
LDA:
	xchg	ax,bx

SAVE_ACCUM:
	mov	[si-02],al
	ret

RETURN:
	mov	bx,[si]
	and	bx,dx
	mov	bp,[bx+di]
	add	word ptr [si],02
	jmp	JUMPU

OSCALL:
	popf
	mov	dl,al
	int	21
	jmp	FLAGS_TO_STATUS


ATM_data:
	db	12,1a,0a,22,32	

INSTRUCTIONS:
	db	JUMPU-BEGIN
	db	GOSUB-BEGIN
	db	PUSHB-BEGIN
	db	POPB-BEGIN
	db	LDA-BEGIN
	db	STA-BEGIN
	db	RDI-BEGIN
	db	WRI-BEGIN
	db	RDSYS-BEGIN
	db	ADDW-BEGIN
	db	JUMPC-BEGIN
	db	ATM-BEGIN	
	db	ATM-BEGIN
	db	ATM-BEGIN
	db	ATM-BEGIN
	db	ATM-BEGIN


greatOne ENDS
END start

