comment	-Ŀ
	     entry for HUGI size coding	competition #9		
  
  
    	    
    		   SPEW	emulator	     	     
    	     
  
   no	special	comments
  
-
.model	tiny
.486
.code
.startup
	O	equ	offset
	B	equ	byte ptr
	W	equ	word ptr
	C2	equ	dx	; will hold the	Constant 2 most	of the time
	FFF	equ	di	; contains the 0FFF mask which is needed
				; very (perhaps	too?) often.
	IMAGE	equ	FFF	; I use	it as the IMAGE	base address, too.
	IMAGE_	equ	0FFFh	; this is the base address as a	constant.
	A	equ	0F00h	; offsets of A,STATUS,STK and PC in the
	STATUS	equ	0F01h	; SPEW image
	STK	equ	0F02h
	PC	equ	0F04h

; assumes
;  cx>001F
;  bx=0000
s:	pop	es		; es=0 for rdsys (! beware of stos,movs	!)
	mov	FFF,0FFFh	; initialise the most important	constant.
	mov	dx,FFF		; load image to	0FFF.
	mov	ax,1A5Ch	; set DTA address.
	int	21h
	cbw			; ax=005C
	xchg	dx,ax		; dx=005C (dh=0!); ah=0F OPEN FCB
	int	21h
	mov	ah,27h		; RANDOM BLOCK READ FROM FCB FILE
	int	21h		; read SPEW image.
p0l:	mov	B [IMAGE+bx],bl
	inc	bl
	jnz	p0l		; initialise the first 256 bytes.
; at this point, dh=00 and ch=00, di=0FFF (named FFF or	IMAGE)
main:	push	offset main	; ret is enough	to loop, this also allows
	mov	bp,PC		; some nice tricks like	using opcode imple-
	mov	si,0FFFh+A	; mentations as	sub-routines
	mov	dl,2		; useful constants...but are those the most
				; useful ones?
	mov	bx,W [IMAGE+bp]	; load PC
	call	lwi		; load instruction
	mov	cl,ah		; cx=0 iff OSCALL
	push	ax		; save opcode
	xor	ax,0D100h+O return-O s
; calculate intel - jcc	(works if opcode=Axxx) and entry point for return,
; if it	actually is a return. note that	the condition of jcc can be reversed
; by toggling the LSB of it's opcode.
	cmp	ax,0C100h+O return-O s
	je	nocalc		; it was a return - skip table lookup and
				; advancing PC.
	add	W [IMAGE+bp],C2	; advance PC.
	mov	bx,O optab
	mov	B [O jpccp+bx-O	optab],ah
				; patch	jump for opcode=Axxx.
	shr	ax,12		; ax=operation
	xlat			; al=offset to routine or calc opcode
	cmp	al,33h		; (!) all calc opcodes are smaller than	this
	jae	nocalc
	mov	B [O calcp],al	; patch	calc instruction for opcode>=B000.
	mov	al,O calc-O s	; set entry point
nocalc:	pop	bx		; restore opcode
	and	bx,FFF		; calculate address from opcode.
	mov	ah,1
	push	ax		; calculate entry point	and put	it on stack
	imul	ax,W [si],16	; put V	bit from STATUS	in MSB of ax, then
	shr	ax,1		; set OF to the	MSB in ax.
	lodsw			; set SI to IMAGE+STK, AX=STATUS*100+A.
	sahf			; set other flags.
	ret			; jump to calculated address.

; the entry points below are called with the following values:
; ax=STATUS*100+A,
; bx=0xxx (address from	opcode),
; cx=00xx (high	byte of	opcode),
; dx=0002,
; si=IMAGE+STK=1F01,
; di=0FFF,
; bp=PC=0F04,
; flags	set according to status

return:	call	pop_		; load ax from stack
	add	W [si],C2	; increment stack pointer
	xchg	ax,bx
	jmp	jpu		; load PC with value from stack	(cx is not 0)

popb:	push	bx		; save address
	call	pop_		; load ax from stack
	pop	bx		; restore address
	mov	B [IMAGE+bx],al	; store	byte
	inc	W [si]		; increment stack pointer _after_ storing byte
				; fall through;	the code below does not	change
				; memory
pop_:	mov	bx,W [si]	; bx=stack pointer
lwi:	and	bx,FFF
	mov	ax,W [IMAGE+bx]	; ax=top word from stack
	ret

oscall:	mov	dl,al		; set up arguments for INT 21h
	mov	ah,bl		; set function code
	int	21h		; oscall...(according to my docs, this
				; does change neither dh nor ch)
	mov	bx,0		; this requires	IMAGE=SI,DI or 0
	org	$-2		; skip two bytes, don't change flags
calc:
calcp:	or	al,B [IMAGE+bx]	; this is patched with the correct operation
f2s:	pushf
	pop	bx		; bx=flags
	and	bx,08D5h	; mask the flags we'd like to have
	xor	bh,bl		; combine them
	mov	ah,bh		; and put them in ah
	db	84h		; 84 26	== test	[imm16],ah
				; this skips the instruction at	rdsys:
rdsys:	mov	al,B es:[bx]	; read from system memory (does	not change ah)
stax:	mov	W [si-2],ax	; store	both STATUS and	A
	ret

gosub:	push	bx		; save address
	call	push_		; calculate address on stack and decrement STK
	mov	ax,W [IMAGE+bp]	; get PC
	mov	W [IMAGE+bx],ax	; put it on the	stack
	pop	bx		; and jump to the saved	address	(cx!=0)
jpu:	jcxz	oscall		; if cx=0, it was an OSCALL instruction
	mov	W [IMAGE+bp],bx	; save bx in PC
@ret:	ret

; note:	PC is advanced before executing	JP, but	as the value written to
; PC by	JP does	not depend on the current value	of PC, this does no harm.

jpcc:	xchg	ax,bx		; simulate ADDW	[PC] with A=bl
	mov	bx,bp		; if condition is met
jpccp:	jb	@ret		; conditional jump; condition is reversed

addw:	cbw			; sign extend al
	add	W [IMAGE+bx],ax	; add
	ret

rdi:	mov	bx,W [IMAGE+bx]
	and	bx,FFF		; calculate indirect address
lda:	mov	al,B [IMAGE+bx]	; does not modify ah, which still contains
	jmp	stax		; the old status

pushb:	dec	C2		; modify constant to fit our needs ;-)
push_:	sub	W [SI],C2	; decrement stack pointer by 1 or 2(gosub)
	mov	al,B [IMAGE+bx]	; get byte to push
	mov	bx,STK		; store	byte indirect via stack	pointer
wri:	mov	bx,W [IMAGE+bx]
	and	bx,FFF		; calculate indirect address
sta:	mov	B [IMAGE+bx],al	; store	byte
	ret

dopc	MACRO	op
	op	al,B [bx]	; use the r8,r/m8 opcode
	org	$-1
	ENDM

h	MACRO	n,r:REST	; this is just to help sorting the
	r			; next list correctly
	ENDM

; operation table. contains an offset from s: to the appropriate entry
; point	for opcodes <B000 and the int*l-opcode for the calc operation
; for opcodes >=B000. the order	might seem a bit strange, but it isn't ;-)
optab: ;h n xor	D,...		;n
	h 0,dopc or		;D
	h 1,dopc sbb		;C
	h 2,dopc xor		;F
	h 3,dopc and		;E
	h 4,db O addw-O	s	;9
	h 5,db O rdsys-O s	;8
	h 6,dopc adc		;B
	h 7,db O jpcc-O	s	;A
	h 8,db O sta-O s	;5
	h 9,db O lda-O s	;4
	h A,db O wri-O s	;7
	h B,db O rdi-O s	;6
	h C,db O gosub-O s	;1
	h D,db O jpu-O s	;0
	h E,db O popb-O	s	;3
	h F,db O pushb-O s	;2

end
