;----------------------------------------------------------------------------
; 		 SPEW emulator for the Hugi sizecoding compo #9
;                      based on example written by TAD
;                       By Peter Korsgaard aka Jacmet
; If you want to contact me I can be reached at jacmet@kom.auc.dk
;----------------------------------------------------------------------------
; current file size: 269 bytes.

	.model tiny
	.486

w	equ	word ptr
b	equ	byte ptr
o	equ	offset
s	equ	short
l	equ	low
A	equ	b [si]
STATUS	equ	b [si+1]
STK	equ	w [si+2]
PC	equ	w [si+4]
HLPSTK	equ	cx

	.code
	org 256
start:
	mov	fs,ax			; fs = 0 - for rdsys command
	push	si			; [sp] = 100h (for filling constant area)

; set up filename
	shr	si,1			; si = 80h (length byte of commandline)
        mov 	bl,[si]			; bx = length of commandline
	inc	bx			; point to end
        mov	[bx+si],al		; terminate with zero

	lodsw				; si += 2 (trashes ax)
        mov	dx,si			; ds:dx = filename

; open file
	mov	ax,3D00h		; al already 0 (ah=3Dh -> open file)
	int	21h			; open file (ax = file handle)

; read data
	xchg	bx,ax			; bx = file handle (smaller than mov bx,ax) (ax = 0)
	mov	ch,16 			; faking it.. ;) cx = 4351 ( 0x10FF)
	mov	dx,cx			; memory offset (should be larger than 0x100+filesize(entry.com) (0x10ff)
	mov	ah,3Fh			; ah=0 -> read from file
	int	21h

; set up pointers
	mov	di,dx			; memory offset of spew image

; fill mem[000]..mem[0FF] hex with 00..FF
	pop	bx

fillconstants:
	dec	bx
	mov	byte ptr [di+bx],bl
	jnz	fillconstants

; emulator main loop	
emulate:	
	push	o emulate

	mov	si,10FFh + 0F00h	; A

	mov	ax,PC
	call	helper

	mov	al,2
	call	gojp			; small way of pointing PC to next instruction+fetching instruction (ax = instruction, bx = instruction and 0xFFF)

	test	ah,ah
	jz	short oscall		; 00xx ?		

	push	bx
	mov	bp,ax
	
	shr	ax,12

	cmp	al,0Ah
	ja	short aritmetic

	mov	bx,o decodetable
	xlat

	add	ax,bx
	xchg	ax,bp

	pop	bx

	jmp	bp
							
decodetable	db	l (o jump - o decodetable)	; 0xxx
		db	l (o gosub - o decodetable)	; 1xxx
		db	l (o pushb - o decodetable)	; 2xxx
		db	l (o popb - o decodetable)	; 3xxx
		db	l (o lda - o decodetable)	; 4xxx
		db	l (o sta - o decodetable)	; 5xxx		
		db	l (o rdi - o decodetable)	; 6xxx
		db	l (o wri - o decodetable)	; 7xxx
		db	l (o rdsys - o decodetable)	; 8xxx
		db	l (o addw - o decodetable)	; 9xxx		
		db	l (o jumpcc - o decodetable)	; Axxx

;----------------------------------------------------------------------------
; 00xx    OSCALL xx               Operating System CALL
;----------------------------------------------------------------------------
oscall:
	call	extractflags 		; flags <--<-- STATUS (thanx Ruud)
	mov	ah,al	   	  	; ah = xx
	mov	al,A			; al = A
	mov	dl,al			; dl = A
	int	21h	     		; int 21h  
	mov	A,al			; A = al
	jmp	short packstatus 	; STATUS <--<-- flags

;----------------------------------------------------------------------------
; B/C/D/E/Fxxx combined (selfmodifying code)
;----------------------------------------------------------------------------
modifytable	db	10h  		; adc
		db	18h		; sbb
		db	08h		; or
		db	20h		; and
		db	30h		; xor
aritmetic:
	xchg	ax,bp
	mov	al,b [bp + o modifytable - 0Bh]
	mov	byte ptr aritmetic_modifyme,al
	pop	bx

	call	extractflags
	mov	al,byte ptr [di+bx]

aritmetic_modifyme:
	adc	A,al			; A + mem[xxx] + CF

;----------------------------------------------------------------------------
; pack SPEW "STATUS <--<-- flags"
;----------------------------------------------------------------------------
packstatus:
	pushf
	pop	ax
	and	ax,0000100011010101b
	or	al,ah
	mov	STATUS,al

;----------------------------------------------------------------------------
; extract 80x86 "flags <--<-- STATUS"
;----------------------------------------------------------------------------
extractflags:
	pusha
	lodsw				; ah = STATUS
	mov	al,ah
	and	ax,0000100011010101b
	pushf
	pop	dx
	and	dx,1111011100101010b
	or	dx,ax
	push	dx
	popf
	popa
	ret

;----------------------------------------------------------------------------
; 1000    RETURN                  Return from sub-routine (ie. RET)
;----------------------------------------------------------------------------
return:

	sub	PC,2			; PC - 2
	
	call	HLPSTK

	call	helpermem

	add	STK,2			; STK + 2	
;----------------------------------------------------------------------------
; 0xxx    JP xxx                  Jump to new PC address (ie. JMP)
;----------------------------------------------------------------------------
jump:
	mov	PC,ax			; PC = mem[STK]
	ret

;-----------------------------------------------------------------------------
; 1xxx    GOSUB xxx               Goto sub-routine (ie. a CALL)
;-----------------------------------------------------------------------------
gosub:
	test	bx,bx
	jz	short return

	push	bx

	sub	STK,2			; STK - 2

	call	HLPSTK

	mov	ax,PC			; ax = PC

	mov	WORD PTR [di+bx],ax	; mem[STK] = PC

	pop	ax
	jmp	short jump

;----------------------------------------------------------------------------
; 2xxx    PUSHB xxx               Push memory byte onto the stack
;----------------------------------------------------------------------------
pushb:
	dec	STK			; STK - 1

	mov	dl,byte ptr [di+bx]	; temp = mem[xxx]
	
	call	HLPSTK
	
pushb_cleanup:
	mov	byte ptr [di+bx],dl	; mem[STK] = temp
	ret

;----------------------------------------------------------------------------
; 3xxx    POPB xxx                Pop memory byte from the stack
;----------------------------------------------------------------------------
popb:
	push	bx

	call	HLPSTK

	mov	dl,byte ptr [di+bx]	; temp = mem[STK]

	pop	bx

	call 	pushb_cleanup

	inc	STK			; STK + 1
	ret		
	
;----------------------------------------------------------------------------
; 6xxx    RDI [(xxx)]             Read indirect byte from memory pointer
;----------------------------------------------------------------------------
rdi:
	call	helpermem

;----------------------------------------------------------------------------
; 4xxx    LDA [xxx]               Load A (accumulator) from memory
;----------------------------------------------------------------------------
lda:
	mov	al,byte ptr [di+bx]
	jmp	short rdsys_cleanup

;----------------------------------------------------------------------------
; 7xxx    WRI [(xxx)]             Write indirect byte from memory-pointer
;----------------------------------------------------------------------------
wri:
	call	helpermem

;----------------------------------------------------------------------------
; 5xxx    STA [xxx]               Store A (accumulator) in memory
;----------------------------------------------------------------------------
sta:
	mov	dl,A
	jmp 	short pushb_cleanup

;----------------------------------------------------------------------------
; 8xxx    RDSYS [0000:0xxx]       Read a system byte from segment zero.
;----------------------------------------------------------------------------
rdsys:
	mov	al,FS:[bx]		; read byte from 0000:[bx]

rdsys_cleanup:
	mov	A,al			; A = SYS ram[0000:0xxx]
	ret

;----------------------------------------------------------------------------
; 9xxx    ADDW [xxx],A            Add sign-extended A register to word location
;----------------------------------------------------------------------------
addw:
	lodsb
	cbw

	add	WORD PTR [di+bx],ax	; WORD mem[xxx] + A
	ret

;----------------------------------------------------------------------------
; Acpp    JPcc    +pp             Conditional jump instruction (ie. Jcc) (selfmodifying code)
;----------------------------------------------------------------------------
jumpcc:
	add	bh,70h
	mov	byte ptr jumpcc_modifyme,bh
	
	call	extractflags  		; flags <--<-- STATUS (thanx Ruud)
jumpcc_modifyme:
	jo	short gojp
	ret


gojp:
	cbw
	add	PC,ax			; PC = +pp
	
helpermem:
	mov	ax,WORD PTR [di+bx]
	jmp	short helper
helperstk:
	mov	ax,STK
helper:
	mov	HLPSTK,o helperstk
	mov	bx,0FFFh
	and	bx,ax
	ret

	end	start
