       %pagesize 80,86
       %linum 3
       %nosyms
       %nocref
;
;                entry SPEW emulator for the Hugi compo #9
;
;                         written by TAD
;                         reduced by JAS
;
;
; Compile:
;               TASM entry
;               TLINK /t entry   <--- assemble as a .COM file
;
; Run:
;               entry test.spu
;
;
	.model tiny
;
; the 4096 byte SPEW cpu memory image
;
	.data?
mem     db      256 dup (?)
	db      (0F00h-256) dup (?)
A       db      ?               ; mem[F00]
STATUS  db      ?               ; mem[F01]
STK     dw      ?               ; mem[F02]..mem[F03]
PC      dw      ?               ; mem[F04]..mem[F05]
	db      (1000h-0F06h) dup (?)

xor_XORA = (LOW(x_XORA - start)) XOR 30h
xor_ANDA = ((LOW(x_ANDA - start)) XOR xor_XORA) XOR 20h
xor_ORA = (((LOW(x_ORA - start)) XOR xor_ANDA) XOR xor_XORA) XOR 8
xor_SBBA = ((((LOW(x_SBBA - start)) XOR xor_ORA) XOR xor_ANDA) XOR xor_XORA) XOR 18h
xor_ADCA = (((((LOW(x_ADCA - start)) XOR xor_SBBA ) XOR xor_ORA) XOR xor_ANDA) XOR xor_XORA) XOR 10h
;
; let the code carnage begin...
;
	.code
	org 256
start:

	;; scan filename from command-line ;;

	mov     di,0081h        ; command line
	mov     al," "
skipspaces:
	repz scasb
	lea     dx,[di-1]              ; [DS:DX] --> filename
findend:
	scasb
	jna     findend
	mov     ax,3D00h
	mov     byte ptr [di-1],al      ; null term string

	;; load the 4Kb .SPU image ;;

	int     21h
	jnc     short x_opened
	int     20h
x_opened: xchg  ax,bx
	mov     cx,4096
	mov     di,offset mem
	lea     dx,[di]         ; [DS:DX] --> 4096 buffer
	mov     ah,3Fh
	int     21h             ; read file
	mov     ah,3Eh
	int     21h             ; close file

	;; fill mem[000]..mem[0FF] hex with 00..FF hex ;;

	mov     cx,si           ; cx = 0100 (si init)
	mov     si,di           ; save for later
	xor     ax,ax           ; ax = 0
	.386
	mov     fs,ax           ; for use in RDSYS
	.8086
fillmem:
	stosb
	inc     ax
	loop    fillmem
	
;
;                       The main emulator...
;

emulate:                ; so <ret> comes back
	.386
	push    (256 + emulate - start)
	.8086

	mov     di,offset STK
	mov     bp,offset PC
	mov     cx,0FFFh
	mov     bx,[bp]
	and     bx,cx
	mov     dx,WORD PTR [bx+si]
	cmp     dx,1000h
	jz      short x_RETURN         ; 1000 ?
	add     word ptr [bp],2        ; PC + 2
	or      dh,dh
	jz      x_OSCALL               ; 00xx ?

	mov     bx,00F0h
	and     bl,dh
	and     dx,cx
	.386
	shr     bx,4
	.8086
	mov     al,x_decodetable[bx]
	cbw
	add     ax,offset x_BASE
	mov     bx,dx
	jmp     ax

;
; 00xx    OSCALL xx             Operating System CALL
;
x_OSCALL:
	mov     ah,dl                  ; ah = xx
	mov     al,A                   ; al = A
	mov     dl,al                  ; dl = A
	call    extractflags           ; flags <--<-- STATUS (thanx Ruud)
	int     21h                    ; int 21h
	mov     A,al                   ; A = al
	jmp     short packstatus       ; STATUS <--<-- flags

;
; 1000    RETURN                Return from sub-routine (ie. RET)
;
x_RETURN:
	mov     bx,[di]                ; get address
	and     bx,cx
	mov     dx,WORD PTR [bx+si]
	add     word ptr [di],2        ; STK + 2
	jmp     short x_JP

x_BASE:
;
; Bxxx    ADCA [xxx]            Add byte to the accumulator with Carry
;
x_ADCA:
	xor     al,xor_ADCA
;
; Cxxx    SBBA [xxx]            Subtract byte to the accumulator with Borrow
;
x_SBBA:
	xor     al,xor_SBBA
;
; Dxxx    ORA [xxx]             Logical OR byte to the accumulator
;
x_ORA:
	xor     al,xor_ORA
;
; Exxx    ANDA [xxx]            Logical AND byte to the accumulator
;
x_ANDA:
	xor     al,xor_ANDA
;
; Fxxx    XORA [xxx]            Logical XOR byte to the accumulator
;
x_XORA:
	xor     al,xor_XORA
	mov     byte ptr X_INSTR1,al
	call    extractflags
	mov     al,[bx+si]
x_INSTR1: 
	xor     A,al
; fall thru to packstatus

;
; pack SPEW "STATUS <--<-- flags"
;
packstatus:
	pushf
	pop     ax
	and     ax,0000100011010101b
	or      al,ah
	mov     [di-1],al
	ret

;
; 1xxx    GOSUB xxx             Goto sub-routine (ie. a CALL)
;
x_GOSUB:
	sub     word ptr [di],2        ; STK - 2
	mov     bx,cx
	and     bx,[di]
	mov     ax,[bp]
	mov     WORD PTR [bx+si],ax    ; mem[STK] = PC

;
; 0xxx    JP xxx                Jump to new PC address (ie. JMP)
;
x_JP:
	mov     [bp],dx                ; PC = xxx
	ret

;
; 2xxx    PUSHB xxx             Push memory byte onto the stack
;
x_PUSHB:
	dec     word ptr [di]          ; STK - 1
	mov     ax,[bx+si]
	mov     bx,cx
	and     bx,[di]
x_memal:mov     [bx+si],al      ; mem[STK] = temp
	ret

;
; 3xxx    POPB xxx              Pop memory byte from the stack
;
x_POPB:
	mov     bx,cx
	and     bx,[di]
	mov     ax,[bx+si]             ; temp = mem[STK]
	mov     bx,dx
	mov     [bx+si],al             ; mem[xxx] = temp
	inc     word ptr [di]          ; STK + 1
	ret
	
;
; 6xxx    RDI [(xxx)]           Read indirect byte from memory pointer
;
x_RDI:
	mov     bx,WORD PTR [bx+si]     ; temp = mem[xxx]
	and     bx,cx

;
; 4xxx    LDA [xxx]             Load A (accumulator) from memory
;
x_LDA:
	mov     al,[bx+si]
x_sial: 
	mov     A,al            ; A = mem[temp]
	ret

;
; 7xxx    WRI [(xxx)]           Write indirect byte from memory-pointer
;
x_WRI:
	mov     bx,WORD PTR [bx+si]    ; temp = mem[xxx]
	and     bx,cx
;
; 5xxx    STA [xxx]             Store A (accumulator) in memory
;
x_STA:
	mov     al,A
	jmp     short x_memal

;
; 8xxx    RDSYS [0000:0xxx]     Read a system byte from segment zero.
;
x_RDSYS:
	.386
	mov     al,FS:[bx]
	.8086
	jmp     short x_sial

;
; 9xxx    ADDW [xxx],A          Add sign-extended A register to word location
;
x_ADDW:
	mov     al,A
	cbw
	add     WORD PTR [bx+si],ax    ; WORD mem[xxx] + A
	ret

;
; Acpp    JPcc    +pp           Conditional jump instruction (ie. Jcc)
;
x_JPcc:
	add     dh,070h
	mov     byte ptr x_JP1,dh
	call    extractflags           ; flags <--<-- STATUS (thanx Ruud)
x_JP1:   
	jo      x_goJP
	ret
x_goJP:
	xchg    ax,dx
	cbw
	add     [bp],ax                ; PC = +pp
	ret

;
; extract 80x86 "flags <--<-- STATUS"
;
extractflags:
	.386
	pusha
	.8086
	mov     al,STATUS
	mov     ah,al
	and     ax,0000100011010101b
	pushf
	pop     dx
	and     dx,1111011100101010b
	or      ax,dx
	push    ax
	popf
	.386
	popa
	.8086
	ret

x_decodetable db x_JP-x_BASE            ; 0xxx
	db      x_GOSUB-x_BASE          ; 1xxx
	db      x_PUSHB-x_BASE          ; 2xxx
	db      x_POPB-x_BASE           ; 3xxx
	db      x_LDA-x_BASE            ; 4xxx
	db      x_STA-x_BASE            ; 5xxx
	db      x_RDI-x_BASE            ; 6xxx
	db      x_WRI-x_BASE            ; 7xxx
	db      x_RDSYS-x_BASE          ; 8xxx
	db      x_ADDW-x_BASE           ; 9xxx
	db      x_JPcc-x_BASE           ; Axxx
	db      x_ADCA-x_BASE           ; Bxxx
	db      x_SBBA-x_BASE           ; Cxxx
	db      x_ORA-x_BASE            ; Dxxx
	db      x_ANDA-x_BASE           ; Exxx
	db      x_XORA-x_BASE           ; Fxxx

	end     start
