;ENTRY.ASM	10-15-1999		Hugi #9 emulator task @202 bytes
				.RADIX 16
;*******************************************************************************
;	Copyright (c) Lawrence E. Boothby, 1999, All rights reserved.
;		Contract programming - boothbyl@reed.edu
;					      ^ a lower case L, not 1
;*******************************************************************************
;	I am assuming BX=0, CX=00FF, SI=0100 and SP=FFFE = -2 (full segment)
;
;	Some comments remain from TAD's example program provided with the
;	rules - this was my starting point.
;*******************************************************************************
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY
				ORG 100
;
		; the 4096 byte SPEW cpu memory image
Image	STRUC
 mem	DB	100 dup (?)		;<== DS:DI
	DB	(0F00-100) dup (?)
 A	DB	?			; MEM[0F00]	<==DS:SI, but
 STATUS DB	?			; MEM[0F01]	<== after LODSW
 STK	DW	?			; MEM[0F02],MEM[0F03]
 PC	DW	?			; MEM[0F04],MEM[0F05]
	DW	(1000h-0F00-06) dup (?)
Image	ENDS
;*******************************************************************************
; I had been using a DTA of 1000h, but	on 10-7-1999 Ruud suggested using 0FFF
; which has other advantages.
Start:		MOV	DX,0FFF		;DTA for spew image
		MOV	DI,DX
		MOV	AX,1A5C		;set DTA
		INT	21
		CBW
		XCHG	DX,AX		;DS:005C==>fcb to open
		INT	21
	;	or	al,al		;AL=FF if failed
	;	jns	okay
quit:	;	ret
okay:		MOV	AH,27		;random block read to DTA
		INT	21		;CX=00FF > 20h * 80h  =	 required bytes
	;	dec	ax
	;	js	quit
Init:		MOV	[BX+DI],BL	;fill with 00,01,02, etc.
		INC	BX
		DEC	SI		;from initial SI=0100h
		JNZ	Init
		POP	ES		;ES<--0000 for RDSYS
;**************-----------------************************************************
Emulate:	MOV	SI,1EFF		;spew memory registers <==DS:SI
		LODSW			;AL<--A, AH<--STATUS
		MOV	BX,[SI+02]	;get current program counter
		MOV	BP,DI		;re-initialize BP=0FFF
		AND	BX,BP		;handle wrap around
		MOV	BX,[BX+DI]	;get the opcode
		MOV	CX,BX		;earlier had used SHLD
		DB 0C1,0E9,0C		;SHR  CX,0Ch
		;--------------------------------------------------------+
		DB 60	;PUSHA						 |
		MOV	AL,AH			;			 |
		AND	AX,08D5			;			 |
		PUSH	AX			;save flags		 |
		;   do code modification up here so that instruction	 |
		;   queue will be flushed long before needed		 |
		MOV	SI,OFFSET OpcodeTable -0Bh +01		;	 |
		XOR	BH,0D0			;convert to opcode	 |
	       ;MOV	BYTE PTR Condition,AL	;place opcode		 |
		MOV	[SI+01],BH		;saves byte using SI	 |
		REP	LODSB			;instead of XLAT with BX |
		MOV	BYTE PTR Opcode,AL	;			 |
		POPF				;			 |
		STI				;enable interrupt	 |
		DB 61	;POPA						 |
		;--------------------------------------------------------+
		PUSHF				;save full flags
		; Chut reminded me that SP (can) equal -0002, used repeatedly
		SUB	word ptr [SI+02],SP	;PC + 2
		OR	BH,BH
		JZ	OSCALL
		AND	BX,BP
		JCXZ	JP			;no change to flags
		LOOP	Try_PUSHB		;no change to flags
		JNZ	GOSUB		;thanks Ruud, had done earlier in
					;former version where DI = 1000h = DTA,
		ADD word ptr [SI+02],SP		; now must undo for RETURN
;*******************************************************************************
; 1000	  RETURN		  Return from sub-routine (ie. RET)
;*******************************************************************************
		AND	BP,[SI]
		MOV	BX,[BP+DI]	;temp = mem[STK]
		SUB	[SI],SP
		JMP	SHORT JP
;*******************************************************************************
; 1xxx	  GOSUB xxx		  Goto sub-routine (ie. a CALL)
;*******************************************************************************
GOSUB:		ADD	[SI],SP		; STK - 2
		AND	BP,[SI]
		MOV	AX,[SI+02]
		MOV	[BP+DI],AX	; mem[STK] = PC
;*******************************************************************************
; 0xxx	  JP xxx		  Jump to new PC address (ie. JMP)
;*******************************************************************************
JP:		MOV	[SI+02],BX	; PC = xxx
Try_PUSHB:	LOOP	Try_POPB
;*******************************************************************************
; 2xxx	  PUSHB xxx		  Push memory byte onto the stack
;*******************************************************************************
		DEC	WORD PTR [SI]	; STK - 1
		MOV	AL,[BX+DI]	; temp = mem[xxx]
		AND	BP,[SI]
		MOV	[BP+DI],AL
Try_POPB:	LOOP	Try_LDA
;*******************************************************************************
; 3xxx	  POPB xxx		  Pop memory byte from the stack
;*******************************************************************************
		AND	BP,[SI]
		MOV	AL,[BP+DI]	; temp = mem[STK]
		MOV	[BX+DI],AL	; mem[xxx] = temp
		INC	WORD PTR [SI]	; STK + 1
Try_LDA:	DEC	CX
		JZ	DoLDA
Try_STA:	LOOP	Try_RDI
;*******************************************************************************
; 5xxx	  STA [xxx]		  Store A (accumulator) in memory
;*******************************************************************************
STA:		MOV	[BX+DI],AL	; mem[xxx] = A
Try_RDI:	LOOP	Try_DRI
;*******************************************************************************
; 6xxx	  RDI [(xxx)]		  Read indirect byte from memory pointer
;*******************************************************************************
RDI:		MOV	BX,[BX+DI]	; temp = mem[xxx]
		AND	BX,BP
;*******************************************************************************
; 4xxx	  LDA [xxx]		  Load A (accumulator) from memory
;*******************************************************************************
DoLDA:		MOV	AL,[BX+DI]
		POPF			;discard flags on stack
SaveAX:		MOV	[SI-02],AX	; A = mem[temp]
ToEmulate:	JMP	SHORT Emulate	;because Cxxx - Fxxx will have CX NOT 0
;*******************************************************************************
Try_DRI:	POPF			; flags for opcode Acpp below
		LOOP	Try_RDSYS
;*******************************************************************************
; 7xxx	  WRI [(xxx)]		  Write indirect byte from memory-pointer
;*******************************************************************************
x_WRI:		AND	BP,[BX+DI]	; temp = mem[xxx]
		MOV	[BP+DI],AL	; mem[temp] = A
;*******************************************************************************
Try_ADCA:	DEC	CX
		JS	ToEmulate
;*******************************************************************************
; Bxxx	  ADCA [xxx]		  Add byte to the accumulator with Carry
;*******************************************************************************
; Cxxx	  SBBA [xxx]		  Subtract byte to the accumulator with Borrow
;*******************************************************************************
; Dxxx	  ORA [xxx]		  Logical OR byte to the accumulator
;*******************************************************************************
; Exxx	  ANDA [xxx]		  Logical AND byte to the accumulator
;*******************************************************************************
; Fxxx	  XORA [xxx]		  Logical XOR byte to the accumulator
;*******************************************************************************
	     ;	SAHF			;DEC CX does not modified needed CF
Opcode:		XOR	AL,[BX+DI]	; A - mem[xxx] - CF
PackStatus:	LAHF			;get AH<--most flags
		PUSHF
		POP	DX
	     ;	AND	DH,0A		;isolate overflow and interrupt flag
		AND	DX,BP		;saves byte, thanks, Ruud
		XOR	AH,DH		;insert the overflow flag, clear bit 1
		JMP	SHORT SaveAX
;*******************************************************************************
; 00xx	  OSCALL xx		  Operating System CALL
;*******************************************************************************
OSCALL:		POPF
		MOV	DX,AX		; dl = A
		MOV	AH,BL		; AH = xx
		INT	21
		JMP	SHORT PackStatus ; STATUS <--<-- flags
;*******************************************************************************
Try_ADDW:	LOOP	Try_JPcc
;*******************************************************************************
; 9xxx	  ADDW [xxx],A		  Add sign-extended A register to word location
;*******************************************************************************
ADDW:		CBW
		ADD	[BX+DI],AX	; WORD mem[xxx] + A
Try_JPcc:	LOOP	Try_ADCA
;*******************************************************************************
; Acpp	  JPc	  +pp		  Conditional jump instruction (ie. Jcc)
;*******************************************************************************
JPcpp:		XCHG	BX,AX
		MOV	BX,0F04		;thanks Ruud
Condition:	JO	ADDW		;reuse some code
;*******************************************************************************
Try_RDSYS:	LOOP	Try_ADDW
;*******************************************************************************
; 8xxx	  RDSYS [0000:0xxx]	  Read a system byte from segment zero.
;*******************************************************************************
RDSYS:		DB 26	;ES:
		MOV	AL,[BX]
		JMP	SHORT SaveAX	; A = SYS ram[0000:0xxx]
;*******************************************************************************
OpcodeTable	DB 12,1A,0A,22,32
;*******************************************************************************
ONLY	ENDS
	END Start
