;
;                SPEW emulator for the Hugi compo #9
;
;                       written by MaistroJack
;
;
; Compile:
;               TASM itst
;               TLINK /t itst           <--- assemble as a .COM file
;
; Run:
;               itst test.spu
;
;

                .model tiny
                .486

                .data?
mem             db      256 dup (?)
                db      (0F00h-256) dup (?)
A               db      ?                       ; mem[F00]
STATUS          db      ?                       ; mem[F01]
STK             dw      ?                       ; mem[F02]..mem[F03]
PC              dw      ?                       ; mem[F04]..mem[F05]
                db      (1000h-0F06h) dup (?)

                .code
                org 256
                
start:          mov     fs,ax
                mov     bl,80h
                mov     cl,[bx]
                add     bx,cx
                inc     bx
                mov     [bx],al
                mov     dx,0082h
                mov     ah,3Dh
                int     21h
                mov     bx,ax
                mov     ah,4ch
                jc      short quit
                mov     cx,4096
                mov     dx,offset mem
                mov     ah,3Fh
quit:           int     21h

                mov     ah,0ffh
                mov     di,dx
fillmem:        stosb
                inc     ax
                jnz     short fillmem
                mov     bp,0fffh

emulate:        call    execute1
                jmp     short emulate

;
; 1xxx    GOSUB xxx               Goto sub-routine (ie. a CALL)
;
x_GOSUB:        dec     di
                call    sub_call
                mov     ax,PC
                stosw

;
; 0xxx    JP xxx                  Jump to new PC address (ie. JMP)
;
x_JP:           and     dx,bp
x_JP1:          mov     PC,dx
                ret

;
; 2xxx    PUSHB xxx               Push memory byte onto the stack
;
x_PUSHB:        call    sub_call
                movsb
                ret

;
; 3xxx    POPB xxx                Pop memory byte from the stack
;
x_POPB:         call    sub_call2
                xchg    di,si
                movsb
                inc     STK
                ret
                
x_RDI:          mov     si,[si]
                and     si,bp
                add     si,cx

x_LDA:          mov     al,[si]
Fill_A:         mov     A,al
                ret

;
; 7xxx    WRI [(xxx)]             Write indirect byte from memory-pointer
;
x_WRI:          push    ax
                call    x_RDI
                pop     ax
x_STA:          mov     [si],al
                ret

;
; 8xxx    RDSYS [0000:0xxx]       Read a system byte from segment zero.
;
x_RDSYS:        sub     si,cx
                db 64h                          ; FS:
                lodsb
                jmp     short Fill_A      

;
; 1000    RETURN                  Return from sub-routine (ie. RET)
;
x_RETURN:       call    sub_call2
                mov     dx,[di]
                add     STK,2
                jmp     short x_JP1

sub_call:       dec     di
                mov     STK,di
sub_call2:      and     di,bp
                add     di,cx
                ret

;
; 9xxx    ADDW [xxx],A            Add sign-extended A register to word location
;
x_ADDW:         cbw
                add     [si],ax
                ret

;
; Acpp    JPcc    +pp             Conditional jump instruction (ie. Jcc)
;
x_JPcc:         and     dh,0fh
                xor     dh,71h
                mov     byte ptr [f_comp],dh
                call    extractflags
f_comp:         jo      short x_goJP
                mov     al,dl
                cbw
                add     PC,ax
x_goJP:         ret

execute1:       mov     di,STK
                mov     bx,PC
                and     bx,bp
                mov     dx,WORD PTR mem[bx]
                mov     al,A
        
                cmp     dx,1000h
                jz      short x_RETURN          ; 1000 ?
                add     PC,2
                or      dh,dh
                jz      short x_OSCALL          ; 00xx ?

                mov     si,bp
                and     si,dx
                mov     cx,offset mem
                add     si,cx
                mov     bx,dx
                shr     bx,12
                cmp     bl,0bh
                jae     short sub_proc
                mov     bl,[bx+offset x_decodetable]
                mov     bh,1
                jmp     bx

x_decodetable   db low(offset x_JP)
                db low(offset x_GOSUB)
                db low(offset x_PUSHB)
                db low(offset x_POPB)
                db low(offset x_LDA)
                db low(offset x_STA)
                db low(offset x_RDI)
                db low(offset x_WRI)
                db low(offset x_RDSYS)
                db low(offset x_ADDW)
                db low(offset x_JPcc)

;
; 00xx    OSCALL xx               Operating System CALL
;
x_OSCALL:       mov     ah,dl
                mov     dl,al
                call    extractflags
                int     21h
                mov     A,al
                jmp     short packstatus
        
action  db 10h,18h,08h,20h,30h
sub_proc:       mov     al,[offset action-0bh+bx]
                mov     byte ptr [offset sub_v1],al
                lodsb
                call    extractflags
sub_v1:         adc     A,al

;
; pack SPEW "STATUS <--<-- flags"
;
packstatus:     pushf
                pop     ax
                and     ax,0000100011010101b
                or      al,ah
                mov     STATUS,al

extractflags:   pusha
                mov     al,STATUS
                mov     ah,al
                and     ax,0000100011010101b
                pushf
                pop     dx
                and     dx,1111011100101010b
                or      dx,ax
                push    dx
                popf
                popa
                ret
                     
        end     start
