.model tiny
.386
.code
.startup
Ideal

A	equ	si-2
STATUS	equ	si-1
STK	equ	si
PC	equ	si+2

VAR	equ	si
MEM	equ	di

DATA	equ	0FFFh

;-------------------------------------------------- 29
	org	100h

;Initialization			5
	pop	fs		; mov fs,ax
	mov	MEM,DATA

;Set DTA address		7
	mov	ax,1A5Ch	; ah=1A
	mov	dx,MEM
	int	21h
	
;Open FCB			4
	cbw
	xchg	ax,dx		; dx=005C ah=0F
	int	21h		; ax=0F00

;Sequential Read		7
	mov	ah,14h
	sub	[bx+6Bh],ah
	int	21h		; ax=1403

;Pre-set 00-FF			6
@init:	mov	[bx+MEM],bl
	inc	bl
	jnz	@init

;-------------------------------------------------- 50
	
;Main loop			8
	push	offset $	; sp=-2
	mov	bp,MEM		; bp=0FFF
	mov	VAR,DATA+0F00h

;Read PC / x86 flags / opcode	10
	mov	bx,[PC+2]
	and	bx,bp		; OF=0
	mov	ax,[bx+MEM]	; ax=xaaa (opcode)
	sub	[word PC+2],sp	; PC + 2

;Prepare JPcc & JP		10
	mov	bx,offset tab
	mov	dl,0D1h
	xor	dl,ah
	mov	[bx+offset @JPCC-offset tab],dl
	mov	cl,ah

;Separate Instr and Arg		7
	xor	dx,dx		; dx:ax=0000:xaaa
	inc	bp
	div	bp		; dx:ax=0aaa:000x
	dec	bp		; AF set !
	aaa			; ah=01 al=(al+06)&0F

;Compute address		13
	xlatb
	mov	[offset @arop],al
	cmp	al,30h
	ja	@nota
	mov	al,(offset @arith)-100h
@nota:	push	ax		; jmp ax
	
;Convert STATUS -> x86 flags	9
	lodsw
	shld	bx,ax,5
	ror	bx,1		; set O
;	bt	ax,11
;	rcr	bx,1
	sahf			; set SZAPC

;Jump to emulation routines	3
	mov	bx,dx
	ret			; jmp ax

;--------------------------------------------------

tab:	db	(offset @JPCC)-0100h	; Axxx
	db	10h			; Bxxx
	db	18h			; Cxxx
	db	08h			; Dxxx
	db	20h			; Exxx
	db	30h			; Fxxx
	db	(offset @JP)-0100h	; 0xxx
	db	(offset @GOSUB)-0100h	; 1xxx
	db	(offset @PUSHB)-0100h	; 2xxx
	db	(offset @POPB)-0100h	; 3xxx
	db	(offset @LDA)-0100h	; 4xxx
	db	(offset @STA)-0100h	; 5xxx
	db	(offset @RDI)-0100h	; 6xxx
	db	(offset @WRI)-0100h	; 7xxx
	db	(offset @RDSYS)-0100h	; 8xxx
	db	(offset @ADDW)-0100h	; 9xxx

;--------------------------------------------------

@PUSHB:	dec	[word STK]	; STK--
	and	bp,[STK]
	mov	al,[bx+MEM]	; temp=mem[xxx]
	db	0BBh		; mov bx,...
@WRI:	and	bp,[bx+MEM]	; temp=mem[xxx]
	mov	bx,bp
@STA:	mov	[bx+MEM],al	; mem[temp]=A
	ret

@JPCC:	jc	@jpok
	xchg	ax,bx
	mov	bx,0F04h	; bx = PC-MEM
@ADDW:	cbw
	add	[bx+MEM],ax	; mem[w xxx]+=A
@jpok:	ret

@call:	add	[word STK],sp
	and	bp,[STK]
	mov	ax,[PC+bx-2]
	mov	[bp+MEM],ax
@JP:	jcxz	@OSCAL
	mov	[PC],dx
	ret

@OSCAL:	mov	ah,bl	   	; ah=xx
	mov	dl,al		; dl=al=A
	int	21h
;	mov	[A],al
;	jmp	@pack
	db	0BDh		; mov bp,?
@arith:	mov	al,[bx+MEM]
@arop:	sbb	[A],al
@pack:	pushf
	pop	ax
	and	ah,00001010b	; keep OF & IF
	xor	al,ah
	inc	VAR
	jmp	@load
	org	$-1

@POPB:	and	bp,[STK]
	mov	al,[bp+MEM]	; temp=mem[STK]
	mov	[bx+MEM],al	; mem[xxx]=temp
	inc	[word STK]	; STK++
	ret

@GOSUB:	dec	bx
	mov	bx,0002h
	jns	@call
@ret:	add	[word PC+bx-2],sp
	and	bp,[STK]
	mov	ax,[bp+MEM]
	mov	[PC+bx-2],ax
	sub	[word STK],sp
	ret

@RDI:	and	bp,[bx+MEM]
	mov	bx,bp
@LDA:	mov	al,[bx+MEM]
	db	80h		; skip next (Thanks Chut)
@RDSYS:	mov	al,[fs:bx]	; A=0000:0xxx
@load:	mov	[VAR-2],al
	ret
end