;
; 		 example SPEW emulator for the Hugi compo #9
;
; 			     written by TAD
;
;
; Compile:
;	  	TASM eg
;		TLINK /t eg		<--- assemble as a .COM file
;
; Run:
;		eg test.spu
;
;

	.model tiny

;
; the 4096 byte SPEW cpu memory image
;
	.data?
mem	db	256 dup (?)
	db	(0F00h-256) dup (?)
A	db	?	      		; mem[F00]
STATUS	db	?			; mem[F01]
STK	dw	?			; mem[F02]..mem[F03]
PC	dw	?			; mem[F04]..mem[F05]
	db	(1000h-0F06h) dup (?)

;
; let the code carnage begin...
;
	.code
	org 256
start:

	;; scan filename from command-line ;;

	mov	si,0081h
skipspaces:
	lodsb
	cmp	al," "
	je	short skipspaces

	lea	dx,[si-1]		; [DS:DX] --> filename
findend:
	lodsb
	cmp	al," "
	ja	short findend
	mov	byte ptr [si-1],0

	;; load the 4Kb .SPU image ;;

	mov	ax,3D00h
	int	21h
	jc	quit
	mov	bx,ax
	mov	cx,4096
	lea	dx,mem[0]		; [DS:DX] --> 4096 buffer
	mov	ah,3Fh
	int	21h
	mov	ah,3Eh
	int	21h

	;; fill mem[000]..mem[0FF] hex with 00..FF hex ;;

	mov	cx,256
	sub	bx,bx
fillmem:
	mov	mem[bx],bl
	inc	bx
	loop	fillmem
	
	jmp	emulate

quit:
	mov	ax,4C00h
	int	21h

;
;			The main emulator...
;

emulate:
	call	execute1
	jmp	short emulate


execute1:
	mov	bx,PC
	and	bx,0FFFh
	mov	dx,WORD PTR mem[bx]

	cmp	dh,00h
	jz	short x_OSCALL		; 00xx ?
	cmp	dx,1000h
	jz	short x_RETURN		; 1000 ?

	mov	bx,00F0h
	and	bl,dh
	shr	bx,1
	shr	bx,1
	shr	bx,1			; (DX) = opcode word
	jmp	x_decodetable[bx]

x_decodetable	dw	x_JP		; 0xxx
		dw	x_GOSUB		; 1xxx
		dw	x_PUSHB		; 2xxx
		dw	x_POPB		; 3xxx
		dw	x_LDA		; 4xxx
		dw	x_STA		; 5xxx
		dw	x_RDI		; 6xxx
		dw	x_WRI		; 7xxx
		dw	x_RDSYS		; 8xxx
		dw	x_ADDW		; 9xxx
		dw	x_JPcc		; Axxx
		dw	x_ADCA		; Bxxx
		dw	x_SBBA		; Cxxx
		dw	x_ORA		; Dxxx
		dw	x_ANDA		; Exxx
		dw	x_XORA		; Fxxx

;
; 00xx    OSCALL xx               Operating System CALL
;
x_OSCALL:
	add	PC,2			; PC + 2
	mov	ah,dl	   	  	; ah = xx
	mov	al,A			; al = A
	mov	dl,A			; dl = A
	call	extractflags 		; flags <--<-- STATUS (thanx Ruud)
	int	21h	     		; int 21h  
	mov	A,al			; A = al
	call	packstatus   		; STATUS <--<-- flags
	ret

;
; 0xxx    JP xxx                  Jump to new PC address (ie. JMP)
;
x_JP:
	and	dx,0FFFh
	mov	PC,dx			; PC = xxx
	ret

;
; 1000    RETURN                  Return from sub-routine (ie. RET)
;
x_RETURN:
	mov	bx,STK
	and	bx,0FFFh
	mov	ax,WORD PTR mem[bx]
	mov	PC,ax			; PC = mem[STK]
	add	STK,2			; STK + 2
	ret

;
; 1xxx    GOSUB xxx               Goto sub-routine (ie. a CALL)
;
x_GOSUB:
	add	PC,2			; PC + 2
	sub	STK,2			; STK - 2
	mov	bx,0FFFh
	and	bx,STK
	mov	ax,PC
	mov	WORD PTR mem[bx],ax	; mem[STK] = PC
	and	dx,0FFFh
	mov	PC,dx			; PC = xxx
	ret

;
; 2xxx    PUSHB xxx               Push memory byte onto the stack
;
x_PUSHB:
	add	PC,2			; PC +2
	dec	STK			; STK - 1
	mov	bx,0FFFh
	and	bx,dx
	mov	al,mem[bx]		; temp = mem[xxx]
	mov	bx,0FFFh
	and	bx,STK
	mov	mem[bx],al		; mem[STK] = temp
	ret

;
; 3xxx    POPB xxx                Pop memory byte from the stack
;
x_POPB:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,STK
	mov	al,mem[bx]		; temp = mem[STK]
	mov	bx,0FFFh
	and	bx,dx
	mov	mem[bx],al		; mem[xxx] = temp
	inc	STK			; STK + 1
	ret
	
;
; 4xxx    LDA [xxx]               Load A (accumulator) from memory
;
x_LDA:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	mov	al,mem[bx]
	mov	A,al			; A = mem[xxx]
	ret

;
; 5xxx    STA [xxx]               Store A (accumulator) in memory
;
x_STA:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	mov	al,A
	mov	mem[bx],al		; mem[xxx] = A
	ret

;
; 6xxx    RDI [(xxx)]             Read indirect byte from memory pointer
;
x_RDI:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	mov	bx,WORD PTR mem[bx]	; temp = mem[xxx]
	and	bx,0FFFh
	mov	al,mem[bx]
	mov	A,al			; A = mem[temp]
	ret

;
; 7xxx    WRI [(xxx)]             Write indirect byte from memory-pointer
;
x_WRI:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	mov	bx,WORD PTR mem[bx]
	and	bx,0FFFh		; temp = mem[xxx]
	mov	al,A
	mov	mem[bx],al		; mem[temp] = A
	ret

;
; 8xxx    RDSYS [0000:0xxx]       Read a system byte from segment zero.
;
x_RDSYS:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	push	ES
	sub	ax,ax
	mov	ES,ax
	mov	al,ES:[bx]
	pop	ES
	mov	A,al			; A = SYS ram[0000:0xxx]
	ret

;
; 9xxx    ADDW [xxx],A            Add sign-extended A register to word location
;
x_ADDW:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	mov	al,A
	cbw
	add	WORD PTR mem[bx],ax	; WORD mem[xxx] + A
	ret

;
; Acpp    JPcc    +pp             Conditional jump instruction (ie. Jcc)
;
x_JPcc:
	add	PC,2			; PC + 2
	mov	bx,000Fh
	and	bl,dh
	add	bx,bx
	call	extractflags  		; flags <--<-- STATUS (thanx Ruud)
	jmp	x_condtable[bx]
x_goJP:
	mov	al,dl
	cbw
	add	PC,ax			; PC = +pp
	ret

x_condtable	dw	x_JPOV		; 0
		dw	x_JPNO		; 1
		dw	x_JPC		; 2
		dw	x_JPNC		; 3
		dw	x_JPZ		; 4
		dw	x_JPNZ		; 5
		dw	x_JPBE		; 6
		dw	x_JPA		; 7
		dw	x_JPS		; 8
		dw	x_JPNS		; 9
		dw	x_JPP		; A
		dw	x_JPNP		; B
		dw	x_JPL		; C
		dw	x_JPGE		; D
		dw	x_JPLE		; E
		dw	x_JPG		; F

x_JPOV:	jo	short x_goJP
	ret
x_JPNO:	jno	short x_goJP
	ret
x_JPC:	jc	short x_goJP
	ret
x_JPNC:	jnc	short x_goJP
	ret
x_JPZ:	jz	short x_goJP
	ret
x_JPNZ:	jnz	short x_goJP
	ret
x_JPBE:	jbe	short x_goJP
	ret
x_JPA:	ja	short x_goJP
	ret
x_JPS:	js	short x_goJP
	ret
x_JPNS:	jns	short x_goJP
	ret
x_JPP:	jp	short x_goJP
	ret
x_JPNP:	jnp	short x_goJP
	ret
x_JPL:	jl	short x_goJP
	ret
x_JPGE:	jge	short x_goJP
	ret
x_JPLE:	jle	short x_goJP
	ret
x_JPG:	jg	short x_goJP
	ret


;
; Bxxx    ADCA [xxx]              Add byte to the accumulator with Carry
;
x_ADCA:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	call	extractflags
	mov	al,mem[bx]
	adc	A,al  			; A + mem[xxx] + CF
	call	packstatus
	ret
;
; Cxxx    SBBA [xxx]              Subtract byte to the accumulator with Borrow
;
x_SBBA:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	call	extractflags
	mov	al,mem[bx]
	sbb	A,al			; A - mem[xxx] - CF
	call	packstatus
	ret	
;
; Dxxx    ORA [xxx]               Logical OR byte to the accumulator
;
x_ORA:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	call	extractflags
	mov	al,mem[bx]
	or	A,al			; A - mem[xxx] - CF
	call	packstatus
	ret	
;
; Exxx    ANDA [xxx]              Logical AND byte to the accumulator
;
x_ANDA:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	call	extractflags
	mov	al,mem[bx]
	and	A,al			; A - mem[xxx] - CF
	call	packstatus
	ret	
;
; Fxxx    XORA [xxx]              Logical XOR byte to the accumulator
;
x_XORA:
	add	PC,2			; PC + 2
	mov	bx,0FFFh
	and	bx,dx
	call	extractflags
	mov	al,mem[bx]
	xor	A,al			; A - mem[xxx] - CF
	call	packstatus
	ret	


;
; pack SPEW "STATUS <--<-- flags"
;
packstatus:
	push	ax
	pushf
	pop	ax
	and	ax,0000100011010101b
	or	al,ah
	mov	STATUS,al
	pop	ax
	ret

;
; extract 80x86 "flags <--<-- STATUS"
;
extractflags:
	push	ax
	push	dx
	mov	al,STATUS
	mov	ah,al
	and	ax,0000100011010101b
	pushf
	pop	dx
	and	dx,1111011100101010b
	or	dx,ax
	push	dx
	popf
	pop	dx
	pop	ax
	ret


	end	start
