;**** Test file for spew emulators, hugi compo #9
;
;     compiled using mak.bat test
;     output file test.spu
;
;     no (c), Ruud ....
;

;*** Initial system registers

A_INIT              EQU       0h
F_INIT              EQU       0h
SP_INIT             EQU       0ffeh
PC_INIT             EQU       Entry-Begin

                    INCLUDE SPEW.INC

Start:

bTemp               db        0
wTemp               dw        0
wAddr               dw        0
wWra                dw        0
bByte1              db        0
bByte2              db        0
bByte               db        0

wFlgPtr             dw        bCCFlags            ;Pointer to bCCFlags

;*** List of flags and JPcc opcodes for testing JPcc
;
;    BYTE 0 : opcode JPcc
;    BYTE 1 : Flag contents for cc=TRUE
;    BYTE 2 : Flag contents for cc=FALSE

bCCFlags            db        0a2h,01h,0feh       ;JPC
                    db        0aah,04h,0fbh       ;JPP
                    db        0a0h,08h,0f7h       ;JPOV
                    db        0a4h,40h,0bfh       ;JPZ
                    db        0a8h,80h,07fh       ;JPS
                    db        0a6h,01h,0beh       ;JPBE CY=1
                    db        0a6h,40h,0beh       ;JPBE ZF=1
                    db        0a6h,41h,0beh       ;JPBE CY=ZF=1
                    db        0ach,80h,088h       ;JPL  S=1, O=0
                    db        0ach,08h,077h       ;JPL  O=1, S=0
                    db        0aeh,40h,0b8h       ;JPLE ZF=1, O=S=0
                    db        0aeh,0c0h,036h      ;JPLE ZF=1, O=0, S=1
                    db        0aeh,48h,0bch       ;JPLE ZF=1, O=1, S=0
                    db        0aeh,0c8h,0bfh      ;JPLE ZF=1, O=S=1
                    db        0aeh,80h,037h       ;JPLE ZF=0, O=0, S=1
                    db        0aeh,08h,0beh       ;JPLE ZF=0, O=1, S=0
                    db        0

Go:                 gosub     ShowInput           ;Read console input bytes
                                                  ; and output to console.
                    gosub     ConstCheck          ;Check initial constant area
	gosub	#0eh	;Low memory call
                    gosub     ShowChecksum        ;Output checksum of mem area
                    gosub     ShowThis            ;If returned here, const OK
                    db        '.. constant area OK.',0dh,0ah

                    ;*** Check if the emulator uses the upper 4 bits of
                    ;    the PC correctly

                    lda       wPc+1
                    ora       #0f0h
                    sta       wPc+1               ;Set upper 4 bits of PC
                    lda       wPc+1
                    anda      #0f0h
                    sbba      #0f0h
                    jpnz      PcHighErr           ;>> Upper 4 bits not set
                    gosub     PcCheck1            ;Check if call resets upper
                    jpnz      PcHighErr           ;>> Call doesn't reset upper
                    lda       wPc+1
                    anda      #0f0h
                    sbba      #0f0h
                    jpz       NoPcHighErr         ;>> Return preserves upper

                    ;*** One of the above tests failed, show message and exit

PcHighErr:          gosub     ErrorExit
                    db        'Error high 4 bits of pc !',0dh,0ah

NoPcHighErr:        gosub     ShowThis
                    db        '.. high 4 bits of pc OK.',0dh,0ah

                    ;*** Test how the emulator handles pushb mem[sp]

                    lda       wStack
                    sta       bTemp
                    pushb     wStack
                    rdi       wStack
                    ora       bAccu
                    adca      #1
                    ora       bAccu
                    sbba      bTemp
                    jpz       NoStkPushErr        ;>> pushb OK
                    gosub     ErrorExit
                    db        'Error "pushb mem[sp]" !',0dh,0ah

                    ;*** Test how the emulator handles popb mem[sp]
                    ;    and if the upper 4 bits are OK

NoStkPushErr:       lda       #0feh
                    sta       wStack+1
                    pushb     #0ffh
                    popb      wStack              ;Stack must become ff00
                    lda       wStack
                    ora       bAccu
                    jpnz      StkPopErr           ;>> Lsb != 0
                    lda       wStack+1
                    sbba      #0ffh
                    jpz       NoStkPopErr         ;>> popb mem[sp] OK.
StkPopErr:          gosub     ErrorExit
                    db        'Error "popb mem[sp]" !',0dh,0ah


NoStkPopErr:        lda       #0feh
                    sta       wStack              ;SP=0fffeh -> mem[sp]=0ffeh
                    gosub     ShowThis
                    db        '.. pushb and popb for mem[sp] OK.',0dh,0ah

                    ;*** Test reserved bits of status register

                    pushb     #0ffh
                    popb      bFlag
                    lda       bFlag               ;Must have bit 2 and 5 set
                    anda      #00100010b          ;Filter bits, also clears
                                                  ; reserved bits in status !
                    jpz       FlagErr1            ;>> both bits are 0
                    jpnp      FlagErr1            ;>> one bit is 0
                    anda      bFlag
                    jpz       NoFlagErr1          ;>> Reserved bits OK
FlagErr1:           gosub     ErrorExit
                    db        'Error, reserved flag bits !',0dh,0ah

NoFlagErr1:         gosub     ShowThis
                    db        '.. Reserved status bits handled OK.',0dh,0ah

                    ;*** Test for Flags<--Status oscall, Flags-->Status

                    pushb     #11011101b
                    popb      bFlag
                    oscall    19h                 ;Get default drive (nothing)
                    lda       bFlag
                    xora      #11011101b
                    jpnz      FlagErr2
                    sta       bFlag
                    oscall    19h                 ;Get default drive (nothing)
                    lda       bFlag
                    ora       bAccu
                    jpz       NoFlagErr2
FlagErr2:           gosub     ErrorExit
                    db        'Error, flags wrong after oscall !',0dh,0ah

NoFlagErr2:         gosub     JccTest             ;Test conditional jumps
                    gosub     ShowThis            ;Must be ok if returned
                    db        '.. Conditional jumps OK.',0dh,0ah

                    ;*** Check the multiply routine for later
                    ;
                    ;    wTemp=0;
                    ;    for (bTemp=0;bTemp<100h;bTemp++)
                    ;    {
                    ;       wWra=Multiply (bTemp,5ah);
                    ;       if (wTemp!=wWra)
                    ;         Error(Message);
                    ;       wTemp+=5ah;
                    ;    }

                    lda       #0
                    sta       bTemp
                    sta       wTemp
                    sta       wTemp+1

MulX1:              lda       #5ah
                    sta       bByte1
                    lda       wAddr
                    gosub     Multiply
                    lda       wWra
                    sbba      wTemp
                    jpnz      MulError
                    lda       wWra+1
                    sbba      wTemp+1
                    jpz       NoMulError
MulError:           gosub     ErrorExit
                    db        'Error while testing multiply !',0dh,0ah
NoMulError:         lda       #5ah
                    addw      wTemp
                    lda       #1
                    adca      wAddr
                    sta       wAddr
                    jpnz      MulX1
                    gosub     ShowThis
                    db        '.. Multiply gave no errors.',0dh,0ah

                    gosub     ShowThis
                    db        '.. List of flags and A values after some'
                    db        ' operations...',0dh,0ah

                    ;*** Do some adca, suba, xora... and output the
                    ;    status and accu to console, the byte list
                    ;    should match the reference list (use fc.exe).

                    lda       #0
                    sta       wAddr
                    sta       wAddr+1
ArTst:              rdi       wAddr
                    xora      bByte
                    gosub     UpdByte
                    rdi       wAddr
                    adca      bByte
                    gosub     UpdByte
                    rdi       wAddr
                    sbba      bByte
                    gosub     UpdByte
                    rdi       wAddr
                    adca      bByte
                    gosub     UpdByte
                    rdi       wAddr
                    ora       bByte
                    gosub     UpdByte
                    rdi       wAddr
                    anda      bByte
                    gosub     UpdByte
                    lda       wAddr+1
                    ora       bAccu
                    jpz       ArTst
                    gosub     ShowThis
                    db        0dh,0ah

	gosub	PcTest
	gosub	ShowThis
	db	'.. PC increment test passed.',0dh,0ah

	;*** Jump up and down using addw

                    lda       #(AdwCheck-_Adw1)
                    addw      wPc
_Adw1:              dw        0
_Adw2:              gosub     ShowThis
                    db        '.. addw sign extension OK.',0dh,0ah

                    ;<INT-E>
                    ;*** check whether return advances PC
                    lda       wStack
                    sta       wAddr
                    lda       wStack+1
                    sta       wAddr+1             ; save STK to wAddr
                    lda       #08
                    sta       wStack
                    lda       #0F
                    sta       wStack+1            ; STK=0F08
                    gosub     CheckReturn         ; check return (also checks
                    lda       wAddr
                    sta       wStack
                    lda       wAddr+1
                    sta       wStack+1            ; restore STK
                    gosub     ShowThis            ; the call instruction...)
                    db        ".. return (SP=ofs PC) OK.",0dh,0ah
                    ;</INT-E>
                    gosub     ShowSystem          ;Some system data
                    gosub     ShowChecksum        ;Checksum after running

                    oscall    4ch                 ;Terminate

AdwCheck:           lda       #(_Adw2-PcCheck1)
                    addw      wPc

PcCheck1:           lda       wPc+1
                    anda      #0f0h
                    return

;*** Try a lot of JPcc's exit if not handled correctly

JccTest:            rdi       wFlgPtr
                    sta       Cjmp1+1
                    sta       Cjmp3+1
                    xora      #1
                    sta       Cjmp2+1
                    sta       Cjmp4+1
                    lda       #1
                    addw      wFlgPtr
                    rdi       wFlgPtr
                    sta       bFlag
                    lda       #1
                    addw      wFlgPtr
Cjmp2:              jpz       CjErr
Cjmp1:              jpz       Cjmp03
CjErr:              gosub     ErrorExit
                    db        'Error, conditional jumps !',0dh,0ah
Cjmp03:             rdi       wFlgPtr
                    sta       bFlag
                    lda       #1
                    addw      wFlgPtr
Cjmp3:              jpz       CjErr
Cjmp4:              jpz       CjmpOk
                    jp        CjErr

CjmpOk:             rdi       wFlgPtr
                    ora       bAccu
                    jpnz      JccTest
                    return


UpdByte:            sta       bByte
                    pushb     bFlag
                    pushb     bFlag
                    gosub     ShowA
                    lda       #71h
                    sta       bByte1
                    lda       bByte
                    gosub     Multiply
                    lda       wWra
                    xora      wWra+1
                    adca      bByte
                    sta       bByte
                    lda       #1
                    addw      wAddr
                    lda       #','
                    oscall    6
                    popb      bAccu
                    gosub     ShowA
                    lda       #' '
                    oscall    6
                    oscall    6
                    oscall    6
                    popb      bFlag
                    return

wDigPtr             dw        0
bTwoDig:            db        '??'

                    ;*** Show text replacement of A hex

ShowA:              pushb     #(bTwoDig-Begin)and(0ffh)
                    pushb     #(bTwoDig-Begin)shr(8)
                    popb      wDigPtr+1
                    popb      wDigPtr
                    gosub     DumpA
                    lda       bTwoDig
                    oscall    6
                    lda       bTwoDig+1
                    oscall    6
                    return

                    ;*** Stuff text replacement of A hex to buffer
                    ;    pointed to by wDigPtr (uses WRI)

DumpA:              pushb     bAccu
                    gosub     ShRgt
                    gosub     ShRgt
                    gosub     ShRgt
                    gosub     ShRgt
                    gosub     ShowD
                    popb      bAccu
ShowD:              anda      #0fh
                    sbba      #0ah
                    adca      #39h
                    jpc       @@Shd01
                    adca      #8
@@Shd01:            wri       wDigPtr
                    lda       #1
                    addw      wDigPtr
                    return

ErrorExit:          pushb     #4ch
                    pushb     #0
                    popb      Term+1
                    popb      Term

ShowThis:           popb      wTemp
                    popb      bAccu
                    ora       #0f0h               ;Indirect address > 1000h
                    sta       wTemp+1
Sh00:               rdi       wTemp
                    oscall    6
                    xora	#0ah
                    lda       #1
                    addw      wTemp
                    jpnz      Sh00
                    pushb     wTemp+1
                    pushb     wTemp
Term:               return

;*** shr A,1 : bit A,0 -> CY and high(A shl 7) -> A

ShRgt:              pushb     #2
                    popb      bTemp
@@Shr_0:            adca      bAccu
                    pushb     bAccu
                    lda       bTemp
                    adca      bTemp
                    sta       bTemp
                    popb      bAccu
                    jpnc      @@Shr_0
                    adca      #80h
                    lda       bTemp
                    return

;*** wWra = A*bByte1

MultiPly:           pushb     bAccu
                    lda       #0
                    sta       wWra
                    sta       wWra+1
                    sta       bByte2
                    popb      bAccu
@@Mul00:            gosub     ShRgt
                    pushb     bAccu
                    jpnc      @@Mul01
                    lda       bByte1
                    anda      #0ffh
                    adca      wWra
                    sta       wWra
                    lda       bByte2
                    adca      wWra+1
                    sta       wWra+1
@@Mul01:            lda       bByte1
                    anda      #0ffh
                    adca      bByte1
                    sta       bByte1
                    lda       bByte2
                    adca      bByte2
                    sta       bByte2
                    popb      bAccu
                    ora       bAccu
                    jpnz      @@Mul00
                    return

                    ;*** Read all bytes from CON and output to CON
                    ;    checks the ZF after OSCALL 6

Shi00:              oscall    6
ShowInput:          lda       #-1
                    oscall    6
                    jpnz      Shi00
                    return

                    ;*** Calculate and show checksum of entire 1000h byte area
                    ;    used at start for reference and at end to check if
                    ;    no unwanted memory changes have occured

ShowChecksum:       lda       #0
                    sta       wAddr
                    sta       wAddr+1
                    sta       wTemp
                    sta       wTemp+1
                    ora       bAccu
@@Chs01:            rdi       wAddr
                    adca      wTemp
                    sta       wTemp
                    lda       #0
                    adca      wTemp+1
                    sta       wTemp+1
                    lda       #1
                    addw      wAddr
                    lda       wAddr+1
                    ora       bAccu
                    sbba      #10h
                    jpnz      @@Chs01
                    pushb     #(bChDig-Begin)and(0ffh)
                    pushb     #(bChDig-Begin)shr(8)
                    popb      wDigPtr+1
                    popb      wDigPtr
                    lda       wTemp+1
                    gosub     DumpA
                    lda       wTemp
                    gosub     DumpA
                    gosub     ShowThis
                    db        '.. current checksum = '
bChDig              db        '1234',0dh,0ah
                    return

ShowSystem:         rdsys     410h                ;Equip flag
                    sta       wTemp
                    rdsys     411h                ;Equip flag high
                    sta       wTemp+1
                    pushb     #(bChDig1-Begin)and(0ffh)
                    pushb     #(bChDig1-Begin)shr(8)
                    popb      wDigPtr+1
                    popb      wDigPtr
                    lda       wTemp+1
                    gosub     DumpA
                    lda       wTemp
                    gosub     DumpA
                    gosub     ShowThis
                    db        '.. equipment flag = '
bChDig1             db        '????',0dh,0ah
                    rdsys     472h                ;Reset flag
                    sta       wTemp
                    rdsys     473h                ;Reset flag high
                    sta       wTemp+1
                    pushb     #(bChDig2-Begin)and(0ffh)
                    pushb     #(bChDig2-Begin)shr(8)
                    popb      wDigPtr+1
                    popb      wDigPtr
                    lda       wTemp+1
                    gosub     DumpA
                    lda       wTemp
                    gosub     DumpA
                    gosub     ShowThis
                    db        '.. Reset flag = '
bChDig2             db        '????',0dh,0ah
                    pushb     #(bChDig3-Begin)and(0ffh)
                    pushb     #(bChDig3-Begin)shr(8)
                    popb      wDigPtr+1
                    popb      wDigPtr
                    rdsys     449h                ;Video mode
                    gosub     DumpA
                    gosub     ShowThis
                    db        '.. Video mode = '
bChDig3             db        '??',0dh,0ah
                    return

                    ;*** Const check for the fun of it

bOne                db        1

ConstCheck:         ora       bAccu
                    sbba      bAccu
                    sta       wAddr
                    sta       wAddr+1
@@Ccheck1:          rdi       wAddr
                    sbba      wAddr
                    jpnz      ErrConst
                    adca      bOne
                    adca      wAddr
                    sta       wAddr
                    jpnz      @@Ccheck1
                    return

ErrConst:           gosub     ErrorExit
                    db        'Error, bad constant area !',0dh,0ah

Entry:              gosub     ShowInput           ;Read console input bytes
                                                  ; and output to console.
                    gosub     ShowThis
                    db        '.. Started at the right entry.',0dh,0ah
                    jp        Go

                    ;<INT-E>
; this is called with STK=0F08, this means STK=0F06 on entry.
CheckReturn:        gosub     CheckReturn2
                    jp        CheckReturnErr
; STK=0F04 now, PC=[STK]
CheckReturn2:       return
; the first time, return loads the word at [STK] (i.e. PC) to PC,
; that is, it copies PC to itself. this will fail if PC is first
; advanced by 2; the statements at CheckReturnErr will be executed.
; the second time, return returns to the calling routine, which
; restores SP.
CheckReturnErr:     lda       wAddr
                    sta       wStack
                    lda       wAddr+1
                    sta       wStack+1            ; restore STK
                    gosub     ErrorExit
                    db        'Error "return (STK=offset PC)" !',0dh,0ah
                    ;</INT-E>

;*** Test increment of pc.... Ruud
;    for : LDA, ADCA, ANDA, ORA, XORA, SBBA, WRI, RDI, PUSHB, POPB, STA
;    return done separately = above
;    JP,    how ?
;    OSCALL how ?
;    GOSUB  how ?
;    JPCC   how ?
;    RDSYS  how ?
;    ADDW   how ?

PcTest:	lda	wPc	;Get pc
	xora	#($-Begin)and(0ffh)
	jpnz	ErrPctst
	adca	wPc
	xora	#($-Begin)and(0ffh)
	jpnz	ErrPctst
	xora	wPc
	xora	#($-Begin)and(0ffh)
	jpnz	ErrPctst
	sbba	wPc
	xora	#(Begin-$)and(0ffh)
	jpnz	ErrPctst
	ora	wPc
	xora	#($-Begin)and(0ffh)
	jpnz	ErrPctst
	lda	#0ffh
	anda	wPc
	xora	#($-Begin)and(0ffh)
	jpnz	ErrPctst
	rdi	wPc
	xora	#0ffh	;All values ok
	jpnz	ErrPctst
	wri	wPc
	lda	#0ffh
	ora	bAccu
	jpnz	ErrPctst
	pushb	wPc
	popb	bAccu
	xora	#($-Begin-2)and(0ffh)
	jpnz	ErrPctst
	lda	#(_Ptr1-Begin)and(0ffh)
	sta	wPc
_Ptr1:	jp	_Ptr2
	jp	ErrPctst
_Ptr2:	pushb	#(_Ret1-Begin)and(0ffh)
	popb	wPc
_Ret1:	return

ErrPctst:	gosub	ErrorExit
	db	'Error PC increment test.',0dh,0ah




                    ORG       0f00h
bAccu               db        A_INIT
bFlag               db        F_INIT
wStack              dw        SP_INIT
wPc                 dw        PC_INIT

b0a0h	db	0a0h

	ORG	0f0eh
	
	;*** Calling rom address 0e will endup here
RomCallTest:	lda	#0ffh
	sta	#0a0h
	lda	#0a0h
	xora	#0ffh
	lda	b0a0h
	sta	#0a0h
	jpnz	RtErr
	gosub	ShowThis
	db	'.. call to low memory OK, low memory is R/W',0dh,0ah
	return

RtErr:	gosub	ErrorExit
	db	'Error modifying low memory !',0dh,0ah


                    ORG       0fffh
                    db        0

                    END       Start
