;
;
;	DICE - simple SPEW Disassembler and ICE for Hugi compo #9
;				by TAD 1999
;		    cakeypig@darkplace.freeserve.co.uk
;

DBUG = 0

	LOCALS
	.model	tiny
	.286

	;### Ruudje ### changed video ram for page 1

VRAM		equ	0B800h		; video-memory segment
scrSEG		equ	0BA00h		; debug screen segment
scrWIDE		equ	80
scrHIGH		equ	50
scrLINE		equ	160
scrSIZE		equ	8000

;* Attribute colours
DULL_ATTR	equ	30h
NUM_ATTR	equ	3Eh
STATUS0_ATTR	equ	30h
STATUS1_ATTR	equ	3Fh
MEM_ATTR	equ	30h

MEM_HIGH	equ	15

CPU_ATTR	equ	30h
CPUBRK_ATTR	equ	4Fh
CPUBAR_ATTR	equ	1Fh
CPUPC_ATTR	equ	3Eh

CPU_HIGH	equ	29

STKADR_ATTR	equ	30h
STKNUM_ATTR	equ	3Eh
STKBAR_ATTR	equ	70h

KEYBAR_ATTR	equ	70h
KEYBARHI_ATTR	equ	74h

INPUT_ATTR	equ	70h
ALARM_ATTR	equ	4Fh

;* SPEW stuff ...
ADDR_RANGE	equ	1000h
ADDR_MASK	equ	0FFFh


;* OS functions
INT_VIDEO	equ	<int 10h>
INT_KEYB	equ	<int 16h>
INT_DOS		equ	<int 21h>

;* ASCII control codes
BACKSPC		equ	08h
ESCAPE		equ	1Bh
RETURN		equ	0Dh


;* Key scan/ASCII codes
BSPC_K		equ	0008h

PGUP_K		equ	4900h
PGDN_K		equ	5100h
UP_K		equ	4800h
DOWN_K		equ	5000h
LEFT_K		equ	4B00h
RIGHT_K		equ	4D00h
HOME_K		equ	4700h
END_K		equ	4F00h

ALTA_K		equ	1E00h
ALTE_K		equ	1200h
ALTP_K		equ	1900h
ALTN_K		equ	3100h
ALTX_K		equ	2D00h
	
	;### Ruudje ### added ALT F5
ALTF5_K		equ	6C00h
ALTF9_K		equ	7000h

ESC_K		equ	001Bh

CTRLA_K		equ	0001h
CTRLC_K		equ	0003h
CTRLG_K		equ	0007h
CTRLJ_K		equ	000Ah
CTRLK_K		equ	000Bh
CTRLN_K		equ	000Eh
CTRLP_K		equ	0010h
CTRLS_K		equ	0013h
CTRLT_K		equ	0014h

F1_K		equ	03B00h
F2_K		equ	03C00h
F3_K		equ	03D00h
F4_K		equ	03E00h
F5_K		equ	03F00h
F6_K		equ	04000h
F7_K		equ	04100h
F8_K		equ	04200h
F9_K		equ	04300h
F10_K		equ	04400h

LSHIFT		equ	001h
RSHIFT		equ	002h
CTRL		equ	004h
ALT		equ	008h

SHIFT		equ	(LSHIFT+RSHIFT)

;* My control-codes

XTAB		equ	1		; x
YTAB		equ	2		; y
LOCATE		equ	3		; +x, +y	(from origin x,y)
ORIGIN		equ	4		; x, y
CENTRE		equ	5		; <string...>
ATTR		equ	6		; cc
BOX		equ	7		; width,height
INPUT		equ	8		; max length


	.data?
zero_start	equ	$		; ** start of zero'd area

mempnt		dw	?

cpupnt		dw	?		; cpu window
cpubarpnt	dw	?

herePCbrk	dw	?		; F4-Here brk addr
hereSTKreturn	dw	?		; F8-Step1 (Ruud's GOSUB/RETURN pair)

key_status	db	?
sym3flag	db	?
editmode	db	?		; NZ = editing memory
editnibb	db	?		; 0/1 = nibble
editpos		dw	?
deadflag	db	?		; NZ = program terminated
asciiflag	db	?		; NZ = show ASCII char for opcode

int1Boff	dw	?
int1Bseg	dw	?
cbrkflag  	db	?		; CTRL-BRK flag NZ=stop


txtX		db	?		; used by 'prtitems'
txtY		db	?
txtATTR		db	?
txtorgX		db	?
txtorgY		db	?
txtlenX		db	?
txtlenY		db	?
inputFLAG	db	?		; type of input
inputVALUE	dw	?
inputBUFFER	db	80 dup (?)


brkflags	db	ADDR_RANGE dup (?)

spufilename	db	80 dup (?)

zero_end   	equ	$		; ** end of zero'd area

	IF DBUG

		dw	400 dup (?)
stacktop	dw	?

	ENDIF


	.data
	
	;### Ruudje ### Added some data

bSilent	db	0			; NZ = run in /S silent mode

;----------------------------- the SPEW memory map ------------------------
spewimage	db	0F00h dup (0)
A_reg		db	00h			; F00
STATUS_reg	db	00h			; F01
STK_reg		dw	0000h			; F02..F03
PC_reg		dw	0000h			; F04..F05
		db	0FAh dup (0)
;----------------------------- the SPEW memory map ------------------------


CALCXY	macro	xpos,ypos
	mov	di,(ypos*scrLINE)+xpos+xpos
	endm

	.code
	org	256
start:
	mov	si,80h

	IF	DBUG
	mov	ax,CS
	mov	DS,ax
	mov	ES,ax
	mov	SS,ax
	mov	sp,offset stacktop

	lea	si,cmdline
	ENDIF

	;; first clear ALL memory variables/buffers ;;

	lea	bx,zero_start
zeromem:
	mov	byte ptr [bx],0
	inc	bx
	cmp	bx,OFFSET zero_end
	jb	short zeromem

	mov	[txtATTR],07h
	mov	[txtlenX],scrWIDE
	mov	[txtlenY],scrHIGH

	;; Install the CTRL-BRK handler ;;

	push	ES
	mov	ax,351Bh
	INT_DOS
	mov	[int1Bseg],ES
	mov	[int1Boff],bx
	pop	ES

	lea	dx,int1Bhandler
	mov	ax,251Bh
	INT_DOS

	;; load .SPU image ;;

	call	initspu

	lea	di,spufilename
	call	scanfname
	jc	short nocmdname		; no .SPU filename on cmd line ?

	lea	dx,spufilename
	call	loadspu			; load .SPU

nocmdname:
	call	initrom


	;; kill all breakpoints ;;

	call	zapbrks

	mov	ax,-1
	mov	[herePCbrk],ax
	mov	[hereSTKreturn],ax

	;### Ruudje ### skip video stuff for silent mode
	;    also moved the instruction above

	cmp	bSilent,0
	jne short	Silent_1

	;; set the video mode ;;

	mov	ax,3
	INT_VIDEO			; mode 3
	mov	bl,00h
	mov	ax,1112h
	INT_VIDEO			; text mode 80x50
	
	;### Ruudje ### added page flip
	
	call	DebugScreen		; *** TAD
	mov	ax,scrSEG
	mov	ES,ax			; ES --> video ram

	call	repaint

Silent_1:
	mov	ax,[PC_reg]
	mov	[cpupnt],ax
	mov	[cpubarpnt],ax
	mov	[mempnt],ax


	;### Ruudje, simply run if silent
	
	cmp	bSilent,0
	je	short mainloop
	call	run			; *** TAD - in case of CTRL-BRK
	jmp	short quit		; *** TAD - when running /S mode

mainloop:
	call	drawcpu			; redraw the various pieces...
	call	drawregs
	call	drawstatus
	call	drawstk
	call	drawmem
	call	drawedit

mainwait:
	call	testkey
	push	ax
	lea	si,cpu_bartable
	call	drawkeybar		; draw the info-bar
	pop	ax
	test	ax,ax
	jz	short mainwait		; no key ?

	call	chkedit
	test	ax,ax
	jz	short mainloop		; editing memory ?

	lea	si,cpu_keytable
	call	chkkeys			; do key(AX)
	jmp	short mainloop

	;; el quito ;;
	
	;### Ruudje ### added unhook int 21h and page flip

quit:	
	;; restore CTRL-BRK vector ;;

	push	DS
	mov	dx,[int1Boff]
	mov	DS,[int1Bseg]
	mov	ax,251Bh
	INT_DOS
	pop	DS

	;### Ruudje, skip if silent

	cmp	bSilent,0
	jne	short Silent_2
	
	mov	ax,0500h
	INT_VIDEO
	mov	ax,3
	INT_VIDEO

	;### Ruudje, skip if silent

Silent_2:
	mov	ah,4Ch
	mov	al,[A_reg]		; *** TAD - exit code(A_reg)
	INT_DOS

	;*** TAD - modified  ***

;* CTRL-BRK handler
int1Bhandler:
	mov	CS:[cbrkflag],1		; Signal CTRL-BRK was hit
	iret

;* Re-paint entire background (frames, title etc..)
repaint:
	lea	si,debugscr
	sub	di,di
	mov	cx,(scrSIZE/2)
	rep	movsw			; (who needs turbo-vision?  #;o)
	ret

;* Show user-screen [ALT-F5] + wait for a key-press
ShowUser:
	call	UserScreen
	mov	ah,0
	INT_KEYB
	call	DebugScreen
	ret

	;### Ruudje ### user screen

;* Display user screen
UserScreen:
	cmp	[bSilent],0
	jnz	short _ret		; silent mode ?
	pusha

	sub	ax,ax
	call	setscreen
;;	mov	ax,0500h
;;	INT_VIDEO
	popa
_ret:
	ret

;* Display DICE debug screen
DebugScreen:
	cmp	[bSilent],0
	jnz	short _ret		; silent mode ?
	pusha

	mov	ax,(scrSEG-VRAM)*(16/2)
	call	setscreen

;;	mov	ax,0501h
;;	INT_VIDEO
;;	push	ds
;;	xor	ax,ax
;;	mov	ds,ax
;;	mov	byte ptr ds:[462h],0 	; Fool dos and bios
;;	pop	ds
	popa
	ret

;* Set screen-start registers (problems with setpage INT21h, fn:5)
setscreen:
	push	ax
	mov	dx,3D4h
	mov	al,0Ch
	out	dx,ax			; start hi = 02
	pop	ax
	mov	ah,al
	mov	al,0Dh
	out	dx,ax			; start lo = 0Ah
	ret



;* (AX)=Wait key and get shift status
testkey:
	mov	ah,02h
	INT_KEYB
	mov	[key_status],al
	mov	ah,01h
	INT_KEYB
	jnz	short waitkey
	sub	ax,ax
	ret

waitkey:
	mov	ah,00h
	INT_KEYB
	ret


; Check and process key(AX) table[DS:SI]
chkkeys:
	call	uppercase
	call	indexstatus
	cmp	al,00
	xchg	ax,dx
	jz	short ck_FIND		; no ASCII code (ALT/Fx/CURSOR) ?
	mov	dh,0			; else zap scancode, use only ASCII
ck_FIND:
	lodsw
	xchg	ax,cx			; CX = key scan/ASCII code
	jcxz	short ck_NOPE
	lodsw
	xchg	ax,bx			; BX = routine
	lodsw				
	cmp	cx,dx
	jnz	short ck_FIND		; no match ?
	mov	si,ax			; AX/SI = data/parameter
	call	bx
ck_NOPE:
	ret

; (SI)=index into table[DS:SI] depending on key SHIFT/ALT/CTRL status
indexstatus:
	push	ax
	mov	al,[key_status]
	mov	bx,6
	test	al,CTRL
	jnz	short @@1
	mov	bx,4
	test	al,ALT
	jnz	short @@1
	mov	bx,2
	test	al,SHIFT
	jnz	short @@1
	sub	bx,bx
@@1:
	mov	si,[si+bx]
	pop	ax
	ret

;* Draw the key help bar[DS:SI]
drawkeybar:
	call	indexstatus
	mov	cx,scrWIDE

	CALCXY	0,49
dkb_2:
	mov	ah,KEYBAR_ATTR
dkb_LP:
	lodsb
	cmp	al,0
	jz	short dkb_END
	cmp	al,''
	jnz	short dkb_1
      	mov	ah,KEYBARHI_ATTR
	jmp	short dkb_LP
dkb_1:
	cmp	al,''
	jz	short dkb_2
	stosw
	loop	dkb_LP
dkb_END:
	mov	al,' '
	rep	stosw
	ret


;* Draw the edit cursor (if any)
drawedit:
	cmp	[editmode],0
	jz	short @@1

	mov	ax,[editpos]
	aam	16
	add	ax,(33 SHL 8)
	xchg	ax,dx			; AL=x, AH=y

	mov	al,scrLINE
	mul	dh
	xchg	ax,di

	mov	al,6
	mul	dl
	cmp	[editnibb],0
	jnz	short @@2
    	add	ax,2
@@2:
	xchg	ax,bx
	mov	byte ptr ES:[di+bx+(12*2)+1],4Fh

	add	dl,dl
	mov	bl,dl
	mov	byte ptr ES:[di+bx+(61*2)+1],4Fh
@@1:
	ret

;* Check key(AX) and edit memory nibble
chkedit:
	push	ax
	cmp	[editmode],0
	jz	short ce_NOPE		; not in edit mode ?

	call	chkhex
	jc	short ce_NOPE		; not "0..F" ?
	xchg	ax,dx

	mov	bx,[mempnt]
	add	bx,[editpos]
	call	peek_BX
	mov	cl,[editnibb]
	ror	al,cl
	and	al,0F0h
	or	al,dl
	rol	al,cl
	call	poke_BX			; wrt new nibble

	call	editright		; move right --> 1 nibble

	pop	ax
	sub	ax,ax
	ret	

ce_NOPE:
	pop	ax
	ret

;* Move up 1 edit line 
editup:
	add	[editpos],ax
	jns	short @@1
	sub	[editpos],ax
	jmp	relmem			; scroll up 1 line if above top
@@1:
	ret

;* Move down 1 edit line
editdown:
	add	[editpos],ax
	cmp	[editpos],(16*MEM_HIGH)
	jb	short @@1
	sub	[editpos],ax
	jmp	relmem	    		; scroll down 1 line if below bottom
@@1:
	ret

;* Move left 1 edit nibble
editleft:
	xor	[editnibb],4
	jnz	short _ret3		; same byte (high nibble) ?

	cmp	[editpos],0
	jz	short relmem		; scroll left 1 byte if at top
	dec	[editpos]
	ret

;* Move right 1 edit nibble
editright:
	xor	[editnibb],4
	jz	short _ret3		; same byte (low nibble) ?

	cmp	[editpos],(16*MEM_HIGH)-1
	jz	short relmem		; scroll right 1 byte if at bottom
	inc	[editpos]
_ret3:
	ret


;* Goto top of edit memory
edittop:
	mov	[editpos],ax
	mov	[mempnt],ax
	ret

;* Goto bottom of edit memor
editend:
	mov	[editpos],(16*MEM_HIGH)-1
	mov	[mempnt],ax
	ret

;* Move mem-dump by +/-(AX) bytes
relmem:
	add	[mempnt],ax
	and	[mempnt],ADDR_MASK
	ret

;* Jump to reg addr
editatreg:
	lodsw
	mov	[editpos],0

;* Set memory pnt to(AX)
topmem:
endmem:
	mov	[editnibb],4
	mov	[mempnt],ax
	ret

;* Toggle edit-mem mode
togedit:
	lea	ax,cpu_normkeys
	xor	[editmode],-1
	jz	short @@1		; not in edit mode ?
	mov	[editnibb],4
	mov	[editpos],0
	lea	ax,edit_normkeys	; replace key list pnt
@@1:
	mov	cpu_keytable[0],ax	; norm keys
	ret


;* Toggle BRK (breakpoint) at cpu cursor addr
togbrk:
	mov	bx,[cpubarpnt]
	xor	brkflags[bx],al
	ret

;* Goto top of cpu memory
topcpu:
	mov	[cpupnt],ax
	mov	[cpubarpnt],ax
	ret

;* Goto end of cpu memory
endcpu:
	mov	[cpupnt],ax
	add	ax,(CPU_HIGH-1)*2
	mov	[cpubarpnt],ax
	ret

;* Sync PC - deal with odd/even PC and cpu addr
syncpc:
	mov	ax,1
	and	ax,[PC_reg]

	and	[cpubarpnt],0FFFEh
	or	[cpubarpnt],ax

	and	[cpupnt],0FFFEh
	or	[cpupnt],ax
	ret

;* Jump to pc and check cursor is in window (used after STEP/TRACE etc..)
jumptopc:
	mov	ax,[PC_reg]
	and	ax,ADDR_MASK
	mov	[cpubarpnt],ax
	sub	ax,ax
	jmp	relcpu


;* Goto pc & centre cursor in window
gotopc:
	mov	ax,[PC_reg]
	and	ax,ADDR_MASK
	mov	[cpubarpnt],ax

	mov	ax,[cpubarpnt]
	sub	ax,(CPU_HIGH/2)*2
	mov	[cpupnt],ax
	ret

;* Set PC to cursor addr
newpc:
	mov	ax,[cpubarpnt]
	mov	[PC_reg],ax
	ret


relpg:
	add	[cpupnt],ax
	and	[cpupnt],ADDR_MASK
	ret

;* Move cpu cursor AND page by (AX)
relpgcpu:
	call	relpg

;* Move cpu cursor by (AX) - (has to deal with 12-bit addr wrap !!)
relcpu:
	mov	dx,ADDR_MASK
	add	ax,[cpubarpnt]
	and	ax,dx
	mov	[cpubarpnt],ax
	xchg	ax,bx

	mov	ax,-2
	sub	bx,[cpupnt]
	and	bx,dx
	cmp	bx,(ADDR_MASK-1)
	jz	short relpg		; 1 line above window ?

	mov	ax,2
	sub	bx,(CPU_HIGH)*2
	jc	short reldone
	and	bx,dx
	jz	short relpg		; 1 line below window ?

	mov	ax,[cpubarpnt]
	sub	ax,(CPU_HIGH/2)*2
	and	ax,ADDR_MASK
	mov	[cpupnt],ax		; else move entire page
reldone:
	ret

; Draw all the register values
drawregs:
	CALCXY	61,2
	mov	al,[A_reg]
	mov	dl,NUM_ATTR
	call	prthex2			; A reg
	add	di,2
	mov	al,[A_reg]
	mov	ah,NUM_ATTR
	stosw				; ASCII char too

	CALCXY	61,3
	mov	al,[STATUS_reg]
	call	prthex2			; STATUS reg
	add	di,2
	mov	al,[STATUS_reg]
	mov	ah,NUM_ATTR
	stosw				; ASCII char

	CALCXY	59,4
	mov	ax,[STK_reg]
	call	prthexD3		; STK

	CALCXY	59,5
	mov	ax,[PC_reg]
	call	prthexD3		; PC
	ret

; Draw all the stack values
drawstk:
	CALCXY	68,16
	mov	bx,[STK_reg]
	sub	bx,7			; BX = STK - 7
	mov	cx,15
dst_LP:
	push	di
	mov	dx,(STKNUM_ATTR SHL 8)+(STKADR_ATTR)
	cmp	cl,8
	jnz	short dst_BAR
	mov	dx,(STKBAR_ATTR SHL 8)+(STKBAR_ATTR)
dst_BAR:
	mov	ax,bx
	call	prthex3			; BX addr
	add	di,(75-68-3)*2
	call	peek_BX
	mov	dl,dh
	call	prthex2			; mem[BX] byte
	pop	di
	add	di,scrLINE
	inc	bx
	loop	dst_LP
	ret

; Draw memory dump (with wrap-around)
drawmem:
	CALCXY	6,33

	mov	dl,MEM_ATTR
	mov	bx,[mempnt]
	mov	cx,MEM_HIGH
dmm_HIGH:
	push	cx
	push	di

	mov	ax,bx
	call	prthex3
	add	di,(12-6-3)*2

	mov	bp,(61-12)*2

	mov	cx,16
ddm_WIDE:
	call	peek_BX
	mov	ah,dl
	mov	ES:[di+bp],ax		; prt char
	call	prthex2			; prt mem byte
	add	di,2
	sub	bp,4
	inc	bx
	loop	ddm_WIDE
	pop	di
	add	di,scrLINE
	pop	cx
	loop	dmm_HIGH
	ret

; Draw STATUS bit descriptions
drawstatus:
	CALCXY	66,7
	mov	dh,8
	mov	bl,[STATUS_reg]
	lea	si,statustxt
dsr_LP:
	push	di
	push	si
	mov	al,STATUS0_ATTR
	mov	cx,13
	add	bl,bl
	jnc	short dsr_PRT
	add	si,cx
	mov	al,STATUS1_ATTR
dsr_PRT:
	movsb
	stosb
	loop	dsr_PRT			; prt false/true STATUS string

	pop	si
	add	si,13+13

	pop	di
	add	di,scrLINE
	dec	dh
	jnz	short dsr_LP
	ret

; Draw CPU disassembly - displays opcode and various cursors/info
drawcpu:
	CALCXY	1,2
	mov	bx,[cpupnt]
	mov	cx,CPU_HIGH
dcp_LP:
	push	cx
	push	di

	and	bx,ADDR_MASK

	mov	ax,bx
	call	checkbrk
	lea	si,brktxt
	mov	dl,CPUBRK_ATTR
	jnz	short dcp_1		; over a brk ?

	mov	dl,CPU_ATTR
	lea	si,cpuatxt
	cmp	bx,(A_reg-spewimage)
	jz	short dcp_1		; over A reg ?

	lea	si,cpustatustxt
	cmp	bx,(STATUS_reg-spewimage)
	jz	short dcp_1		; over STATUS reg ?

	lea	si,cpustktxt
	cmp	bx,(STK_reg-spewimage)
	jz	short dcp_1		; over STK reg ?

	lea	si,cpupctxt
	cmp	bx,(PC_reg-spewimage)
	jz	short dcp_1		; over PC reg ?
	lea	si,blanktxt
dcp_1:

	mov	ax,ADDR_MASK
	and	ax,[PC_reg]
	cmp	bx,ax
	jnz	short dcp_3
	lea	si,cpubartxt 		; "PC -->" cursor
	mov	dl,CPUPC_ATTR
dcp_3:

	cmp	bx,[cpubarpnt]
	jnz	short dcp_2   		; not over cursor line ?
	mov	dl,CPUBAR_ATTR
dcp_2:

	mov	al,' '
	mov	ah,dl
	stosw
	mov	ax,bx
	call	prthex3			; cpu addr
	mov	al,' '
	mov	ah,dl
	stosw
	stosw

	call	peek_BX
	xchg	ax,cx
	inc	bx
	call	peek_BX
	mov	ch,al			; CX = opcode word
	mov	ax,cx
	call	prthex4
	inc	bx

	mov	word ptr [blanktxt+2],cx	; show ASCII chars
	cmp	[asciiflag],0
	jnz	short dcp_ASCII
	mov	word ptr [blanktxt+2],'  '
dcp_ASCII:


	push	cx
	mov	cx,8
	mov	al,dl
dcp_TYPE:
	movsb
	stosb
	loop	dcp_TYPE		; print line cursor[DS:SI]
	pop	cx

	call	prtopcode		; decode & print opcode

	pop	cx
	push	cx
	add	cx,(49)*2
	sub	cx,di
	jc	short dcp_OOPS
	shr	cx,1
	mov	al,' '
	rep	stosw			; padding to end of window
dcp_OOPS:
	pop	di
	add	di,scrLINE
	pop	cx
	dec	cx
	jz	short dcp_DONE
	jmp	dcp_LP
dcp_DONE:
	ret

;* toggle flag at[DS:SI]
toggle:
	xor	byte ptr [si],1
	ret

; Print(AX) as either 3-digit hex, or symbolic name
prtsym3:
	cmp	[sym3flag],0
	jz	short psy_OFF		; symbolic-3 disabled ?
	push	si
	and	ax,ADDR_MASK
	lea	si,symbatxt
	cmp	ax,(A_reg-spewimage)
	jz	short psy_SYM

	lea	si,symbstatustxt
	cmp	ax,(STATUS_reg-spewimage)
	jz	short psy_SYM

	lea	si,symbstktxt
	cmp	ax,(STK_reg-spewimage)
	jz	short psy_SYM

	lea	si,symbpctxt
	cmp	ax,(PC_reg-spewimage)
	jz	short psy_SYM

	pop	si
psy_OFF:
	jmp	prthex3
psy_SYM:
	mov	ah,dl
psy_PRT:
	lodsb
	cmp	al,0
	jz	short psy_END
	stosw
	jmp	short psy_PRT
psy_END:
	pop	si
	ret


poc_INDIR:
	push	bx			; indirect addr (used by RDI & WRI)
	mov	bx,cx
	inc	bx
	call	peek_BX
	mov	ah,al
	dec	bx
	call	peek_BX
	call	prtsym3
	pop	bx
	jmp	poc_PRT	

poc_INDB:
	push	bx			; indirect byte (RDI & WRI info)
	mov	bx,cx
	call	peek_BX
	push	ax
	inc	bx
	call	peek_BX
	pop	bx
	mov	bh,al

	call	peek_BX
	call	prthex2
	pop	bx
	jmp	poc_PRT	


; Decode & print opcode(CX) PC+2(BX)
prtopcode:
	lea	si,d_OSCALL
	cmp	ch,00h
	jz	short poc_PRT		; 00xx "OSCALL" ?
	lea	si,d_RETURN
	cmp	cx,1000h
	jz	short poc_PRT		; 1000 "RETURN" ?

	mov	ax,00F0h
	and	al,ch
	shr	ax,1
	shr	ax,1
	shr	ax,1
	add	ax,offset d_table
	xchg	ax,si
	lodsw
	xchg	ax,si			; [DS:SI] --> decode string
poc_PRT:
	mov	ah,dl
	lodsb
	cmp	al,0
	jz	short poc_END
	cmp	al,'a'
	jb	short poc_WRT
	jz	short poc_ADDR		; 12-bit addr
	cmp	al,'b'
	jz	short poc_INDB		; indirect byte
	cmp	al,'c'
	jz	short poc_JPcc		; conditional jump
	cmp	al,'f'
	jz	short poc_FUNC		; OSCALL func
	cmp	al,'i'
	jz	short poc_INDIR		; indirect mem addr
	cmp	al,'m'
	jz	short poc_MEM		; 12-bit [mem]
	cmp	al,'p'
	jz	short poc_PCREL		; relative jump
	cmp	al,'x'
	jz	short poc_HEX3
poc_WRT:
	cmp	al,'A'
	jb	short poc_LOWER
	cmp	al,'Z'
	ja	short poc_LOWER
	xor	al,20h			; force to lower-case
poc_LOWER:
	stosw
	jmp	short poc_PRT

poc_END:
	ret

poc_FUNC:
	mov	al,cl			; "OSCALL xx" function
	call	prthex2
	jmp	short poc_PRT

poc_ADDR:
	mov	ax,cx			; addr or symbolic name
	call	prtsym3
	jmp	short poc_PRT

poc_MEM:
	test	ch,00Fh
	jz	short poc_CONST		; addr = 0xx ?

	mov	al,'['			; prt "[xxx]"
	stosw
	mov	ax,cx
	call	prtsym3
	mov	ah,dl
	mov	al,']'
	stosw
	jmp	short poc_PRT

poc_CONST:
	mov	al,'#'			; prt "#xx"
	stosw
	mov	al,cl
	call	prthex2
	jmp	short poc_PRT

poc_HEX3:
	mov	ax,cx			; print "xxx"
	call	prthex3
	jmp	short poc_PRT

poc_JPcc:
	push	si			; print "JPxx" condition
	mov	si,000Fh
	mov	al,ch
	and	si,ax
	add	si,si
	mov	al,JPcctable[si]
	stosw
	mov	al,JPcctable+1[si]
	stosw
	pop	si
	jmp	poc_PRT

poc_PCREL:
	mov	al,cl			; print "JPcc +pp" jump addr
	cbw
poc_RDSYS:
	add	ax,bx
	call	prthex3
	jmp	poc_PRT

; ZF=Check if address[AX] has a break point
checkbrk:
	push	bx
	mov	bx,ADDR_MASK
	and	bx,ax
	cmp	brkflags[bx],0
	pop	bx
	ret

; AL=Peek spew mem[BX]
peek_BX:
	push	bx
	and	bx,ADDR_MASK
	mov	al,spewimage[bx]
	pop	bx
	ret

;* Poke spew mem[BX]=AL
poke_BX:
	push	bx
	and	bx,ADDR_MASK
	mov	spewimage[bx],al
	pop	bx
	ret

;* Print(AX) as 4-digit hex
prthex4:
	push	ax
	mov	al,ah
	call	prthex2
	pop	ax
	jmp	short prthex2

;* Print(AX) with top-nibble dull to show 12-bit addr
prthexD3:
	push	ax
	push	dx
	mov	al,0
	rol	ax,4
	mov	dl,DULL_ATTR
	call	blapattrhex		; prt top nibble as dull
	pop	dx
	pop	ax
prthex3:
	push	ax
	mov	al,ah
	aam	16
	call	blapattrhex		; bits 11..8
	pop	ax	
prthex2:
	aam	16
	push	ax
	mov	al,ah
	call	blapattrhex
	pop	ax
blapattrhex:
	cmp	al,10
	sbb	al,69h
	das
	stosb				; char
	mov	al,dl
	stosb				; attr
	ret

;* Zap all breakpoints
zapbrks:
	mov	bx,ADDR_RANGE
zb_ZAP:
	mov	brkflags-1[bx],0
	dec	bx
	jnz	short zb_ZAP
	ret

;* (AX)=peek opcode at mem[BX]
peekopcode:
	and	bx,ADDR_MASK
	mov	al,spewimage[bx]
	inc	bx
	and	bx,ADDR_MASK
	mov	ah,spewimage[bx]
	ret

;* "Here" - run until PC = cursor addr
runhere:
	mov	ax,[cpubarpnt]
	mov	[herePCbrk],ax
	call	run
	ret

;* "Step" - trace 1 instruction/step over GOSUB call
step1:
	mov	bx,[PC_reg]
	call	peekopcode
	cmp	ax,1000h
	jbe	short trace1		; ignore "RETURN"
	cmp	ax,1FFFh
	ja	short trace1		; not over "1xxx GOSUB xxx" ?

	;; now check for Ruud's "ShowThis" routine ;;

	and	ax,ADDR_MASK
	xchg	ax,bx
	call	peekopcode		; get GOSUB xxx --> 1st opcode
	and	ax,0F000h
	cmp	ax,03000h
	jz	step1_RETURN		; is first opcode "POPB xxx" ?

	;; else run until PC+2 (return addr of the GOSUB) ;;

	mov	ax,[PC_reg]
	add	ax,2
	and	ax,ADDR_MASK
	mov	[herePCbrk],ax		; BRK at PC+2 (after GOSUB)
	call	run			; then run...
	ret


	;; run until 'RETURN' of this GOSUB ;;

step1_RETURN:
	mov	ax,[STK_reg]
	sub	ax,2
	and	ax,ADDR_MASK		; basically run until we hit a
	mov	[hereSTKreturn],ax 	; RETURN where stack = STK+2
	call	run
	ret



;* "Trace" - execute 1 instruction (follows GOSUB's)
trace1:
	call	execute1
	call	syncpc
	call	jumptopc
_ret4:
	ret

;* "Run" - execute the program (until a BRK/HERE marker)
run:
	call	checkdead
	jc	short _ret4		; prog terminated ?

	mov	[cbrkflag],0		; Doh !
	call	UserScreen		; Show user screen while running..
ru_LOOP:
	call	emulate
	cmp	[cbrkflag],0
	jnz	short ru_BRK		; CTRL-BRK ?
	mov	bx,ADDR_MASK
	and	bx,[PC_reg]
	cmp	bx,[herePCbrk]
	jz	short ru_BRK		; found "Here" BRK ?
	cmp	brkflags[bx],0
	jz	short ru_LOOP		; no BRK ?
ru_BRK:
	call	DebugScreen		; back to debug screen

	call	syncpc
	call	jumptopc
	mov	ax,-1
	mov	[herePCbrk],ax		; clear "Here" addr
	mov	[hereSTKreturn],ax	; clear GOSUB/RETURN addr
	ret

;* CF=Check that program has NOT terminated
checkdead:
	cmp	[deadflag],0
	jz	short _ret6
	lea	si,termin_alert
	call	alert
	stc	
_ret6:
	ret


	;### Ruudje ### implemented scan for /S

; Scan filename/string[DS:SI] into[ES:DI]
scanfname:
	lodsb
scanfn1:	cmp	al,1
	jc	short sfn_END
	cmp	al,'/'
	jne	sfn_Chk1
	lodsb
	call	uppercase
	cmp	al,'S'
	jne short scanfn1
	mov	bSilent,al
	jmp short	scanfname

sfn_Chk1:	cmp	al," "
	jbe	short scanfname		; skip whitespaces
sfn_COPY:
	call	uppercase
	stosb
	lodsb
	cmp	al," "
	ja	short sfn_COPY
	and	al,0			; CF = 0 (okay)
	stosb				; ASCII-Z
sfn_END:
	ret

;* Force(AL) to upper-case
uppercase:
	cmp	al,'a'
	jb	short uc_NOPE
	cmp	al,'z'
	ja	short uc_NOPE
	xor	al,20h
uc_NOPE:
	ret

;* init .SPU image memory
initspu:
	;; first zap memory

	mov	bx,ADDR_RANGE
	sub	ax,ax
isp_ZAP:
	mov	spewimage-1[bx],al
	dec	bx
	jnz	short isp_ZAP

	;; set default register values - used if NO .SPU image loaded ;;

	mov	[A_reg],al
	mov	[STATUS_reg],al
	mov	[PC_reg],100h
	mov	[STK_reg],ax
	ret

;* init the "ROM" (memory constants)
initrom:
	;; init mem[000]..mem[0FF] = 00..FF

	mov	bx,00FFh
iro_RST:
	mov	spewimage[bx],bl
	dec	bx
	jns	short iro_RST
	ret


;* Load .SPU image[DS:DX] and reset variables etc..
loadspu:
	mov	ax,3D00h
	INT_DOS
	jc	short rpt_CantOpenSPU
	xchg	ax,bx
	lea	dx,spewimage
	mov	cx,ADDR_RANGE
	mov	ah,3Fh
	INT_DOS
	mov	ah,3Eh
	INT_DOS
	clc
	ret

rpt_CantOpenSPU:
	lea	si,err_CantOpenSPU
	call	conmess
	lea	si,spufilename
	call	conmess
	mov	ah,0
	INT_KEYB
	stc
	ret

;* Print ASCII-Z[DS:SI] to con
conmess:
	mov	dx,si
cm_SCAN:
	lodsb
	cmp	al,0
	jnz	short cm_SCAN
	dec	si
	mov	cx,si
	sub	cx,dx
	mov	bx,1
	mov	ah,40h
	INT_DOS
	ret

;* print alert item list[DS:SI] and wait for [ESC]
alert:
	call	DebugScreen

	call	prtitems
alert2:
	call	waitkey
	cmp	al,ESCAPE
	jnz	short alert2
	ret

;* Print item list[DS:SI] - use my control codes for boxs/attr/position etc..
;
; It handles the alert and input boxes aswell as inputting a string/number
; it returns the address of the inputbuffer in [DS:SI] the value in(AX)
;
prtitems:
	pusha
	mov	ah,[txtATTR]
	call	pit_CALCXY
	jmp	short pit_NEXT
pit_PRT:
	stosw
pit_NEXT:
	lodsb
	cmp	al,INPUT
	ja	short pit_PRT		; not a control code ?
	mov	bx,00FFh
	and	bx,ax
	add	bx,bx
	call	pit_table[bx]
	jmp	short pit_NEXT
pit_EXIT:
	pop	di			; zap RET-addr
	popa
	mov	ax,[inputVALUE]		; (AX) = number
	lea	si,inputBUFFER[0]	; [DS:SI] --> input string
	cmp	[inputFLAG],0		; CF=ESC, ZF=0 string, NZ=number
	ret

pit_table	dw	pit_EXIT      	;
		dw	pit_XTAB      	; x
		dw	pit_YTAB      	; y
		dw	pit_LOCATE    	; x,y
		dw	pit_ORIGIN    	; x,y,width,height
		dw	pit_CENTRE    	; <string> ...
		dw	pit_ATTR      	; n 
		dw	pit_BOX		; width,height
		dw	pit_INPUT	; length

pit_XTAB:
	lodsb
	mov	[txtX],al
	jmp	short pit_CALCXY

pit_LOCATE:
	lodsb
	mov	[txtX],al
pit_YTAB:
	lodsb
	mov	[txtY],al
pit_CALCXY:
	push	ax
	mov	al,[txtY]
	add	al,[txtorgY]
	mov	ah,scrLINE
	mul	ah
	xchg	ax,di
	mov	al,[txtX]
	add	al,[txtorgX]
	mov	ah,0
	add	ax,ax
	add	di,ax			; [ES:DI] --> screen byte
	pop	ax
	ret

pit_ORIGIN:
	lodsb
	mov	[txtorgX],al
	lodsb
	mov	[txtorgY],al
	lodsb
	mov	[txtlenX],al
	lodsb
	mov	[txtlenY],al
	mov	word ptr [txtX],0	; X=Y=0
	jmp	short pit_CALCXY

pit_ATTR:
	dec	si			; * nice trick to load AH
	lodsw				; * from [DS:SI] and SI+1
	mov	[txtATTR],ah
	ret

pit_CENTRE:
	push	si
@@1:
	lodsb
	cmp	al,CENTRE
	ja	short @@1		; scan until position control-code
	mov	bx,si
	pop	si
	sub	bx,si
	mov	al,[txtlenX]
	sub	al,bl
	shr	al,1			; centre within current origin limits
	mov	[txtX],al
	call	pit_CALCXY
	ret

pit_BOX:
	push	di
	xchg	ax,dx
	lodsw
	xchg	ax,dx			; DL = width, DH=height

	mov	bl,17h			; Shadow mask

	push	di			; draw top edge
	mov	al,""	
	stosw
	mov	al,""			; my "ascii_chart" macro rulez #;o)
	mov	ch,0
	mov	cl,dl
	rep	stosw
	mov	al,""
	stosw
	pop	di
	add	di,scrLINE
pit_BOX1:
	push	di			; draw sides and middle
	mov	al,""
	stosw
	mov	cl,dl
	mov	al," "
	rep	stosw
	mov	al,""
	stosw
	and	ES:[di+1],bl		; shadow..
	pop	di
	add	di,scrLINE
	dec	dh
	jnz	short pit_BOX1

	push	di			; draw bottom edge
	mov	al,""
	stosw
	mov	cl,dl
	mov	al,""
	rep	stosw
	mov	al,""
	stosw
	and	ES:[di+1],bl		; shadow..
	pop	di
	add	di,scrLINE+3
	add	dl,2   			; draw bottom shadow
pit_BOX2:
	and	ES:[di],bl
	add	di,2
	dec	dl
	jnz	short pit_BOX2
	pop	di			; restore scr addr
	ret

;* Bulky routine to handle string/number input
pit_INPUT:
	push	ax
	lodsb
	cbw
	xchg	ax,cx			; (CX) = max length

	sub	bx,bx			; length/position
inp_LOOP:
	push	cx
	push	di

	mov	ah,[txtATTR]
	sub	bp,bp
inp_DRAW:
	cmp	bp,bx
	jz	short inp_DRAW2
	mov	al,inputBUFFER[bp]
	stosw				; print input so far..
	inc	bp
	dec	cx
	jmp	short inp_DRAW
inp_DRAW2:
	mov	al,""
	xor	ah,7Fh
	stosw				; draw cursor
	mov	al," "
	xor	ah,7Fh
	rep	stosw			; pad to max. length

	pop	di
	pop	cx
inp_WAIT:
	mov	byte ptr inputBUFFER[bx],0	; mark ASCII-Z
	call	waitkey
	cmp	al,ESCAPE
	jz	short inp_ESC		; [ESC] ?
	cmp	al,BACKSPC
	jz	short inp_BS		; [BACKSPACE] ?
	cmp	al,RETURN
	jz	short inp_RET		; [RETURN] ?
	cmp	al," "
	jb	short inp_WAIT
	cmp	al,128
	ja	short inp_WAIT		; accept 32..128
	cmp	bx,cx
	jz	short inp_WAIT		; max length ?
	mov	inputBUFFER[bx],al
	inc	bx
	jmp	short inp_LOOP

inp_BS:
	test	bx,bx
	jz	short inp_WAIT
	dec	bx	      		; del char
	jmp	short inp_LOOP
inp_ESC:
	mov	al,-1			; ESC flag
	jmp	short inp_EXIT

;* [RETURN] - scan input string to see if it's a number..
inp_RET:
	push	si
	lea	si,inputBUFFER
	call	scanhex
	pop	si
	mov	[inputVALUE],ax 	; keep number (if any)
	mov	al,1
	sbb	al,0			; 00=string, 01=number
inp_EXIT:
	mov	[inputFLAG],al		; FF=[ESC] hit
	pop	ax
	ret


;* CF (AX)=Scan hex number/symbol from[DS:SI]
scanhex:
	push	dx
	sub	dx,dx
sn_SKIP:
	lodsb
	cmp	al,0
	jz	short sn_NUL		; null string = 0000
	cmp	al," "
	jbe	short sn_SKIP

	call	chkhex
	jc	short sn_EXIT		; no valid digit ?
sn_SCAN:
	shl	dx,4
	or	dl,al
	lodsb
	call	chkhex
	jnc	short sn_SCAN
	dec	si
sn_NUL:
	xchg	ax,dx
	clc				; OK	CF=0
sn_EXIT:
	pop	dx
	ret

;* AL=Check(AL) is a hex-char "0-9" "a-f" or "A-F"
chkhex:
	sub	al,'0'
	cmp	al,9
	jbe	short ch_OK
	and	al,0DFh
	sub	al,'A'-'0'
	cmp	al,5+1
	cmc
	jc	short ch_NOPE
	add	al,10
ch_OK:
	clc
ch_NOPE:
	ret

;* Prompt[DS:SI] and input register value
promptreg:
	push	si
	lea	si,promptregtxt
	call	prtitems
	pop	si
	call	prtitems
	ret


inputAreg:
	call	promptreg
	jle	short _ret2
	mov	[A_reg],al
_ret2:
	ret

inputSTATUSreg:
	call	promptreg
	jle	short _ret2
	mov	[STATUS_reg],al
	ret

inputSTKreg:
	call	promptreg
	jle	short _ret2
	mov	[STK_reg],ax
	ret

inputPCreg:
	call	promptreg
	jle	short _ret2
	mov	[PC_reg],ax
	call	syncpc
	ret

inputcpu:
	call	promptreg
	jle	short _ret2
	and	ax,ADDR_MASK
	mov	[cpubarpnt],ax
	and	ax,1
	and	[cpupnt],0FFFEh
	or	[cpupnt],ax
	sub	ax,ax
	call	relcpu
	ret

inputmem:
	call	promptreg
	jle	short _ret2
	and	ax,ADDR_MASK
	sub	ax,(MEM_HIGH/2)*16
	mov	[mempnt],ax
	mov	[editpos],(MEM_HIGH/2)*16
	ret

inputuntil:
	call	promptreg
	jle	short _ret2
	and	ax,ADDR_MASK
	mov	[herePCbrk],ax
	call	run
	ret

last:


;* Execute 1 SPEW instruction then show Debug screen
execute1:
	call	emulate
	call	DebugScreen		; View DICE debug screen
	ret


;
;		All the emulator code 'n' stuff
;

_ret5:
	ret

emulate:
	call	checkdead
	jc	short _ret5		; prog terminated ?


	mov	bx,[PC_reg]
	and	bx,ADDR_MASK
	mov	dx,WORD PTR spewimage[bx]

	cmp	dh,00h
	jz	short x_OSCALL		; 00xx ?
	cmp	dx,1000h
	jz	short x_RETURN		; 1000 ?

	mov	bx,00F0h
	and	bl,dh
	shr	bx,3			; (DX) = opcode word
	jmp	x_decodetable[bx]

x_decodetable	dw	x_JP		; 0xxx
		dw	x_GOSUB		; 1xxx
		dw	x_PUSHB		; 2xxx
		dw	x_POPB		; 3xxx
		dw	x_LDA		; 4xxx
		dw	x_STA		; 5xxx
		dw	x_RDI		; 6xxx
		dw	x_WRI		; 7xxx
		dw	x_RDSYS		; 8xxx
		dw	x_ADDW		; 9xxx
		dw	x_JPcc		; Axxx
		dw	x_ADCA		; Bxxx
		dw	x_SBBA		; Cxxx
		dw	x_ORA		; Dxxx
		dw	x_ANDA		; Exxx
		dw	x_XORA		; Fxxx

x_OSCALL:
	add	[PC_reg],2		; PC + 2
	mov	ah,dl			; ah = xx
	mov	al,[A_reg]		; al = A
	mov	dl,[A_reg]		; dl = A

	;### Ruudje ### Stupid me, hooking int 21h

	;** TAD - modified to show user screen **

	cmp	ah,00h
	jz	short x_QUIT		; OSCALL 00 ?
	cmp	ah,4Ch
	jz	short x_QUIT		; OSCALL 4C ?

	call	UserScreen		; View user screen (in case of input)

	call	x_extract		; #	flags <--<-- STATUS (thanx Ruud)
	int	21h			; #  
	mov	[A_reg],al		; #	A = al
	call	x_pack			; #	STATUS <--<-- flags

	ret

x_QUIT:
	cmp	[bSilent],0
	jnz	short @@1
	mov	[cbrkflag],1
	mov	[deadflag],1		; indicate prog terminated
	lea	si,termin_alert
	call	alert
	ret
@@1:
	jmp	quit


x_JP:
	and	dx,ADDR_MASK
	mov	[PC_reg],dx		; PC = xxx
	ret

x_RETURN:
	mov	bx,[STK_reg]
	and	bx,ADDR_MASK
	cmp	bx,[hereSTKreturn]	;# detect Ruud's "ShowThis" routine
	jnz	short x_RETURN2		;# - used by F8-Step to catch a
	mov	[cbrkflag],1		;#   modified GOSUB return-address
x_RETURN2:
	mov	ax,WORD PTR spewimage[bx]
	mov	[PC_reg],ax		; PC = mem[STK]
	add	[STK_reg],2		; STK + 2
	ret

x_GOSUB:
	add	[PC_reg],2		; PC + 2
	sub	[STK_reg],2		; STK - 2
	mov	bx,ADDR_MASK
	and	bx,[STK_reg]
	mov	ax,[PC_reg]
	mov	WORD PTR spewimage[bx],ax	; mem[STK] = PC
	and	dx,ADDR_MASK
	mov	[PC_reg],dx		; PC = xxx
	ret
x_PUSHB:
	add	[PC_reg],2		; PC + 2
	dec	[STK_reg]		; STK - 1
	mov	bx,ADDR_MASK
	and	bx,dx
	mov	al,spewimage[bx]	; temp = mem[xxx]
	mov	bx,ADDR_MASK
	and	bx,[STK_reg]
	mov	spewimage[bx],al	; mem[STK] = temp
	ret

x_POPB:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,[STK_reg]
	mov	al,spewimage[bx]	; temp = mem[STK]
	mov	bx,ADDR_MASK
	and	bx,dx
	mov	spewimage[bx],al	; mem[xxx] = temp
	inc	[STK_reg]		; STK + 1
	ret
	
x_LDA:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	mov	al,spewimage[bx]
	mov	[A_reg],al		; A = mem[xxx]
	ret
x_STA:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	mov	al,[A_reg]
	mov	spewimage[bx],al	; mem[xxx] = A
	ret

x_RDI:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	mov	bx,WORD PTR spewimage[bx]	; temp = mem[xxx]
	and	bx,ADDR_MASK
	mov	al,spewimage[bx]
	mov	[A_reg],al		; A = mem[temp]
	ret
x_WRI:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	mov	bx,WORD PTR spewimage[bx]
	and	bx,ADDR_MASK		; temp = mem[xxx]
	mov	al,[A_reg]
	mov	spewimage[bx],al	; mem[temp] = A
	ret

x_RDSYS:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	push	ES
	sub	ax,ax
	mov	ES,ax
	mov	al,ES:[bx]
	pop	ES
	mov	[A_reg],al		; A = SYS ram[0000:0xxx]
	ret

x_ADDW:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	mov	al,[A_reg]
	cbw
	add	WORD PTR spewimage[bx],ax	; WORD mem[xxx] + A
	ret

x_JPcc:
	add	[PC_reg],2		; PC + 2
	mov	bx,000Fh
	and	bl,dh
	add	bx,bx
	call	x_extract		; flags <--<-- STATUS (thanx Ruud)
	jmp	x_condtable[bx]
x_goJP:
	mov	al,dl
	cbw
	add	[PC_reg],ax		; PC = +pp
	ret

x_condtable	dw	x_JPOV		; 0
		dw	x_JPNO		; 1
		dw	x_JPC		; 2
		dw	x_JPNC		; 3
		dw	x_JPZ		; 4
		dw	x_JPNZ		; 5
		dw	x_JPBE		; 6
		dw	x_JPA		; 7
		dw	x_JPS		; 8
		dw	x_JPNS		; 9
		dw	x_JPP		; A
		dw	x_JPNP		; B
		dw	x_JPL		; C
		dw	x_JPGE		; D
		dw	x_JPLE		; E
		dw	x_JPG		; F

x_JPOV:	jo	short x_goJP
	ret
x_JPNO:	jno	short x_goJP
	ret
x_JPC:	jc	short x_goJP
	ret
x_JPNC:	jnc	short x_goJP
	ret
x_JPZ:	jz	short x_goJP
	ret
x_JPNZ:	jnz	short x_goJP
	ret
x_JPBE:	jbe	short x_goJP
	ret
x_JPA:	ja	short x_goJP
	ret
x_JPS:	js	short x_goJP
	ret
x_JPNS:	jns	short x_goJP
	ret
x_JPP:	jp	short x_goJP
	ret
x_JPNP:	jnp	short x_goJP
	ret
x_JPL:	jl	short x_goJP
	ret
x_JPGE:	jge	short x_goJP
	ret
x_JPLE:	jle	short x_goJP
	ret
x_JPG:	jg	short x_goJP
	ret


x_ADCA:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	call	x_extract
	mov	al,spewimage[bx]
	adc	[A_reg],al  		; A + mem[xxx] + CF
	call	x_pack
	ret
x_SBBA:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	call	x_extract
	mov	al,spewimage[bx]
	sbb	[A_reg],al		; A - mem[xxx] - CF
	call	x_pack
	ret	
x_ORA:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	call	x_extract
	mov	al,spewimage[bx]
	or	[A_reg],al		; A - mem[xxx] - CF
	call	x_pack
	ret	
x_ANDA:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	call	x_extract
	mov	al,spewimage[bx]
	and	[A_reg],al		; A - mem[xxx] - CF
	call	x_pack
	ret	
x_XORA:
	add	[PC_reg],2		; PC + 2
	mov	bx,ADDR_MASK
	and	bx,dx
	call	x_extract
	mov	al,spewimage[bx]
	xor	[A_reg],al		; A - mem[xxx] - CF
	call	x_pack
	ret	


x_pack:
	push	ax
	pushf
	pop	ax
	and	ax,0000100011010101b
	or	al,ah
	mov	[STATUS_reg],al		; STATUS <--<-- flags
	pop	ax
	ret

x_extract:
	push	ax
	push	dx
	mov	al,[STATUS_reg]
	mov	ah,al
	and	ax,0000100011010101b
	pushf
	pop	dx
	and	dx,1111011100101010b
	or	dx,ax
	push	dx
	popf				; flags <--<-- STATUS
	pop	dx
	pop	ax
	ret
	
;


	.data
titletxt	db	'DICE - Disassembler & ICE for the Hugi compo #9',13,10
		db	'written by TAD  - (additional code by Ruud)',13,10
		db	0

err_CantOpenSPU	db	7,'**Error** Unable to open SPU file: ',0

promptregtxt	db	ATTR,INPUT_ATTR
		db	ORIGIN,8,10,30,5,BOX,28,3
		db	LOCATE,2,0," input value "
		db	LOCATE,4,2
		db	0

promptAtxt		db	'A register= ',INPUT,3,0
promptSTATUStxt		db	'STATUS register= ',INPUT,3,0
promptSTKtxt		db	'STK register= ',INPUT,4,0
promptPCtxt		db	'PC register= ',INPUT,4,0

promptcputxt		db	'Goto address= ',INPUT,3,0
promptmemtxt		db	'Jump to mem= ',INPUT,3,0

promptuntiltxt		db	'Run Until PC= ',INPUT,3,0


termin_alert	db	ATTR,ALARM_ATTR
		db	ORIGIN,4,20,38,7
		db	BOX,38,5,LOCATE,2,0," Alert "
		db	YTAB,2,CENTRE,"Program Terminated"
		db	YTAB,4,CENTRE,"- press [ESC] to quit -"
		db	0

;			 123456789abcd   123456789abcd
statustxt	db	'0 (+ve)  JPNS','1 (-ve)   JPS'		; sign flag
		db	'0 (non-zero) ','1 (zero)     '		; zero flag
		db	'             ','1 **ILLEGAL**'		; -
		db	'0            ','1 (aux true) '		; aux. flag
		db	'0            ','1 (overflow) '		; VF flag
		db	'0 (odd)      ','1 (even)     '		; PF flag
		db	'             ','1 **ILLEGAL**'		; -
		db	'0 (no-carry) ','1 (carry-set)'		; CF flag


brktxt		db	'  BRK   '
blanktxt	db	'        '
cpubartxt	db	' PC  '
cpuatxt		db	'=A      '
cpustatustxt	db	'=STATUS '
cpustktxt	db	'=STK    '
cpupctxt	db	'=PC     '

symbatxt	db	'a',0
symbstatustxt	db	'str',0
symbstktxt	db	'stk',0
symbpctxt	db	'pc',0

;* Instruction decoding strings
d_OSCALL	db	'OSCALL f',0
d_RETURN	db	'RETURN',0

d_JP		db	'JP     a',0
d_GOSUB		db	'GOSUB  a',0
d_PUSHB		db	'PUSHB  m',0
d_POPB		db	'POPB   m',0
d_LDA		db	'LDA    m',0
d_STA		db	'STA    m',0
d_RDI		db	'RDI    [(a)]      MEM[i]=b',0
d_WRI		db	'WRI    [(a)]      MEM[i]=b',0
d_RDSYS		db	'RDSYS  [0000:0x]',0
d_ADDW		db	'ADDW   [a],A',0
d_JPcc		db	'JPc   p',0
d_ADCA		db	'ADCA   m',0
d_SBBA		db	'SBBA   m',0
d_ORA		db	'ORA    m',0
d_ANDA		db	'ANDA   m',0
d_XORA		db	'XORA   m',0


d_table		dw	d_JP
		dw	d_GOSUB
		dw	d_PUSHB
		dw	d_POPB
		dw	d_LDA
		dw	d_STA
		dw	d_RDI
		dw	d_WRI
		dw	d_RDSYS
		dw	d_ADDW
		dw	d_JPcc
		dw	d_ADCA
		dw	d_SBBA
		dw	d_ORA
		dw	d_ANDA
		dw	d_XORA

JPcctable	db	'ov'
		db	'no'
		db	'c '
		db	'nc'
		db	'z '
		db	'nz'
		db	'be'
		db	'a '
		db	's '
		db	'ns'
		db	'po'
		db	'pe'
		db	'l '
		db	'ge'
		db	'le'
		db	'g '

cpu_keytable	dw	cpu_normkeys
		dw	cpu_shiftkeys
		dw	cpu_altkeys
		dw	cpu_ctrlkeys

cpu_bartable	dw	cpu_normbar
		dw	cpu_shiftbar
		dw	cpu_altbar
		dw	cpu_ctrlbar


cpu_ctrlbar	db	' CTRL+  A-reg  STATUS  STK  PC-reg'
		db	'  Goto  Jump-to-mem  reg-Names',0

cpu_ctrlkeys	dw	CTRLA_K,inputAreg, promptAtxt
		dw	CTRLS_K,inputSTATUSreg, promptSTATUStxt
		dw	CTRLT_K,inputSTKreg, promptSTKtxt
		dw	CTRLP_K,inputPCreg,promptPCtxt
		dw	CTRLG_K,inputcpu,promptcputxt
		dw	CTRLJ_K,inputmem,promptmemtxt
		dw	CTRLN_K,toggle,sym3flag
		dw	0


cpu_shiftbar	db	' SHIFT+  Home/End/Pg/',1Ah,"-Scroll-mem  "
		db	'PC-mem  STK-mem'
		db	0

cpu_shiftkeys	dw	UP_K, relmem, -16
		dw	DOWN_K, relmem, 16
		dw	LEFT_K, relmem, -1
		dw	RIGHT_K, relmem, 1
		dw	PGUP_K, relmem, -(16*15)
		dw	PGDN_K, relmem, (16*15)
		dw	HOME_K, topmem, 0
		dw	END_K, topmem,(ADDR_RANGE-(MEM_HIGH*16))
		dw	"T", editatreg, STK_reg
		dw	"P", editatreg, PC_reg
		dw	0

cpu_normbar	db	' F1-Help  F2-Brk  F4-Here  F7-Trace  F8-Step  '
		db	'F9-Run  Home/End/Pg/',1Ah,"-Scroll",0

cpu_normkeys	dw	UP_K, relcpu, -2
		dw	DOWN_K, relcpu, 2
		dw	PGUP_K, relpgcpu, -(2*CPU_HIGH)
		dw	PGDN_K, relpgcpu, (2*CPU_HIGH)
		dw	LEFT_K, relpgcpu, -1
		dw	RIGHT_K, relpgcpu, 1
		dw	HOME_K, topcpu, 0
		dw	END_K, endcpu, (ADDR_RANGE-(CPU_HIGH*2))
		dw	F2_K, togbrk, 1
		dw	F4_K, runhere, 0
		dw	F7_K, trace1, 0
		dw	F8_K, step1, 0
		dw	F9_K, run, 0
		dw	0

cpu_altbar	db	' ALT+  eXit  New-PC  goto-PC'
		db	'  F5-User screen  F9-Until  Edit-mem'
		db	'  Ascii-tog',0

cpu_altkeys	dw	ALTX_K, quit, 0
		dw	ALTP_K, gotopc, 0
		dw	ALTN_K, newpc,0
		dw	ALTE_K, togedit, 0
		dw	ALTA_K, toggle, asciiflag

	;### Ruudje ### added function under ALT F5
	;*** modified by TAD ***
	
		dw	ALTF5_K, ShowUser, 0
		dw	ALTF9_K, inputuntil,promptuntiltxt
		dw	0

;* used when in 'edit' mode

edit_normkeys	dw	UP_K, editup, -16
		dw	DOWN_K, editdown, 16
		dw	PGUP_K, relmem, -(2*CPU_HIGH)
		dw	PGDN_K, relmem, (2*CPU_HIGH)
		dw	LEFT_K, editleft, -1
		dw	RIGHT_K, editright, 1
		dw	HOME_K, edittop, 0
		dw	END_K, editend, (ADDR_RANGE-(CPU_HIGH*2))
		dw	ESC_K, togedit, 0
		dw	BSPC_K, editleft, -1
		dw	0


debugscr label byte
	include	dicescr.db

	IF DBUG
cmdline		db	'TEST.BIN',0
	ENDIF

	end	start
