comment $

example for Hugi compo 24 - The Tortoise and the Hare
by Hannes Uppman / 2005
$

.model tiny
.486
.code
org 100h

LOCALS

by equ <byte ptr>
wo equ <word ptr>
do equ <dword ptr>
off equ <offset>

hugi24example:

main PROC
        mov     si,off buf      ;fill restore buffer with 0
        mov     by [si],0
        lea     di,[si+1]
        call    copy
bigLoop:
        mov     ax,3            ;enter textmode
        int     10h
        call    openFile        ;get drawing commands
        
        mov     ax,13h          ;enter gfx mode 13h
        int     10h     

        push    0A000h          ;restore saved screendump
        pop     es
        mov     si,off buf
        xor     di,di
        call    copy
execute:
        call    readByte
        jcxz    @@1
        add     ax,ax           ;entries in cmdRoutineTable is 2 bytes
        mov     bx,ax
        call    wo [bx+cmdRoutineTable] ;call command service
        jmp     execute                 ;routine
@@1:
        mov     ah,3Eh          ;close file
        mov     bx,[fileHandle]
        int     21h

        push    0A000h          ;save screendump
        pop     ds
        push    cs
        pop     es
        xor     si,si
        mov     di,off buf
        call    copy
        push    cs
        pop     ds
        jmp     bigLoop
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
openFile PROC
        mov     ah,0Ah          ;get file name from console
        mov     dx,off keyBuf
        int     21h

        add     dx,2            ;Z-terminate string
        mov     bx,dx
        movzx   di,by [bx-1]
        mov     by [bx+di],0
        
        mov     ax,3D00h        ;open file
        int     21h
        jc      @@1            ;if error, exit program

        mov     [fileHandle],ax
        ret

@@1:    int     20h
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; copy 64000 bytes from ds:si to es:di
copy PROC
        xor     bx,bx
@@1:    mov     ax,[si+bx]
        mov     es:[di+bx],ax
        inc     bx
        cmp     bx,320*200
        jne     @@1
        ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
readByte PROC
        mov     bx,[fileHandle]
        mov     cx,1
        mov     ah,3Fh
        mov     dx,off buf
        int     21h
        
        xchg    ax,cx
        movzx   ax,by [buf]
        ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; plots pixel at pen.x, pen.y
; if pen.x,pen.y isnt whithin the screen, then they are clipped
; a pixel is plotted only if no clipping has occured
plot PROC
        pusha
        call    clip
        mov     [pen.x],cx
        mov     [pen.y],ax
        test    dl,dl
        jnz     @@1             ;dont plot
        cmp     [pen.on],0
        je      @@1             ;dont plot
        call    getVideoAddress
        mov     al,[pen.color]
        stosb
@@1:    popa
        ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; returns clipped pen.x in cx, and clipped pen.y in ax, dl != 0 if 
; clipping has occured
clip PROC
        xor     dl,dl
        mov     ax,[pen.x]
        mov     bp,319
        call    bound
        xchg    ax,cx
        mov     ax,[pen.y]
        mov     bp,199
        call    bound
        ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; variable to test in ax, maxlimit in bp, increases dl if clipping is
; made
bound PROC      
        cmp     ax,0
        jge     @@1
        xor     ax,ax
        inc     dl
@@1:    cmp     ax,bp
        jle     @@2
        mov     ax,bp
        inc     dl
@@2:    ret
ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
getVideoAddress PROC
        imul    di,[pen.y],320
        add     di,[pen.x]
        ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
nop PROC
        ret
ENDP
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveUp PROC
        call    plot
        call    readByte
        xchg    ax,cx
        jcxz    @@2
@@1:    dec     [pen.y]
        call    plot
        loop    @@1
@@2:    ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveDown PROC
        call    plot
        call    readByte
        xchg    ax,cx
        jcxz    @@2
@@1:    inc     [pen.y]
        call    plot
        loop    @@1
@@2:    ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveLeft PROC
        call    plot
        call    readByte
        push    ax
        call    readByte
        pop     cx
        mov     ch,al
        jcxz    @@2
@@1:    dec     [pen.x]
        call    plot
        loop    @@1
@@2:    ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveRight PROC
        call    plot
        call    readByte
        push    ax
        call    readByte
        pop     cx
        mov     ch,al
        jcxz    @@2
@@1:    inc     [pen.x]
        call    plot
        loop    @@1
@@2:    ret 
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveCoord PROC
        call    readByte
        mov     by [pen.x],al
        call    readByte
        mov     by [pen.x+1],al
        call    readByte
        mov     by [pen.y],al
        call    readByte
        mov     by [pen.y+1],al
        ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
penOn PROC
        mov     [pen.on],-1
        ret
ENDP
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
penOff PROC
        mov     [pen.on],0
        ret
ENDP
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
changeColor PROC
        call    readByte
        mov     [pen.color],al
        ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pause PROC
        xor     ax,ax
        int     16h
        ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; traditional midpoint line circle algorithm
midpointCircle PROC

; for your reading pleasure =D
X       equ <bx>
Y       equ <ax>
radius  equ <ax>
deltaE  equ <bp>
deltaSE equ <cx>
D       equ <dx>

        push    wo [pen.on]     ;circle cmd should not be affected by
        mov     [pen.on],-1     ;pen on/off state

        call    readByte        ;Y = radius
        xor     X,X
        mov     D,1
        sub     D,radius
        mov     deltaE,3
        mov     deltaSE,5
        sub     deltaSE,radius
        sub     deltaSE,radius  ;D = 1-radius, deltaE = 3
                                ;deltaSE = 5 - 2*radius
        call    circlePlot
@@1:    cmp     Y,X
        jbe     @@3
        test    D,D
        jns     southEast
east:
        add     D,deltaE
        add     deltaE,2
        add     deltaSE,2
        jmp     @@2
southEast:
        add     D,deltaSE
        add     deltaE,2
        add     deltaSE,4
        dec     Y
        
@@2:    inc     X
        call    circlePlot
        jmp     @@1
@@3:    pop     wo [pen.on]
        ret
ENDP
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; use symmetry in order to print a circle
circlePlot PROC
        pusha
        call    circlePlot2     ;x,y
        neg     Y
        call    circlePlot2     ;x,-y
        neg     X
        call    circlePlot2     ;-x,-y
        neg     Y
        call    circlePlot2     ;-x,y
        xchg    Y,X
        call    circlePlot2     ;y,-x
        neg     Y
        call    circlePlot2     ;y,x
        neg     X
        call    circlePlot2     ;-y,x
        neg     Y
        call    circlePlot2     ;-y,-x
        popa
        ret
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
circlePlot2 PROC
        pusha
        xchg    [pen.x],X
        add     [pen.x],X
        xchg    [pen.y],Y
        add     [pen.y],Y
        call    plot
        mov     [pen.x],X
        mov     [pen.y],Y
        popa
        ret
ENDP
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; this function is highly recursive and requires a lot of stack, worst
; case senario is that the levels of recursion equals the number of
; pixels available; a little less then 64k. Hence one can only afford
; one byte to be pushed on the stack per level of recusrion. A special
; "custom stack" is used for this.
fill PROC   
        call    readByte
        mov     [fcolor.use],al

        call    getVideoAddress
        mov     al,by es:[di]
        mov     [fcolor.target],al

        mov     bx,off buf
        mov     by [bx],off @@1 - off fill  ;call    filler
        jmp     filler
@@1:    ret
ENDP

filler PROC 
        inc     bx

        call    clip            ;on screen?
        test    dl,dl
        jnz     @@2
        
        call    getVideoAddress
        mov     al,by es:[di]
        cmp     al,[fcolor.target]
        jnz     @@2             ;dont plot if color on pixel isnt
                                ;target color
        cmpxchg [fcolor.use],al
        jz      @@2             ;dont plot if target color and the
        stosb                   ;color in use (the color of the pixel
                                ;to be plotted) is equal
fillWest:
        dec     [pen.x]
        mov     by [bx],off fillEast - off fill     ;call    filler
        jmp     filler
fillEast:                                               
        add     [pen.x],2
        mov     by [bx],off fillNorth - off fill    ;call    filler
        jmp     filler
fillNorth:
        dec     [pen.x]
        dec     [pen.y]
        mov     by [bx],off fillSouth - off fill    ;call    filler
        jmp     filler
fillSouth:
        add     [pen.y],2
        mov     by [bx],off @@1 - off fill          ;call    filler
        jmp     filler        
@@1:
        dec     [pen.y]         ;back to were we started       
@@2:    dec     bx              ;ret
        movsx   ax,by [bx]
        add     ax,off fill
        jmp     ax
ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cmdRoutineTable:
    dw  off nop
    dw  off moveUp
    dw  off moveDown
    dw  off moveLeft
    dw  off moveRight
    dw  off moveCoord
    dw  off penOn
    dw  off penOff
    dw  off changeColor
    dw  off pause
    dw  ?
    dw  ?
    dw  ?
    dw  ?
    dw  ?
    dw  ?
    dw  off midpointCircle
    dw  off fill

_pen STRUC
        x       dw 0
        y       dw 0
        on      db 0
        color   db 0
_pen ENDS
pen             _pen <>

keyBuf          db 20,0,20 dup(?)
 
_fillColor STRUC
        target  db ?
        use     db ?
_fillColor ENDS
fcolor          _fillColor ?

fileHandle      dw ?
buf:
end hugi24example