comment $
 hc24 testprogram by Hannes Uppman / 2005

 Parameter '-D' dumps the screen (generated by entry.com) to disk.
 This feature is a quick n' dirty extension. It will hide text output.
 Run program without '-D' or redirect stdOut to read the messages :-)
$
.model tiny
.386
.code
org 100h
LOCALS
by equ <byte ptr>
wo equ <word ptr>
do equ <dword ptr>
off equ <offset>

test:
    jmp     main

; a bit tight in the segment.. will have to overwrite some old code
; and data, hence the weird code layout :-P

dump PROC
; get palette
    mov     ax,13h
    int     10h
    mov     dx,3C7h
    xor     ax,ax
    out     dx,al
    inc     dx
    inc     dx
    mov     cx,256
    mov     bx,off colorMap
@@1:in      al,dx
    shl     ax,8
    in      al,dx
    shl     ax,2
    mov     wo [bx+1],ax
    in      al,dx
    shl     ax,2
    mov     by [bx],al
    add     bx,3
    loop    @@1
    mov     ax,3
    int     10h
; write TGA
    mov     ah,3Ch
    mov     dx,off dmpName
    xor     cx,cx
    int     21h
    xchg    ax,bx
    mov     ah,40h
    mov     cx,off colorMap - off TGAhead + 3*256 + 320*200
    mov     dx,off TGAhead
    int     21h
    mov     ah,3Eh
    int     21h
; exit with error code
exit:
    mov     ah,4Ch
    mov     al,cs:[errorF]
    int     21h

errorF      db 0
dmpName     db "DUMP.TGA",0
TGAhead:    db 0            ; no Image Identification Field
            db 1            ; one color map
            db 1            ; Uncompressed, Color-mapped Image
            dw 0            ; index of first color map entry
            dw 256          ; count of color map entries
            db 24           ; Color Map Entry Size
            dw 0            ; X coordinate of the lower left corner
            dw 0            ; Y coordinate of the lower left corner
            dw 320          ; Width of Image
            dw 200          ; Height of Image
            db 8            ; Image Pixel Size
            db 00100000b    ; Image Descriptor Byte
colorMap:   ;db 256*3 dup(?); Color map data.
;screenBuf  db 320*200 dup(?);Image Data Field
screenBuf equ <colorMap+256*3>
ENDP

main PROC
; fixup
    mov     ax,cs
    mov     [paramBlock+4],ax
    mov     [paramBlock+8],ax
    mov     [paramBlock+12],ax
    mov     [stackptr+2],ax
; free some of the allocated memory
    mov     ah,4Ah
    mov     bx,4096 ;64*1024/16 - only need 64kB
    int     21h
; hook int16
    mov     ax,3516h
    int     21h
    mov     [int16ptr+2],es
    mov     [int16ptr],bx
    mov     ax,2516h
    mov     dx,off int16isr
    int     21h
; hook int10
    mov     ax,3510h
    int     21h
    mov     [int10ptr+2],es
    mov     [int10ptr],bx
    mov     ax,2510h
    mov     dx,off int10isr
    int     21h
; run entry.com
    mov     ax,4B00h
    mov     dx,off testName
    push    cs
    pop     es
    mov     bx,off paramBlock
    int     21h
    lss     sp,do [stackptr]
    push    cs
    pop     ds
; run example.com
    inc     [refF]
    mov     ax,4B00h
    mov     dx,off refName
    push    cs
    pop     es
    mov     bx,off paramBlock
    int     21h
    lss     sp,do [stackptr]
    push    cs
    pop     ds
; exit to textmode?
    mov     ah,0Fh
    int     10h
    cmp     al,3
    jz      @@1
    mov     ax,03
    int     10h
    mov     ah,09
    mov     dx,off modeMsg
    int     21h
    inc     [errorF]
; int16 generated the correct amount of times?
@@1:mov     ax,[nrPauseRef]
    cmp     ax,[nrPauseTest]
    jz      @@2
    mov     ah,09
    mov     dx,off pauseMsg
    int     21h
    inc     [errorF]
; pixel error?
@@2:cmp     [pixelF],0
    jnz     @@3
    mov     ah,09
    mov     dx,off pixelMsg
    int     21h
    inc     [errorF]
; everything correct?
@@3:cmp     [errorF],0
    jnz     @@4
    mov     ah,09
    mov     dx,off okMsg
    int     21h
; unhook int16 & int10
@@4:mov     ax,2516h
    lds     dx,do [int16ptr]
    int     21h
    push    cs
    pop     ds
    mov     al,10h
    lds     dx,do [int10ptr]
    int     21h
; dump screen?
    push    cs
    pop     ds
    mov     bx,80h
@@5:inc     bl
    jz      exit
    cmp     by [bx],'-'
    jnz     @@5
    cmp     by [bx+1],'D'
    jnz     @@5
    jmp     dump
ENDP

int16isr PROC
    pusha
    test    ah,ah
    jnz     @@2
    mov     ah,0Fh
    int     10h
    cmp     al,13h
    jnz     @@2
    cmp     cs:[refF],0
    jz      try
ref:inc     cs:[nrPauseRef]
    jmp     @@1
try:inc     cs:[nrPauseTest]
@@1:popa
    iret
@@2:popa
    db      0EAh    ;jmp far int16ptr
int16ptr    dw 2 dup(?)
ENDP

int10isr PROC
    pusha
    cmp     ax,3
    jnz     @@2
    push    es
    push    ds
    push    cs
    pop     es
    push    0A000h
    pop     ds
    mov     cx,320*200
    xor     si,si
    mov     di,off screenBuf
    cld
    cmp     cs:[refF],0
    jnz     tr
re: rep     movsb
    jmp     @@1
tr: repz    cmpsb
    setz    cs:[pixelF]
@@1:pop     ds
    pop     es
@@2:popa
    db      0EAh    ;jmp far int10ptr
int10ptr    dw 2 dup(?)
ENDP

paramBlock  dw 0, 80h, ?, 6Ch, ?, 5Ch, ?
modeMsg     db " - didnt return to mode 3 on exit",13,10,'$'
pixelMsg    db " - some pixels doesnt match those produced by reference",13,10,'$'
pauseMsg    db " - didnt pause the correct amount of times",13,10,'$'
okMsg       db " - passed    ",13,10,'$'
refName     db "EXAMPLE.COM",0
testName    db "ENTRY.COM",0
refF        db 0
pixelF      db 0
nrPauseRef  dw 0
nrPauseTest dw 0
stackptr    dw 0FFFEh,?

end test