/****************************************************************************
 * mtfenc.cpp                                  Simple Move to Front Encoder *
 ****************************************************************************
 * made by Fabian Giesen aka RYG/Chrome Design                              *
 * for my BWT article in hugi #13                                           *
 *                                                                          *
 * If you use this code in one of your productions, please credit me        *
 * (although it isn't very useful standalone)                               *
 ****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <iostream.h>

char order[256];                       // the order table

int main(int argc, char *argv[])
{
  FILE *in, *out;                      // input/output files
  char *buffer;                        // io buffer
  int   i, j, r, code;                 // some counters & stuff

  cerr << "Basic MTF Encoder" << endl; // title line

  if (argc!=3)                         // if wrong parameter count, exit
  {
    cerr << endl << "Use: MTFENC <Input filename> <Output filename>" << endl;
    return 1;
  };

  in=fopen(argv[1], "rb");             // open input file

  if (!in)                             // if open failed, exit
  {
    cerr << endl << "cannot open input file!" << endl;
    return 1;
  };

  out=fopen(argv[2], "wb");            // open output file

  if (!out)                            // if open failed, exit
  {
    cerr << endl << "cannot open output file!" << endl;
    return 1;
  };

  buffer=new char[65535];              // allocate a 64k-1 buffer for io

  for (i=0; i<256; i++) order[i]=i;    // initialize order table

  cerr << endl << "Encoding..." << endl;

  do                                   // the actual encoder
  {
    r=fread(buffer, 1, 65535, in);     // fill buffer with input data

    for (i=0; i<r; i++)                // run over input data
    {
      char inpt=buffer[i];             // input char

      code=-1;                         // set code to impossible value

      // then find input byte in order table

      for (j=0; j<256; j++)
        if (order[j]==inpt) { code=j; break; };

      buffer[i]=code;                  // write its code back to buffer

      for (j=code; j>0; j--) order[j]=order[j-1];
      order[0]=inpt;
    };

    fwrite(buffer, 1, r, out);         // write our buffer to output file
  } while (r==65535);                  // loop as long as buffer gets full

  cerr << "Done!" << endl;             // tell the user we're done

  delete [] buffer;                    // free memory

  fclose(in);                          // close files
  fclose(out);

  return 0;                            // and exit
};
