//////////////////////////////////////////////////////////////
//           simple video for DJGPP or WATCOM
//////////////////////////////////////////////////////////////

#define The_W  320
#define The_H  200

static unsigned char The_Screen[The_W*The_H];
#define VID_MEM(y)	(The_Screen+y*The_W)
#define VID_PITCH  ( The_W )
#define VID_SIZE   ( The_W*The_H )

static int xo, yo;  // the mouse

#if defined( __DJGPP__ )

#include <dpmi.h>
#include <go32.h>
#include <sys/nearptr.h>
#define VIDEO (void*)( ((0xa000)<<4) + __djgpp_conventional_base)

#elif defined( __WATCOMC__ )

#include <i86.h>

#define outportb  outp
#define VIDEO (void*)(0xa000<<4)

// typedef union REGS __dpmi_regs;
      // DPMI registers       <=>  <dpmi.h>
typedef union {
#pragma pack(1)
  struct { unsigned long edi, esi, ebp, res, ebx, edx, ecx, eax; } d;
  struct {
    unsigned short di, di_hi, si, si_hi, bp, bp_hi, res, res_hi;
    unsigned short bx, bx_hi, dx, dx_hi, cx, cx_hi, ax, ax_hi;
    unsigned short flags, es, ds, fs, gs, ip, cs, sp, ss;
  } x;
  struct {
    unsigned char edi[4], esi[4], ebp[4], res[4];
    unsigned char bl, bh, ebx_b2, ebx_b3, dl, dh, edx_b2, edx_b3;
    unsigned char cl, ch, ecx_b2, ecx_b3, al, ah, eax_b2, eax_b3;
  } h;
#pragma pack()
} __dpmi_regs;

   // simulate djgpp's one.
static int __dpmi_int( char no, __dpmi_regs *in )
{
   union REGS r;
   r.w.ax       = 0x300;
   r.h.bl       = no;
   r.h.bh       = 0;
   r.w.cx       = 0;
   r.x.edi      = FP_OFF( in );
   int386( 0x31, &r, &r );   
   return( r.w.cflag );                        
}
#endif

static void Init_Video( )
{
   __dpmi_regs r;
   int i, j;

#if defined(__DJGPP__)
   __djgpp_nearptr_enable( );
#endif

   memset( &r, 0, sizeof(r) );
   r.x.ax = 0x13;
   __dpmi_int( 0x10, &r );

   outportb( 0x3c8, 0);
   for ( i=0; i<255; i++ )    // gray ramp
   {
      outportb( 0x3c9, i>>2 );
      outportb( 0x3c9, i>>2 );
      outportb( 0x3c9, i>>2 );
   }
   outportb( 0x3c9, 255>>2 );     // color #255 = red
   outportb( 0x3c9, 0 );
   outportb( 0x3c9, 0 );

   xo = The_W/2;
   yo = The_H/2;
}
static void Close_Video( )
{
   __dpmi_regs r;

#if defined(__DJGPP__)
   __djgpp_nearptr_disable( );
#endif
   memset( &r, 0, sizeof(r) );
   r.x.ax = 0x03;
   __dpmi_int( 0x10, &r );
}
static int Get_Key( )
{
   if ( kbhit( ) ) return( getch( ) );
   else return( -1 );
}
static void Get_Mouse_Coord( int *x, int *y )
{
   __dpmi_regs r;
   memset( &r, 0, sizeof(r) );
   r.x.ax = 0x000b;
   __dpmi_int( 0x33, &r );
   xo += r.x.cx>=0x8000 ? r.x.cx-65535 : r.x.cx;
   yo += r.x.dx>=0x8000 ? r.x.dx-65535 : r.x.dx;
   *x = xo;
   *y = yo;
}
static void Update_Video( )
{
   memcpy( VIDEO, VID_MEM(0), VID_SIZE );
}
static void Clear_Video( )
{
   memset( VID_MEM(0), 0x00, VID_SIZE );
}

//////////////////////////////////////////////////////////////

