;#############################################################################
;#
;# genmath.asm
;#
;# Purpose:
;#	General math functions
;#
;#############################################################################

		.386
		.387
		Ideal
		Jumps
		Model	Tiny,C

		Include 'vector2.inc'
		CodeSeg

;******************************************************************************
;*
;* int SolveQuadratic(float *V,float *S)
;*
;* Purpose:
;*	Solves the quadratic equation ax^2+bx+c = 0
;*
;* Arguments:
;*	V - near pointer to array of floats containing coefficients a,b,c
;*	    (a=x,b=y,c=z)
;*	S - near pointer to array to put the two results in
;*
;* Returns:
;*	Solutions in S
;*	Number of solutions in eax
;*
;******************************************************************************
Public		SolveQuadratic
Proc		SolveQuadratic	uses si di
		arg	V:word,S:word
		local	UnderRoot:word

		mov	si,[V]
		mov	di,[S]
		fld	[dword si+4]		; Load b
		fld	st(0)			; Load b
		fmul				; b*b
		fld	[FLOAT_4_0]		; Load 4
		fld	[dword si]		; Load a
		fld	[dword si+8]		; Load c
		fmul				; a*c
		fmul				; 4*a*c
		fsub				; b*b-4*a*c

		ftst				; Check how many solutions we got
		fstsw	ax
		sahf
		jb 	SHORT @@ZeroSolutions
		je	SHORT @@OneSolution
		fsqrt				; sqrt(b*b-4*a*c)

		fld	st(0)			; Duplicate

		fld	[dword si+4]		; Load b
		fchs				; -b
		fadd				; -b+sqrt(...)

		fld	[dword si]		; Load a
		fld	st(0)			; again
		fadd				; a+a (2.0*a)

		fdiv				; -b+sqrt(...)/2a
		fstp	[dword di]		; Save

		fld	[dword si+4]		; Load b
		fchs
		fsubr				;-b-sqrt(...)

		fld	[dword si]		; Load a
		fld	st(0)
		fadd				; a+a (2.0*a)
		fdiv
		fstp	[dword di+4]
		mov	eax,2
		jmp	SHORT @@Exit
@@OneSolution:
		fld	[dword si+4]		; Load b
		fchs				; -b
		fadd				; -b+sqrt(...)

		fld	[dword si]		; Load a
		fld	st(0)
		fadd				; a+a (2.0*a)

		fdiv				; -b+sqrt(...)/2a
		fst	[dword di]		; Save
		fstp	[dword di]
		mov	ax,1
		jmp	SHORT @@Exit
@@ZeroSolutions:
		fstp	st(0)
		xor	ax,ax
@@Exit:
		ret
Endp		SolveQuadratic

;******************************************************************************
;*
;* float XtoY(float X,float Y)
;*
;* Purpose:
;*	Computes X^Y
;*
;* Arguments:
;*	X and Y
;*
;* Returns:
;*	X^Y in eax
;*
;*	Taken from Art of Assembly, chapter 14 (Randall Hyde)
;*
;******************************************************************************
Public		XtoY
Proc		XtoY
		arg	X:dword,Y:dword
		local	temp:dword
		fld	[X]
		ftst
		fstsw	ax
		sahf
		jz	SHORT @@XisZero
		fld	[Y]
		fxch

                fld1            ;Compute lg(y).
                fxch
                fyl2x

                fmul            ;Compute x*lg(y).
                call    TwoToX  ;Compute 2**(x*lg(y)).
		fstp	[temp]
		mov	eax,[temp]
		fstp	st(0)
		jmp	SHORT @@Exit
@@XisZero:
		fstp	st(0)
		xor	eax,eax
@@Exit:
		ret
Endp		XtoY


;******************************************************************************
;*
;* TowToX()
;*
;* Purpose:
;*	Computes 2^X
;*	THIS IS AN INTERNAL ROUTINE ONLY, AND USES THE FPU STACK!
;*
;*	Taken from Art of Assembly, chapter 14 (by Randall Hyde)
;*
;******************************************************************************
proc		TwoToX
		local	SaveCW:word,MaskedCW:word
                fstcw   [SaveCW]

; Modify the control word to truncate when rounding.

                fstcw   [MaskedCW]
                or      [byte ptr MaskedCW+1], 1100b
                fldcw   [MaskedCW]

                fld     st(0)           ;Duplicate tos.
                fld     st(0)
                frndint                 ;Compute integer portion.

                fxch                    ;Swap whole and int values.
                fsub    st(0), st(1)    ;Compute fractional part.

                f2xm1                   ;Compute 2**frac(x)-1.
                fld1
                fadd                    ;Compute 2**frac(x).

                fxch                    ;Get integer portion.
                fld1                    ;Compute 1*2**int(x).
                fscale
                fstp    st(1)           ;Remove st(1) (which is 1).

                fmul                    ;Compute 2**int(x) * 2**frac(x).

                fldcw   [SaveCW]     	;Restore rounding mode.
                ret
endp		TwoToX

; NEVER USED!
;Public		ACos
;Proc		ACos
;		arg	value:dword
;		local	temp:dword
;
;		fld	[value]
;                fld     st(0)           ;Duplicate X on tos.
;                fmul                    ;Compute X**2.
;                fld     st(0)           ;Duplicate X**2 on tos.
;                fld1                    ;Compute 1-X**2.
;                fsubr
;                fdivr                   ;Compute (1-x**2)/X**2.
;                fsqrt                   ;Compute sqrt((1-X**2)/X**2).
;                fld1                    ;To compute full arctangent.
;		fpatan                  ;Compute atan of the above.
;		fstp	[temp]
;		mov	eax,[temp]
;		ret
;EndP		ACos

		DataSeg
		Align	4

; Constants used in different functions
public FLOAT_4_0
FLOAT_4_0	dd	4.0
public FLOAT_2_0
FLOAT_2_0	dd	2.0
;public FLOAT_8_0
;FLOAT_8_0	dd	8.0
public FLOAT_255_0
FLOAT_255_0	dd	255.0
;public FLOAT_32_0
;FLOAT_32_0	dd	32.0
public FLOAT_100_0
FLOAT_100_0	dd	100.0

		end
