;#############################################################################
;#
;# ray.asm
;#
;# Purpose:
;#	Raytracing-routines
;#
;#############################################################################
		.386
		.387
		Ideal
		Jumps
		Model 	Tiny,C
		Include 'settings.inc'
		Include 'ray2.inc'
		Include	'vector.inc'
		Include 'genmath.inc'
		Include 'color.inc'

		CodeSeg

Public		RayGetPoint
Proc		RayGetPoint	uses ebx esi edi
		arg	p0:ptr Vector,p1:ptr Vector,objlist:ptr ptr Object
		arg	numObjects:word,skipObject:word,inters:ptr Vector
		local	curHitObject:word
		local	curLength:dword
		local	length_:dword
		local	isIntersection:word

		xor	bx,bx
		mov	[isIntersection],bx	; Set to TRUE if there was an intersection
		mov	[curHitObject],-1
		xor	si,si
		mov	si,[objlist]
@@ObjectLoop:
		cmp	bx,[skipObject]
		je	SHORT @@SkipThisObject
		push	bx
		add	bx,bx
		mov	di,[si+bx]
		pop	bx
		call	RayGetIntersection	C,[p0],[p1],di,offset rgpIntersTemp
		test	ax,ax			; Was there an intersection?
		jz	SHORT @@NoIntersection	; No, skip

						; Get distance to point...
		call	VectorSub		C,offset rgpIntersTemp,[p0],offset rgpIntersTemp
		call	VectorLength		C,offset rgpIntersTemp
		mov	[length_],eax		; Store it for later use

		mov	ax,[isIntersection]	; Has there been an intersection before?
		test	ax,ax
		jz	SHORT @@StoreIntersection	; Nope, copy intersection-point
						; Okay, compare the distances..
		fld	[curLength]
		fld	[length_]
		fcompp
		fstsw   ax
		sahf
		jae	SHORT @@DontStoreIntersection

@@StoreIntersection:
		mov	[curHitObject],bx
		mov	eax,[length_]
		mov	[curLength],eax
		call	VectorAdd		C,offset rgpIntersTemp,[p0],offset rgpCurInters

		mov	[isIntersection],1
@@NoIntersection:
@@DontStoreIntersection:
@@SkipThisObject:
		inc	bx
		cmp	bx,[numObjects]
		jb	@@ObjectLoop
		call	VectorCopy		C,offset rgpCurInters,[inters]
		mov	ax,[curHitObject]
		cwde
		ret
EndP		RayGetPoint

Proc		RayCheckShadow		uses	bx cx si di
		arg	light:ptr vector,objlist:ptr ptr Object,numObjects:word,curObject:word
		arg	inters:ptr Vector
		local	lightLength:dword		; Distance from inters to light
		local	temp1:dword

		call	VectorSub	C,[light],[inters],offset rcsTempVector1
		call	VectorLength	C,offset rcsTempVector1
		mov	[lightLength],eax

		mov	cx,[numObjects]
		xor	di,di
		mov	si,[objlist]
@@Loop1:
		cmp	di,[curObject]
		je	SHORT @@SkipObject
		mov	bx,di
		add	bx,bx
		mov	bx,[si+bx]
		call	RayGetIntersection	C,[inters],[light],bx,offset rcsCurInters
		test	ax,ax
		jz	SHORT @@NoIntersection
		; Yes, there was an intersection. Now check if the intersection was
		; between inters and the light source
		call	VectorSub		C,offset rcsCurInters,[inters],offset rcsTempVector1
		call	VectorLength		C,offset rcsTempVector1
		mov	[temp1],eax
		fld	[temp1]
		fld	[lightLength]
		fcompp
		fstsw	ax
		sahf
		jbe	SHORT @@NoBlocking		; There was no blocking here
		mov	ax,1			; Return TRUE
		jmp	SHORT @@Exit
@@NoBlocking:
@@SkipObject:
@@NoIntersection:
		inc	di
		loop	@@Loop1

		xor	ax,ax
@@Exit:
		ret
EndP		RayCheckShadow

Public		RayGetColor
Proc		RayGetColor	uses bx si cx di dx
		arg	p0:ptr Vector,p1:ptr Vector,objlist:ptr ptr Object
		arg	numObjects:word,skipObject:word,iterations:word,light:ptr Vector
		arg	color:ptr Vector
		local	curObject:word
		local	tempx:dword,tempy:dword
		local	gotTexture:word

		mov	[gotTexture],0	; So far we don't know if we have a texture

		mov	di,[iterations]
		test	di,di
		jz	@@NoHit		; No more iterations

		mov	ax,SIZE Vector	; Get offset to current place in rgcIntersTable
		mul	di
		mov	di,ax
		; si = intersection
		lea	si,[rgcIntersTable + di]
		; Get the intersection and object number
		call	RayGetPoint	C,[p0],[p1],[objlist],[numObjects],[skipObject],si
		cmp	eax,-1
		jz	@@NoHit

		; Get the texture-color, if any
		push	eax ecx bx si
		mov	bx,[objlist]		; Get pointer to object address
		add	bx,ax
		add	bx,ax
		mov	bx,[bx]			; Get object address
		cmp	[bx+Object.Class],OBJECT_GROUND
		jnz	SHORT @@NoTexture		; Only textures for ground objects
		cmp	[bx+Object.Texture],0	; Check the texture pointer
		jz	SHORT @@NoTexture		; Nope, no texture here, skip
		; Now find x and y of texture and scale them. This is easiest done
		; Find x in texture
		fld	[si+Vector.X]
		fistp	[tempx]			; Store it
		mov	eax,[tempx]
		mov	ecx,[bx+Object.TextureScale]
		sar	eax,cl			; Scale it
		and	eax,[bx+Object.WidthMask]	; Mask it (only works for 2x2 textures now)
		mov	[tempx],eax
		; Find z (which will become y in texture)
		fld	[si+Vector.Z]
		fistp	[tempy]			; Store it
		mov	eax,[tempy]
		mov	ecx,[bx+Object.TextureScale]
		sar	eax,cl			; Scale it
		and	eax,[bx+Object.HeightMask]		; Mask it (only works for 2x2 textures now)
		mov	[tempy],eax
		mov	ecx,[bx+Object.TextureWidth]
		shl	eax,cl			; Get y offset
		add	eax,[tempx]
		shl	eax,2			; RGBA is 4 bytes big
		mov	bx,[bx+Object.Texture]
		mov	si,ax
		lea	bx,[bx+si]
		lea	si,[rgcTextureTable+di]
		call	ColorRGB2Float	C,bx,si
		mov	[gotTexture],1
@@NoTexture:
		pop	si bx ecx eax

		mov	[curObject],ax
		push	ax
		call	RayCheckShadow	C,[light],[objlist],[numObjects],ax,si
		mov	cx,ax
		pop	ax

		; bx = pointer to object in list
		mov	bx,[objlist]	; List of pointers to objects
		add	bx,ax
		add	bx,ax
		; dx = lightcolor
		lea	dx,[rgcLightColorTable+di]	; Get current place in rgcLightColorTable

		call	RayGetLight	C,[p0],[bx],si,[light],dx,cx

		; Mul texture if it exists
		cmp	[gotTexture],0
		je	SHORT @@NoAddTexture
		lea	cx,[rgcTextureTable+di]
		call	ColorFloatMulFloat	C,dx,cx,dx
@@NoAddTexture:

		; Do we have reflection?
		push	bx
		mov	bx,[bx]
		fld	[bx+Object.Reflection]
		pop	bx
		ftst
		fstsw	ax
		fstp	st(0)
		sahf
		jz	@@NoReflection

		; Find the reflectional light (mirror)

		; cx = viewer
		lea	cx,[rgcViewerTable+di]
		call	VectorSub	C,[p0],si,cx

		; ax = normal
		lea	ax,[rgcNormalTable+di]
		call	RayGetNormal	C,[bx],si,ax

		; dx = reflection
		push	ax
		lea	dx,[rgcReflectionTable+di]
		call	VectorGetReflection	C,cx,ax,dx
		test	ax,ax
		pop	ax
		jz	SHORT @@NoReflectionLight

		; cx = eye
		lea	cx,[rgcEyeTable+di]
		call	VectorAdd	C,dx,si,cx
		mov	ax,[iterations]
		dec	ax

		; dx = reflectioncolor
		lea	dx,[rgcReflectionColorTable+di]
		call	RayGetColor	C,si,cx,[objlist],[numObjects],[curObject],ax,[light],dx
		test	ax,ax
		jz	SHORT @@NoReflectionLight

		mov	bx,[objlist]		; Get pointer to object address
		add	bx,[curObject]
		add	bx,[curObject]
		mov	bx,[bx]			; Get object address
		call	VectorScale	C,dx,[dword bx+Object.Reflection],dx
		; cx = lightcolor
		lea	cx,[rgcLightColorTable+di]
	       	call	VectorAdd	C,dx,cx,[color]

		;call	VectorCopy	C,cx,[color]
		call	VectorClamp	C,[color],[color]
		;call	VectorCopy	C,offset TestVector,[color]
		; Return the color
		mov	ax,1		; Return true
		jmp	SHORT @@Exit
@@NoReflectionLight:
		lea	cx,[rgcLightColorTable+di]
		call	VectorCopy	C,cx,[color]
		mov	ax,1
		jmp	SHORT @@Exit
@@NoReflection:
		; We remember that dx still is lightcolor here
		call	VectorCopy	C,dx,[color]
		mov	ax,1
		jmp	SHORT @@Exit
@@NoHit:
		xor	ax,ax		; Return false
@@Exit:
		ret
EndP		RayGetColor

Proc		RayGetLight	uses	eax si di
		arg	p0:ptr Vector,obj:ptr Object,inters:ptr Vector
		arg	light:ptr Vector,lightColor:ptr Vector,isShadow:word
		local	ambient:dword,diffuse:dword,specular:dword,tempshininess:dword
		local	rv_dot:dword

		mov	ax,[isShadow]
		test	ax,ax		; Is the object in shadow?
		jz	SHORT @@NoShadow	; No
		mov	si,[obj]
		lea	di,[si+Object.AmbientColor]
		call	VectorCopy	C,di,[lightcolor]
		jmp	@@Exit
@@NoShadow:
		; Find viewer vector and normalize it
		call	VectorSub	C,[p0],[inters],offset rglViewer
		call	VectorNormalize	C,offset rglViewer,offset rglViewer

		; Find the light vector of the point and normalize it
		call	VectorSub	C,[light],[inters],offset rglLight
		call	VectorNormalize	C,offset rglLight,offset rglLight

		; Find the normal for point at the object surface
		call	RayGetNormal	C,[obj],[inters],offset rglNormal

		; Find the diffuse light
		call	VectorDot	C,offset rglNormal,offset rglLight
		mov	[diffuse],eax
		fld	[diffuse]
		fldz
		fcompp
		fstsw	ax
		sahf
		jbe	SHORT @@DiffuseNotSmall
		fldz
		fstp	[diffuse]
@@DiffuseNotSmall:

		mov	si,[obj]
		lea	di,[si+Object.DiffuseColor]
		call	VectorScale	C,di,[diffuse],[lightColor]
		; Trengs denne? (Ikke n lenger, med clamping av [diffuse]
		;call	VectorClamp	C,[lightColor],[lightColor]

		; Find the specular light
		;call	VectorGetReflection	C,offset rglNormal,offset rglLight,offset rglReflection
		call	VectorGetReflection	C,offset rglLight,offset rglNormal,offset rglReflection
		test	ax,ax
		jz	SHORT @@NoSpecular
		call	VectorDot		C,offset rglReflection,offset rglViewer

		mov	[rv_dot],eax
		fld	[rv_dot]		; Check if R*V is negative
		fldz				; ftst is enough, i think..
		fcompp
		fstsw	ax
		sahf
		jbe	SHORT @@SpecularNotNegative
; Maybe this should just skip the rest of the specular color calculations?
		fldz				; Use zero as the dot product
		fstp	[rv_dot]
@@SpecularNotNegative:
		fld	[si+Object.Shininess]	; Check if shininess is zero
		ftst
		fstsw	ax
		sahf
		jnz	SHORT @@ShininessNotZero

		fstp	st(0)			; It's zero, so the specular factor
		fld1				; is 1
		fstp	[specular]
		jmp	SHORT @@SpecularGo

@@ShininessNotZero:
		fld	[FLOAT_100_0]		; Blow up shininess
		fmulp
		fstp	[tempshininess]
		call	XtoY	C,[rv_dot],[tempshininess]
		mov	[specular],eax
@@SpecularGo:
		lea	di,[si+Object.SpecularColor]
		call	VectorScale	C,di,[specular],offset rglTempVector1
		call	VectorAdd	C,offset rglTempVector1,[lightColor],[lightColor]
@@NoSpecular:
		lea	di,[si+Object.AmbientColor]
		call	VectorAdd	C,di,[lightColor],[lightColor]
		call	VectorClamp	C,[lightColor],[lightColor]
@@Exit:
		ret
EndP		RayGetLight

;******************************************************************************
;*
;* int RayGetIntersection(Vector *p0,Vector *p1,Object *obj,Vector *inters)
;*
;* Purpose:
;*	Checks if the ray defined by p0 and p0 intersects with the object
;*
;* Arguments:
;*	p0 - near pointer to eye position
;*	p1 - near pointer to point on projectingplane
;*	object - near pointer to a object
;*	inters - near pointer to hold intersection coordinates, if any
;*
;* Returns:
;*	Returns true(1) if there was an intersection, false(1) if not
;*
;* 	See page 702/703 in Computer Graphics:Principles and Practice
;*
;******************************************************************************
Public		RayGetIntersection
Proc		RayGetIntersection	uses	si di
		arg	p0:ptr Vector,p1:ptr Vector,obj:ptr Object,inters:ptr Vector
		local	temp1:dword

		; Do common stuff

		; Find p1-p0 and normalize it
		call	VectorSub	C,[p1],[p0],offset rgiDelta
		call	VectorNormalize	C,offset rgiDelta,offset rgiDelta

		; rgip0_2 = p0 eller rgip0_2 = p1 - rgiDelta
		call	VectorCopy	C,[p0],offset rgip0_2

		; Now check which type of object we got
		mov	si,[obj]				; Check if we got a SPHERE
		cmp	[si+Object.Class],OBJECT_SPHERE
		jne	@@NoSphere

		; Calulcate a temp vector which is used several times
		mov	si,[obj]
		lea	si,[si+Object.Position]		; Get offset to position-vector
		call	VectorSub	C,offset rgip0_2,si,offset rgiTempVector1

		; Calculate coefficients
		; a
		call	VectorDot	C,offset rgiDelta,offset rgiDelta
		mov	[rgiCoeffa],eax

		; b
		call	VectorDot	C,offset rgiDelta,offset rgiTempVector1
		; Multiply by 2
		mov	[temp1],eax
		fld	[temp1]
		fld	st(0)
		fadd			; temp1+temp1 (2.0*temp1)
		fstp	[rgiCoeffb]

		; c
		call	VectorDot	C,offset rgiTempVector1,offset rgiTempVector1
		mov	[temp1],eax
		mov	si,[obj]
		lea	si,[si+Object.radius]
		fld	[dword si]
		fld	st(0)
		fmul
		fld	[temp1]
		fsubr
		fstp	[rgiCoeffc]

		; Solve the equation
		call	SolveQuadratic	C,offset rgiCoeff,offset rgiSols
		cmp	ax,2
		jb	SHORT @@NoIntersection

		; Find the correct intersection
		call	RayGetCorrectT	C,offset rgiSols
		cmp	ax,-1
		; No valid intersection points
		je	SHORT @@NoIntersection

		cwde
		; Find the intersection point
		call	VectorScale	C,offset rgiDelta,[dword rgiSols+eax*4],offset rgiTempVector1
		; Add the delta*t and p02 and put it in the intersection-vector!
		call	VectorAdd	C,offset rgiTempVector1,offset rgip0_2, [inters]
		mov	ax,1
		jmp	SHORT @@Exit
@@NoIntersection:
		xor	ax,ax
		jmp	SHORT @@Exit
@@NoSphere:
		cmp	[si+Object.Class],OBJECT_GROUND
		jne	SHORT @@NoGround

		; This is a ground object, find t

		lea	di,[si+Object.Position]
		fld	[di+Vector.Y]		; position.y
		fld	[rgip0_2.Y]		; p0.y
		fsubp				; position.y - p0.y
		fld	[rgiDelta.Y]		; delta.y
		fdivp				; divide
		fldz				; Is it above zero
		fcomp
		fstsw	ax
		sahf
		ja	SHORT @@NoGroundIntersection	; Nope, no intersection
		; Find the intersection point
		fstp	[temp1]			; t
		call	VectorScale	C,offset rgiDelta,[temp1],offset rgiTempVector1
		; Add the delta*t and p02 and put it in the intersection-vector!
		call	VectorAdd	C,offset rgiTempVector1,offset rgip0_2, [inters]
		mov	ax,1
		jmp	SHORT @@Exit
@@NoGroundIntersection:
		fstp	st(0)
		xor	ax,ax
		jmp	SHORT @@Exit
@@NoGround:

		xor	ax,ax		; No sphere or ground,return FALSE for now
@@Exit:
		ret

EndP		RayGetIntersection

;******************************************************************************
;*
;* int RayGetCorrectT(float *t)
;*
;* Purpose:
;*	Returns the index of the t to use, or -1 if none are valid
;*
;* Arguments:
;*	t - near pointer to array with two floats
;*
;* Returns:
;*	Correct index or -1
;*
;******************************************************************************
Public		RayGetCorrectT
Proc		RayGetCorrectT	uses si
		arg	ts:ptr dword
		; Check if the first point is >1
		mov	si,[ts]
		call	RayCheckIfTIsBelow0	C,[dword si]
		test	eax,eax
		jz	SHORT @@NotFirstPoint
		; It's ok, now check the second point
		call	RayCheckIfTIsBelow0	C,[dword si+4]
		test	eax,eax
		jz	SHORT @@ReturnFirst
		; Both points are valid, find the smallest
		fld	[dword si]
		fld	[dword si+4]
		fcompp
		fstsw	ax
		sahf
		jnb	SHORT @@ReturnFirst
@@ReturnSecond:
		mov	eax,1
		jmp	SHORT @@Exit
@@ReturnFirst:
		xor	eax,eax
		jmp	SHORT @@Exit
@@NotFirstPoint:
		; Check if the second point is >1
		call	RayCheckIfTIsBelow0	C,[dword si+4]
		test	eax,eax
		; Yes it is, no need to do more
		jnz	SHORT @@ReturnSecond
		mov	eax,-1
@@Exit:
		ret
Endp		RayGetCorrectT

Proc		RayCheckIfTIsBelow0
		arg	t:dword
		fldz
		fld	[t]
		fcompp
		fstsw	ax
		sahf
		jbe	SHORT @@InvalidPoint
		mov	eax,1
		jmp	SHORT @@Exit
@@InvalidPoint:
		xor	eax,eax
@@Exit:
		ret
Endp

;******************************************************************************
;*
;* void RayGetNormal(Object *obj,Vector *point,Vector *normal)
;*
;* Purpose:
;*	Finds the normal of a point on a object
;*
;* Arguments:
;*	obj - near ptr to an object
;*	point - near ptr to a vector (point on object surface)
;*	normal - near ptr to a vector to store the normal
;*
;* Returns:
;*	The surface normal in normal
;*
;******************************************************************************
Public		RayGetNormal
Proc		RayGetNormal	uses eax si
		arg	obj:ptr Object,point:ptr Vector,normal:ptr Vector

		mov	si,[obj]
		mov	eax,[si+Object.Class]
		cmp	eax,OBJECT_SPHERE
		jne	SHORT @@NoSphere
		lea	si,[si+Object.Position]
		call	VectorSub	C,[point],si,[normal]
		; Hadde det ikke vrt en id  dividere hvert element med radiusen?
		call	VectorNormalize	C,[normal],[normal]
		jmp	SHORT @@Exit
@@NoSphere:
		cmp	eax,OBJECT_GROUND
		jne	SHORT @@NoGround
; It's a ground object... return (0,-1,0)
		mov	si,[normal]
		fldz
		fstp	[si+Vector.X]
		fld1
		fchs
		fstp	[si+Vector.Y]
		fldz
		fstp	[si+Vector.Z]
@@NoGround:
@@Exit:
		ret
Endp		RayGetNormal


		DataSeg
		Align	4

; Local variables for RayGetPoint
rgpCurInters	Vector < >
rgpIntersTemp	Vector < >

; Local variables for RayCheckShadow
rcsTempVector1	Vector < >
rcsCurInters	Vector < >

; Local variables for RayGetColor

rgcIntersTable	Vector < >
	REPT MAX_ITERATIONS
		Vector < >
	ENDM

rgcLightColorTable Vector < >
	REPT MAX_ITERATIONS
		Vector < >
	ENDM

rgcViewerTable	Vector < >
	REPT MAX_ITERATIONS
		Vector < >
	ENDM

rgcNormalTable	Vector < >
	REPT MAX_ITERATIONS
		Vector < >
	ENDM

rgcReflectionTable Vector < >
	REPT MAX_ITERATIONS
		Vector < >
	ENDM

rgcReflectionColorTable Vector < >
	REPT MAX_ITERATIONS
		Vector < >
	ENDM

rgcEyeTable	Vector < >
	REPT MAX_ITERATIONS
		Vector < >
	ENDM

rgcTextureTable	Vector < >
	REPT MAX_ITERATIONS
		Vector < >
	ENDM

;rgcInters	Vector < >
;rgcLightColor	Vector < >

; Local variables for RayGetLight
rglViewer	Vector < >
rglLight	Vector < >
rglNormal	Vector < >
rglReflection	Vector < >
rglTempVector1	Vector < >

; Local variables for RayGetIntersection
rgip0_2		Vector < >		; new p0?
rgiDelta     	Vector < >		; p1-p0
rgiTempVector1	Vector < >

label rgiCoeff
rgiCoeffa	dd	0
rgiCoeffb	dd	0
rgiCoeffc	dd	0
rgiSols		dd	2 dup(0)	; Solutions

TestVector	Vector	< 0.0, 0.0, 0.0 >
		end

