;#############################################################################
;#
;# vector.asm
;#
;# Purpose:
;#	Vector functions
;#
;#############################################################################
		.386
		.387
		Ideal
		Jumps
		Model	Tiny,C
		Include	'vector2.inc'
		Include 'genmath.inc'
		CodeSeg

;******************************************************************************
;*
;* void VectorNormalize(Vector *A,Vector *O)
;*
;* Purpose:
;*	Normalizes a vector
;*
;* Arguments:
;*	A - near pointer to a vector
;*	O - near pointer to a vector to put result in (can be the same as A)
;*
;* Returns:
;*	Normalized vector in O
;*
;******************************************************************************
Public		VectorNormalize
Proc		VectorNormalize uses ax si di cx
		arg	V:ptr Vector,O:ptr Vector
		local	T:dword

		mov	si,[V]
		call	VectorLength	C,si
		mov	[T],eax
		fld	[T]
		ftst				; Check if it is a null-vector
		fstsw	ax
		sahf
		jz	SHORT @@NullVector

		mov	di,[O]
		mov	cx,3
@@Loop1:
		fld	[dword si]
		fdiv	st(0),st(1)
		fstp	[dword di]
		add	si,4
		add	di,4
		loop	@@Loop1

;		fld	[si+Vector.X]
;		fdiv    st(0),st(1)
;		fstp    [di+Vector.X]

;		fld	[si+Vector.Y]
;		fdiv    st(0),st(1)
;		fstp    [di+Vector.Y]

;		fld	[si+Vector.Z]
;		fdiv    st(0),st(1)
;		fstp    [di+Vector.Z]
		jmp	SHORT @@Exit
@@NullVector:
@@Exit:
		fstp	st(0)
		ret
EndP		VectorNormalize

;******************************************************************************
;*
;* float VectorLength(Vector *A)
;*
;* Purpose:
;*	Finds the length of a vector
;*
;* Arguments:
;*	A - near pointer to a vector
;*
;* Returns:
;*	Vector length in eax
;*
;******************************************************************************
Public		VectorLength
Proc		VectorLength	uses	si
		arg	A:ptr Vector
		local	T:dword

		call	VectorDot	C,[A],[A],offset vlTemp1
		mov	[T],eax
		fld	[T]
		fsqrt
		fstp	[T]
		mov	eax,[T]

		;mov	si,[A]
		;fld	[si+Vector.X]
		;fld	st(0)
		;fmul				;X*X

		;fld	[si+Vector.Y]
		;fld	st(0)
		;fmul				;Y*Y

		;fadd				;X*X+Y*Y
		;fld	[si+Vector.Z]
		;fld	st(0)
		;fmul				;Z*Z
		;fadd				;X*X+Y*Y+Z*Z
		;fsqrt				;sqrt(X*X+Y*Y+Z*Z)

		;fstp	[T]
		;mov	eax,[T]
		ret
Endp		VectorLength


;******************************************************************************
;*
;* float VectorDot(Vector *A,Vector *B)
;*
;* Purpose:
;*	Finds the dot-product for two vectors
;*
;* Arguments:
;*	A - near pointer to a vector
;*	B - near pointer to a vector
;*
;* Returns:
;*	Dot-product in eax
;*
;******************************************************************************
Public		VectorDot
Proc		VectorDot	uses	si di
		arg	A:ptr Vector,B:ptr Vector
		local	T:dword

		mov	si,[A]
		mov	di,[B]

		fld	[si+Vector.X]
		fld	[di+Vector.X]
		fmul
		fld	[si+Vector.Y]
		fld	[di+Vector.Y]
		fmul
		fadd
		fld	[si+Vector.Z]
		fld	[di+Vector.Z]
		fmul
		fadd
		fstp	[T]
		mov	eax,[T]
		ret
Endp		VectorDot

;******************************************************************************
;*
;* void VectorAdd(Vector *A,Vector *B,Vector *O)
;*
;* Purpose:
;*	Adds two vectors
;*
;* Arguments:
;*	A - near pointer to a vector
;*	B - near pointer to a vector
;*	O - near pointer to a vector to put result in
;*	    (can be the same as A or B)
;*
;* Returns:
;*	Sum in O
;*
;******************************************************************************
Public		VectorAdd
Proc		VectorAdd	uses	si di bx
		arg	A:ptr Vector,B:ptr Vector,O:ptr Vector

		mov	si,[A]
		mov	di,[B]
		mov	bx,[O]

		fld	[si+Vector.X]
		fld	[di+Vector.X]
		fadd
		fstp	[bx+Vector.X]

		fld	[si+Vector.Y]
		fld	[di+Vector.Y]
		fadd
		fstp	[bx+Vector.Y]

		fld	[si+Vector.Z]
		fld	[di+Vector.Z]
		fadd
		fstp	[bx+Vector.Z]
		ret
EndP		VectorAdd

;******************************************************************************
;*
;* void VectorSub(Vector *A,Vector *B,Vector *O)
;*
;* Purpose:
;*	Subtracts two vectors
;*
;* Arguments:
;*	A - near pointer to a vector
;*	B - near pointer to a vector
;*	O - near pointer to a vector to put result in
;*	    (can be the same as A or B)
;*
;* Returns:
;*	Difference in O
;*
;******************************************************************************
Public		VectorSub
Proc		VectorSub	uses	si di bx
		arg	A:ptr Vector,B:ptr Vector,O:ptr Vector

		mov	si,[A]
		mov	di,[B]
		mov	bx,[O]

		fld	[si+Vector.X]
		fld	[di+Vector.X]
		fsub
		fstp	[bx+Vector.X]

		fld	[si+Vector.Y]
		fld	[di+Vector.Y]
		fsub
		fstp	[bx+Vector.Y]

		fld	[si+Vector.Z]
		fld	[di+Vector.Z]
		fsub
		fstp	[bx+Vector.Z]
		ret
EndP		VectorSub

;******************************************************************************
;*
;* void VectorCopy(Vector *A,Vector *O)
;*
;* Purpose:
;*	Duplicates a vector
;*
;* Arguments:
;*	A - near pointer to vector do duplicate
;*	O - near pointer to copy to
;*
;* Returns:
;*	Copy of A in O
;*
;******************************************************************************
Public		VectorCopy
Proc		VectorCopy	uses si di es cx
		arg	A:ptr Vector,O:ptr Vector
		mov	si,[A]
		mov	di,[B]
		push	ds
		pop	es
		mov	cx,(size Vector)/4
		rep movsd
		ret
Endp		VectorCopy

;******************************************************************************
;*
;* void VectorScale(Vector *A,float s,Vector *O)
;*
;* Purpose:
;*	Scales a vector
;*
;* Arguments:
;*	A - near pointer to a vector
;*	s - scale-factor
;*	O - near pointer to a vector to put result in
;*
;* Returns:
;*	A*s in O
;*
;******************************************************************************
Public		VectorScale
Proc		VectorScale	uses si di
		arg	A:ptr Vector,s:dword,O:ptr Vector
		mov	si,[A]
		mov	di,[O]

		fld	[s]			; Load s
		fld	st(0)			; Duplicate it
		fld	st(0)			; twice
		fld	[si+Vector.X]		; Load X
		fmul				; X*s
		fstp	[di+Vector.X]

		fld	[si+Vector.Y]		; Load Y
		fmul				; Y*s
		fstp	[di+Vector.Y]		; Save

		fld	[si+Vector.Z]		; Load Z
		fmul				; Z*s
		fstp	[di+Vector.Z]		; Save
		ret
Endp		VectorScale

Public		VectorClamp
Proc		VectorClamp	uses si di cx
		arg	A:ptr Vector,O:ptr Vector
		mov	si,[A]
		mov	di,[O]
		mov	cx,3

; M optimaliseres! (loader et koordinat flere ganger)
@@Loop1:
		fld	[dword si]		;	 Is it smaller than 0?
		fldz
		fcompp
		fstsw	ax
		sahf
		jbe	SHORT @@NotSmall
		fldz
		fstp	[dword di]
		jmp	SHORT @@Done
@@NotSmall:
		fld	[dword si]		; Is it bigger than 1?
		fld1
		fcompp
		fstsw	ax
		sahf
		jae	SHORT @@Done
		fld1
		fstp	[dword di]
@@Done:
		add	si,4
		add	di,4
		loop	@@Loop1

		ret
EndP		VectorClamp

Public		VectorGetReflection
Proc		VectorGetReflection
		arg	I:ptr Vector,N:ptr Vector,R:ptr Vector
		local	temp1:dword

		call	VectorDot	C,[N],[I]

		mov	[temp1],eax
		fld	[temp1]
		ftst
		fstsw	ax
		sahf
		jb	SHORT @@NoReflection
		fld	[FLOAT_2_0]
		fmulp
		fstp	[temp1]
		call	VectorScale	C,[N],[temp1],[R]
		call	VectorSub	C,[R],[I],[R]
		call	VectorNormalize	C,[R],[R]
		mov	ax,1
		jmp	SHORT @@Exit
@@NoReflection:
		fstp	st(0)
		xor	ax,ax
@@Exit:
		ret
EndP		VectorGetReflection

; NEVER USED!

;Public		VectorGetAngle
;Proc		VectorGetAngle
;		arg	A:ptr Vector,B:ptr Vector
;		local	dot:dword
;
;		call	VectorNormalize	C,[A],offset vgaTemp1
;		call	VectorNormalize	C,[B],offset vgaTemp2
;		call	VectorDot	C,offset vgaTemp1,offset vgaTemp2
;		call	ACos		C,eax
;		; Check if it should change sign
;
;		ret
;EndP		VectorGetAngle

		DataSeg
		Align 2

vlTemp1		Vector	< >
vgaTemp1	Vector	< >
vgaTemp2	Vector	< >




		end
