/**************************************************************************
 *                                                                        *
 *              video.h (uninteresting graphical stuff)                   *
 *                                                                        *
 * Skal/Bomb!                                                             *
 * skal@planet-d.net                                                      *
 **************************************************************************/

///////////////////////////////////////////////////////////////////////////
//                              X11 part                                 //
///////////////////////////////////////////////////////////////////////////

#if defined( X11 )

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#include <netdb.h>
#include <unistd.h>

//extern char *shmat( int, char *, int );
//extern int   shmdt( char * );
#if defined(sgi)
#define XShmGetEventBase(A) 0
#else
extern int XShmGetEventBase(Display*);
#endif

static XEvent         Event;
static Display       *display = 0;
static int            screen;
static int            depth;
static XImage        *XImg = 0;
static Colormap       Cmap;
static Window         Win = (Window)0;
static XGCValues      Values;
static GC             gc;
static XSetWindowAttributes W_Attribs;
static int            X11_Key = 0;

   /* Shared memory */

static int Shm_Ok;
static XShmSegmentInfo ShmInfo;
static int       Completion_Type;

static BYTE *Allocate_XImage();
static BYTE *Allocate_Shm_XImage();

#define MASKS     StructureNotifyMask| ExposureMask      \
                | KeyReleaseMask | KeyPressMask          \
                | ButtonPressMask | ButtonReleaseMask    \
                | ButtonMotionMask | PointerMotionMask

unsigned long X11_Pixels[256];

static BYTE *Allocate_XImage( )
{
   Vid_Mem = (BYTE*)malloc(Width*Height);
   if (Vid_Mem==0) return 0;
   XImg = XCreateImage(
         display,
         DefaultVisual( display, screen ),
         8, ZPixmap, 0,
         (char*)Vid_Mem,
         Width, Height,
         32, 0 );
   if (XImg==0)
   {
      free(Vid_Mem);
      return 0;
   }
   return Vid_Mem;
}

static BYTE *Allocate_Shm_XImage( )
{
   XImg = 0;
   ShmInfo.shmid = shmget(
         IPC_PRIVATE,
         Width*Height,
         IPC_CREAT | 0x1ff );
   if ( ShmInfo.shmid < 0 )
   {
      fprintf( stderr, "Error with shared memory ID..." );
      return 0;
   }

   ShmInfo.shmaddr = (char*)shmat(ShmInfo.shmid, 0, 0);
   if ( ShmInfo.shmaddr == ( void *)(-1) )
   {
      fprintf( stderr, "Error with shared memory segment allocation..." );
      return 0;
   }

   Vid_Mem = (BYTE*)(ShmInfo.shmaddr);
   XImg = XShmCreateImage(
         display,
         DefaultVisual( display, screen ),
         8, ZPixmap, (char *)Vid_Mem,
         &(ShmInfo), Width, Height );

   if (XImg==0) goto Failed;

   if ( XImg->xoffset != 0 )
   {
      fprintf( stderr, "Error with XImage xoffset..." );
      goto Failed;
   }

   ShmInfo.readOnly = 0;
   if ( !XShmAttach( display, &(ShmInfo) ) )
   {
      fprintf( stderr, "Error with XShmAttach..." );
      goto Failed;
   }
   return Vid_Mem;

Failed:
   if (XImg) XDestroyImage( XImg );
   if (Vid_Mem) {
     shmdt( ShmInfo.shmaddr );
     shmctl( ShmInfo.shmid, IPC_RMID, 0 );
   }
   XImg = 0;
   Vid_Mem = 0;
   return 0;
}

int Video_On(int Nb_Colors)
{
   char *Name;
   char Me[ 256 ];
   XSizeHints Size_Hints;

   if ( display != 0 ) return 0;

   if ( gethostname( Me, 256 ) == -1 )
   {
      perror( "gethostname" );
      return 1;
   }

   Name = XDisplayName( 0 );

   display = XOpenDisplay( Name );
   if ( display == 0 )
   {
      fprintf( stderr, "Can't open X DISPLAY: '%s'.\n", Name );
      return 1;
   }

   Shm_Ok = 1;     /* A priori guess... */
   if (!XShmQueryExtension( display ))
   {
      fprintf( stderr, " Shared memory extension not available...\n" );
      Shm_Ok = 0;
   }
   else if ( Name[ 0 ] != ':' )
      if ( strncmp( Me, Name, strlen( Me ) ) != 0 )
      {
         fprintf( stderr, " Can't use shared memory when DISPLAY is redirected...\n" );
         Shm_Ok = 0;
      }
   
   screen  = DefaultScreen( display );
   depth   = XDisplayCells( display, screen );
   if ( depth != 256 )
   {
      fprintf( stderr, "Not a 256 colors display ! Sorry...\n" );
      return 1;
   }

   Win   = XCreateSimpleWindow(
            display, RootWindow( display, screen ),
            0, 0, Width, Height,
            0, 0, 0 );

   gc   = XCreateGC( display, Win, 0, &( Values ) );

   {     /* No resize */

      Size_Hints.width  = Width;
      Size_Hints.height = Height;
      Size_Hints.min_width = Size_Hints.width;
      Size_Hints.max_width = Size_Hints.width;
      Size_Hints.min_height = Size_Hints.height;
      Size_Hints.max_height = Size_Hints.height;
      Size_Hints.flags = PSize | PMinSize | PMaxSize;
      XSetWMNormalHints ( display, Win, &Size_Hints );
   }  
   
   W_Attribs.backing_store = Always;
   XChangeWindowAttributes( display, Win,
      CWBackingStore, &( W_Attribs ) );


      /* Colors */

         /* Try with default CMap */

   Cmap = DefaultColormap( display, screen );
   if ( !XAllocColorCells( display, Cmap, 1, 0, 0, 
                           X11_Pixels, Nb_Colors ) )
   {
         /* It failed -> Private CMap */

      Cmap = XCreateColormap( display, 
                              RootWindow( display, screen ),
                              DefaultVisual( display, screen ),
                              AllocNone );
      XAllocColorCells( display, Cmap, 1, 0, 0, 
                                 X11_Pixels, Nb_Colors );
   }

   XSetWindowColormap( display, Win, Cmap );

   XStoreName( display, Win, "Bilinear" );

   XSelectInput( display, Win, MASKS );

   XMapWindow( display, Win );
   XFlush( display );


      /* Main bitmap setup */

   if (Shm_Ok)      /* Try to allocate segment */
      if (Allocate_Shm_XImage()!=0) {
        Shm_Ok = 1;
      Completion_Type = XShmGetEventBase( display ) + ShmCompletion;
   }
   if (!Shm_Ok)
      if (Allocate_XImage()!=0)
         return 1; /* Usual fashion... */
    
   Stride = XImg->bytes_per_line;
   return 0;
}

void Video_Lock() {}
void Video_Unlock()
{
   if (Shm_Ok)
   {
      XShmPutImage(display, Win, gc, XImg,
                   0, 0, 0, 0, Width, Height, 1 );

      while(XNextEvent(display, &Event))
      {
#if !defined(sgi)
         if (Event.type == Completion_Type) break;
#endif
         if (Event.type == KeyPress)
           X11_Key = XLookupKeysym(&Event.xkey,0);
      }
   }
   else XPutImage(display, Win, gc, XImg, 
                  0, 0, 0, 0, Width, Height );
}

void Video_Off( )
{
   if ( display != 0 )
   {
      while(XPending(display)>0) XNextEvent( display, &Event );
      if (XImg!=0)
      {
         if (Shm_Ok)
         {
            if (XImg) {
              XShmDetach(display, &ShmInfo);
              XDestroyImage( XImg );
            }
            shmdt( ShmInfo.shmaddr );
            shmctl( ShmInfo.shmid, IPC_RMID, 0 );
         }
         else XDestroyImage( XImg );
      }
      if ( Win != (Window)0 )
      {
         XUnmapWindow( display, Win );
         XDestroyWindow( display, Win );
         if (Cmap!=DefaultColormap( display, screen ))
           XFreeColormap( display, Cmap );
         XFreeGC( display, gc );
      }
      XImg = 0;
      Win = (Window)0;
      XCloseDisplay( display );
   }
   display = 0;
}

void Video_Store_Colors(int Nb, BYTE *Colors)
{
   static XColor colors[ 256 ];
   int i;
   for( i=0; i<Nb; ++i )
   {
      colors[i].red   = (unsigned short)(*Colors++)<<8;
      colors[i].green = (unsigned short)(*Colors++)<<8;
      colors[i].blue  = (unsigned short)(*Colors++)<<8;
      colors[i].pixel = X11_Pixels[i];
      colors[i].flags = DoRed | DoGreen | DoBlue;
   }
   XStoreColors( display, Cmap, colors, Nb );
}

int Get_Key() {
  if (X11_Key) return X11_Key;
  if (XPending(display)==0) return 0;
  XNextEvent(display,&Event);
  if (Event.type == KeyPress)
    X11_Key = XLookupKeysym(&Event.xkey,0);
  return X11_Key;
}

///////////////////////////////////////////////////////////////////////////
//                          SVGALIB part                                 //
///////////////////////////////////////////////////////////////////////////

#elif defined(SVGALIB)

#include <unistd.h>
#include <vga.h>
#include <vgagl.h>

void Video_Store_Colors(int Nb, BYTE *Colors)
{
   Palette Pal;
   int i;
   for(i=0; i<Nb; i++)
   {
      Pal.color[i].red   = (*Colors++)>>2;
      Pal.color[i].green = (*Colors++)>>2;
      Pal.color[i].blue  = (*Colors++)>>2;
   } 
   gl_setpalette( &Pal );
}

int Video_On(int Nb_Colors)
{
   if (geteuid()) {
      printf( "Not suid root.\n" );
      return 1;
   }
                     
   setuid( geteuid() );
   if (!vga_hasmode(G320x200x256)) return 1;
   vga_disabledriverreport();
   if (vga_init()) return 1;
//   vga_setmousesupport(1);

   vga_setmode(G320x200x256);
   vga_setpage( 0 );

   Vid_Mem = vga_getgraphmem( );
   Stride = 320;
   setuid( getuid( ) );
   return 0;
}

void Video_Off() { vga_setmode( TEXT ); }
void Video_Lock() {}
void Video_Unlock() { 
  //vga_waitretrace(); 
}
int Get_Key() { return vga_getkey( ); }

///////////////////////////////////////////////////////////////////////////
//                           DOS part                                    //
///////////////////////////////////////////////////////////////////////////

#elif defined(DOS)

#if defined( __DJGPP__ )

#include <dpmi.h>
#include <go32.h>
#include <sys/nearptr.h>
#define VIDEO (BYTE*)( ((0xa000)<<4) + __djgpp_conventional_base)

#elif defined( __WATCOMC__ )

#include <i86.h>

#define outportb  outp
#define VIDEO (BYTE*)(0xa000<<4)

      // DPMI registers       <=>  <dpmi.h>
typedef union {
#pragma pack(1)
  struct { unsigned long edi, esi, ebp, res, ebx, edx, ecx, eax; } d;
  struct {
    unsigned short di, di_hi, si, si_hi, bp, bp_hi, res, res_hi;
    unsigned short bx, bx_hi, dx, dx_hi, cx, cx_hi, ax, ax_hi;
    unsigned short flags, es, ds, fs, gs, ip, cs, sp, ss;
  } x;
  struct {
    unsigned char edi[4], esi[4], ebp[4], res[4];
    unsigned char bl, bh, ebx_b2, ebx_b3, dl, dh, edx_b2, edx_b3;
    unsigned char cl, ch, ecx_b2, ecx_b3, al, ah, eax_b2, eax_b3;
  } h;
#pragma pack()
} __dpmi_regs;

   // simulate djgpp's one.
static int __dpmi_int( char no, __dpmi_regs *in )
{
   union REGS r;
   r.w.ax       = 0x300;
   r.h.bl       = no;
   r.h.bh       = 0;
   r.w.cx       = 0;
   r.x.edi      = FP_OFF( in );
   int386( 0x31, &r, &r );   
   return( r.w.cflag );                        
}

#endif		/* __WATCOMC__ */

int Video_On(int Nb_Colors)
{
   __dpmi_regs r;
   int i, j;

#if defined(__DJGPP__)
   __djgpp_nearptr_enable( );
#endif

   memset( &r, 0, sizeof(r) );
   r.x.ax = 0x13;
   __dpmi_int( 0x10, &r );

   Vid_Mem = VIDEO;
   Stride = 320;
   return 0;
}

void Video_Store_Colors(int Nb, BYTE *Colors)
{
   int i;
   outportb( 0x3c8, 0);
   for (i=0; i<Nb; i++)
   {
      outportb( 0x3c9, (*Colors++)>>2 );
      outportb( 0x3c9, (*Colors++)>>2 );
      outportb( 0x3c9, (*Colors++)>>2 );
   }
}

void Video_Off( )
{
   __dpmi_regs r;

   memset( &r, 0, sizeof(r) );
   r.x.ax = 0x03;
   __dpmi_int( 0x10, &r );
}

int Get_Key( )
{
   if ( kbhit( ) ) return( getch( ) );
   else return 0;
}

void Video_Lock( )
{
#if defined(__DJGPP__)
   __djgpp_nearptr_enable( );
#endif
   Vid_Mem = VIDEO;
   Stride = 320;
}

void Video_Unlock() {
#if defined(__DJGPP__)
   __djgpp_nearptr_disable( );
#endif
}

///////////////////////////////////////////////////////////////////////////

#endif
