
		.data?
;buffer for the structure describing the blit
		BlitDescription	DDBLTFX <>

		.data
		BlitFlags dd DDBLT_WAIT + DDBLT_DDFX + DDBLT_ASYNC + DDBLT_KEYSRCOVERRIDE

		.code

MainDrawingProcedure:
; Here we draw all effects on virtual screen by our GFX routines
		call _MAIN



;a simple flag protects us from using unitialized data

		cmp [DDrawIsInitialized],0
		je NoBlit


		pushad


		DoTheBlit:


;write to offscreen surface 
;1.lock the offscreen surface so that we can write to it

		mov [SurfaceDescription.dwsurfFlags], DDSD_LPSURFACE + DDSD_PIXELFORMAT 
		mov [SurfaceDescription.ddpfPixelFormat+4], DDPF_RGB 

		xor  eax,eax
		push eax
		push DDLOCK_WAIT
		push offset SurfaceDescription
		push eax
		DXfunction_ OurOffscreenSurface,DDSLOCK
		or eax,eax
		jnz nosurflock

;obtain a pointer to display memory
		mov edi, [SurfaceDescription.lpSurface]

; Here we copy our GFX from virtual screen to ofscreen surface
		include draw.inc

		AllDrawn:

		nolock:

;unlock surface
		xor  eax,eax
		push eax
		DXfunction_ OurOffscreenSurface,DDSUNLOCK
		
		nosurflock:

;set some blitting flags for the Offscreen to Primary blit
		mov [BlitDescription.dwSize], size DDBLTFX		
		mov [BlitDescription.dwDDFX], DDBLTFX_NOTEARING


		include  textout.inc

		mov [BlitDescription.ddckSrcColorkey+0], 0FFFFFFFFh
		mov [BlitDescription.ddckSrcColorkey+4], 0FFFFFFFFh



;do the blit
		push offset BlitDescription
		push [BlitFlags]
		xor  eax,eax
		push eax
		push [OurOffscreenSurface]
		push eax;[BlitRectPtr]
		DXfunction OurPrimarySurface, DDSBLT, "DDSBLT"

		 popad

NoBlit:

		 ret


		.CODE
Create_Surface:
;  EAX : first param
;  EDI : description
;  EBP : interface ptr

		push edi
		push edi
		DXfunction OurPrimarySurface, DDSGETCAPS, "DDSGETCAPS"
		pop edi

		mov dword ptr [edi+DDSURFACEDESC.dwSize], size DDSURFACEDESC
		mov dword ptr [edi+DDSURFACEDESC.dwsurfFlags], DDSD_HEIGHT OR DDSD_WIDTH OR DDSD_CAPS
		mov dword ptr [edi+DDSURFACEDESC.ddssurfCaps], DDSCAPS_OFFSCREENPLAIN  
		mov dword ptr [edi+DDSURFACEDESC.dwHeight],VERT_RAZR
		mov dword ptr [edi+DDSURFACEDESC.dwWidth],HOR_RAZR

		xor eax,eax
Create_Surface2:

		push eax
		push ebp
		push edi
		DXfunction OurDirectDrawInterface, DDCREATESURFACE, "DDCREATESURFACE"

		retn


Set_Vid_Mode_Err:
		lea eax,vidmoderrmsg
DX_errmsg:
                 push MB_ICONHAND + MB_OK
                 push offset MessageBoxTitle
                 push eax
                 push 0
                 call MessageBoxA
                 jmp Exit
