
;initialize all the other needed things

;init DirectDraw

include myddraw.def

		.code

	IFDEF masm
	 GetProcAddress equ GetProcAddress@8
	 LoadLibraryA equ LoadLibraryA@4
	ENDIF

		EXTRN LoadLibraryA:near
		EXTRN GetProcAddress:near

		push offset dllname
		call LoadLibraryA
;eax is now the hInstance of the dll (or zero if the function failed)

		push offset functionname
		push eax
		call GetProcAddress

;now we have the address of the DirectDrawCreate function in eax.
;lets start with creating a DirectDrawInterface

;create a DirectDraw interface
		xor  edx,edx
		push edx
		push offset OurDirectDrawInterface
		push edx
		call eax
		or eax,eax
		jnz WM_QUIT_received

;setting up DirectDraw:
;1. set the Cooperative Level. 
;This is done in the COM way of calling functions.

;and now the function call
		push DDSCL_FULLSCREEN or DDSCL_EXCLUSIVE
;set fullscreen and exclusive mode
		push [Windowhandle]
		DXfunction OurDirectDrawInterface, DDSETCOOPERATIVELEVEL , "DDSETCOOPERATIVELEVEL"


;Find videomode, supported by videosystem. 
;It can be 320x200x32bpp, 320x200x24bpp, 320x200x16bpp,

		.DATA
;so we have here a table of supported bpp's
		Vidmode_Depths_Tab  db  32,24,16

;Virtual screen's copy procedures offsets. Internally our gfx
;routines work in 32bpp, and we have to convert pixels when copy them
;to the offscreen surface, which have bpp, corresponding to current
;videomode's bpp, and our primary surface's bpp

		Blit_Proc_Tab    dd  offset Blit_32bpp
		  		 dd  offset Blit_24bpp
		  		 dd  offset Blit_16bpp

;shows which supported by intro videomode was set
                Vidmode_Num  dd  0

		.CODE

@@N_Ok:
                mov  eax,Vidmode_Num
		mov  al,Vidmode_Depths_Tab[eax]
		push eax
		push VERT_RAZR
		push HOR_RAZR
		DXfunction_ OurDirectDrawInterface, DDSETDISPLAYMODE
;Until we set videomode succesfuly
		or  eax,eax
		jz  @@Ok
;Or until we try all supported by intro videomodes, then error msg and exit
                cmp  Vidmode_Num,MAX_VIDMODE_NUM
                jz   Set_Vid_Mode_Err

                inc  Vidmode_Num
		jmp  @@N_Ok
@@Ok:


;2. create a primary surface and an offscreen surface

;set up the DDSURFACEDESC structure for telling DirectDraw that a 
;PrimarySurface is needed
		mov dword ptr SurfaceDescription.dwSize, size DDSURFACEDESC
		mov dword ptr SurfaceDescription.ddssurfCaps,DDSCAPS_PRIMARYSURFACE 

		xor  eax,eax
		lea  ebp,OurPrimarySurface
		lea  edi,SurfaceDescription
		call Create_Surface2

;create the offscreen surface according to the primary surface
		mov dword ptr SurfaceDescription.dwSize, size DDSURFACEDESC
		mov dword ptr SurfaceDescription.dwsurfFlags, DDSD_HEIGHT OR DDSD_WIDTH OR DDSD_CAPS OR DDSD_PIXELFORMAT

;change settings to our needs so that the offscreen surface fits our needs 
		lea edi,SurfaceDescription
		lea ebp,OurOffscreenSurface
		call Create_Surface


;Now we have 2 Surfaces. That is all we need here for drawing.

include Create3.inc

;set a flag that initialization has finished
		mov [DDrawIsInitialized],1
