; *** Hugi-compo #13 (Soko Ban) ***
; Name:         Guillermo Sais
; Country:      Mexico
; E-mail:       guillermo_sais@hotmail.com

Ideal
p486

SCREEN_END      = (10*2)+(21*80)
SCREEN_OFS      = ((((10000h-SCREEN_END)or 0fh)+1)shr 4)+1
SCREEN_SEG      = 0b800h-SCREEN_OFS
SCREEN_START    = SCREEN_OFS shl 4

NAME_POS        = SCREEN_START
COUNTER_POS     = SCREEN_START+(39*2)
LEVEL_POS       = SCREEN_START+(10*2)+(4*80)

LOOKUP_TBL      = 80h-20h
BUFFER_OFS      EQU ES

segment 	CodeSegment use16
assume          cs:CodeSegment,ds:CodeSegment,es:CodeSegment,ss:CodeSegment
org		100h
Start:
                db ?,77h                        ; 20h - floor
                db ?,33h                        ; 21h - dock
                db 20h,07h                      ; 22h - background
                db 0b0h,47h                     ; 23h - wall
                db 0feh,7eh                     ; 24h - box (floor)
                db 0feh,3eh                     ; 25h - box (dock)
                db 02h,79h                      ; 26h - sokoban (floor)
                db 02h,39h                      ; 27h - sokoban (dock)

org             100h
cmpsw
ja              short Init

org             110h
Init:
int             10h
mov             bl,5dh
push            SCREEN_SEG
pop             es
assume          es:SCREEN_SEG

SaveKey:
pop             si
jnp             short LoadFile
aad             28
jns             short SaveKey10
mov             dl,-22
SaveKey10:
jnp             short SaveKey20
neg             dx
SaveKey20:
push            si
push            dx

LoadFile:
mov             cx,6126h
cmp             [byte bx],cl
ja              short LoadFile10
xor             [byte bx],ch
LoadFile10:
xor             ax,ax
pusha
mov             ah,3dh
mov             dx,bx
int             21h
xchg            bx,ax
jc              short Quit
mov             ah,3fh
mov             dx,BUFFER_OFS
int             21h
int             10h
mov             ah,3eh
int             21h
std
jmp             short ApplyKeys30

NextLevel:
inc             [byte bx]
mov             al,7
int             29h
push            bp
inc             cx

ReadKey:
pop             sp
jcxz            short NextLevel
int             16h
aas
jnc             short SaveKey

Quit:
mov             al,3
int             10h
int             20h

ApplyKeys:
inc             ax
scasw
pusha
ApplyKeys10:
inc             si
cmp             [byte si],cl
jb              short ApplyKeys10
mov             bx,[word di]
lea             di,[si+bx]
cmp             [byte di],23h
jb              ApplyKeys20
jz              ApplyKeys30
test            [byte di+bx],cl
jp              ApplyKeys30
add             [byte di+bx],4
ApplyKeys20:
or              [byte di],cl
and             [byte si],ch

ApplyKeys30:
popa
mov             si,BUFFER_OFS
cmp             di,sp
jg              short ApplyKeys
push            di

PrintCounter:
mov             di,COUNTER_POS
mov             cx,10
PrintCounter10:
cwd
div             cx
xchg            dx,ax
or              ax,'0' or 0e00h
stosw
mov             ax,dx
dec             dx
jns             short PrintCounter10
rep
stosw

PrintName:
xlat
mov             ah,0ch
mov             [word es:NAME_POS],ax

DisplayLevel:
cld
mov             di,LEVEL_POS-(40-20)
DisplayLevel10:
sub             di,-(40-20)
jz              short ReadKey
DisplayLevel20:
lodsb
cbw
add             al,LOOKUP_TBL
jns             short DisplayLevel10
shl             ax,1
xchg            si,ax
movsw
xchg            si,ax
test            al,10
jnz             short DisplayLevel20
loop            short DisplayLevel20

ends            CodeSegment
end		Start
