// This is for hiding the windows code from me. Ignore this please =) it's horrible!

class glApp
{
	GLfloat zNearClip, zFarClip;
	bool changeRes;
   int xRes, yRes;
	HWND hWnd;
	HGLRC hRC;   
	HDC hDC;
public:
	glApp(int xRes, int yRes, GLfloat zNearClip, GLfloat zFarClip, bool changeRes);
	void initGL(), setGLOptions(), flip(), changeScreenRes(), close();
   bool makeWindow(HINSTANCE hInstance, char *className, char *appName), setupGLWindow(HWND hWnd), init(HWND hWnd);
} glApp(640, 480, 0.1f, 500.0f, 1);


LRESULT CALLBACK wndProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam);

glApp::glApp(int xRes, int yRes, GLfloat zNearClip, GLfloat zFarClip, bool changeRes)
{	
   hWnd = NULL;
	hDC = NULL;
	this->xRes = xRes;
	this->yRes = yRes;
	this->zNearClip = zNearClip;
	this->zFarClip = zFarClip;
   this->changeRes = changeRes;
   return;
}

void glApp::initGL()
{
	glViewport(0, 0, xRes, yRes);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();							
	gluPerspective(45.0f, (GLfloat) xRes / (GLfloat) yRes, zNearClip, zFarClip);	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	return;
}

void glApp::setGLOptions()	
{	
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);		
	glClearDepth(1.0);							
	glDepthFunc(GL_LESS);						
	glEnable(GL_DEPTH_TEST);					
	glShadeModel(GL_SMOOTH);
	return;
}

void glApp::flip()
{
   SwapBuffers(hDC);
   return;
}

void glApp::changeScreenRes()
{
	DEVMODE dmScreenSettings;											
	memset(&dmScreenSettings, 0, sizeof(DEVMODE));
	
   dmScreenSettings.dmSize			= sizeof(DEVMODE);
	dmScreenSettings.dmPelsWidth	= xRes;								
	dmScreenSettings.dmPelsHeight	= yRes;
	dmScreenSettings.dmFields		= DM_PELSWIDTH | DM_PELSHEIGHT;
	ChangeDisplaySettings(&dmScreenSettings, CDS_FULLSCREEN);  
   return;
}

void glApp::close()
{
   ChangeDisplaySettings(NULL, 0);
   wglMakeCurrent(hDC, NULL);
   wglDeleteContext(hRC);
   ReleaseDC(hWnd, hDC);
   return;
}

bool glApp::init(HWND hWnd)
{
   if(!setupGLWindow(hWnd)) return 0;
   if(changeRes) changeScreenRes();
	initGL();
   setGLOptions();
   glMatrixMode(GL_MODELVIEW);
	return 1;
}

bool glApp::setupGLWindow(HWND hWnd)
{
	PIXELFORMATDESCRIPTOR PFD;
	memset(&PFD, 0, sizeof(PFD));
	PFD.nSize = sizeof(PFD);
	PFD.nVersion = 1;
	PFD.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
	PFD.iPixelType = PFD_TYPE_RGBA;
	PFD.cColorBits = 16;
	PFD.cDepthBits = 16;
	PFD.dwLayerMask = PFD_MAIN_PLANE;   
	
	GLuint PixelFormat;
	if(!hWnd) return 0;
	hDC = GetDC(hWnd); 	
	if(!hDC) return 0;
	PixelFormat = ChoosePixelFormat(hDC, &PFD);
	if(!PixelFormat) return 0;
   if(!SetPixelFormat(hDC, PixelFormat, &PFD)) return 0;
   hRC = wglCreateContext(hDC); 
   if(!hRC) return 0;
   if(!wglMakeCurrent(hDC, hRC)) return 0;
	return 1;
}

bool glApp::makeWindow(HINSTANCE hInstance, char *className, char *appName)
{
	WNDCLASS wc;			
	wc.style			   = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc		= (WNDPROC) wndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;
	wc.hIcon		   	= NULL;
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= NULL;
	wc.lpszMenuName	= NULL;
	wc.lpszClassName	= className;

	if(!RegisterClass(&wc)) return 0;
	hWnd = CreateWindow(className, appName,	/*WS_OVERLAPPEDWINDOW*/WS_POPUP |  WS_CLIPCHILDREN | WS_CLIPSIBLINGS, 
                		0, 0, xRes, yRes, NULL, NULL, hInstance, NULL);
	if(!hWnd) return 0;
	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);
	SetFocus(hWnd);
	return 1;
}

LRESULT CALLBACK wndProc(HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
   switch(Message)		
   {
      case WM_CREATE:
         if(!glApp.init(hWnd)) 
         {
            MessageBox(MB_OK, "Window creation error.", "Error", MB_ICONSTOP);
            PostQuitMessage(0);
		   }
      break;
      case WM_KEYDOWN:
        case VK_ESCAPE:
        glApp.close();
        PostQuitMessage(0);
        break;
      break;
      case WM_DESTROY:
      case WM_CLOSE:
      case WM_QUIT:		
         glApp.close();
         PostQuitMessage(0);
      break;
	}
   return DefWindowProc(hWnd, Message, wParam, lParam);
}
