// Email me with questions/comments: nnash@stokes2.thphys.may.ie or nash@cfxweb.net 
// This is the important code for the tutorial, enjoy! 

//#include <iostream>
//#include <vector>
//#include <string>
#include "tables.h"

// Put the class defs in a header if you have the energy ;)
class Point3D
{
public:
	int x, y, z;
	Point3D(int x = 0, int y = 0, int z = 0) { this->x = x; this->y = y; this->z = z; return; }	
};

template <class surfType> class CalcMesh
{
	Point3D spaceSize, stepSize;
	surfType *surface;
	int getIndex(Point3D *p), nCells, totalCells;
	void triangulate(Point3D *s, int index);
	char *visited;	
public:
   Point3D *mesh;
   int nVerts, getCube(int x, int y, int z);
   CalcMesh(Point3D spaceSize, int nCells, surfType *surface, Point3D *mesh);
	void generate(int x, int y, int z), reset();	
	~CalcMesh();
};

template <class surfType> CalcMesh <surfType>::CalcMesh(Point3D spaceSize, int nCells, surfType *surface, Point3D *mesh)
{
	this->spaceSize.x = spaceSize.x / 2;
	this->spaceSize.y = spaceSize.y / 2;
	this->spaceSize.z = spaceSize.z / 2;
	this->stepSize.x = spaceSize.x / nCells;
	this->stepSize.y = spaceSize.y / nCells;	
	this->stepSize.z = spaceSize.z / nCells;	
	this->nCells = nCells;
	this->surface = surface;
	this->mesh = mesh;
   nVerts = 0;
   totalCells = nCells * nCells * nCells;
   visited = new char[totalCells];
	memset(visited, 0, totalCells * sizeof(char));
	return;
}

template <class surfType> void CalcMesh <surfType>::reset()
{
   memset(visited, 0, totalCells);
   nVerts = 0;
   return;
}

template <class surfType> int CalcMesh <surfType>::getIndex(Point3D *p)
{
  	int index = 0;
   for(int i = 0; i < 8; i++) if(surface->outside(p[i])) index |= (1 << i);
	return index;
}

template <class surfType> void CalcMesh <surfType>::triangulate(Point3D *s, int index)
{
	// See which combination of the 12 edges is intersected.
	// This code is dependent on the naming convention of the cube's sides&vertices used by edgeTab
   Point3D verts[12];	
   if(edgeTab[index] & 1) verts[0] = surface->getIntersection(s[0], s[1]);
   if(edgeTab[index] & 2) verts[1] = surface->getIntersection(s[1], s[2]);
   if(edgeTab[index] & 4) verts[2] = surface->getIntersection(s[2], s[3]);
   if(edgeTab[index] & 8) verts[3] = surface->getIntersection(s[3], s[0]);
   if(edgeTab[index] & 16) verts[4] = surface->getIntersection(s[4], s[5]);
   if(edgeTab[index] & 32) verts[5] = surface->getIntersection(s[5], s[6]);
   if(edgeTab[index] & 64) verts[6] = surface->getIntersection(s[6], s[7]);
   if(edgeTab[index] & 128) verts[7] = surface->getIntersection(s[7], s[4]);
   if(edgeTab[index] & 256) verts[8] = surface->getIntersection(s[0], s[4]);
   if(edgeTab[index] & 512) verts[9] = surface->getIntersection(s[1], s[5]);
   if(edgeTab[index] & 1024) verts[10] = surface->getIntersection(s[2], s[6]);
   if(edgeTab[index] & 2048) verts[11] = surface->getIntersection(s[3], s[7]);
   for(int i = 0; triTab[index][i] != -1; i += 3, nVerts += 3)  
   {
      mesh[nVerts] = verts[triTab[index][i + 2]];
      mesh[nVerts + 1] = verts[triTab[index][i + 1]];
      mesh[nVerts + 2] = verts[triTab[index][i]];
   }
	return;
}

template <class surfType> int CalcMesh <surfType>::getCube(int x, int y, int z)
{
   Point3D s[8];
   int ind = ((z + spaceSize.z) / stepSize.z) * nCells * nCells + ((y + spaceSize.y) / stepSize.y) * nCells + ((x + spaceSize.x) / stepSize.x);
   for(int i = x; i >= -spaceSize.x; i -= stepSize.x)
   {
      if(visited[ind]) break;
      ind--;
      s[0].x = i;              s[0].y = y + stepSize.y;  s[0].z = z;
      s[1].x = i + stepSize.x; s[1].y = y + stepSize.y;  s[1].z = z;	
      s[2].x = i + stepSize.x; s[2].y = y + stepSize.y;  s[2].z = z - stepSize.z;
      s[3].x = i;              s[3].y = y + stepSize.y;  s[3].z = z - stepSize.z;
      s[4].x = i;              s[4].y = y;               s[4].z = z;
      s[5].x = i + stepSize.x; s[5].y = y;               s[5].z = z;
	   s[6].x = i + stepSize.x; s[6].y = y;               s[6].z = z - stepSize.z;
	   s[7].x = i;              s[7].y = y;               s[7].z = z - stepSize.z;    
      if(getIndex(s)) break;
   }
   return i; 
}


template <class surfType> void CalcMesh <surfType>::generate(int x, int y, int z) // coordinates of top left-back of cube we are testing.
{
   if(x < -spaceSize.x || y < -spaceSize.y || z < -spaceSize.z || x >= spaceSize.x || y >= spaceSize.y || z >= spaceSize.z) return;
   int ind = ((z + spaceSize.z) / stepSize.z) * nCells * nCells + ((y + spaceSize.y) / stepSize.y) * nCells + ((x + spaceSize.x) / stepSize.x);
   if(visited[ind]) return;
   visited[ind] = 1;
   Point3D s[8];
   s[0].x = x;              s[0].y = y + stepSize.y;  s[0].z = z;
   s[1].x = x + stepSize.x; s[1].y = y + stepSize.y;  s[1].z = z;	
   s[2].x = x + stepSize.x; s[2].y = y + stepSize.y;  s[2].z = z - stepSize.z;
   s[3].x = x;              s[3].y = y + stepSize.y;  s[3].z = z - stepSize.z;
   s[4].x = x;              s[4].y = y;               s[4].z = z;
   s[5].x = x + stepSize.x; s[5].y = y;               s[5].z = z;
	s[6].x = x + stepSize.x; s[6].y = y;               s[6].z = z - stepSize.z;
	s[7].x = x;              s[7].y = y;               s[7].z = z - stepSize.z;
	int cubeInd = getIndex(s);
   if(!edgeTab[cubeInd]) return; // cube is totally inside/outside
   triangulate(s, cubeInd);
   generate(x - stepSize.x, y, z);
   generate(x + stepSize.x, y, z);
   generate(x, y - stepSize.y, z);
   generate(x, y + stepSize.y, z);
   generate(x, y, z - stepSize.z);
   generate(x, y, z + stepSize.z);
   return;
}

template <class surfType> CalcMesh <surfType>::~CalcMesh()
{
	delete [] visited;
	return;
}