	PAGE	240,132
; \DICEROLL.XPL	8-AUG-2001
; \3D animation of a rolling die
; \ by Boreal (aka: Loren Blaney)
; \
; \The XPL0 compiler used by this program is available at:
; \ http://www.idcomm.com/personal/lorenblaney
; \If you have any questions, feel free to write me at:
; \ loren_blaney@idcomm.com
; \
; \This program uses a right-hand coordinate system:
; \
; \			       |   Z  (into screen)
; \			       |  /
; \			       | /
; \			       |/
; \		       --------+-------- X
; \			      /|
; \			     / |
; \			    /  |
; \			       |
; \			       Y
; \
; 
; include	\cxpl\codesi;\CODESI.XPL	COMPLETE SET OF INTRINSICS
; 
; code	ABS=0,		RAN=1,		REM=2,		RESERVE=3,
; 	SWAP=4,		EXTEND=5,	RESTART=6,	CHIN=7,
; 	CHOUT=8,	CRLF=9,		INTIN=10,	INTOUT=11,
; 	TEXT=12,	OPENI=13,	OPENO=14,	CLOSE=15,
; 	ABORT=16,	TRAP=17,	FREE=18,	RERUN=19,
; 	GETHP=20,	SETHP=21,	GETERR=22,	CURSOR=23,
; 	FSET=24,	SETRUN=25,	HEXIN=26,	HEXOUT=27,
; 	CHAIN=28,	FOPEN=29,	WRITE=30,	READ=31,
; 	FCLOSE=32,	CHKKEY=33,	SOFTINT=34,	GETREG=35,
; 	BLIT=36,	PEEK=37,	POKE=38,	SOUND=39,
; 	CLEAR=40,	POINT=41,	LINE=42,	MOVE=43,
; 	READPIX=44,	SETVID=45	FIX=50,		POUT=64,
; 	PIN=65,		INTRET=66,	EXTJMP=67,	EXTCAL=68,
; 	ATTRIB=69,	SETWIND=70,	RAWTEXT=71,	HILIGHT=72,
; 	MALLOC=73,	RELEASE=74,	TRAPC=75,	TESTC=76,
; 	EQUIP=77,	SHRINK=78,	RANSEED=79,	IRQ=80;
; code real
; 	RLRES=46,	RLIN=47,	RLOUT=48,	FLOAT=49,
; 	RLABS=51,	FORMAT=52,
; 	SQRT=53,	LN=54,		EXP=55,		SIN=56,
; 	ATAN2=57,	MOD=58,		LOG=59,		COS=60,
; 	TAN=61,		ASIN=62,	ACOS=63;
; 	\run-time library routines (intrinsics)
; 
	INCLUDE	RUNTIME.ASM
CSEG	SEGMENT DWORD PUBLIC 'CODE'
	ASSUME CS:CSEG
PROGRM:
	ADD	DI,8
	MOV	AX,1
	PUSH	AX
	
	PUSH	AX
	INC	AX
	PUSH	CS
	CALL	NEAR PTR MKARRAY
; seg char Image(1);	\buffer for setting up copy of screen image

	MOV	AX,6
	PUSH	AX
	MOV	AL,1
	PUSH	AX
	INC	AX
	PUSH	CS
	CALL	NEAR PTR MKARRAY
; seg char Face(6);	\101x101 pixel image (texture map) of each face

; real	CorX, CorY, CorZ; \arrays: coordinates of cube's corners (vertexes)
; def	S = 54.0;	\half the length of an edge of the cube (pixels)
; def	IntSize = 2;	\number of bytes in an integer (2 => 16-bit XPL0)
; 
; 
; 
	JMP	L1

L2	LABEL	NEAR
; proc	Erase(Im);	\Erase Image buffer (paint it green actually)

; seg int Im;
; int	I;
	PUSH	SI
	MOV	SI,DI
	PUSH	DI
	LEA	DI,[SI]+4
	XOR	AX,AX
	MOV	WP [SI]+2,AX
	XCHG	DX,AX

L3:
; for I:= 0, 32000-1 do			\write two bytes at a time for speed

	MOV	BX,WP [SI]+0
	MOV	AX,[BX]+0
	MOV	BX,DX
	ADD	BX,BX
	MOV	ES,AX
	MOV	WP ES:[BX],30583
	INC	DX
	CMP	DX,31999
	JLE	L3
	MOV	WP [SI]+2,DX

	POP	DI
	POP	SI
	RET
; 	Im(0, I):= $7777;		\nice shade of green, for background

; 
; \-------------------------------------------------------------------------------
; 

L4	LABEL	NEAR
; proc	DrawPoly(X0, Y0, A, F);	\Draw a texture-mapped polygon
; \This procedure was originally written to draw any kind of polygon, convex or
; \ concave. It was hastily hacked here to draw the simple parallelograms that
; \ form the faces of the die. The linked list could be replaced with a simple
; \ array since there are always exactly two edges per scan line (unlike for a
; \ concave polygon), but I'm too lazy to do it.
; int	X0, Y0,		\location to plot polygon (coordinates of first point)
; 	A,		\1-dimensional array of X,Y coordinates with first value
; 			\ (always 4) giving the number of vertexes (X,Y pairs)
; 	F;		\die face number (0..5)
; int	TM,		\array: die texture map dimensions
; 	N, HeadTbl, P, MemPtr, \used to build linked list
; 	Gx, Gy, Hx, Hy,	\coordinates of end points of plotted horiz scan line
; 	I, J,		\indexes
; 	X, Y,		\coordinates to plot horiz scan lines
; 	Y320		\Y * 320 (for speed)
; 	Min, Max,	\minimum and maximum Y coordinates of polygon
; 	Height;		\height of polygon in pixels
; def	Nil= $8000;	\linked list null pointer
; def	SS = 8;		\scale shift factor
; int	Py, Qy, Ry, Sy,	\Y coordinates of 4 corners of 'polygon'
; 	Tpx, Tpy, Tqx, Tqy, Trx, Try, Tsx, Tsy,	\texture map corner coordinates
; 	Cg, Ch,		\relative position of horizontal line from end points
; 	Tx0, Ty0, Tx1, Ty1, \end points of corresponding line in texture map
; 	Tdx, Tdy,	\amount to step coordinates in texture map
; 	Tx, Ty;		\coordinates in texture map
; 
; 
	JMP	L5

L6	LABEL	NEAR
; 	proc	BuildLine(I0, I1);

; 	\Build table containing X coordinates along polygon edge. This creates
; 	\ a linked list for each horizontal line that will be drawn through the
; 	\ polygon.
; 	int	I0, I1;
; 	int	X, Y, DX, DY, M, T, Q;
	PUSH	SI
	MOV	SI,DI
	PUSH	DI
	LEA	DI,[SI]+18
; 	begin

	MOV	BX,WP [SI]+0
	ADD	BX,BX
	MOV	BP,BASE1
	ADD	BX,WP [BP]+4
	MOV	AX,[BX]
	ADD	AX,WP [BP]+0
	MOV	WP [BP]+18,AX
	MOV	AX,WP [SI]+0
	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [BP]+4
	MOV	AX,[BX]
	ADD	AX,WP [BP]+2
	MOV	WP [BP]+20,AX
; 	Gx:= A(I0) + X0;   Gy:= A(I0+1) + Y0;	\get coordinates of end points

	MOV	BX,WP [SI]+2
	ADD	BX,BX
	ADD	BX,WP [BP]+4
	MOV	AX,[BX]
	ADD	AX,WP [BP]+0
	MOV	WP [BP]+22,AX
	MOV	AX,WP [SI]+2
	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [BP]+4
	MOV	AX,[BX]
	ADD	AX,WP [BP]+2
	MOV	WP [BP]+24,AX
; 	Hx:= A(I1) + X0;   Hy:= A(I1+1) + Y0;	\ of the polygon's edge

; 
	CMP	WP [BP]+20,AX
	MOV	AX,-1
	JG	$+3
	INC	AX
	ORG	$-6
	JLE	L8
; 	if Gy > Hy then

; 		begin				\swap end points
	MOV	AX,WP [BP]+20
	MOV	WP [SI]+14,AX
	MOV	AX,WP [BP]+24
	MOV	WP [BP]+20,AX
	MOV	AX,WP [SI]+14
	MOV	WP [BP]+24,AX
; 		T:= Gy;   Gy:= Hy;   Hy:= T;

	MOV	AX,WP [BP]+18
	MOV	WP [SI]+14,AX
	MOV	AX,WP [BP]+22
	MOV	WP [BP]+18,AX
	MOV	AX,WP [SI]+14
	MOV	WP [BP]+22,AX
; 		T:= Gx;   Gx:= Hx;   Hx:= T;

	MOV	AX,WP [SI]+0
	MOV	WP [SI]+14,AX
	MOV	AX,WP [SI]+2
	MOV	WP [SI]+0,AX
	MOV	AX,WP [SI]+14
	MOV	WP [SI]+2,AX
; 		T:= I0;   I0:= I1;   I1:= T;


L8:
; 		end;
; 
	MOV	BP,BASE1
	MOV	AX,WP [BP]+24
	SUB	AX,WP [BP]+20
	MOV	WP [SI]+10,AX
; 	DY:= Hy - Gy;

	TEST	AX,AX
	MOV	AX,-1
	JE	$+3
	INC	AX
	ORG	$-6
	JNE	L10
	POP	DI
	POP	SI
	RET

L10:
; 	if DY = 0 then return;			\don't a single horiz line

	MOV	BP,BASE1
	MOV	AX,WP [BP]+22
	SUB	AX,WP [BP]+18
	MOV	WP [SI]+8,AX
; 	DX:= Hx - Gx;

	MOV	AH,AL
	XOR	AL,AL
	CWD
	IDIV	WP [SI]+10
	MOV	REMAIN,DX
	MOV	WP [SI]+12,AX
; 	M:= DX<<SS / DY;			\scaled slope (rotated 90 deg)

; 
	MOV	AX,WP [BP]+18
	MOV	AH,AL
	XOR	AL,AL
	MOV	WP [SI]+4,AX
; 	X:= Gx<<SS;				\scaled starting X coordinate

	MOV	AX,WP [BP]+20
	SUB	AX,WP [BP]+36
	MOV	WP [SI]+6,AX
	MOV	AX,WP [BP]+24
	SUB	AX,WP [BP]+36
	DEC	AX
	PUSH	AX
	MOV	DX,WP [SI]+6
	JMP	L11

L12:
; 	for Y:= Gy-Min, Hy-Min-1 do

; 		begin
	MOV	AX,WP [SI]+4
	MOV	AL,AH
	XOR	AH,AH
	MOV	WP [SI]+14,AX
; 		T:= X>>SS;			\unscale X

	MOV	AX,DX
	ADD	AX,AX
	MOV	BP,BASE1
	ADD	AX,WP [BP]+12
	MOV	WP [BP]+14,AX
; 		P:= HeadTbl + Y*IntSize;	\point to list header table


L13:
; 		loop	begin
	MOV	BP,BASE1
	MOV	BX,WP [BP]+14
	MOV	AX,[BX]+0
	CMP	AX,-32768
	MOV	AX,-1
	JE	$+3
	INC	AX
	ORG	$-6
	JE	L15
	MOV	BX,WP [BP]+14
	MOV	AX,[BX]+0
	MOV	BX,AX
	MOV	AX,[BX]+2
	CMP	AX,WP [SI]+14
	MOV	AX,-1
	JG	$+3
	INC	AX
	ORG	$-6
	JLE	L16

L15:
; 			case of P(0)=Nil, P(0,1)>T: \if entry empty or greater

; 				begin		\insert item at front of list
	MOV	BP,BASE1
	MOV	AX,WP [BP]+16
	MOV	WP [SI]+16,AX
; 				Q:= MemPtr;	\ (sorted left-to-right)

	MOV	AX,WP [BP]+16
	ADD	AX,6
	MOV	WP [BP]+16,AX
; 				MemPtr:= MemPtr + 3*IntSize;

	MOV	BX,WP [BP]+14
	MOV	AX,[BX]+0
	MOV	BX,WP [SI]+16
	MOV	[BX],AX
; 				Q(0):= P(0);	\copy nil or pointer to larger X

	MOV	AX,WP [SI]+16
	ADD	AX,2
	MOV	BX,AX
	MOV	AX,WP [SI]+14
	MOV	[BX],AX
; 				Q(1):= T;	\unscaled X

	MOV	AX,WP [SI]+16
	ADD	AX,4
	PUSH	AX
	MOV	AX,WP [SI]+2
	MOV	AH,AL
	XOR	AL,AL
	ADD	AX,WP [SI]+0
	POP	BX
	MOV	[BX],AX
; 				Q(2):= I0 + I1<<8; \indexes of ends of line seg

	MOV	AX,WP [SI]+16
	MOV	BX,WP [BP]+14
	MOV	[BX],AX
; 				P(0):= Q;

	JMP	L17
; 				quit;

; 				end

L16:
	MOV	BP,BASE1
	MOV	BX,WP [BP]+14
	MOV	AX,[BX]+0
	MOV	WP [BP]+14,AX

L14:
; 			other	P:= P(0);	\follow pointers in linked list

	JMP	L13

L17:
; 			end;

	MOV	AX,WP [SI]+4
	ADD	AX,WP [SI]+12
	MOV	WP [SI]+4,AX
; 		X:= X + M;			\next X coordinate

	INC	WP [SI]+6
	MOV	DX,WP [SI]+6

L11:
	MOV	BX,SP
	CMP	DX,[BX]
	JLE	L12
	POP	CX

; 		end;

	POP	DI
	POP	SI
	RET
; 	end;	\BuildLine

; 
; 

L5:
	PUSH	SI
	MOV	SI,DI
	XCHG	BASE1,DI
	PUSH	DI
	LEA	DI,[SI]+86
; begin	\DrawPoly

; \Find maximum and minimum Y coordinates
	MOV	BX,WP [SI]+4
	MOV	AX,[BX]+0
	MOV	WP [SI]+10,AX
; N:= A(0);				\get number of coordinates

	MOV	WP [SI]+36,32767
	MOV	WP [SI]+38,-32768
; Min:= $7FFF;   Max:= $8000;

	MOV	WP [SI]+26,2
; I:= 2;					\index of first Y coordinate in A

	MOV	WP [SI]+28,1
	PUSH	AX
	MOV	DX,WP [SI]+28
	JMP	L18

L19:
; for J:= 1, N do

; 	begin
	MOV	BX,WP [SI]+26
	ADD	BX,BX
	ADD	BX,WP [SI]+4
	MOV	AX,[BX]
	ADD	AX,WP [SI]+2
	MOV	WP [SI]+32,AX
; 	Y:= Y0 + A(I);

	CMP	AX,WP [SI]+38
	MOV	AX,-1
	JG	$+3
	INC	AX
	ORG	$-6
	JLE	L21
	MOV	WP [SI]+38,AX

L21:
; 	if Y > Max then Max:= Y;

	MOV	AX,WP [SI]+32
	CMP	AX,WP [SI]+36
	MOV	AX,-1
	JL	$+3
	INC	AX
	ORG	$-6
	JGE	L23
	MOV	WP [SI]+36,AX

L23:
; 	if Y < Min then Min:= Y;

	MOV	AX,WP [SI]+26
	ADD	AX,2
	MOV	WP [SI]+26,AX
; 	I:= I + 2;			\next Y coordinate

	INC	DX

L18:
	MOV	BX,SP
	CMP	DX,[BX]
	JLE	L19
	POP	CX
	MOV	WP [SI]+28,DX

; 	end;

	MOV	AX,WP [SI]+38
	SUB	AX,WP [SI]+36
	INC	AX
	MOV	WP [SI]+40,AX
; Height:= Max - Min + 1;

; 
; \Set up array of list headers for each horizontal scan line in the polygon.
; \ The list will contain the X coordinates (lowest value first) of the edges,
; \ along with the index to the coordinates for the start and end of each edge.
	ADD	AX,AX
	PUSH	CS
	CALL	NEAR PTR INTR3
	MOV	WP [SI]+12,AX
; HeadTbl:= Reserve(Height*IntSize);

	XOR	AX,AX
	MOV	WP [SI]+32,AX
	MOV	AX,WP [SI]+40
	DEC	AX
	PUSH	AX
	MOV	DX,WP [SI]+32
	JMP	L24

L25:
	MOV	AX,DX
	ADD	AX,AX
	ADD	AX,WP [SI]+12
	MOV	BX,AX
	INC	DX
	MOV	WP [BX],-32768

L24:
	MOV	BX,SP
	CMP	DX,[BX]
	JLE	L25
	POP	CX
	MOV	WP [SI]+32,DX

; for Y:= 0, Height-1 do HeadTbl(Y):= Nil;

; 
	MOV	AX,30000
	PUSH	CS
	CALL	NEAR PTR INTR3
	MOV	WP [SI]+16,AX
; MemPtr:= Reserve(30000);		\set up our own heap space manager

; 					\ (or in-line BuildLine)
	MOV	WP [SI]+26,1
; I:= 1;					\index of first coordinate in array A

	MOV	WP [SI]+28,2
	PUSH	WP [SI]+10
	MOV	DX,WP [SI]+28
	JMP	L26

L27:
; for J:= 2, N do

; 	begin
	MOV	AX,WP [SI]+26
	ADD	AX,2
	MOV	WP [DI]+2,AX
	MOV	AX,WP [SI]+26
	MOV	WP [DI]+0,AX
	CALL	L6
; 	BuildLine(I, I+2);		\make edge of polygon between vertexes

	MOV	AX,WP [SI]+26
	ADD	AX,2
	MOV	WP [SI]+26,AX
; 	I:= I + 2;			\ i.e. build table of X values for edge

	INC	WP [SI]+28
	MOV	DX,WP [SI]+28

L26:
	MOV	BX,SP
	CMP	DX,[BX]
	JLE	L27
	POP	CX

; 	end;

	MOV	WP [DI]+2,1
	MOV	AX,WP [SI]+26
	MOV	WP [DI]+0,AX
	CALL	L6
; BuildLine(I, 1);			\make sure the polygon is closed, i.e.

; 					\ connect last vertex to first vertex
; \    0  1  2  3  4  5  6  7  8
; \A:  N  Px Py Qx Qy Rx Ry Sx Sy		array of 'polygon' vertexes
; \TM: -  px py qx qy rx ry sx sy		coorsponding array of texture vertexes
; 

DSEG	SEGMENT WORD PUBLIC 'DATA'

L28	DW	0
	DW	0
	DW	0
	DW	100
	DW	0
	DW	100
	DW	100
	DW	0
	DW	100
DSEG	ENDS

	MOV	WP [SI]+8,OFFSET L28
; TM:= [0, 0,0, 100,0, 100,100, 0,100];	\clockwise, start at upper-right corner

; 
	MOV	AX,WP [SI]+36
	MOV	WP [SI]+32,AX
	PUSH	WP [SI]+38
	XCHG	DX,AX
	JMP	L29

L30:
; for Y:= Min, Max do			\draw horizontal lines to fill polygon

; 	begin				\ from top to bottom
	MOV	AX,DX
	SUB	AX,WP [SI]+36
	ADD	AX,AX
	ADD	AX,WP [SI]+12
	MOV	WP [SI]+14,AX
; 	P:= HeadTbl + (Y-Min)*IntSize;


L31:
; 	loop	begin			\for edge on left side of polygon...
	MOV	BX,WP [SI]+14
	MOV	AX,[BX]+0
	MOV	WP [SI]+14,AX
; 		P:= P(0);

	CMP	AX,-32768
	MOV	AX,-1
	JE	$+3
	INC	AX
	ORG	$-6
	JNE	L33
	JMP	L34

L33:
; 		if P = Nil then quit;

	MOV	BX,WP [SI]+14
	MOV	AX,[BX]+2
	MOV	WP [SI]+18,AX
; 		Gx:= P(1);		\starting X coordinate for horiz line

; 
	MOV	BX,WP [SI]+14
	MOV	AX,[BX]+4
	XOR	AH,AH
	MOV	WP [SI]+26,AX
; 		I:= P(2) & $00FF;	\index of start of edge

	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [SI]+4
	MOV	AX,[BX]
	ADD	AX,WP [SI]+2
	MOV	WP [SI]+48,AX
; 		Sy:= A(I+1) + Y0;	\Y coordinate of start of edge

	MOV	BX,WP [SI]+26
	ADD	BX,BX
	ADD	BX,WP [SI]+8
	MOV	AX,[BX]
	MOV	WP [SI]+62,AX
; 		Tsx:= TM(I);		\corresponding coordinate in texture map

	MOV	AX,WP [SI]+26
	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [SI]+8
	MOV	AX,[BX]
	MOV	WP [SI]+64,AX
; 		Tsy:= TM(I+1);

; 
	MOV	BX,WP [SI]+14
	MOV	AX,[BX]+4
	MOV	AL,AH
	XOR	AH,AH
	MOV	WP [SI]+26,AX
; 		I:= P(2)>>8;		\index of end of edge

	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [SI]+4
	MOV	AX,[BX]
	ADD	AX,WP [SI]+2
	MOV	WP [SI]+46,AX
; 		Ry:= A(I+1) + Y0;	\Y coordinate of end of edge

	MOV	BX,WP [SI]+26
	ADD	BX,BX
	ADD	BX,WP [SI]+8
	MOV	AX,[BX]
	MOV	WP [SI]+58,AX
; 		Trx:= TM(I);		\corresponding coordinate in texture map

	MOV	AX,WP [SI]+26
	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [SI]+8
	MOV	AX,[BX]
	MOV	WP [SI]+60,AX
; 		Try:= TM(I+1);

; 
	MOV	BX,WP [SI]+14
	MOV	AX,[BX]+0
	MOV	WP [SI]+14,AX
; 		P:= P(0);

	CMP	AX,-32768
	MOV	AX,-1
	JE	$+3
	INC	AX
	ORG	$-6
	JNE	L36
	JMP	L37

L36:
; 		if P = Nil then quit;

	MOV	BX,WP [SI]+14
	MOV	AX,[BX]+2
	MOV	WP [SI]+22,AX
; 		Hx:= P(1);		\ending X coordinate for horiz line

; 
	CMP	WP [SI]+18,AX
	MOV	AX,-1
	JNE	$+3
	INC	AX
	ORG	$-6
	JE	L39
; 		if Gx # Hx then		\same as above for edge on right side

; 			begin		\ of polygon...
	MOV	BX,WP [SI]+14
	MOV	AX,[BX]+4
	XOR	AH,AH
	MOV	WP [SI]+26,AX
; 			I:= P(2) & $00FF;

	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [SI]+4
	MOV	AX,[BX]
	ADD	AX,WP [SI]+2
	MOV	WP [SI]+42,AX
; 			Py:= A(I+1) + Y0;

	MOV	BX,WP [SI]+26
	ADD	BX,BX
	ADD	BX,WP [SI]+8
	MOV	AX,[BX]
	MOV	WP [SI]+50,AX
; 			Tpx:= TM(I);

	MOV	AX,WP [SI]+26
	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [SI]+8
	MOV	AX,[BX]
	MOV	WP [SI]+52,AX
; 			Tpy:= TM(I+1);

; 
	MOV	BX,WP [SI]+14
	MOV	AX,[BX]+4
	MOV	AL,AH
	XOR	AH,AH
	MOV	WP [SI]+26,AX
; 			I:= P(2)>>8;

	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [SI]+4
	MOV	AX,[BX]
	ADD	AX,WP [SI]+2
	MOV	WP [SI]+44,AX
; 			Qy:= A(I+1) + Y0;

	MOV	BX,WP [SI]+26
	ADD	BX,BX
	ADD	BX,WP [SI]+8
	MOV	AX,[BX]
	MOV	WP [SI]+54,AX
; 			Tqx:= TM(I);

	MOV	AX,WP [SI]+26
	INC	AX
	MOV	BX,AX
	ADD	BX,BX
	ADD	BX,WP [SI]+8
	MOV	AX,[BX]
	MOV	WP [SI]+56,AX
; 			Tqy:= TM(I+1);

; 
	MOV	AX,WP [SI]+32
	SUB	AX,WP [SI]+46
	MOV	AH,AL
	XOR	AL,AL
	PUSH	AX
	MOV	AX,WP [SI]+48
	SUB	AX,WP [SI]+46
	POP	CX
	XCHG	AX,CX
	CWD
	IDIV	CX
	MOV	REMAIN,DX
	MOV	WP [SI]+66,AX
; 			Cg:= (Y-Ry)<<SS / (Sy-Ry);	\relative position

	MOV	AX,WP [SI]+32
	SUB	AX,WP [SI]+44
	MOV	AH,AL
	XOR	AL,AL
	PUSH	AX
	MOV	AX,WP [SI]+42
	SUB	AX,WP [SI]+44
	POP	CX
	XCHG	AX,CX
	CWD
	IDIV	CX
	MOV	REMAIN,DX
	MOV	WP [SI]+68,AX
; 			Ch:= (Y-Qy)<<SS / (Py-Qy);

; 
	MOV	AX,WP [SI]+62
	SUB	AX,WP [SI]+58
	IMUL	WP [SI]+66
	PUSH	AX
	MOV	AX,WP [SI]+58
	MOV	AH,AL
	XOR	AL,AL
	POP	CX
	ADD	AX,CX
	MOV	WP [SI]+70,AX
; 			Tx0:= Cg * (Tsx-Trx) + Trx<<SS;	\corresponding end points

	MOV	AX,WP [SI]+64
	SUB	AX,WP [SI]+60
	IMUL	WP [SI]+66
	PUSH	AX
	MOV	AX,WP [SI]+60
	MOV	AH,AL
	XOR	AL,AL
	POP	CX
	ADD	AX,CX
	MOV	WP [SI]+72,AX
; 			Ty0:= Cg * (Tsy-Try) + Try<<SS;	\ in texture map

	MOV	AX,WP [SI]+50
	SUB	AX,WP [SI]+54
	IMUL	WP [SI]+68
	PUSH	AX
	MOV	AX,WP [SI]+54
	MOV	AH,AL
	XOR	AL,AL
	POP	CX
	ADD	AX,CX
	MOV	WP [SI]+74,AX
; 			Tx1:= Ch * (Tpx-Tqx) + Tqx<<SS;

	MOV	AX,WP [SI]+52
	SUB	AX,WP [SI]+56
	IMUL	WP [SI]+68
	PUSH	AX
	MOV	AX,WP [SI]+56
	MOV	AH,AL
	XOR	AL,AL
	POP	CX
	ADD	AX,CX
	MOV	WP [SI]+76,AX
; 			Ty1:= Ch * (Tpy-Tqy) + Tqy<<SS;

; 
	MOV	AX,WP [SI]+74
	SUB	AX,WP [SI]+70
	PUSH	AX
	MOV	AX,WP [SI]+22
	SUB	AX,WP [SI]+18
	POP	CX
	XCHG	AX,CX
	CWD
	IDIV	CX
	MOV	REMAIN,DX
	MOV	WP [SI]+78,AX
; 			Tdx:= (Tx1-Tx0) / (Hx-Gx);	\amount to move in

	MOV	AX,WP [SI]+76
	SUB	AX,WP [SI]+72
	PUSH	AX
	MOV	AX,WP [SI]+22
	SUB	AX,WP [SI]+18
	POP	CX
	XCHG	AX,CX
	CWD
	IDIV	CX
	MOV	REMAIN,DX
	MOV	WP [SI]+80,AX
; 			Tdy:= (Ty1-Ty0) / (Hx-Gx);	\ texture map

; 
	MOV	AX,WP [SI]+70
	MOV	WP [SI]+82,AX
; 			Tx:= Tx0;	\coords of start of line in texture map

	MOV	AX,WP [SI]+72
	MOV	WP [SI]+84,AX
; 			Ty:= Ty0;

	MOV	AX,320
	IMUL	WP [SI]+32
	MOV	WP [SI]+34,AX
; 			Y320:= Y*320;

	MOV	AX,WP [SI]+18
	MOV	WP [SI]+30,AX
	MOV	AX,WP [SI]+22
	DEC	AX
	PUSH	AX
	MOV	DX,WP [SI]+30
	JMP	L40

L41:
; 			for X:= Gx, Hx-1 do	\step one horiz pixel at a time

; 				begin
	MOV	BX,WP HEAPLO+8
	MOV	AX,[BX]+0
	PUSH	AX
	MOV	AX,WP [SI]+34
	ADD	AX,DX
	PUSH	AX
	MOV	BX,WP [SI]+6
	ADD	BX,BX
	ADD	BX,WP HEAPLO+12
	MOV	AX,[BX]
	PUSH	AX
	MOV	AX,WP [SI]+82
	MOV	AL,AH
	XOR	AH,AH
	PUSH	AX
	MOV	AX,WP [SI]+84
	MOV	AL,AH
	XOR	AH,AH
	MOV	CX,101
	IMUL	CX
	POP	CX
	ADD	AX,CX
	MOV	BX,AX
	POP	ES
	MOV	AL,ES:[BX]
	XOR	AH,AH
	MOV	CX,AX
	POP	BX
	POP	ES
	MOV	ES:[BX],CL
; 				Image(0, X + Y320):= Face(F, Tx>>SS + 101*(Ty>>SS));

	MOV	AX,WP [SI]+82
	ADD	AX,WP [SI]+78
	MOV	WP [SI]+82,AX
; 				Tx:= Tx + Tdx;	\loc of next pixel in texture map

	MOV	AX,WP [SI]+84
	ADD	AX,WP [SI]+80
	MOV	WP [SI]+84,AX
; 				Ty:= Ty + Tdy;

	INC	WP [SI]+30
	MOV	DX,WP [SI]+30

L40:
	MOV	BX,SP
	CMP	DX,[BX]
	JLE	L41
	POP	CX

; 				end;


L39:
; 			end;
	JMP	L31

L37:

L34:
; 		end;

	INC	WP [SI]+32
	MOV	DX,WP [SI]+32

L29:
	MOV	BX,SP
	CMP	DX,[BX]
	JLE	L30
	POP	CX

; 	end;


L42:
	POP	DI
	XCHG	DI,BASE1
	POP	SI
	RET
; end;	\DrawPoly

; 
; \-------------------------------------------------------------------------------
; 

L43	LABEL	NEAR
; proc	DrawCube;	\Draw cube
; int	T, CT, F, C, I;
	PUSH	SI
	MOV	SI,DI
	PUSH	DI
	LEA	DI,[SI]+10
; begin


DSEG	SEGMENT WORD PUBLIC 'DATA'

L44	DW	4
	DW	0
	DW	0
	DW	0
	DW	0
	DW	0
	DW	0
	DW	0
	DW	0
DSEG	ENDS

	MOV	WP [SI]+0,OFFSET L44
; T:= [4, 0,0, 0,0, 0,0, 0,0];		\table of 4 polygon vertex coordinates

; 
; \Table of corners: Contains indexes into CorX, CorY & CorZ arrays for each face

DSEG	SEGMENT WORD PUBLIC 'DATA'

L45	DW	0
	DW	1
	DW	3
	DW	2
; CT:= [	[0, 1, 3, 2],	\1


L46	DW	4
	DW	5
	DW	1
	DW	0
; 	[4, 5, 1, 0],	\2


L47	DW	4
	DW	0
	DW	2
	DW	6
; 	[4, 0, 2, 6],	\3


L48	DW	1
	DW	5
	DW	7
	DW	3
; 	[1, 5, 7, 3],	\4


L49	DW	7
	DW	6
	DW	2
	DW	3
; 	[7, 6, 2, 3],	\5


L50	DW	5
	DW	4
	DW	6
	DW	7

L51	DW	L45
	DW	L46
	DW	L47
	DW	L48
	DW	L49
	DW	L50
DSEG	ENDS

	MOV	WP [SI]+2,OFFSET L51
; 	[5, 4, 6, 7] ];	\6

; 
	XOR	AX,AX
	MOV	WP [SI]+4,AX
	XCHG	DX,AX

L52:
; for F:= 0, 5 do				\for all the faces on the cube...

; 	begin
	MOV	WP [SI]+8,1
; 	I:= 1;

	XOR	AX,AX
	MOV	WP [SI]+6,AX
	XCHG	DX,AX

L53:
; 	for C:= 0, 3 do				\for all the corners on a face..

; 		begin
	MOV	AX,WP [SI]+8
	ADD	AX,AX
	ADD	AX,WP [SI]+0
	PUSH	AX
	PUSH	WP HEAPLO+26
	PUSH	WP HEAPLO+28
	PUSH	WP HEAPLO+30
	PUSH	WP HEAPLO+32
	MOV	BX,WP [SI]+4
	ADD	BX,BX
	ADD	BX,WP [SI]+2
	MOV	AX,[BX]
	MOV	BX,DX
	ADD	BX,BX
	ADD	BX,AX
	MOV	AX,[BX]
	PUSH	CS
	CALL	NEAR PTR TRIDO
	POP	AX
	PUSH	CS
	CALL	NEAR PTR INTR50
	POP	BX
	MOV	[BX],AX
; 		T(I):= Fix(CorX(CT(F,C)));	\X coordinate

	MOV	AX,WP [SI]+8
	INC	AX
	MOV	WP [SI]+8,AX
; 		I:= I + 1;

	ADD	AX,AX
	ADD	AX,WP [SI]+0
	PUSH	AX
	PUSH	WP HEAPLO+34
	PUSH	WP HEAPLO+36
	PUSH	WP HEAPLO+38
	PUSH	WP HEAPLO+40
	MOV	BX,WP [SI]+4
	ADD	BX,BX
	ADD	BX,WP [SI]+2
	MOV	AX,[BX]
	MOV	BX,WP [SI]+6
	ADD	BX,BX
	ADD	BX,AX
	MOV	AX,[BX]
	PUSH	CS
	CALL	NEAR PTR TRIDO
	MOV	AX,16362
	PUSH	AX
	MOV	AX,-22545
	PUSH	AX
	MOV	AX,-25166
	PUSH	AX
	MOV	AX,11535
	PUSH	AX
	PUSH	CS
	CALL	NEAR PTR FMULDO
	POP	AX
	PUSH	CS
	CALL	NEAR PTR INTR50
	POP	BX
	MOV	[BX],AX
; 		T(I):= Fix(CorY(CT(F,C)) * 0.833); \Y coord, fix aspect ratio

	MOV	AX,WP [SI]+8
	INC	AX
	MOV	WP [SI]+8,AX
; 		I:= I + 1;			\320*3/4 = 240, 200/240 = 0.833

	INC	WP [SI]+6
	MOV	DX,WP [SI]+6
	CMP	DX,3
	JLE	L53

; 		end;

	PUSH	WP HEAPLO+42
	PUSH	WP HEAPLO+44
	PUSH	WP HEAPLO+46
	PUSH	WP HEAPLO+48
	MOV	BX,WP [SI]+4
	ADD	BX,BX
	ADD	BX,WP [SI]+2
	MOV	AX,[BX]
	MOV	BX,AX
	MOV	AX,[BX]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	PUSH	WP HEAPLO+42
	PUSH	WP HEAPLO+44
	PUSH	WP HEAPLO+46
	PUSH	WP HEAPLO+48
	MOV	BX,WP [SI]+4
	ADD	BX,BX
	ADD	BX,WP [SI]+2
	MOV	AX,[BX]
	MOV	BX,AX
	MOV	AX,[BX]+4
	PUSH	CS
	CALL	NEAR PTR TRIDO
	PUSH	CS
	CALL	NEAR PTR FADDDO
	XOR	AX,AX
	PUSH	AX
	
	PUSH	AX
	
	PUSH	AX
	
	PUSH	AX
	PUSH	CS
	CALL	NEAR PTR FGTDO
	POP	AX
	TEST	AX,AX
	JE	L55
; 	if CorZ(CT(F,0)) + CorZ(CT(F,2)) > 0.0 then \Z coord of center is visible

	MOV	WP [DI]+2,100
	MOV	WP [DI]+0,160
	MOV	AX,WP [SI]+4
	MOV	WP [DI]+6,AX
	MOV	AX,WP [SI]+0
	MOV	WP [DI]+4,AX
	CALL	L4

L55:
; 		DrawPoly(160, 100, T, F);

	INC	WP [SI]+4
	MOV	DX,WP [SI]+4
	CMP	DX,5
	JLE	L52

; 	end;

	POP	DI
	POP	SI
	RET
; end;	\DrawCube

; 
; 
; 

L56	LABEL	NEAR
; proc	Rotate;		\Rotate the cube
; int	I;
; def	Cx= 0.04, Cy= 0.05, Cz=-0.03;	\determine rotation speed
	PUSH	SI
	MOV	SI,DI
	PUSH	DI
	LEA	DI,[SI]+2
; begin

	XOR	AX,AX
	MOV	WP [SI]+0,AX
	XCHG	DX,AX

L57:
; for I:= 0, 7 do		\rotate all 8 corners...

; 	begin
	MOV	AX,DX
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,WP HEAPLO+34
	PUSH	AX
	PUSH	WP HEAPLO+34
	PUSH	WP HEAPLO+36
	PUSH	WP HEAPLO+38
	PUSH	WP HEAPLO+40
	MOV	AX,DX
	PUSH	CS
	CALL	NEAR PTR TRIDO
	PUSH	WP HEAPLO+42
	PUSH	WP HEAPLO+44
	PUSH	WP HEAPLO+46
	PUSH	WP HEAPLO+48
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	MOV	AX,16292
	PUSH	AX
	MOV	AX,31457
	PUSH	AX
	MOV	AX,18350
	PUSH	AX
	MOV	AX,5243
	PUSH	AX
	PUSH	CS
	CALL	NEAR PTR FMULDO
	PUSH	CS
	CALL	NEAR PTR FADDDO
	PUSH	CS
	CALL	NEAR PTR STTDO
; 	CorY(I):= CorY(I) + CorZ(I)*Cx;		\rotate about X axis

	MOV	AX,WP [SI]+0
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,WP HEAPLO+42
	PUSH	AX
	PUSH	WP HEAPLO+42
	PUSH	WP HEAPLO+44
	PUSH	WP HEAPLO+46
	PUSH	WP HEAPLO+48
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	PUSH	WP HEAPLO+34
	PUSH	WP HEAPLO+36
	PUSH	WP HEAPLO+38
	PUSH	WP HEAPLO+40
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	MOV	AX,16292
	PUSH	AX
	MOV	AX,31457
	PUSH	AX
	MOV	AX,18350
	PUSH	AX
	MOV	AX,5243
	PUSH	AX
	PUSH	CS
	CALL	NEAR PTR FMULDO
	PUSH	CS
	CALL	NEAR PTR FSUBDO
	PUSH	CS
	CALL	NEAR PTR STTDO
; 	CorZ(I):= CorZ(I) - CorY(I)*Cx;

	MOV	AX,WP [SI]+0
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,WP HEAPLO+42
	PUSH	AX
	PUSH	WP HEAPLO+42
	PUSH	WP HEAPLO+44
	PUSH	WP HEAPLO+46
	PUSH	WP HEAPLO+48
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	PUSH	WP HEAPLO+26
	PUSH	WP HEAPLO+28
	PUSH	WP HEAPLO+30
	PUSH	WP HEAPLO+32
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	MOV	AX,16297
	PUSH	AX
	MOV	AX,-26215
	PUSH	AX
	
	PUSH	AX
	INC	AX
	PUSH	AX
	PUSH	CS
	CALL	NEAR PTR FMULDO
	PUSH	CS
	CALL	NEAR PTR FADDDO
	PUSH	CS
	CALL	NEAR PTR STTDO
; 	CorZ(I):= CorZ(I) + CorX(I)*Cy;		\rotate about Y axis

	MOV	AX,WP [SI]+0
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,WP HEAPLO+26
	PUSH	AX
	PUSH	WP HEAPLO+26
	PUSH	WP HEAPLO+28
	PUSH	WP HEAPLO+30
	PUSH	WP HEAPLO+32
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	PUSH	WP HEAPLO+42
	PUSH	WP HEAPLO+44
	PUSH	WP HEAPLO+46
	PUSH	WP HEAPLO+48
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	MOV	AX,16297
	PUSH	AX
	MOV	AX,-26215
	PUSH	AX
	
	PUSH	AX
	INC	AX
	PUSH	AX
	PUSH	CS
	CALL	NEAR PTR FMULDO
	PUSH	CS
	CALL	NEAR PTR FSUBDO
	PUSH	CS
	CALL	NEAR PTR STTDO
; 	CorX(I):= CorX(I) - CorZ(I)*Cy;

	MOV	AX,WP [SI]+0
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,WP HEAPLO+26
	PUSH	AX
	PUSH	WP HEAPLO+26
	PUSH	WP HEAPLO+28
	PUSH	WP HEAPLO+30
	PUSH	WP HEAPLO+32
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	PUSH	WP HEAPLO+34
	PUSH	WP HEAPLO+36
	PUSH	WP HEAPLO+38
	PUSH	WP HEAPLO+40
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	MOV	AX,-16482
	PUSH	AX
	MOV	AX,-18351
	PUSH	AX
	MOV	AX,-5243
	PUSH	AX
	MOV	AX,7865
	PUSH	AX
	PUSH	CS
	CALL	NEAR PTR FMULDO
	PUSH	CS
	CALL	NEAR PTR FADDDO
	PUSH	CS
	CALL	NEAR PTR STTDO
; 	CorX(I):= CorX(I) + CorY(I)*Cz;		\rotate about Z axis

	MOV	AX,WP [SI]+0
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,AX
	ADD	AX,WP HEAPLO+34
	PUSH	AX
	PUSH	WP HEAPLO+34
	PUSH	WP HEAPLO+36
	PUSH	WP HEAPLO+38
	PUSH	WP HEAPLO+40
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	PUSH	WP HEAPLO+26
	PUSH	WP HEAPLO+28
	PUSH	WP HEAPLO+30
	PUSH	WP HEAPLO+32
	MOV	AX,WP [SI]+0
	PUSH	CS
	CALL	NEAR PTR TRIDO
	MOV	AX,-16482
	PUSH	AX
	MOV	AX,-18351
	PUSH	AX
	MOV	AX,-5243
	PUSH	AX
	MOV	AX,7865
	PUSH	AX
	PUSH	CS
	CALL	NEAR PTR FMULDO
	PUSH	CS
	CALL	NEAR PTR FSUBDO
	PUSH	CS
	CALL	NEAR PTR STTDO
; 	CorY(I):= CorY(I) - CorX(I)*Cz;

	INC	WP [SI]+0
	MOV	DX,WP [SI]+0
	CMP	DX,7
	JLE	L57

; 	end;

	POP	DI
	POP	SI
	RET
; end;	\Rotate

; 
; \-------------------------------------------------------------------------------
; 

L58	LABEL	NEAR
; proc	MakeFaces;	\Make texture maps for the 6 die faces
; int	F,	\face number
; 	P,	\pattern of spots
; 	Tbl,	\table of spot patterns for each face
; 	X, Y;	\coordinates
; 
; 
	JMP	L59

L60	LABEL	NEAR
; 	proc	DrawCircle(X0, Y0);	\Draw a filled circle in Image array

; 	int	X0, Y0;		\coordinates of center (pixels)
; 	int	X, Y;		\coordinates (pixels)
; 	def	R=14;		\radius (pixels)
	PUSH	SI
	MOV	SI,DI
	PUSH	DI
	LEA	DI,[SI]+8
; 	begin

	MOV	WP [SI]+6,-14
	MOV	DX,WP [SI]+6

L61:
; 	for Y:= -R, R do

	MOV	WP [SI]+4,-14
	MOV	DX,WP [SI]+4

L62:
; 	    for X:= -R, R do	\(speed is not an issue here)

; 		begin		\smooth the edge a little with gray
	MOV	AX,DX
	IMUL	AX
	PUSH	AX
	MOV	AX,WP [SI]+6
	IMUL	AX
	POP	CX
	ADD	AX,CX
	CMP	AX,196
	MOV	AX,-1
	JL	$+3
	INC	AX
	ORG	$-6
	JGE	L64
	MOV	BP,BASE1
	MOV	BX,WP [BP]+0
	ADD	BX,BX
	ADD	BX,WP HEAPLO+12
	MOV	AX,[BX]
	PUSH	AX
	MOV	AX,WP [SI]+4
	ADD	AX,WP [SI]+0
	PUSH	AX
	MOV	AX,WP [SI]+6
	ADD	AX,WP [SI]+2
	MOV	CX,101
	IMUL	CX
	POP	CX
	ADD	AX,CX
	MOV	BX,AX
	POP	ES
	MOV	BYTE PTR ES:[BX],24

L64:
; 		if X*X+Y*Y < R*R then Face(F, X+X0 + 101*(Y+Y0)):= $18; \gray

	MOV	AX,WP [SI]+4
	IMUL	AX
	PUSH	AX
	MOV	AX,WP [SI]+6
	IMUL	AX
	POP	CX
	ADD	AX,CX
	CMP	AX,171
	MOV	AX,-1
	JL	$+3
	INC	AX
	ORG	$-6
	JGE	L66
	MOV	BP,BASE1
	MOV	BX,WP [BP]+0
	ADD	BX,BX
	ADD	BX,WP HEAPLO+12
	MOV	AX,[BX]
	PUSH	AX
	MOV	AX,WP [SI]+4
	ADD	AX,WP [SI]+0
	PUSH	AX
	MOV	AX,WP [SI]+6
	ADD	AX,WP [SI]+2
	MOV	CX,101
	IMUL	CX
	POP	CX
	ADD	AX,CX
	MOV	BX,AX
	POP	ES
	MOV	BYTE PTR ES:[BX],16

L66:
; 		if X*X+Y*Y < R*R-25 then Face(F, X+X0 + 101*(Y+Y0)):= $10; \black

	INC	WP [SI]+4
	MOV	DX,WP [SI]+4
	CMP	DX,14
	JLE	L62

	INC	WP [SI]+6
	MOV	DX,WP [SI]+6
	CMP	DX,14
	JLE	L61

; 		end;

	POP	DI
	POP	SI
	RET
; 	end;	\DrawCircle

; 
; 

L59:
	PUSH	SI
	MOV	SI,DI
	XCHG	BASE1,DI
	PUSH	DI
	LEA	DI,[SI]+10
; begin

; \Table to define location of spots on each face of a die. A spot is displayed at
; \ the corresponding bit position:
; \	0 1 2
; \	3 4 5
; \	6 7 8

DSEG	SEGMENT WORD PUBLIC 'DATA'

L67	DW	16
	DW	257
	DW	273
	DW	325
	DW	341
	DW	455
DSEG	ENDS

	MOV	WP [SI]+4,OFFSET L67
; Tbl:= [$010, $101, $111, $145, $155, $1C7];

; 
	XOR	AX,AX
	MOV	WP [SI]+0,AX
	XCHG	DX,AX

L68:
; for F:= 0, 5 do					\for all the faces...

; 	begin
	MOV	AX,DX
	ADD	AX,AX
	ADD	AX,WP HEAPLO+12
	PUSH	AX
	MOV	REMAIN,9
	MOV	AX,638
	PUSH	CS
	CALL	NEAR PTR INTR73
	POP	BX
	MOV	[BX],AX
; 	Face(F):= Malloc(101*101/16+1);		\make a light gray square

	XOR	AX,AX
	MOV	WP [SI]+8,AX
	XCHG	DX,AX

L69:
; 	for Y:= 0, 100 do

	XOR	AX,AX
	MOV	WP [SI]+6,AX
	XCHG	DX,AX

L70:
; 	    for X:= 0, 100 do			\shade of gray depends on face

	MOV	BX,WP [SI]+0
	ADD	BX,BX
	ADD	BX,WP HEAPLO+12
	MOV	AX,[BX]
	PUSH	AX
	MOV	AX,101
	IMUL	WP [SI]+8
	ADD	AX,WP [SI]+6
	PUSH	AX
	MOV	AX,WP [SI]+0
	ADD	AX,AX
	SUB	AX,5
	NEG	AX
	JS	$-2
	MOV	CX,2
	CWD
	IDIV	CX
	MOV	REMAIN,DX
	ADD	AX,26
	MOV	CX,AX
	POP	BX
	POP	ES
	MOV	ES:[BX],CL
	INC	WP [SI]+6
	MOV	DX,WP [SI]+6
	CMP	DX,100
	JLE	L70

	INC	WP [SI]+8
	MOV	DX,WP [SI]+8
	CMP	DX,100
	JLE	L69

; 		Face(F, X+101*Y):= abs(F+F-5)/2 + $1A;

; 
	MOV	BX,WP [SI]+0
	ADD	BX,BX
	ADD	BX,WP [SI]+4
	MOV	AX,[BX]
	MOV	WP [SI]+2,AX
; 	P:= Tbl(F);			\get pattern of spots for current face

	XOR	AX,AX
	MOV	WP [SI]+8,AX
	XCHG	DX,AX

L71:
; 	for Y:= 0, 2 do

	XOR	AX,AX
	MOV	WP [SI]+6,AX
	XCHG	DX,AX

L72:
; 	    for X:= 0, 2 do

; 		begin
	MOV	AX,WP [SI]+2
	AND	AX,1
	JE	L74
	MOV	AL,32
	IMUL	DX
	ADD	AX,2
	ADD	AX,16
	PUSH	AX
	MOV	AX,32
	IMUL	WP [SI]+8
	ADD	AX,2
	ADD	AX,16
	MOV	WP [DI]+2,AX
	POP	WP [DI]+0
	CALL	L60

L74:
; 		if P & 1 then DrawCircle(X*32+2+16, Y*32+2+16);

	MOV	AX,WP [SI]+2
	SHR	AX,1
	MOV	WP [SI]+2,AX
; 		P:= P >> 1;

	INC	WP [SI]+6
	MOV	DX,WP [SI]+6
	CMP	DX,2
	JLE	L72

	INC	WP [SI]+8
	MOV	DX,WP [SI]+8
	CMP	DX,2
	JLE	L71

; 		end;

	INC	WP [SI]+0
	MOV	DX,WP [SI]+0
	CMP	DX,5
	JLE	L68

; 	end;

	JMP	L42
; end;	\MakeFaces

; 
; \===============================================================================
; 

L1:
	ADD	DI,24
; begin	\Main

	MOV	AX,4000
	PUSH	CS
	CALL	NEAR PTR INTR73
	MOV	BX,WP [SI]+8
	MOV	[BX],AX
; Image(0):= Malloc(4000);		\allocate a 64000-byte staging buffer

; \Coordinates defining the initial position of the 8 corners of a cube:

DSEG	SEGMENT WORD PUBLIC 'DATA'

L75	DQ	0000000000000404BH
	DQ	0000000000000C04BH
	DQ	0000000000000404BH
	DQ	0000000000000C04BH
	DQ	0000000000000404BH
	DQ	0000000000000C04BH
	DQ	0000000000000404BH
	DQ	0000000000000C04BH
DSEG	ENDS

	MOV	AX,OFFSET L75
	PUSH	AX
	PUSH	AX

	PUSH	AX

	PUSH	AX
	POP	WP [SI]+32
	POP	WP [SI]+30
	POP	WP [SI]+28
	POP	WP [SI]+26
; CorX:= [ S,	-S,	 S,	-S,	 S,	-S,	 S,	-S];


DSEG	SEGMENT WORD PUBLIC 'DATA'

L76	DQ	0000000000000404BH
	DQ	0000000000000404BH
	DQ	0000000000000C04BH
	DQ	0000000000000C04BH
	DQ	0000000000000404BH
	DQ	0000000000000404BH
	DQ	0000000000000C04BH
	DQ	0000000000000C04BH
DSEG	ENDS

	MOV	AX,OFFSET L76
	PUSH	AX
	PUSH	AX

	PUSH	AX

	PUSH	AX
	POP	WP [SI]+40
	POP	WP [SI]+38
	POP	WP [SI]+36
	POP	WP [SI]+34
; CorY:= [ S,	 S,	-S,	-S,	 S,	 S,	-S,	-S];


DSEG	SEGMENT WORD PUBLIC 'DATA'

L77	DQ	0000000000000404BH
	DQ	0000000000000404BH
	DQ	0000000000000404BH
	DQ	0000000000000404BH
	DQ	0000000000000C04BH
	DQ	0000000000000C04BH
	DQ	0000000000000C04BH
	DQ	0000000000000C04BH
DSEG	ENDS

	MOV	AX,OFFSET L77
	PUSH	AX
	PUSH	AX

	PUSH	AX

	PUSH	AX
	POP	WP [SI]+48
	POP	WP [SI]+46
	POP	WP [SI]+44
	POP	WP [SI]+42
; CorZ:= [ S,	 S,	 S,	 S,	-S,	-S,	-S,	-S];

; 
	MOV	AX,19
	PUSH	CS
	CALL	NEAR PTR INTR45
; SetVid($13);				\set 320x200x256 graphic mode

; 
	CALL	L58
; MakeFaces;


L78:
	MOV	AX,WP [SI]+8
	MOV	WP [DI]+0,AX
	CALL	L2
; repeat	Erase(Image);

	CALL	L43
; 	DrawCube;

	MOV	BX,WP [SI]+8
	MOV	AX,[BX]+0
	PUSH	AX
	XOR	AX,AX
	PUSH	AX
	MOV	AH,160
	PUSH	AX
	XOR	AX,AX
	PUSH	AX
	MOV	AH,250
	PUSH	CS
	CALL	NEAR PTR INTR36
;  	Blit(Image(0), 0, $A000, 0, 64*1000);	\copy image to screen

	CALL	L56
; 	Rotate;

	XOR	AX,AX
	PUSH	AX
	INC	AX
	PUSH	AX
	
	PUSH	CS
	CALL	NEAR PTR INTR39
; 	Sound(0, 1, 1);			\delay approx 1/18 second

	PUSH	CS
	CALL	NEAR PTR INTR33
	TEST	AX,AX
	JE	L78
; until ChkKey;				\keystroke terminates program

; 
	XOR	AX,AX
	PUSH	CS
	CALL	NEAR PTR INTR13
; Openi(0);				\eat keystroke character, for neatness

	MOV	AX,3
	PUSH	CS
	CALL	NEAR PTR INTR45
; SetVid($03);				\restore normal text display

	RETF
; end;	\Main

	PUBLIC	PROGRM
CSEG	ENDS
	END
