#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/* ok ok this is absolutely horrible.  Both the #includes and the #defines.
 * But I wanted to get rid of (most of) the casts by using C++ inheritance,
 * to make the source code clearer. */

#ifdef RBTREES
#include "rbtrees.h"
#include "rbtrees.c"
#define avl_left rb_left
#define avl_right rb_right
#define avl_parent rb_parent
#define avl_node_t rb_node_t
#define avl_rebalance rb_rebalance
#define avl_erase rb_erase
#else
#include "avltrees.h"
#include "avltrees.c"
#endif

struct tree_t : avl_node_t {
  char c;
};

tree_t *tree;

char print[80*28+1];

int
ptree_rec (tree_t *root, tree_t *parent, int x, int y, int width)
{
  int hgt_left = 0, hgt_right = 0;
  int n;

  if (root->avl_parent != parent) 
    printf("Error in parent of %c (is %c)!\n", root->c,
	   ((tree_t *) root->avl_parent)->c);

  if (root->avl_left)
    hgt_left = ptree_rec ((tree_t *) (root->avl_left), root,
			  x - width / 2, y + 1, (width + 1) / 2);

  if (root->avl_right)
    hgt_right = ptree_rec ((tree_t *) (root->avl_right), root,
			   x + width / 2, y + 1, (width + 1) / 2);

  print[x + 80*y] = root->c;
  return (hgt_left > hgt_right ? hgt_left : hgt_right) + 1;
}

void
ptree (tree_t *root)
{
  int height;
  memset (print, ' ', sizeof(print));
  height = ptree_rec (root, NULL, 40, 0, 40);
  print[80*height] = 0;
  puts (print);
}

tree_t *avl_search(char c)
{
  tree_t *node = tree;

  while (node)
  {
     if (c < node->c)
        node = (tree_t *) node->avl_left;
     else if (c > node->c)
        node = (tree_t *) node->avl_right;
     else
        return node;
  }

  return NULL;
}

void avl_insert(char c)
{
  tree_t **p = &tree;
  tree_t *parent = NULL;
  tree_t *node;

  while (*p)
  {
     parent = *p;

     if (c < (*p)->c)
        p = (tree_t **) &(*p)->avl_left;
     else if (c > (*p)->c)
        p = (tree_t **) &(*p)->avl_right;
     else
        return;
  }

  node = new tree_t;
  node->avl_parent = parent;
  node->avl_left = node->avl_right = NULL;
  node->c = c;

  *p = node;

  avl_rebalance(node, (avl_node_t **) &tree);
}

void banner (char c)
{
#ifdef INTERACTIVE
  printf ("\e[2J\e[H");
#else
  int i;
  for (i = 1; i <= 79; i++)
    putchar (c);

  printf("\n");
#endif
}

int main()
{
  char *c;
  char insertionOrder[] = "THEQUICKBROWNFXJMPSVLAZYDG";
  char removalOrder[] = "GURDHVPXOEBJASKWZCFIYNMLQT";  /* rot13 of the above */

  for (c = insertionOrder; *c; c++)
    {
      avl_insert (*c);
      banner ('-');
      printf("Adding %c:\n", *c);
      ptree (tree);
#ifdef INTERACTIVE
      getchar ();
#endif
    }

  banner ('=');
  puts ("Removing");

  for (c = removalOrder; *c; c++)
    {
      avl_erase (avl_search (*c), (avl_node_t **) &tree);
      banner ('-');
      printf ("Removed %c", *c);
      if (tree) {
	puts (":");
	ptree (tree);
#ifdef INTERACTIVE
	getchar ();
#endif
      }
    }

  return 0;
}
