#include <windows.h>
#include <d3d8.h>
#include <d3dx8.h>

LPDIRECT3D8             g_pD3D;			//D3D Object
LPDIRECT3DDEVICE8       g_pd3dDevice;	//D3D Device
LPDIRECT3DSURFACE8		g_pRenderSurface;
LPDIRECT3DSURFACE8		g_pRenderStencilSurface;
HWND					g_hWnd;

struct DefaultModelVertex
{
    D3DXVECTOR3 position; // The position.
	D3DXVECTOR3 normal;	  // The normal
    FLOAT tu1, tv1;		  // The texture coords
    FLOAT tu2, tv2;
};
#define DMV DefaultModelVertex
#define D3DFVF_DefaultModelVertex (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_TEX2)

LPDIRECT3DVERTEXBUFFER8 pVB;
LPDIRECT3DTEXTURE8 pTexture0;
LPDIRECT3DTEXTURE8 pTexture1;

void MakePlane(void) {
	int nv=4;
	g_pd3dDevice->CreateVertexBuffer( nv*sizeof(DefaultModelVertex),
			0, D3DFVF_DefaultModelVertex, D3DPOOL_MANAGED, &pVB );
	DMV *pVertices;
	pVB->Lock( 0, 0, (BYTE**)&pVertices, 0 );
	float width=1.0f;
	float height=1.0f;
	pVertices[0].position=D3DXVECTOR3( -1*width, 1*height,0);
	pVertices[0].tu1=0; pVertices[0].tv1=0;
	pVertices[0].tu2=0; pVertices[0].tv2=0;
	pVertices[1].position=D3DXVECTOR3( -1*width,-1*height,0);
	pVertices[1].tu1=0; pVertices[1].tv1=1;
	pVertices[1].tu2=0; pVertices[1].tv2=1;
	pVertices[2].position=D3DXVECTOR3(  1*width, 1*height,0);
	pVertices[2].tu1=1; pVertices[2].tv1=0;
	pVertices[2].tu2=1; pVertices[2].tv2=0;
	pVertices[3].position=D3DXVECTOR3(  1*width,-1*height,0);
	pVertices[3].tu1=1; pVertices[3].tv1=1;
	pVertices[3].tu2=1; pVertices[3].tv2=1;
	for (int i=0;i<4;i++)
	pVertices[i].normal=D3DXVECTOR3(0,0,-1);
	pVB->Unlock();

}

void InitD3D(void) {
	g_pD3D = Direct3DCreate8( D3D_SDK_VERSION );
	D3DDISPLAYMODE d3ddm;
	g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm );

	D3DPRESENT_PARAMETERS d3dpp; 
    ZeroMemory( &d3dpp, sizeof(d3dpp) );

	int width=640;
	int height=480;

	d3dpp.BackBufferWidth  = width;
	d3dpp.BackBufferHeight = height;
	d3dpp.Windowed = TRUE;
	d3dpp.SwapEffect = D3DSWAPEFFECT_COPY_VSYNC;
    d3dpp.BackBufferFormat = d3ddm.Format;
    d3dpp.EnableAutoDepthStencil = TRUE;
    d3dpp.AutoDepthStencilFormat = D3DFMT_D16;

	g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWnd,D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &g_pd3dDevice );

	g_pd3dDevice->GetRenderTarget(&g_pRenderSurface);
	g_pd3dDevice->GetDepthStencilSurface(&g_pRenderStencilSurface);

	g_pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    g_pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
	D3DMATERIAL8 mtrl;
    ZeroMemory( &mtrl, sizeof(D3DMATERIAL8) );
    mtrl.Diffuse.r = mtrl.Ambient.r = 1.0f;
    mtrl.Diffuse.g = mtrl.Ambient.g = 1.0f;
    mtrl.Diffuse.b = mtrl.Ambient.b = 1.0f;
    mtrl.Diffuse.a = mtrl.Ambient.a = 1.0f;
    g_pd3dDevice->SetMaterial( &mtrl );

	g_pd3dDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
    g_pd3dDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    g_pd3dDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
	
}

void LoadTexture(char *filename, int texnum) {
	switch (texnum) {
	case 1:
		D3DXCreateTextureFromFile( g_pd3dDevice, filename, &pTexture1 );
		break;
	case 0:
	default:
		D3DXCreateTextureFromFile( g_pd3dDevice, filename, &pTexture0 );
		break;
	}
}

void RenderPlane() {
//	g_pd3dDevice->SetTexture( 0,pTexture );
	g_pd3dDevice->SetStreamSource( 0, pVB, sizeof(DefaultModelVertex) );
	g_pd3dDevice->SetVertexShader( D3DFVF_DefaultModelVertex );
	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2);
//	g_pd3dDevice->SetTexture( 0, NULL);
	g_pd3dDevice->SetStreamSource( 0, NULL, 0);
}

void Render() {
	g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0 );
	
	g_pd3dDevice->SetRenderState( D3DRS_ZENABLE, FALSE);
	
	g_pd3dDevice->SetTexture( 0, pTexture0 );
    g_pd3dDevice->SetTexture( 1, pTexture1 );

	RenderPlane(); //Draw the plane.

	g_pd3dDevice->SetTexture( 0, NULL);
	g_pd3dDevice->SetTexture( 1, NULL);

	g_pd3dDevice->EndScene();
	g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	
}

DWORD m_hPixelShader;
LPD3DXBUFFER pCode;

void MakeShader(char *filename) {
	//Helper function, asembles shader from ascii text file to binary instruction format
	D3DXAssembleShaderFromFile(filename,0,NULL,&pCode,NULL);
	//Creates a pixel shader
	g_pd3dDevice->CreatePixelShader( (DWORD*)pCode->GetBufferPointer(), &m_hPixelShader );
	//Sets the pixel shader we want to use
	g_pd3dDevice->SetPixelShader( m_hPixelShader );
}

void DeleteShader() {
	//Stop using the pixel shader we created
	g_pd3dDevice->SetPixelShader(NULL);
	//Delete the shader
	g_pd3dDevice->DeletePixelShader(m_hPixelShader);
}

LRESULT WINAPI MsgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
    switch( msg )
    {
	    case WM_DESTROY:
            PostQuitMessage( 0 );
            return 0;
    }

    return DefWindowProc( hWnd, msg, wParam, lParam );
}

INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR lpCmdLine, INT )
{

    // Register the window class.
    WNDCLASSEX window = { sizeof(WNDCLASSEX), CS_CLASSDC, MsgProc, 0L, 0L, 
                      GetModuleHandle(NULL), NULL, NULL, NULL, NULL,
                      "pixeltest", NULL };
    RegisterClassEx( &window );

    // Create the application's window.

	g_hWnd=CreateWindow( "pixeltest", "pixeltest",WS_OVERLAPPEDWINDOW,
					  0, 0, 640, 480,GetDesktopWindow(), NULL, window.hInstance, NULL );
	//Initialize Direct3d
	InitD3D();
	//Load the texture
	LoadTexture("texture0.bmp",0);
	LoadTexture("texture1.bmp",1);
	//Make the model
	MakePlane();
	//===========================
	//Pixel Shader Operations
	MakeShader("add.txt");
	//===========================



	ShowWindow( g_hWnd, SW_SHOWDEFAULT );
	UpdateWindow( g_hWnd );

	// Enter the message loop
	MSG msg;
    ZeroMemory( &msg, sizeof(msg) );
    while( msg.message!=WM_QUIT )
	{
		if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
		{
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
		else
			Render();
	}
	//===========================
	//Pixel Shader Operations
	DeleteShader();
	//===========================

	g_pd3dDevice->Release();
	g_pD3D->Release();

	UnregisterClass( "pixeltest", window.hInstance );
	CoUninitialize();
	return 0;
}