;=======================================
; ND-4K - sample.asm
; Based on the the Almighty 4k framework
; Written:  March / September 2002
;
; Author:   Syntax of the Northern Dragons 
; Modifier: Polaris of Northern Dragons
; * Adapted for the purposes of
;   a hugi article.  Note: Code is not
;   optimized; to keep it simple * 
;
; Greets go out to all demo coders
; if you use this, send us a greet!
;======================================

.586p
.Model      Flat, Stdcall
Option      Casemap:None
;Option      NOLJMP
;Option      NOSCOPED

;==== INCLUDES ====
;all these include files weren't originally here
;all numbers were hardcoded and functions were
;gotten by a tricky routines. that sucked.
include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\gdi32.inc
;include \masm32\include\opengl32.inc ; *** Extra dropped out of ND 4KB ***
;include \masm32\include\glu32.inc

;==== DEFINED VALUES ====
;Trigger Vars Manually - easier to use from qedit
LOWRENT equ 1
;DEBUGMODE equ 1

;==== DEFS ====
; *** Extra code that wasn't in ND 4KB  Here temporarily. ***
include winextra.def
include gl.def
include glu.def

;==== LIBRARIES ====
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\gdi32.lib
includelib \masm32\lib\opengl32.lib
includelib \masm32\lib\glu32.lib

; === libraries / includes for debuging routines ===
IFDEF DEBUGMODE
    include \masm32\include\masm32.inc
    includelib \masm32\lib\masm32.lib
ENDIF

;==== FUNCTIONS ====
WinMain    proto :DWORD,:DWORD,:DWORD,:DWORD
SetupOGL   proto
DrawFunc   proto
ResizeProc proto
KillGLWindow proto ; Added by Polaris - required for debug mode / graceful exit
DrawCylinder proto
DrawTree   proto :GLfloat,:GLfloat

;conditionally define the screen size as we'd like it
;to be definable on compile for different compos :)
;set define on cmd line by: ml /DLOWRENT
IFDEF LOWRENT
  SCREENW             equ  640
  SCREENH             equ  480
ELSE
  SCREENW             equ  800
  SCREENH             equ  600
ENDIF
SCREENBITS          equ  16

include include.def ; *** Extra code that wasn't in ND 4KB  Here temporarily. ***

;==== DATA ==== 
.DATA
ClassName           db "EDIT",0    ;hijack the EDIT class (bwuhahaha)
WndName             db "0",0

IFDEF DEBUGMODE
    error           db "ERROR",0
    not_supported   db "The requested fullscreen mode is not supported by",13,10
                    db "your video card.",0
    create_device   db "Can't create a GL device context.",0
    create_pixel    db "Can't find a suitable pixelformat.",0
    create_error    db "Window creation error.",0
    pixel_error     db "Can't set the pixelformat.",0
    rend_error      db "Can't create a GL rendering context.",0
    act_error       db "Can't activate the GL rendering context.",0
    init_error      db "Initialization Failed.",0
    start_full      db "Would you like to run in fullscreen mode ?",0
    class_error     db "Could not unregister class.",0
    disp_float      db "Float from float display:",0
    display_message     db "                    ",0
    FloatConverted dq 0
ENDIF

PixelFmt PIXELFORMATDESCRIPTOR <SIZEOF PIXELFORMATDESCRIPTOR, 1, 25h, 0, SCREENBITS,\
                                   0,0,0,0,0,0,\
                                   0,0,0,\
                                   0,0,0,0,\
                                   16,\
                                   0,0,\
                                   0,\     ;PFD_MAIN_PLANE
                                   0,\
                                   0,0,0>

hWnd                dd 0
hDC                 dd 0
hRC                 dd 0
hInstance           dd 0

gl01f               dq  0.1
gl10f               dq  1.0
gl100f              dq  100.0
gl45f               dq  45.0
gl13f               dq  1.3

rquad               GLfloat 0.0f
q_rot_speed         GLfloat 0.5f

;==== MACROS ====

;========================================================
; Macro:    ErrorMessage
; Author:   Polaris of Northern Dragons
; Written:  July 1st, 2002
; Notes:    Created for conditional code of display routines
;========================================================
ErrorMessage MACRO message_text
    IFDEF DEBUGMODE ; code only kicks off if debugmode is defined
        .IF (!eax)
            invoke KillGLWindow
            invoke MessageBox, 0, ADDR message_text, ADDR disp_float, MB_OK or MB_ICONEXCLAMATION
            xor eax, eax
            ret
        .ENDIF
    ENDIF
ENDM

;========================================================
; Macro:    DisplayFloat
; Author:   Polaris of Northern Dragons
; Written:  July 11, 2002
; Notes:    Created to display floating point numbers
;========================================================
DisplayFloat MACRO float_display
    pushad
        fld float_display
        fstp FloatConverted
        invoke FloatToStr, FloatConverted, ADDR display_message
        invoke MessageBox, 0, ADDR display_message, ADDR disp_float, MB_OK or MB_ICONEXCLAMATION
    popad
ENDM

;==== CODE ====
.Code

Start:
            invoke  GetModuleHandle, NULL
            mov     hInstance, eax
            invoke  WinMain, eax, 0, 0, 0   
            invoke  ExitProcess, eax ; no more wierd memory alignment issues! :)


;========================================================
; Function:  WinMain
; Author:    Syntax of the Northern Dragons
; Written:   March 2002
; Modified:  By Polaris to have full return messages;
;            seems to crash on me without it.
;
;========================================================
WinMain proc hInst:HWND, hPrevInst:UINT, CmdLine:WPARAM, CmdShow:LPARAM
  LOCAL msg:MSG
  LOCAL FullScreen : DEVMODE

    mov FullScreen.dmSize,       SIZEOF DEVMODE
    mov FullScreen.dmPelsWidth,  SCREENW
    mov FullScreen.dmPelsHeight, SCREENH
    mov FullScreen.dmBitsPerPel, SCREENBITS
    mov FullScreen.dmFields,     1C0000h  ;DM_BITSPEREPL|CM_PELWIDTH|DM_PELHEIGHT

    invoke ChangeDisplaySettings, ADDR FullScreen, CDS_FULLSCREEN    
    not eax; Flip the bits before debug test; since a 0 is what we want.  
    ErrorMessage not_supported

    invoke  CreateWindowEx, 0, ADDR ClassName, ADDR WndName, WS_POPUP or WS_VISIBLE,\
        0,0,SCREENW, SCREENH,0,0,hInstance, 0                
    mov hWnd, eax
    ErrorMessage create_error
     
    invoke SetupOGL
    invoke ResizeProc

    invoke ShowWindow, hWnd, SW_SHOWMAXIMIZED
    invoke ShowCursor, 0

         

   StartLoop:
              invoke  PeekMessage, ADDR msg, NULL, 0, 0, PM_REMOVE
              cmp     eax,0
              jne     MsgProcess
              invoke  DrawFunc
              ; *** Following line added ***
              invoke SwapBuffers, hDC

              jmp     StartLoop
  MsgProcess:
    
 .if msg.message == WM_QUIT
              jmp     ExitLoop
              .elseif msg.message == WM_KEYDOWN
              jmp     ExitLoop
              .endif
              invoke  TranslateMessage, ADDR msg
              invoke  DispatchMessage, ADDR msg
              jmp     StartLoop
  ExitLoop:

    invoke KillGLWindow        
    mov eax, msg.wParam
    ret
WinMain endp


;========================================================
; Function:  SetupOGL
; Author:    Syntax of the Northern Dragons
; Written:   March 2002
;
; No params
;========================================================
;****-NOTE
;Everything between this and the next ****-NOTE is GL setup code
SetupOGL    proc
  LOCAL  FmtUsed  :  DWORD
 
    invoke GetDC, hWnd
    mov hDC, eax

    ErrorMessage create_device
    invoke ChoosePixelFormat, hDC, ADDR PixelFmt

    mov FmtUsed, eax
    ErrorMessage create_pixel

    invoke SetPixelFormat, hDC, FmtUsed, ADDR PixelFmt
    ErrorMessage pixel_error

    invoke wglCreateContext, hDC
    mov hRC, eax
    ErrorMessage rend_error

    invoke wglMakeCurrent, hDC, hRC
    ErrorMessage act_error


    invoke glShadeModel, GL_SMOOTH   
    invoke  glClearColor, 0, 0, 0, 0    
    
    ; clear depth must be 1.0f.  Not sure why this next line doesn't work, 
    ; but the line after does.  I suspect it has something to do with the 
    ; gl push routines verses invoke.
    ;invoke  glClearDepth, 0, dword ptr gl10f+4
    _glClearDepth 1.0f
    
    invoke  glEnable, GL_DEPTH_TEST
    invoke  glDepthFunc, GL_LEQUAL
    invoke glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST

    mov eax,1    
    ret
SetupOGL endp
;****-NOTE End of GL setup code

;========================================================
; Function: DrawCylinder
; Author:   Polaris of Northern Dragons
; Written:  July 2nd, 2002
; Note: 
;       This is to be later replaced with a macro,
;       we are needlessly putting things on the stack
; 
;========================================================
DrawCylinder proc
    pushad

   mov eax,8
 repeat_draw:

    push eax 
    invoke glBegin, GL_QUADS             
        _glVertex3f -0.5f,1.0f, -1.2f   ; Top Left
        _glColor3f   1.0f, 0.0f,0.0f       
        _glVertex3f  0.5f,1.0f,   -1.2f  ; Top Right
        _glColor3f   0.0f, 1.0f, 0.0f
        _glVertex3f 0.5f,-1.0f,  -1.2f  ; Bottom Right
        _glColor3f   0.0f, 0.0f, 1.0f
        _glVertex3f -0.5f,-1.0f, -1.2f  ; Bottom Left
        _glColor3f   1.0f, 0.0f, 0.0f
    invoke glEnd
    _glRotatef 45.0f,0.0f,1.0f,0.0f ; next angle
    pop eax
    dec eax
  jnz repeat_draw


    popad
    ret
DrawCylinder endp

;========================================================
; Function:  DrawFunc
; Author:    Syntax of the Northern Dragons
; Modified by: Polaris of Northern Dragons
; Written:   15 February 2002
;
; No params
; Here is where all the drawing calls are made. add demo
; specific routine calls here
;========================================================
DrawFunc proc                                        ;drawing proc
  ;clear screen and depth buffer
    invoke glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT
    invoke glLoadIdentity                               ;reset modelview matrix

    _glTranslatef 0.0f,0.0f,-50.0f
    _glRotatef rquad,0.0f,1.0f,0.0f
    _glScalef 5.0f,5.0f,5.0f

   invoke DrawCylinder

    fld rquad
    fsub q_rot_speed
    fstp rquad
    mov eax,1    
    ret
DrawFunc endp

;========================================================
; Function:  ResizeProc
; Author:    Syntax of the Northern Dragons
; Written:   February 2002
;
;========================================================
ResizeProc  proc
            invoke  glViewport, 0, 0, SCREENW, SCREENH
            invoke  glMatrixMode, GL_PROJECTION
            invoke  gluPerspective, dword ptr gl45f,dword ptr gl45f+4,\
                                    dword ptr gl13f,dword ptr gl13f+4,\
                                    dword ptr gl10f,dword ptr gl10f+4,\
                                    dword ptr gl100f,dword ptr gl100f+4 
            invoke  glMatrixMode, GL_MODELVIEW
            ret
ResizeProc  endp

;========================================================
; Function:  ShutDownGL
; Author:    Polaris of the Northern Dragons
; Written:   July 2002
;
; Used for debug code; to try to return to main screen
; Note: 
;       This is to be later replaced with a macro,
;       we are needlessly putting things on the stack
; 
;========================================================
KillGLWindow proc
        invoke ChangeDisplaySettings, 0, 0          ;get back to window
        invoke ShowCursor, 1                        ;and show mouse ptr
KillGLWindow endp

END Start
