#include <math.h>
#include <stdio.h>
#include <conio.h>

#define Band_Power  4   // 2^Band_Power = Total Points in a band.
#define Band_Points 16 // 16 = 2^Band_Power
#define Band_Mask (Band_Points-2)
#define Sections_In_Band ((Band_Points/2)-1)
#define Total_Points (Sections_In_Band*Band_Points) // remember - for each section in a band, we have a band
#define Section_Arc (6.28/Sections_In_Band)
const float R = -10; // radius of 10

int main(int argc, char* argv[])
{

	int i;
	float x_angle;
	float y_angle;

	for (i=0;i<Total_Points;i++)
	{   
		// using last bit to alternate,+band number (which band)
		x_angle=(float)(i&1)+(i>>Band_Power);  
		
		// (i&Band_Mask)>>1 == Local Y value in the band
		// (i>>Band_Power)*((Band_Points/2)-1) == how many bands have we processed?
		// Remember - we go "right" one value for every 2 points. i>>bandpower - tells us our 
		// band number
		y_angle=(float)((i&Band_Mask)>>1)+((i>>Band_Power)*(Sections_In_Band));

		x_angle*=(float)Section_Arc/2.0f; // remember - 180' x rot not 360
		y_angle*=(float)Section_Arc*-1; 
		
		printf("{%f,%f, %f },\n",
			R*sin(x_angle)*sin(y_angle),
			R*cos(x_angle),
			R*sin(x_angle)*cos(y_angle));
		
	}
	
	printf("Press any key\n");
	getche();
	return 0;
}

