#include "allegro.h"   
#include <math.h>

using namespace std;

// creates a combined bitmap from two 16 color bitmaps.  
void create_combined_bitmap(BITMAP *image_1,BITMAP *image_2, BITMAP *image_target)
{
    // this is a bit simple (using get pixel / put pixel), but it's 
    // only executed once during init time, so speed is not so much of a concern.
     
   int x;
   int y;   
   
   for (x=0;x<320;x++)
      for (y=0;y<200;y++)
      {
            // here we create a combined image.  Each image (image_1, image_2)
            // return a range from 0-15.  So we pack these together into a single
            // byte, where image_1 gets the upper nibble, and image_2 gets the 
            // lower nibble. 
            
            putpixel(image_target,x,y,
                        (getpixel(image_1,x,y)<<4) | getpixel(image_2,x,y));
      }
}

// float degree 
void generate_intermediate_palette(PALETTE image1, PALETTE image2, 
                                    PALETTE intermediate, float degree)
{
    int x;    
    
    // generate rgb values. 
    // we are interpolatng rgb values according to 
    
    for (x=0;x<256;x++)
    {
       // calculates the intermediate colour r,g,b values 
       intermediate[x].r=image1[x>>4].r+
              (int)(degree*(float)(image2[x&0x0F].r-image1[x>>4].r));
              
       intermediate[x].g=image1[x>>4].g+
              (int)(degree*(float)(image2[x&0x0F].g-image1[x>>4].g));
              
       intermediate[x].b=image1[x>>4].b+
              (int)(degree*(float)(image2[x&0x0F].b-image1[x>>4].b));
       
/*     // uncomment this block to force the image to become image 1 only 
        intermediate[x].r=image1[x>>4].r; 
        intermediate[x].g=image1[x>>4].g;
        intermediate[x].b=image1[x>>4].b;*/ 

/*     // uncomment this block to force the image to become image 2 only 
        intermediate[x].r=image2[x&0x0F].r;
        intermediate[x].g=image2[x&0x0F].g;
        intermediate[x].b=image2[x&0x0F].b;*/
                
    }
}

// main program
int main(int argc, char *argv[]) {         
	int i; // global counter

    BITMAP *image_1;    // the image from the pcx file
    PALETTE palette_1;  // the palette from the pcx file

    BITMAP *image_2;    // the image from the pcx file
    PALETTE palette_2;  // the palette from the pcx file

    BITMAP *image_combo;    // the target combined image that's crossfaded
    PALETTE palette_combo;  // tge target combined image that's crossfaded

    // allegro setup
	allegro_init();        // init Allegro 
	install_keyboard();    // setup allegro keyboard	
	install_timer();       // install timer
	
    // setup our images
	image_1 = load_bitmap("image_1.PCX", palette_1); // first image 
   	image_2 = load_bitmap("image_2.PCX", palette_2); // second image
   	image_combo = create_bitmap(320, 200);    // combined image
   	
    // init video mode
	set_color_depth(8) ;   // 8 bit colour

	if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 320, 200, 0, 0)<0)
	// swap with line below for windowed mode
    //if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320, 200, 0, 0)<0) 
	{
	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);  
	    allegro_message("Failure to init video mode!\n%s\n", allegro_error);
	}

	// create our combined bitmap
	create_combined_bitmap(image_1,image_2, image_combo);
    blit(image_combo, screen, 0, 0, 0,0,320,200);
    
    i=0; // set frame counter
    while (!key[KEY_ESC]) 
    {
        i++;
        
        generate_intermediate_palette(palette_1,palette_2, palette_combo, 
                fabs(1.0f - fmod((float)i/200,2.0f)));
        set_palette(palette_combo);
        rest(10);
     };
     
    remove_timer();
	return 0;     
}     
END_OF_MAIN();
