#include "allegro.h"   
#include "C:\Dev-Cpp\fmodapi374win\api\inc\fmod.h"
#include "C:\Dev-Cpp\fmodapi374win\api\inc\fmod_errors.h"  

#define screen_x 320
#define screen_y 200

using namespace std;
FMUSIC_MODULE *mod = NULL;

void Init_Music(void)
{
 	// verify FMOD version
 	if (FSOUND_GetVersion() < FMOD_VERSION)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);         
        allegro_message("Error : You are using the wrong DLL version!  You should be using FMOD %.02f\n", FMOD_VERSION);
        exit(1); // force abort
    }

 	// Initalize Allegro
    if (!FSOUND_Init(32000, 64, 0))
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);         
        allegro_message("Fmod Error: %s\n", FMOD_ErrorString(FSOUND_GetError()));
        exit(1); // force abort
    }
    // Set Allegro Message
    mod = FMUSIC_LoadSong("86sec.s3m");
    if (!mod)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);         
        allegro_message("%s\n", FMOD_ErrorString(FSOUND_GetError()));
        exit(1); // force abort
    }
}

void Play_Music(void)
{
    // Play Song!
    FMUSIC_PlaySong(mod);   
}

void Kill_Music(void)
{
    FMUSIC_FreeSong(mod);
    FSOUND_Close();
}

// main program
int main(int argc, char *argv[]) {   

	allegro_init();        // init Allegro 
	install_keyboard();    // setup allegro keyboard
	
	set_color_depth(8) ;   // 8 bit colour
	if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, screen_x, screen_y, 0, 0)<0)
	{
	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);  
	    allegro_message("Failure to init video mode!\n%s\n", allegro_error);
	    exit(1); // force abort
	}
 	
 	// init more stuff  (next phase)
 	Init_Music();
    Play_Music();
 	
	while ((!key[KEY_ESC])&&(!key[KEY_SPACE])) 
    {
        // DO SOMETHING AMAZING HERE!
    };
    
    // de-init more stuff  (next phase)
    Kill_Music();
    
	return 0;     
}     
END_OF_MAIN();
