comment $

entry for Hugi compo 24 - The Tortoise and the Hare
by Hannes Uppman / 2005


$

.model tiny
.486
.code
org 100h
LOCALS

by equ <byte ptr>
wo equ <word ptr>
do equ <dword ptr>
off equ <offset>

; MEM MAP
; si-80h:   db  pen on/off status
; si-1:     db  color
; si:       db  fillTargetColor / tmp storage
; cs:3:     dw  read data
; hej:      dw  far ptr

hugi24:     sub     bp,bp
mainloop:
;ASSUME ah=0                                                            ;|
            mov     al,13h                                              ;| enter gfx mode / blackout screen
            int     10h             ;clears videomem                    ;|
;ASSUME cd=ds                                                           ;|
savedump:   push    cs                                                  ;|
            pop     es                                                  ;|
            push    si                                                  ;|
            sub     di,di                                               ;| restore / save scrdump
            sub     si,si                                               ;| (start on save)
            mov     cx,320*200                                          ;|
@@1:        lds     di,do [hej]                                         ;|
            rep     movsb                                               ;|
            pop     si                                                  ;|
            push    cs              ;ack                                ;|
            pop     ds                                                  ;|
            xor     wo [si+@@1-hugi24],801h ;lds di > les si > lds di.. ;|
            jpe     execute                                             ;| if scrdump was restored -> execute
                                                                        ;|
            mov     al,3                                                ;| enter textmode
            int     10h                                                 ;|
            xchg    ax,bx           ;not going to use stdErr, replace it;|
                                                                        ;|
            push    di              ;(di -> inputbuf)                   ;| get filename
@@2:        mov     ah,1            ;read char                          ;|
            int     21h                                                 ;|
            stosb                                                       ;|
            sub     al,13           ;enter?                             ;|
            jnz     @@2                                                 ;|
            dec     di                                                  ;|
            stosb                   ;zero terminate                     ;|
                                                                        ;|
            mov     ah,3Eh                                              ;|
            int     21h                                                 ;| close previously opened file...
            pop     dx                                                  ;| .. and open new
            mov     ah,3Dh                                              ;|
            int     21h             ;open file                          ;|
            jnc     mainloop        ;exit on error                      ;|
            int     20h                                                 ;|

execute:    call    read5
            jcxz    savedump        ;eof ?
            mov     dx,ax           ;move wants this information
            mov     bx,off jmpTable
            xlatb
            add     bx,ax
            pop     ax
            call    bx
            push    ax
            jmp     execute

; dx    1       2       3       4       5       6       7       8
; dir   south   north   north   south   east    west    west    east
; cf    1       1       1       1       0       0       0       0
dance PROC
            cmp     dl,4+1
            jc      @@1
            xchg    ax,bp
@@1:        jpo     @@2
            inc     ax
            inc     ax
@@2:        dec     ax
            jc      @@3
            xchg    ax,bp
@@3:
ENDP

jmpTable:   ret ;db off ret - off jmpTable      ;nop            0
            db  off vertical - off jmpTable     ;move up        1
            db  off vertical - off jmpTable     ;move down      2
            db  off horizontal - off jmpTable   ;move left      3
            db  off horizontal - off jmpTable   ;move right     4
            db  off moveTo - off jmpTable       ;move coord     5
            db  off setPen - off jmpTable       ;pen on         6
            db  off resetPen - off jmpTable     ;pen off        7
            db  off setColor - off jmpTable     ;change color   8
            db  off pause - off jmpTable        ;pause          9
moveTo:     call    read4
            xchg    ax,bp
            jmp     read2
            db  off swirl - off jmpTable        ;cirkle         16
            db  off fill - off jmpTable         ;fill           17

read6:      mov     [si],dx
read5:      sub     cx,cx
read4:      inc     cx
read3:      xchg    ax,di
read2:      mov     ah,3Fh
            mov     bx,3
            mov     dx,bx           ;read buffer
            int     21h
            cwd
            xchg    ax,cx           ;(save ev. eof status)
            xchg    [bx],ax         ;zero out high byte
            ret

move PROC
horizontal: inc     cx
vertical:   push    dx
            call    read3
            xchg    ax,bx
            xchg    ax,di
            pop     dx
            add     dx,dx
            inc     bx              ;doh!

@@1:        push    dx
            mov     cx,[si-80h]
            call    doit2
            pop     dx
            dec     bx
            jz      bye
            call    dance
            jmp     @@1
ENDP

; makes sure Y(ax) and X(bp) fit on screen, if clipping was needed cx
; is increased .. plots if no clipping was performed (cx=0)
doit PROC
            sub     cx,cx
doit2:      push    bx
            mov     bx,199
@@0:        cwd
            not     dx              ;dx = FFFF if ax > 0, else dx = 0
            and     dx,bx
            cmp     ax,dx
            jbe     @@1
            inc     cx
            mov     ax,dx
@@1:        add     bx,319-199
            xchg    ax,bp
            jns     @@0             ;could exit loop sooner by jpe,
            pop     bx              ;but that would swap X and Y

adr:        imul    di,ax,320
            add     di,bp
hej:        jcxz    @@2             ;dw 02E3, good place for a buffer :-)
            dw      0A000h          ;\
@@2:        dec     si              ; > add    [bx+si-5BB2],ah
            movsb                   ;/  (ah zero here)
            mov     dl,es:[di]
            ret
ENDP

fill2 PROC
@@2:        xchg    ax,bx
            stosb
            popa
            mov     dl,9
@@3:        dec     dx
            jz      @@stop
            call    dance
            mov     [di],dl
; ASSUME cx=1
filler:     inc     di
            pusha
            call    doit2
            dec     cx
            cmp     dl,[si]
            loopz   @@2             ;continue if es:[di]=targetcolor AND cx != 1
            popa
@@stop:     dec     di
            sub     dx,dx
            add     dl,[di]
            jns     @@3             ;op ret = C3 > 80
bye:        ret
ENDP

; ax = Y off (radius)                       si = saved
; bx = deltaE (3)                           di = D (1-radius)
; cx = deltaSE - deltaE (2-2radius)         bp = X
; dx = X off (0)                           [si]= Y
swirl PROC
            pusha
            xchg    ax,dx
            call    read6           ;cx=1(bytes read), ax=radius, dx=0
            sub     cx,ax           ;1-radius
            mov     di,cx
            add     cx,cx           ;2-2radius

@@pr:       pusha                   ;-- plot
            add     bp,dx
            add     ax,[si]
            call    doit
            popa                    ;-- use symmetry
            xchg    ax,dx
            neg     bx              ;deltaE > 0 hela tiden
            js      @@pr
            neg     dx
            js      @@pr
            neg     ax
            js      @@pr

            cmp     dx,ax
            ja      popaRet
            test    di,di
            js      @@2

            add     di,cx
            inc     cx
            inc     cx
            dec     ax

@@2:        add     di,bx
            inc     bx
            inc     bx
            inc     dx
            jmp     @@pr
ENDP

setPen:     dec     cx
resetPen:   mov     [si-80h],cx     ;(this is nonzero at startup)
            ret                     ;nop instruction lands here

; ASSUME ah=0 (ok since ax=Y)
pause:      pusha
            int     16h
popaRet:    popa
            ret

setColor:   call    read3
            mov     [si-1],al
            xchg    ax,di
            ret

fill PROC
            call    adr
            call    read6
            cmp     al,[si]
            xchg    ax,bx
            xchg    ax,di
            mov     di,off  buf-1
            jnz     filler
            ret
ENDP

buf:
END hugi24